/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class DataOrderDialog
extends QbDialog {
    ChartMain chartmain;
    JPanel cop;
    JComboBox comboBox;
    Vector<String> comboList = new Vector();
    JPanel[] orderpanel;
    JList[] datalist;
    JPanel actualPanel;
    DefaultListModel[] listModel;
    JButton[] upbutton;
    JButton[] downbutton;
    int[] dataOrdering;
    int dim;
    JButton butcancel;
    JButton butOK;
    Chart chart;
    int currpage;
    JRadioButton noneValCheckbox;
    JRadioButton ascValCheckbox;
    JRadioButton descValCheckbox;
    JRadioButton primValCheckbox;
    JRadioButton secValCheckbox;
    JCheckBox enableTopN;
    SpinBox topNField;
    static final short width = 225;
    static final short height = 275;
    JComboBox[] displayMode;
    boolean processing = false;

    public DataOrderDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.dim = this.chart.dataDim;
        this.setBackground(Color.lightGray);
        this.orderpanel = new JPanel[this.dim + 1];
        this.datalist = new JList[this.dim];
        this.listModel = new DefaultListModel[this.dim];
        this.upbutton = new JButton[this.dim];
        this.downbutton = new JButton[this.dim];
        this.dataOrdering = new int[this.dim];
        this.displayMode = new JComboBox[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.orderpanel[i] = new BorderPanel(LanguageEncoder.getText("Data Order"));
            this.listModel[i] = new DefaultListModel();
            ColData coldata = this.chart.colData[this.chart.mDataMap[i]];
            Object[] fname = coldata.getFieldName();
            if (this.chart.mDataMap[i] != this.chart.nCol) {
                for (int j = 0; j < fname.length; ++j) {
                    this.listModel[i].addElement(fname[j]);
                }
            }
            this.datalist[i] = new JList(this.listModel[i]);
            this.datalist[i].setSelectionMode(0);
            this.upbutton[i] = new JButton(LanguageEncoder.getText("Up"));
            this.displayMode[i] = new JComboBox<String>(ColData.DATA_ORDER_STR);
            this.downbutton[i] = new JButton(LanguageEncoder.getText("Down"));
            this.dataOrdering[i] = coldata.getDataOrder();
            this.displayMode[i].setSelectedIndex(this.dataOrdering[i]);
            this.displayMode[i].addItemListener(this);
            this.upbutton[i].setEnabled(this.displayMode[i].getSelectedIndex() == 3);
            this.downbutton[i].setEnabled(this.displayMode[i].getSelectedIndex() == 3);
            this.upbutton[i].addActionListener(this);
            this.downbutton[i].addActionListener(this);
            this.orderpanel[i].setLayout(new BoxLayout(this.orderpanel[i], 1));
            JScrollPane scrollPane = new JScrollPane(this.datalist[i]);
            JPanel spanel = new JPanel();
            spanel.setLayout(new GridLayout(2, 1));
            spanel.add(this.upbutton[i]);
            spanel.add(this.downbutton[i]);
            JPanel bpanel = new JPanel();
            bpanel.setLayout(new BorderLayout());
            bpanel.add("North", spanel);
            bpanel.add("West", new JLabel("  "));
            this.orderpanel[i].add(this.displayMode[i]);
            JPanel butPanel = new JPanel();
            butPanel.setLayout(new BorderLayout());
            butPanel.add("Center", scrollPane);
            butPanel.add("East", bpanel);
            this.orderpanel[i].add(butPanel);
            if (this.chart.mDataMap[i] == this.chart.nCol) continue;
            this.comboList.add(coldata.colName);
        }
        BorderPanel sortGroupPanel = new BorderPanel(1);
        this.noneValCheckbox = new JRadioButton(LanguageEncoder.getText("Disable"), true);
        this.ascValCheckbox = new JRadioButton(LanguageEncoder.getText("Ascending"), false);
        this.descValCheckbox = new JRadioButton(LanguageEncoder.getText("Descending"), false);
        ButtonGroup cg1 = new ButtonGroup();
        cg1.add(this.noneValCheckbox);
        cg1.add(this.ascValCheckbox);
        cg1.add(this.descValCheckbox);
        if (this.chartmain.chart.mData2 == null) {
            sortGroupPanel.setLayout(new GridLayout(3, 1, 5, 5));
            sortGroupPanel.add(this.noneValCheckbox);
        } else {
            sortGroupPanel.setLayout(new GridLayout(2, 2, 5, 5));
            sortGroupPanel.add(this.noneValCheckbox);
            sortGroupPanel.add(new JLabel());
        }
        sortGroupPanel.add(this.ascValCheckbox);
        sortGroupPanel.add(this.descValCheckbox);
        BorderPanel valGroupPanel = new BorderPanel(1);
        valGroupPanel.setLayout(new GridLayout(1, 2, 0, 0));
        this.primValCheckbox = new JRadioButton(LanguageEncoder.getText("Value Axis"), false);
        this.secValCheckbox = new JRadioButton(LanguageEncoder.getText("Sec Axis"), false);
        ButtonGroup cg2 = new ButtonGroup();
        cg2.add(this.primValCheckbox);
        cg2.add(this.secValCheckbox);
        valGroupPanel.add(this.primValCheckbox);
        valGroupPanel.add(this.secValCheckbox);
        if (this.chart.getSortValue() == 1) {
            this.ascValCheckbox.setSelected(true);
            this.primValCheckbox.setSelected(true);
        } else if (this.chart.getSortValue() == 2) {
            this.descValCheckbox.setSelected(true);
            this.primValCheckbox.setSelected(true);
        } else if (this.chart.getSortValue() == 3) {
            this.ascValCheckbox.setSelected(true);
            this.secValCheckbox.setSelected(true);
        } else if (this.chart.getSortValue() == 2) {
            this.descValCheckbox.setSelected(true);
            this.secValCheckbox.setSelected(true);
        } else if (this.chart.getSortValue() == 4) {
            this.descValCheckbox.setSelected(true);
            this.secValCheckbox.setSelected(true);
        } else if (this.chart.getSortValue() == 0) {
            this.noneValCheckbox.setSelected(true);
        }
        this.orderpanel[this.dim] = new BorderPanel(LanguageEncoder.getText("Order by values"));
        if (this.chartmain.chart.mData2 != null) {
            this.orderpanel[this.dim].setLayout(new BoxLayout(this.orderpanel[this.dim], 1));
            this.orderpanel[this.dim].add(valGroupPanel);
            this.orderpanel[this.dim].add(sortGroupPanel);
        } else {
            this.orderpanel[this.dim].setLayout(new GridLayout(1, 1, 5, 5));
            this.primValCheckbox.setSelected(true);
            this.orderpanel[this.dim].add(sortGroupPanel);
        }
        if (this.chart.chartType != 18 && this.chart.chartType != 9 && this.chart.chartType != 10) {
            this.comboList.add(LanguageEncoder.getText("VALUES"));
        }
        BorderPanel topNPanel = new BorderPanel(LanguageEncoder.getText("Limit Number of Datapoints"));
        topNPanel.setLayout(new BorderLayout());
        this.enableTopN = new JCheckBox(LanguageEncoder.getText("Show first"));
        this.enableTopN.addItemListener(this);
        topNPanel.add("West", this.enableTopN);
        this.topNField = new SpinBox(1, 999, 1);
        this.topNField.setValue(25);
        topNPanel.add("Center", this.topNField);
        JLabel datapointsLabel = new JLabel();
        datapointsLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        datapointsLabel.setText("Datapoints");
        topNPanel.add("East", datapointsLabel);
        this.comboBox = new JComboBox<String>(this.comboList);
        this.comboBox.addItemListener(this);
        this.comboBox.addActionListener(this);
        if (this.chartmain.chart.sortValue == 0) {
            this.comboBox.setSelectedIndex(0);
        } else {
            this.comboBox.setSelectedIndex(this.dim);
        }
        this.enableTopN.setSelected(this.chart.maxDataLen > 0);
        this.topNField.setEnabled(this.chart.maxDataLen > 0);
        if (this.chart.maxDataLen > 0) {
            this.topNField.setEnabled(true);
            this.topNField.setValue(this.chart.maxDataLen);
        }
        this.topNPanelSetEnabled(this.isTopNFeatureAvail());
        this.noneValCheckbox.addItemListener(this);
        this.ascValCheckbox.addItemListener(this);
        this.descValCheckbox.addItemListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        this.butcancel.addActionListener(this);
        this.butOK.addActionListener(this);
        buttonPanel.add(this.butOK);
        buttonPanel.add(this.butcancel);
        BorderPanel orderByPanel = new BorderPanel(LanguageEncoder.getText("Order by ..."));
        orderByPanel.setLayout(new BorderLayout());
        orderByPanel.add((Component)this.comboBox, "Center");
        this.cop = (JPanel)this.getContentPane();
        this.cop.setLayout(new BorderLayout());
        this.cop.add((Component)orderByPanel, "First");
        this.actualPanel = this.orderpanel[this.comboBox.getSelectedIndex()];
        this.cop.add((Component)this.actualPanel, "Center");
        if (this.chart.dataDim == 1) {
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
            bottomPanel.add(topNPanel);
            bottomPanel.add(buttonPanel);
            this.cop.add((Component)bottomPanel, "Last");
        } else {
            this.cop.add((Component)buttonPanel, "Last");
        }
        Dimension screensize = this.getToolkit().getScreenSize();
        this.setBounds((screensize.width - 225) / 2, (screensize.height - 275) / 2, 225, 275);
    }

    private void topNPanelSetEnabled(boolean b) {
        this.enableTopN.setEnabled(b);
        if (b) {
            this.topNField.setEnabled(this.enableTopN.isSelected());
        } else {
            this.topNField.setEnabled(false);
        }
    }

    public void show(int i) {
        this.comboBox.setSelectedIndex(i);
        this.setVisible(true);
    }

    private boolean isTopNFeatureAvail() {
        if (this.chart.dataDim != 1) {
            return false;
        }
        if (this.comboBox.getSelectedIndex() == 0) {
            return this.displayMode[0].getSelectedIndex() == 1 || this.displayMode[0].getSelectedIndex() == 2;
        }
        return this.ascValCheckbox.isSelected() || this.descValCheckbox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.comboBox) {
            if (this.actualPanel != null && this.cop != null) {
                this.cop.remove(this.actualPanel);
                this.actualPanel = this.orderpanel[this.comboBox.getSelectedIndex()];
                this.cop.add((Component)this.actualPanel, "Center");
                this.validate();
                this.repaint();
            }
        } else if (target == this.butOK) {
            int maxDataLen = -1;
            if (this.isTopNFeatureAvail() && this.enableTopN.isSelected()) {
                maxDataLen = this.topNField.getValue();
            }
            this.dispose();
            this.chart.setSortValue(0);
            this.chart.mData = this.chart.mData.resortOriginalMultiDimData();
            if (this.chart.mData2 != null) {
                this.chart.mData2 = this.chart.mData2.resortOriginalMultiDimData();
            }
            for (int i = 0; i < this.dim; ++i) {
                if (this.chart.mDataMap[i] == this.chart.nCol) continue;
                this.chartmain.setModifiedOnly();
                this.chart.setFieldOrder(i, this.getName(i));
                this.chart.setDataOrdering(i, this.dataOrdering[i]);
                this.displayMode[i].setSelectedIndex(this.dataOrdering[i]);
            }
            if (this.comboBox.getSelectedIndex() == this.dim) {
                this.chartmain.setModifiedOnly();
                boolean isPrimary = this.primValCheckbox.isSelected();
                boolean isAsc = this.ascValCheckbox.isSelected();
                boolean isDesc = this.descValCheckbox.isSelected();
                if (isPrimary && isAsc) {
                    this.chart.setSortValue(1);
                } else if (!isPrimary && isAsc) {
                    this.chart.setSortValue(3);
                } else if (isPrimary && isDesc) {
                    this.chart.setSortValue(2);
                } else if (!isPrimary && isDesc) {
                    this.chart.setSortValue(4);
                } else {
                    for (int i = 0; i < this.dim; ++i) {
                        this.chart.setFieldOrder(i, this.chart.colData[this.chart.mDataMap[i]].getOriginalFieldName());
                        this.chart.setDataOrdering(i, 0);
                    }
                    this.chart.setSortValue(0);
                }
                if (isAsc || isDesc) {
                    this.chart.setValueOrder(isPrimary, isAsc);
                }
            }
            this.chart.setMaxNumberOfCategories(maxDataLen);
            if (!this.chart.isSaveColorsForCategories()) {
                this.chart.reassignDataColors();
            }
            this.chartmain.chartPanel.repaint();
        } else if (target == this.butcancel) {
            this.dispose();
        } else {
            for (int i = 0; i < this.dim; ++i) {
                if (target == this.upbutton[i]) {
                    this.do_up(i);
                    continue;
                }
                if (target != this.downbutton[i]) continue;
                this.do_down(i);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.processing) {
            return;
        }
        this.processing = true;
        Object target = e.getSource();
        if (target == this.enableTopN) {
            this.topNField.setEnabled(this.enableTopN.isSelected());
        }
        for (int i = 0; i < this.dim; ++i) {
            if (target != this.displayMode[i]) continue;
            if (this.displayMode[i].getSelectedIndex() == 1) {
                this.do_sort(true, i);
            } else if (this.displayMode[i].getSelectedIndex() == 2) {
                this.do_sort(false, i);
            } else if (this.displayMode[i].getSelectedIndex() == 0) {
                this.do_originalSorting(i);
            } else if (this.displayMode[i].getSelectedIndex() == 3) {
                this.noneValCheckbox.setSelected(true);
                this.dataOrdering[i] = 3;
                this.displayMode[i].setSelectedIndex(this.dataOrdering[i]);
            }
            this.upbutton[i].setEnabled(this.displayMode[i].getSelectedIndex() == 3);
            this.downbutton[i].setEnabled(this.displayMode[i].getSelectedIndex() == 3);
        }
        this.topNPanelSetEnabled(this.isTopNFeatureAvail());
        this.processing = false;
    }

    private void do_sort(boolean isAsc, int i) {
        this.noneValCheckbox.setSelected(true);
        ColData colData = this.chart.colData[this.chart.mDataMap[i]];
        this.dataOrdering[i] = isAsc ? 1 : 2;
        this.displayMode[i].setSelectedIndex(this.dataOrdering[i]);
        this.setName(colData.getSortOrder(isAsc), i);
    }

    private void do_up(int i) {
        this.noneValCheckbox.setSelected(true);
        int k = this.datalist[i].getSelectedIndex();
        if (k <= 0) {
            return;
        }
        Object[] name = this.getName(i);
        Object s = name[k];
        name[k] = name[k - 1];
        name[k - 1] = s;
        this.setName(name, i);
        this.dataOrdering[i] = 3;
        this.displayMode[i].setSelectedIndex(this.dataOrdering[i]);
        this.datalist[i].setSelectedIndex(k - 1);
    }

    private void do_down(int i) {
        this.noneValCheckbox.setSelected(true);
        int k = this.datalist[i].getSelectedIndex();
        if (k < 0 || k >= this.datalist[i].getModel().getSize() - 1) {
            return;
        }
        Object[] name = this.getName(i);
        Object s = name[k];
        name[k] = name[k + 1];
        name[k + 1] = s;
        this.setName(name, i);
        this.dataOrdering[i] = 3;
        this.displayMode[i].setSelectedIndex(this.dataOrdering[i]);
        this.datalist[i].setSelectedIndex(k + 1);
    }

    private void do_originalSorting(int i) {
        ColData colData = this.chart.colData[this.chart.mDataMap[i]];
        this.setName(colData.getOriginalFieldName(), i);
        this.dataOrdering[i] = 0;
        this.displayMode[i].setSelectedIndex(this.dataOrdering[i]);
    }

    private Object[] getName(int i) {
        Object[] name = new Object[this.datalist[i].getModel().getSize()];
        for (int j = 0; j < name.length; ++j) {
            name[j] = this.datalist[i].getModel().getElementAt(j);
        }
        return name;
    }

    private void setName(Object[] name, int i) {
        DefaultListModel model = (DefaultListModel)this.datalist[i].getModel();
        if (model.getSize() > 0) {
            model.removeAllElements();
        }
        for (Object element : name) {
            model.addElement(element);
        }
        this.datalist[i].setModel(model);
    }
}

