/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import quadbase.chart.Chart;
import quadbase.chart.DataAttribute;
import quadbase.chart.IPieChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.JSwatchChooserPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.swing.color.DefaultHSBChooserPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class DataPropDialog
extends QbDialog {
    ChartMain chartmain;
    Chart chart;
    SpinBox spinWidth;
    JButton okButton;
    JButton cancelButton;
    JCheckBox checkNegativeLabel1;
    boolean isNegativeLabelEnabled = false;
    ColorButton colorButton1;
    JCheckBox checkNullLine;
    JCheckBox checkDottedLine;
    JCheckBox checkTopLabel;
    JCheckBox checkNullInScatter;
    JCheckBox checkShowShadowOnLine;
    JCheckBox checkTopLabel2;
    JCheckBox useFlatDataPoints;
    JCheckBox showZeroAsNull;
    JCheckBox saveColorsForCategories;
    JCheckBox checkOffsetTicker;
    JRadioButton checkPositiveSide;
    JRadioButton checkNegativeSide;
    JRadioButton checkDefaultPosition;
    JCheckBox checkStackLabel;
    JComboBox primAlignCombo;
    JComboBox stackAlignCombo;

    public DataPropDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.setBackground(Color.lightGray);
        boolean pieChart = this.chart instanceof IPieChart;
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(new JLabel(LanguageEncoder.getText("Column width :")));
        this.spinWidth = new SpinBox(1, 10);
        panel1.add(this.spinWidth);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        this.checkNullLine = new JCheckBox(LanguageEncoder.getText("Show data for nulls"));
        panel2.add(this.checkNullLine);
        this.checkNullLine.addItemListener(this);
        this.checkDottedLine = new JCheckBox(LanguageEncoder.getText("Use dotted line for nulls"));
        panel2.add(this.checkDottedLine);
        this.checkNullInScatter = new JCheckBox(LanguageEncoder.getText("Show null as zero"));
        if (this.chart.getChartType() == 2 || this.chart.getChartType() == 3) {
            panel2.add(this.checkNullInScatter);
        }
        JPanel panel3 = new JPanel(new FlowLayout(0));
        this.checkTopLabel = new JCheckBox(LanguageEncoder.getText("Show primary"));
        panel3.add(this.checkTopLabel);
        this.checkStackLabel = new JCheckBox(LanguageEncoder.getText("Show stack section"));
        panel3.add(this.checkStackLabel);
        this.checkTopLabel.addItemListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        p1.add(new JLabel(LanguageEncoder.getText("Negative Label Color :")));
        this.colorButton1 = new ColorButton(LanguageEncoder.getText("Color"));
        p1.add(this.colorButton1);
        this.colorButton1.addActionListener(this);
        boolean bl = this.isNegativeLabelEnabled = this.chart.topvalueNegativeLabel_color != null;
        if (this.isNegativeLabelEnabled) {
            this.setColor(this.chart.topvalueNegativeLabel_color);
        }
        this.checkNegativeLabel1 = new JCheckBox(LanguageEncoder.getText("Enable"), this.isNegativeLabelEnabled);
        p1.add(this.checkNegativeLabel1);
        this.checkNegativeLabel1.addItemListener(this);
        this.colorButton1.setEnabled(this.isNegativeLabelEnabled && this.chart.getTopValueState());
        this.checkNegativeLabel1.setEnabled(this.chart.getTopValueState());
        JPanel panel6 = new JPanel(new FlowLayout(0));
        this.checkTopLabel2 = new JCheckBox(LanguageEncoder.getText("Show secondary"));
        panel6.add(this.checkTopLabel2);
        this.checkTopLabel2.addItemListener(this);
        JPanel panel5 = new JPanel(new FlowLayout(0));
        this.checkOffsetTicker = new JCheckBox(LanguageEncoder.getText("Draw from end to end"));
        panel5.add(this.checkOffsetTicker);
        this.checkShowShadowOnLine = new JCheckBox(LanguageEncoder.getText("Show shadow on line"));
        panel5.add(this.checkShowShadowOnLine);
        JPanel panel7 = new JPanel(new FlowLayout(0));
        this.useFlatDataPoints = new JCheckBox(LanguageEncoder.getText("Use flat data points"));
        if (!pieChart) {
            panel7.add(this.useFlatDataPoints);
        }
        this.showZeroAsNull = new JCheckBox(LanguageEncoder.getText("Do not show Zero value"));
        if (this.chart.isStackType()) {
            panel7.add(this.showZeroAsNull);
        }
        this.saveColorsForCategories = new JCheckBox(LanguageEncoder.getText("Save Colors for Categories"));
        this.saveColorsForCategories.setToolTipText("<html>If you enable this feature, colors of chart data points will be assigned to<br>names of categories (or series for charts with series).</html>");
        if (!this.chart.isStackType()) {
            panel7.add(this.saveColorsForCategories);
        }
        if (this.chartmain.chart.isSingleColorForCategories()) {
            this.saveColorsForCategories.setEnabled(false);
            this.saveColorsForCategories.setSelected(false);
            this.saveColorsForCategories.setToolTipText("This option is only available for charts with \"Single Color for All Categories\" feature off.");
        }
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new BoxLayout(lpanel, 1));
        if (this.chart.getChartType() == 0 || this.chart.getChartType() == 1 || this.chart.getChartType() == 4 || this.chart.getChartType() == 5 || this.chart.getChartType() == 11 || this.chart.getChartType() == 14 || this.chart.getChartType() == 9 || this.chart.getChartType() == 10 || this.chart.getCategoryType() == 15) {
            lpanel.add(panel1);
        }
        if (!pieChart) {
            lpanel.add(panel2);
            lpanel.add(panel5);
        }
        lpanel.add(panel7);
        JPanel dpanel = new JPanel();
        dpanel.setLayout(new BoxLayout(dpanel, 1));
        if (!pieChart) {
            dpanel.add(panel3);
            dpanel.add(p1);
            dpanel.add(panel6);
        }
        BorderPanel linepanel = new BorderPanel(LanguageEncoder.getText("Data Properties"));
        linepanel.setLayout(new BorderLayout());
        linepanel.add("Center", lpanel);
        BorderPanel datapanel = new BorderPanel(LanguageEncoder.getText("Top Label Properties"));
        datapanel.setLayout(new BorderLayout());
        datapanel.add("Center", dpanel);
        BorderPanel labelPanel = new BorderPanel(LanguageEncoder.getText("Top Label Position"));
        labelPanel.setLayout(new FlowLayout(0));
        this.checkDefaultPosition = new JRadioButton(LanguageEncoder.getText("Default"), !this.chart.isLabelOnPositiveSide() && !this.chart.isLabelOnNegativeSide());
        this.checkPositiveSide = new JRadioButton(LanguageEncoder.getText("Positive Side"), this.chart.isLabelOnPositiveSide());
        this.checkNegativeSide = new JRadioButton(LanguageEncoder.getText("Negative Side"), this.chart.isLabelOnNegativeSide());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.checkDefaultPosition);
        bg.add(this.checkPositiveSide);
        bg.add(this.checkNegativeSide);
        if (!pieChart) {
            labelPanel.add(this.checkDefaultPosition);
            labelPanel.add(this.checkPositiveSide);
            labelPanel.add(this.checkNegativeSide);
        }
        BorderPanel alignPanel = new BorderPanel(LanguageEncoder.getText("Label Alignment"));
        alignPanel.setLayout(new GridLayout(-1, 2, 5, 5));
        this.primAlignCombo = this.createCombo();
        this.stackAlignCombo = this.createStackCombo();
        this.setSelectedIndex(this.chart.topLabel_Alignment, this.primAlignCombo);
        this.setStackSelectedIndex(this.chart.stackLabel_Alignment);
        alignPanel.add(new JLabel(LanguageEncoder.getText("Primary")));
        alignPanel.add(this.primAlignCombo);
        if (this.chart.getSumByIndex() >= 0 && (this.chart.chartType == 4 || this.chart.chartType == 5 || this.chart.chartType == 8)) {
            alignPanel.add(new JLabel(LanguageEncoder.getText("Stack Section")));
            alignPanel.add(this.stackAlignCombo);
        }
        JPanel but_panel = new JPanel();
        but_panel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        but_panel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        but_panel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("North", linepanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add("North", datapanel);
        if (!pieChart) {
            centerPanel.add("Center", labelPanel);
            centerPanel.add("South", alignPanel);
            cop.add("Center", centerPanel);
        }
        cop.add("South", but_panel);
        this.spinWidth.setValue(10 - (int)this.chart.getBarwidthRatio());
        this.checkNullLine.setSelected(this.chart.getNullDataLine());
        if (this.chart.getChartType() == 2) {
            this.checkNullInScatter.setSelected(this.chart.isShowNullInScatter());
        } else {
            this.checkNullInScatter.setSelected(this.chart.isNullDataAsZero());
        }
        this.checkDottedLine.setSelected(!this.chart.isApplyLineStyleToNullData());
        this.checkShowShadowOnLine.setSelected(this.chart.isShowShadowOnLine());
        this.useFlatDataPoints.setSelected(!this.chart.isShowShadowOnPoint());
        this.showZeroAsNull.setSelected(this.chart.isZeroAsNullData());
        this.saveColorsForCategories.setSelected(this.chart.isSaveColorsForCategories());
        this.checkOffsetTicker.setSelected(!this.chart.showOffsetTicker());
        this.checkOffsetTicker.setEnabled(this.supportOffsetTicker());
        this.checkTopLabel.setSelected(this.chart.getTopValueState());
        this.checkStackLabel.setSelected(this.chart.getStackLabelState());
        this.checkStackLabel.setEnabled(this.chart.getSumByIndex() >= 0 && (this.chart.chartType == 4 || this.chart.chartType == 5 || this.chart.chartType == 8));
        if (this.checkStackLabel.isEnabled() && this.chart.getStackLabelState()) {
            this.checkTopLabel.setSelected(this.chart.getStackTotalLabelState());
        }
        this.checkTopLabel2.setSelected(this.chart.getTopValueState2());
        this.checkTopLabel2.setEnabled(this.chart.showLegend2());
        this.checkDefaultPosition.setEnabled(this.chart.getTopValueState() && this.supportPositiveSide());
        this.checkPositiveSide.setEnabled(this.chart.getTopValueState() && this.supportPositiveSide());
        this.checkNegativeSide.setEnabled(this.chart.getTopValueState() && this.supportPositiveSide());
        this.disableComponents();
    }

    private static JColorChooser getColorChooser(ChartMain chartMain, Color initColor) {
        JColorChooser colorChooser = new JColorChooser();
        AbstractColorChooserPanel[] panels = colorChooser.getChooserPanels();
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[]{new JSwatchChooserPanel(chartMain.getRecentColorArray()), new DefaultHSBChooserPanel(), panels[2]};
        colorChooser.setChooserPanels(newPanels);
        colorChooser.setColor(initColor);
        return colorChooser;
    }

    private static Color showDialog(ChartMain chartMain, String title, Color initColor) {
        JColorChooser pane = DataPropDialog.getColorChooser(chartMain, initColor);
        ColorTracker okTracker = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(chartMain, title, true, pane, okTracker, null);
        dialog.setVisible(true);
        return okTracker.getColor();
    }

    private JComboBox createCombo() {
        JComboBox<String> combo = new JComboBox<String>();
        if (this.isColumnType(this.chart.getChartType())) {
            combo.addItem(LanguageEncoder.getText("Top Alignment"));
            combo.addItem(LanguageEncoder.getText("Center Alignment"));
            combo.addItem(LanguageEncoder.getText("Bottom Alignment"));
            combo.addItem(LanguageEncoder.getText("Top Alignment Inside"));
            combo.addItem(LanguageEncoder.getText("Bottom Alignment Inside"));
        } else {
            combo.addItem(LanguageEncoder.getText("Top Alignment"));
        }
        return combo;
    }

    private JComboBox createStackCombo() {
        JComboBox<String> combo = new JComboBox<String>();
        combo.addItem(LanguageEncoder.getText("Top Alignment"));
        combo.addItem(LanguageEncoder.getText("Center Alignment"));
        combo.addItem(LanguageEncoder.getText("Bottom Alignment"));
        return combo;
    }

    private void setSelectedIndex(int idx, JComboBox combo) {
        if (this.isColumnType(this.chart.getChartType())) {
            combo.setSelectedIndex(idx);
        } else {
            combo.setSelectedIndex(0);
        }
    }

    private int getSelectedIndex(JComboBox combo) {
        if (this.isColumnType(this.chart.getChartType())) {
            return combo.getSelectedIndex();
        }
        return 0;
    }

    private int getStackSelectedIndex() {
        int[] map = new int[]{3, 1, 4};
        return map[this.stackAlignCombo.getSelectedIndex()];
    }

    private void setStackSelectedIndex(int idx) {
        int[] map = new int[]{0, 1, 2, 0, 2};
        this.stackAlignCombo.setSelectedIndex(map[idx]);
    }

    private boolean isColumnType(int chartType) {
        return chartType == 0 || chartType == 1 || chartType == 11 || chartType == 4 || chartType == 5 || chartType == 10 || chartType == 9;
    }

    private void disableComponents() {
        if (!this.chart.is2DChart) {
            this.spinWidth.setEnabled(false);
            this.checkNullLine.setEnabled(false);
            this.checkDottedLine.setEnabled(false);
        } else {
            this.checkDottedLine.setEnabled(this.checkNullLine.isSelected());
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
        }
        super.setVisible(b);
    }

    private void restoreValue() {
        boolean newNegativeState;
        boolean newPositiveState;
        int stackAlign;
        this.chart.setBarwidthRatio(10 - this.spinWidth.getValue());
        this.chart.setNullDataLine(this.checkNullLine.isSelected());
        if (this.chart.getChartType() == 2) {
            this.chart.setShowNullInScatter(this.checkNullInScatter.isSelected());
        } else {
            this.chart.setNullDataAsZero(this.checkNullInScatter.isSelected());
        }
        this.chart.applyLineStyleToNullData(!this.checkDottedLine.isSelected());
        if (this.checkStackLabel.isEnabled() && this.checkStackLabel.isSelected()) {
            this.chart.setTopValueState(true);
            this.chart.setStackLabelState(this.checkStackLabel.isSelected());
            this.chart.setStackTotalLabelState(this.checkTopLabel.isSelected());
            if (!this.chart.is2DChart) {
                this.chart.newSurface();
            }
        } else {
            this.chart.setTopValueState(this.checkTopLabel.isSelected());
            this.chart.setStackLabelState(false);
            if (!this.chart.is2DChart) {
                this.chart.newSurface();
            }
        }
        if (this.checkNegativeLabel1.isSelected()) {
            if (this.getButtonColor() != this.chart.getTopValueColorOnNegativeSide()) {
                this.chart.setTopValueColorOnNegativeSide(this.getButtonColor());
                if (!this.chart.is2DChart) {
                    this.chart.newSurface();
                }
            }
        } else if (this.chart.getTopValueColorOnNegativeSide() != null) {
            this.chart.setTopValueColorOnNegativeSide(null);
            if (!this.chart.is2DChart) {
                this.chart.newSurface();
            }
        }
        this.chart.setTopValueState2(this.checkTopLabel2.isSelected());
        this.chart.setShowShadowOnLine(this.checkShowShadowOnLine.isSelected());
        this.chart.setShowShadowOnPoint(!this.useFlatDataPoints.isSelected());
        this.chart.setZeroAsNullData(this.showZeroAsNull.isSelected());
        boolean saveColors = this.saveColorsForCategories.isSelected();
        this.chart.setSaveColorsForCategories(this.saveColorsForCategories.isSelected());
        this.chart.chartColorSet.setDataPointsColorsMapped(saveColors);
        if (saveColors) {
            this.chart.chartColorSet.setChartDataPointsColors(new DataAttribute((MultiDimData)this.chart.mData, (boolean)false, (boolean)this.chart.is2DChart, (int)this.chart.chartType).dataColor);
            this.chart.clearUnusedDataAttributes();
        }
        if (this.chart.mData2 != null && this.chart.chartColorSet2 != null) {
            this.chart.chartColorSet2.setDataPointsColorsMapped(saveColors);
            if (saveColors) {
                this.chart.chartColorSet2.setChartDataPointsColors(new DataAttribute((MultiDimData)this.chart.mData2, (boolean)true, (boolean)this.chart.is2DChart, (int)this.chart.chartType).dataColor);
            }
        }
        this.chart.setOffsetTicker(!this.checkOffsetTicker.isSelected());
        int topAlign = this.getSelectedIndex(this.primAlignCombo);
        if (topAlign != this.chart.topLabel_Alignment) {
            this.chart.topLabel_Alignment = topAlign;
            if (!this.chart.is2DChart) {
                this.chart.newSurface();
            }
        }
        if ((stackAlign = this.getStackSelectedIndex()) != this.chart.stackLabel_Alignment) {
            this.chart.stackLabel_Alignment = stackAlign;
            if (!this.chart.is2DChart) {
                this.chart.newSurface();
            }
        }
        if ((newPositiveState = this.checkPositiveSide.isSelected()) != this.chart.isLabelOnPositiveSide()) {
            this.chart.setLabelOnPositiveSide(newPositiveState);
            if (!this.chart.is2DChart) {
                this.chart.newSurface();
            }
        }
        if ((newNegativeState = this.checkNegativeSide.isSelected()) != this.chart.isLabelOnNegativeSide()) {
            this.chart.setLabelOnNegativeSide(newNegativeState);
            if (!this.chart.is2DChart) {
                this.chart.newSurface();
            }
        }
    }

    private boolean supportOffsetTicker() {
        return this.chart.is2DChart && (this.chart.chartType == 3 || this.chart.chartType == 7 || this.chart.chartType == 8);
    }

    private boolean supportPositiveSide() {
        int chartType = this.chart.chartType;
        return chartType == 0 || chartType == 1;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.checkNegativeLabel1.setEnabled(this.checkTopLabel.isSelected());
        this.colorButton1.setEnabled(this.checkNegativeLabel1.isSelected() && this.checkTopLabel.isSelected());
        this.checkDottedLine.setEnabled(this.checkNullLine.isEnabled() && this.checkNullLine.isSelected());
        this.checkDefaultPosition.setEnabled((this.checkTopLabel.isSelected() || this.checkTopLabel2.isSelected()) && this.supportPositiveSide());
        this.checkPositiveSide.setEnabled((this.checkTopLabel.isSelected() || this.checkTopLabel2.isSelected()) && this.supportPositiveSide());
        this.checkNegativeSide.setEnabled((this.checkTopLabel.isSelected() || this.checkTopLabel2.isSelected()) && this.supportPositiveSide());
        this.checkStackLabel.setEnabled(this.chart.getSumByIndex() >= 0 && (this.chart.chartType == 4 || this.chart.chartType == 5 || this.chart.chartType == 8));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorButton1) {
            Color currentColor = DataPropDialog.showDialog(this.chartmain, LanguageEncoder.getText("Set Color ..."), this.getButtonColor());
            this.setColor(currentColor);
            return;
        }
        this.dispose();
        if (e.getSource() == this.okButton) {
            this.restoreValue();
            this.chartmain.setModified();
            this.chartmain.qbrepaint();
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.setButtonColor(color);
    }

    private Color getButtonColor() {
        return this.colorButton1.getColor();
    }

    private void setButtonColor(Color color) {
        this.colorButton1.setColor(color);
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

