/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.IOUtil;

public class DateAxisPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(DateAxisPanel.class.getName());
    private JTextField textMinY;
    private JTextField textMaxY;
    private JTextField textScaleY;
    private JTextField textOriginY;
    private JTextField textMinMo;
    private JTextField textMaxMo;
    private JTextField textScaleMo;
    private JTextField textOriginMo;
    private JTextField textMinD;
    private JTextField textMaxD;
    private JTextField textScaleD;
    private JTextField textOriginD;
    private JTextField textMinH;
    private JTextField textMaxH;
    private JTextField textScaleH;
    private JTextField textOriginH;
    private JTextField textMinM;
    private JTextField textMaxM;
    private JTextField textScaleM;
    private JTextField textOriginM;
    private long minY;
    private long maxY;
    private long scaleY;
    private long originY;
    private long minMo;
    private long maxMo;
    private long scaleMo;
    private long originMo;
    private long minD;
    private long maxD;
    private long scaleD;
    private long originD;
    private long minH;
    private long maxH;
    private long scaleH;
    private long originH;
    private long minM;
    private long maxM;
    private long scaleM;
    private long originM;
    private Date minDate;
    private Date maxDate;
    private Date originDate;
    private long scale;
    private int scaleMonth;
    private int rawOffset = TimeZone.getDefault().getRawOffset() / 3600000 + 24;
    private boolean isNumericData = false;
    private boolean isNumericDisplay = false;
    private boolean isTimeData = false;
    private boolean isDateData = false;
    private double minDouble;
    private double maxDouble;
    private double scaleDouble;
    private double originDouble;
    private JCheckBox checkDisplayTime;
    private JCheckBox checkDisplayWeek;
    private Chart chart;
    ChartMain chartMain;
    private int axisId = 0;
    private boolean axisScalePanel = false;

    public DateAxisPanel(ChartMain chartMain, Chart chart, int axisId) {
        this(chartMain, chart, axisId, false);
    }

    public DateAxisPanel(ChartMain chartMain, Chart chart, int axisId, boolean axisScalePanel) {
        this.axisId = axisId;
        this.chartMain = chartMain;
        this.chart = chart;
        this.axisScalePanel = axisScalePanel;
        this.init();
    }

    private void init() {
        this.isNumericData = this.chart.axis[this.axisId].columnField != null && this.chart.axis[this.axisId].columnField.axisType == 99;
        this.isNumericDisplay = !this.chart.isLabelDateTimeDisplay(this.axisId);
        this.isTimeData = this.chart.axis.length >= 1 && this.chart.axis[this.axisId].columnField != null && DataType.isTime(this.chart.axis[this.axisId].columnField.axisType);
        this.isDateData = this.chart.axis.length >= 1 && this.chart.axis[this.axisId].columnField != null && DataType.isDate(this.chart.axis[this.axisId].columnField.axisType);
        this.initializeValues();
        String axisType = "";
        if (this.axisId == 0) {
            axisType = "X";
        } else if (this.axisId == 1) {
            axisType = "Y";
        } else if (this.axisId == 2) {
            axisType = "Z";
        }
        this.setBorder(new TitledBorder(axisType + " " + LanguageEncoder.getText("Axis Date/Time Options")));
        this.setLayout(new BoxLayout(this, 1));
        JPanel subPanel1 = new JPanel(new BorderLayout());
        this.checkDisplayTime = new JCheckBox(LanguageEncoder.getText("Display X-Axis in Time"));
        subPanel1.add("West", this.checkDisplayTime);
        this.checkDisplayTime.setSelected(this.chart.isLabelDateTimeDisplay(this.axisId));
        if (!this.axisScalePanel) {
            this.add(subPanel1);
        }
        JPanel subPanel2 = new JPanel(new BorderLayout());
        this.checkDisplayWeek = new JCheckBox(LanguageEncoder.getText("Display X-Axis in Day of Week"));
        subPanel2.add("West", this.checkDisplayWeek);
        this.checkDisplayWeek.setSelected(this.chart.isDisplayByWeek(this.axisId));
        if (!this.axisScalePanel) {
            this.add(subPanel2);
        }
        JPanel subPanel31 = new JPanel(new FlowLayout(2));
        if (this.isNumericData && this.isNumericDisplay) {
            subPanel31.add(new JLabel(LanguageEncoder.getText("Minimum Scale")));
            this.textMinM = new JTextField(this.minDouble + "", 7);
            subPanel31.add(this.textMinM);
        } else {
            JPanel subPanel30 = new JPanel(new FlowLayout(2));
            subPanel30.add(new JLabel(LanguageEncoder.getText("")));
            JLabel titleY = new JLabel("year", 0);
            subPanel30.add(titleY);
            JLabel titleMo = new JLabel("month", 0);
            subPanel30.add(titleMo);
            JLabel titleD = new JLabel("day", 0);
            subPanel30.add(titleD);
            JLabel titleH = new JLabel("hour", 0);
            subPanel30.add(titleH);
            JLabel titleM = new JLabel("min", 0);
            subPanel30.add(titleM);
            this.add(subPanel30);
            subPanel31.add(new JLabel(LanguageEncoder.getText("Minimum:")));
            this.textMinY = new JTextField(this.minY + "", 4);
            subPanel31.add(this.textMinY);
            this.textMinMo = new JTextField(this.minMo + "", 3);
            subPanel31.add(this.textMinMo);
            this.textMinD = new JTextField(this.minD + "", 2);
            subPanel31.add(this.textMinD);
            this.textMinH = new JTextField(this.minH + "", 2);
            subPanel31.add(this.textMinH);
            this.textMinM = new JTextField(this.minM + "", 2);
            subPanel31.add(this.textMinM);
            titleY.setPreferredSize(this.textMinY.getPreferredSize());
            titleMo.setPreferredSize(this.textMinMo.getPreferredSize());
            titleD.setPreferredSize(this.textMinD.getPreferredSize());
            titleH.setPreferredSize(this.textMinH.getPreferredSize());
            titleM.setPreferredSize(this.textMinM.getPreferredSize());
        }
        this.add(subPanel31);
        JPanel subPanel32 = new JPanel(new FlowLayout(2));
        if (this.isNumericData && this.isNumericDisplay) {
            subPanel32.add(new JLabel(LanguageEncoder.getText("Maximum Scale:")));
            this.textMaxM = new JTextField(this.maxDouble + "", 7);
            subPanel32.add(this.textMaxM);
        } else {
            subPanel32.add(new JLabel(LanguageEncoder.getText("Maximum:")));
            this.textMaxY = new JTextField(this.maxY + "", 4);
            subPanel32.add(this.textMaxY);
            this.textMaxMo = new JTextField(this.maxMo + "", 3);
            subPanel32.add(this.textMaxMo);
            this.textMaxD = new JTextField(this.maxD + "", 2);
            subPanel32.add(this.textMaxD);
            this.textMaxH = new JTextField(this.maxH + "", 2);
            subPanel32.add(this.textMaxH);
            this.textMaxM = new JTextField(this.maxM + "", 2);
            subPanel32.add(this.textMaxM);
        }
        this.add(subPanel32);
        JPanel subPanel33 = new JPanel(new FlowLayout(2));
        if (this.isNumericData && this.isNumericDisplay) {
            subPanel33.add(new JLabel(LanguageEncoder.getText("Scale Step:")));
            this.textScaleM = new JTextField(this.scaleDouble + "", 7);
            subPanel33.add(this.textScaleM);
        } else {
            subPanel33.add(new JLabel(LanguageEncoder.getText("Scale Step:")));
            this.textScaleY = new JTextField(this.scaleY + "", 4);
            subPanel33.add(this.textScaleY);
            this.textScaleMo = new JTextField(this.scaleMo + "", 3);
            subPanel33.add(this.textScaleMo);
            this.textScaleD = new JTextField(this.scaleD + "", 2);
            subPanel33.add(this.textScaleD);
            this.textScaleH = new JTextField(this.scaleH + "", 2);
            subPanel33.add(this.textScaleH);
            this.textScaleM = new JTextField(this.scaleM + "", 2);
            subPanel33.add(this.textScaleM);
        }
        this.add(subPanel33);
        JPanel subPanel34 = new JPanel(new FlowLayout(2));
        if (this.isNumericData && this.isNumericDisplay) {
            subPanel34.add(new JLabel(LanguageEncoder.getText("Origin Scale:")));
            this.textOriginM = new JTextField(this.originDouble + "", 7);
            subPanel34.add(this.textOriginM);
        } else {
            subPanel34.add(new JLabel(LanguageEncoder.getText("Origin:")));
            this.textOriginY = new JTextField(this.originY + "", 4);
            subPanel34.add(this.textOriginY);
            this.textOriginMo = new JTextField(this.originMo + "", 3);
            subPanel34.add(this.textOriginMo);
            this.textOriginD = new JTextField(this.originD + "", 2);
            subPanel34.add(this.textOriginD);
            this.textOriginH = new JTextField(this.originH + "", 2);
            subPanel34.add(this.textOriginH);
            this.textOriginM = new JTextField(this.originM + "", 2);
            subPanel34.add(this.textOriginM);
        }
        if (this.axisScalePanel) {
            this.add(subPanel34);
        }
    }

    private void initializeValues() {
        if (this.isNumericData && this.isNumericDisplay) {
            this.minDouble = this.chart.axis[this.axisId].minScale;
            this.maxDouble = this.chart.axis[this.axisId].maxScale;
            this.scaleDouble = this.chart.axis[this.axisId].stepScale;
            this.originDouble = this.chart.axis[this.axisId].axisShift;
        } else {
            try {
                this.minDate = new Date((long)this.chart.axis[this.axisId].minScale);
                this.maxDate = new Date((long)this.chart.axis[this.axisId].maxScale);
                this.scale = (long)this.chart.axis[this.axisId].stepScale;
                this.originDate = new Date((long)this.chart.axis[this.axisId].axisShift);
                this.scaleMonth = this.chart.axis[this.axisId].stepScaleMonth;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to initialize axis values! Using current date.", ex);
                this.minDate = new Date();
                this.maxDate = new Date();
                this.originDate = new Date();
                this.scale = 1L;
            }
            GregorianCalendar gCal = new GregorianCalendar();
            gCal.setTime(this.minDate);
            this.minY = gCal.get(1);
            this.minMo = gCal.get(2) + 1;
            this.minD = gCal.get(5);
            if (!this.chart.isDisplayByWeek(this.axisId) && this.chart.axis[this.axisId].columnField != null && this.chart.axis[this.axisId].columnField.axisType != 8) {
                this.minH = gCal.get(11);
                this.minM = gCal.get(12);
            } else {
                this.minH = 0L;
                this.minM = 0L;
            }
            gCal.setTime(this.maxDate);
            this.maxY = gCal.get(1);
            this.maxMo = gCal.get(2) + 1;
            this.maxD = gCal.get(5);
            if (!this.chart.isDisplayByWeek(this.axisId) && this.chart.axis[this.axisId].columnField != null && this.chart.axis[this.axisId].columnField.axisType != 8) {
                this.maxH = gCal.get(11);
                this.maxM = gCal.get(12);
            } else {
                this.maxH = 0L;
                this.maxM = 0L;
            }
            this.scaleY = (int)Math.floor(this.scaleMonth / 12);
            this.scaleMo = this.scaleMonth % 12;
            this.scale /= 1000L;
            this.scaleD = (int)this.scale / 86400;
            this.scale = (int)this.scale % 86400;
            this.scaleH = (int)this.scale / 3600;
            this.scale = (int)this.scale % 3600;
            this.scaleM = (int)this.scale / 60;
            gCal.setTime(this.originDate);
            this.originY = gCal.get(1);
            this.originMo = gCal.get(2) + 1;
            this.originD = gCal.get(5);
            if (!this.chart.isDisplayByWeek(this.axisId)) {
                this.originH = gCal.get(11);
                this.originM = gCal.get(12);
            } else {
                this.originH = 0L;
                this.originM = 0L;
            }
        }
    }

    String setValues() {
        block23: {
            try {
                this.chart.setLabelDateTimeDisplay(this.axisId, this.checkDisplayTime.isSelected());
                this.chart.setDisplayByWeek(this.axisId, this.checkDisplayWeek.isSelected());
                if (this.isNumericData && this.isNumericDisplay) {
                    this.minDouble = Double.valueOf(this.textMinM.getText());
                    this.maxDouble = Double.valueOf(this.textMaxM.getText());
                    this.scaleDouble = Double.valueOf(this.textScaleM.getText());
                    this.originDouble = Double.valueOf(this.textOriginM.getText());
                    if (this.maxDouble < this.minDouble) {
                        return LanguageEncoder.getText("Maximum or minimum value is not set correctly!");
                    }
                    if (this.originDouble < this.minDouble) {
                        return LanguageEncoder.getText("Origin value must be equal or greater minimum value!");
                    }
                    if (this.originDouble > this.maxDouble) {
                        return LanguageEncoder.getText("Origin value must be eqaul or lesser maximum value!");
                    }
                } else {
                    GregorianCalendar gCal;
                    this.minY = this.validateDateInt(this.textMinY.getText(), 1970);
                    this.minMo = this.validateDateInt(this.textMinMo.getText()) - 1;
                    this.minD = this.validateDateInt(this.textMinD.getText());
                    this.minH = this.validateIntInput(this.textMinH.getText(), 23);
                    this.minM = this.validateIntInput(this.textMinM.getText(), 59);
                    if (!IOUtil.isJava2D() && this.chart.axis[this.axisId].columnField != null && DataType.isDateTime(this.chart.axis[this.axisId].columnField.axisType) && this.chart.axis[this.axisId].columnField.axisType != 9) {
                        gCal = new GregorianCalendar((int)this.minY, (int)this.minMo, (int)this.minD, this.minH + (long)this.rawOffset > 23L ? 23 : (int)this.minH + this.rawOffset, (int)this.minM);
                        this.minH -= (long)this.rawOffset;
                        if (this.minH < 0L) {
                            this.minH = 0L;
                        }
                        String hourStr = Integer.toString((int)this.minH);
                        this.textMinH.setText(hourStr);
                        this.textMaxH.setText(hourStr);
                    } else {
                        gCal = new GregorianCalendar((int)this.minY, (int)this.minMo, (int)this.minD, (int)this.minH, (int)this.minM);
                    }
                    this.minDate = gCal.getTime();
                    this.maxY = this.validateDateInt(this.textMaxY.getText(), 1970);
                    this.maxMo = this.validateDateInt(this.textMaxMo.getText()) - 1;
                    this.maxD = this.validateDateInt(this.textMaxD.getText());
                    this.maxH = this.validateIntInput(this.textMaxH.getText(), 23);
                    this.maxM = this.validateIntInput(this.textMaxM.getText(), 59);
                    gCal = new GregorianCalendar((int)this.maxY, (int)this.maxMo, (int)this.maxD, (int)this.maxH, (int)this.maxM);
                    this.maxDate = gCal.getTime();
                    if (this.maxDate.before(this.minDate)) {
                        return LanguageEncoder.getText("Maximum or minimum date is not set correctly!");
                    }
                    this.scaleY = this.validateIntInput(this.textScaleY.getText());
                    this.scaleMo = this.validateIntInput(this.textScaleMo.getText()) - 1;
                    this.scaleD = this.validateIntInput(this.textScaleD.getText());
                    this.scaleH = this.validateIntInput(this.textScaleH.getText(), 23);
                    this.scaleM = this.validateIntInput(this.textScaleM.getText(), 59);
                    this.scale = (this.scaleD * 86400L + this.scaleH * 3600L + this.scaleM * 60L) * 1000L;
                    this.originY = this.validateDateInt(this.textOriginY.getText(), 1970);
                    this.originMo = this.validateDateInt(this.textOriginMo.getText()) - 1;
                    this.originD = this.validateDateInt(this.textOriginD.getText());
                    this.originH = this.validateIntInput(this.textOriginH.getText(), 23);
                    this.originM = this.validateIntInput(this.textOriginM.getText(), 59);
                    gCal = new GregorianCalendar((int)this.originY, (int)this.originMo, (int)this.originD, (int)this.originH, (int)this.originM);
                    this.originDate = gCal.getTime();
                    if (this.axisScalePanel) {
                        if (this.originDate.before(this.minDate)) {
                            return LanguageEncoder.getText("Origin or minimum date is not set correctly!");
                        }
                        if (this.originDate.after(this.maxDate)) {
                            return LanguageEncoder.getText("Origin or maximum date is not set correctly!");
                        }
                    }
                }
                if (this.scale != 0L || this.scaleMo > 0L || this.scaleY > 0L) {
                    this.chart.setAxisAutoScale(this.axisId, false);
                    try {
                        this.chart.setAxisMinScale(this.axisId, this.minDate.getTime(), true);
                        this.chart.setAxisMaxScale(this.axisId, this.maxDate.getTime(), true);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.log(Level.FINER, "Failed to set axis min/max scale", e);
                        return e.getMessage();
                    }
                    this.chart.setAxisStepSize(this.axisId, this.scale);
                    if (this.scaleMo >= 0L || this.scaleY >= 0L) {
                        int val = (int)(this.scaleY * 12L + this.scaleMo);
                        this.chart.setAxisStepMonth(this.axisId, val);
                    }
                    if (this.axisScalePanel) {
                        this.chart.setUserOriginX(this.originDate.getTime());
                    } else {
                        this.chart.setUserOriginX(this.minDouble);
                    }
                    break block23;
                }
                if (this.scaleDouble > 0.0) {
                    this.chart.setAxisAutoScale(this.axisId, false);
                    this.chart.setAxisMinScale(this.axisId, this.minDouble);
                    this.chart.setAxisMaxScale(this.axisId, this.maxDouble);
                    this.chart.setAxisStepSize(this.axisId, this.scaleDouble);
                    if (this.axisScalePanel) {
                        this.chart.setUserOriginX(this.originDouble);
                    } else {
                        this.chart.setUserOriginX(this.minDouble);
                    }
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Failed to set date axis parameters (Invalid number)", ex);
                return LanguageEncoder.getText("Invalid number") + "\n" + ex.getMessage();
            }
        }
        return null;
    }

    private int validateDateInt(String s) {
        return this.validateDateInt(s, 1);
    }

    private int validateDateInt(String s, int def) {
        int i = this.validateIntInput(s);
        if (i == 0) {
            return def;
        }
        return i;
    }

    private int validateIntInput(String s) {
        int i = 0;
        if (s.trim().length() > 0) {
            i = Integer.parseInt(s);
        }
        return i;
    }

    private int validateIntInput(String s, int maxValue) {
        int i = 0;
        if (s.trim().length() > 0) {
            i = Integer.parseInt(s);
            if (i > maxValue) {
                return maxValue;
            }
            if (i < 0) {
                return 0;
            }
        }
        return i;
    }

    private void resetValue(JTextField textField) {
        if (textField == null) {
            return;
        }
        textField.setText("");
    }

    @Override
    public void setEnabled(boolean b) {
        boolean enableHM;
        boolean enableYMD;
        super.setEnabled(b);
        if (b) {
            this.textOriginY.setEnabled(!this.isTimeData);
            this.textOriginMo.setEnabled(!this.isTimeData);
            this.textOriginD.setEnabled(!this.isTimeData);
        }
        boolean bl = b ? (!this.isTimeData ? b : false) : (enableYMD = b);
        boolean bl2 = b ? (!this.isDateData ? b : false) : (enableHM = b);
        if (this.textMinY != null) {
            this.textMinY.setEnabled(enableYMD);
        }
        if (this.textMaxY != null) {
            this.textMaxY.setEnabled(enableYMD);
        }
        if (this.textScaleY != null) {
            this.textScaleY.setEnabled(enableYMD);
        }
        if (this.textOriginY != null) {
            this.textOriginY.setEnabled(enableYMD);
        }
        if (this.textMinMo != null) {
            this.textMinMo.setEnabled(enableYMD);
        }
        if (this.textMaxMo != null) {
            this.textMaxMo.setEnabled(enableYMD);
        }
        if (this.textScaleMo != null) {
            this.textScaleMo.setEnabled(enableYMD);
        }
        if (this.textOriginMo != null) {
            this.textOriginMo.setEnabled(enableYMD);
        }
        if (this.textMinD != null) {
            this.textMinD.setEnabled(enableYMD);
        }
        if (this.textMaxD != null) {
            this.textMaxD.setEnabled(enableYMD);
        }
        if (this.textScaleD != null) {
            this.textScaleD.setEnabled(enableYMD);
        }
        if (this.textOriginD != null) {
            this.textOriginD.setEnabled(enableYMD);
        }
        if (this.textMinH != null) {
            this.textMinH.setEnabled(enableHM);
        }
        if (this.textMaxH != null) {
            this.textMaxH.setEnabled(enableHM);
        }
        if (this.textScaleH != null) {
            this.textScaleH.setEnabled(enableHM);
        }
        if (this.textOriginH != null) {
            this.textOriginH.setEnabled(enableHM);
        }
        if (this.textMinM != null) {
            this.textMinM.setEnabled(enableHM);
        }
        if (this.textMaxM != null) {
            this.textMaxM.setEnabled(enableHM);
        }
        if (this.textScaleM != null) {
            this.textScaleM.setEnabled(enableHM);
        }
        if (this.textOriginM != null) {
            this.textOriginM.setEnabled(enableHM);
        }
    }
}

