/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.QbUtil;

public class DialDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(DialDialog.class.getName());
    JButton okButton;
    JButton cancelButton;
    JButton applyRatio;
    JButton applyThickness;
    Chart chart;
    ChartMain chartMain;
    JCheckBox checkBorder;
    JCheckBox checkArrow;
    JCheckBox checkFullCircle;
    JCheckBox selectAll;
    JCheckBox[] handCheckBox;
    JTextField startingAngle;
    JTextField endingAngle;
    JTextField internalRadius;
    JTextField selectedRatio;
    JTextField[] handRatio;
    SpinBox[] handThickness;
    SpinBox selectedThickness;
    JRadioButton stick_Style;
    JRadioButton pointer_Style;
    JRadioButton triangularPointer_Style;
    JRadioButton pointedBlade_Style;
    JRadioButton roundHeadedBlade_Style;

    public DialDialog(JFrame frame, Chart chart) {
        super(frame, LanguageEncoder.getText("Dial Chart Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if ((double)dim.height > (double)screenSize.height * 0.6) {
            dim.height = (int)((double)screenSize.height * 0.6);
            dim.width += 20;
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        BorderPanel anglePanel = new BorderPanel("Draw Options");
        anglePanel.setLayout(new GridLayout(0, 2, 5, 5));
        anglePanel.add(new JLabel(LanguageEncoder.getText("Starting Angle")));
        this.startingAngle = new JTextField(8);
        anglePanel.add(this.startingAngle);
        this.startingAngle.setText(Double.valueOf(this.chart.getStartAngleForDial()).toString());
        anglePanel.add(new JLabel(LanguageEncoder.getText("Ending Angle")));
        this.endingAngle = new JTextField(8);
        anglePanel.add(this.endingAngle);
        this.endingAngle.setText(Double.valueOf(this.chart.getEndAngleForDial()).toString());
        anglePanel.add(new JLabel(LanguageEncoder.getText("Center Point Radius")));
        this.internalRadius = new JTextField(8);
        anglePanel.add(this.internalRadius);
        this.internalRadius.setText(Double.valueOf(this.chart.getRadiusForInternalDial()).toString());
        BorderPanel checkPanel = new BorderPanel("Other Options");
        checkPanel.setLayout(new GridLayout(3, 1, 5, 5));
        this.checkBorder = new JCheckBox(LanguageEncoder.getText("Draw Border"));
        checkPanel.add(this.checkBorder);
        this.checkBorder.setSelected(this.chart.getDataBorder());
        this.checkArrow = new JCheckBox(LanguageEncoder.getText("Draw Arrow"));
        checkPanel.add(this.checkArrow);
        this.checkArrow.setSelected(this.chart.getArrowState());
        this.checkFullCircle = new JCheckBox(LanguageEncoder.getText("Draw Full Circle"));
        checkPanel.add(this.checkFullCircle);
        this.checkFullCircle.setSelected(this.chart.isDrawFullCircleForDial());
        BorderPanel needlePanel = new BorderPanel(LanguageEncoder.getText("Needle Style"));
        needlePanel.setLayout(new GridLayout(5, 1, 5, 5));
        this.pointedBlade_Style = new JRadioButton(LanguageEncoder.getText("Pointed Blade"));
        needlePanel.add(this.pointedBlade_Style);
        this.roundHeadedBlade_Style = new JRadioButton(LanguageEncoder.getText("Round Headed Blade"));
        needlePanel.add(this.roundHeadedBlade_Style);
        this.triangularPointer_Style = new JRadioButton(LanguageEncoder.getText("Triangular Pointer"));
        needlePanel.add(this.triangularPointer_Style);
        this.pointer_Style = new JRadioButton(LanguageEncoder.getText("Pointer"));
        needlePanel.add(this.pointer_Style);
        this.stick_Style = new JRadioButton(LanguageEncoder.getText("Rectangular Pointer"));
        needlePanel.add(this.stick_Style);
        ButtonGroup gb = new ButtonGroup();
        gb.add(this.pointedBlade_Style);
        gb.add(this.roundHeadedBlade_Style);
        gb.add(this.triangularPointer_Style);
        gb.add(this.pointer_Style);
        gb.add(this.stick_Style);
        switch (this.chart.getNeedleOption()) {
            case 0: {
                this.stick_Style.setSelected(true);
                break;
            }
            case 1: {
                this.pointer_Style.setSelected(true);
                break;
            }
            case 2: {
                this.triangularPointer_Style.setSelected(true);
                break;
            }
            case 4: {
                this.roundHeadedBlade_Style.setSelected(true);
                break;
            }
            default: {
                this.pointedBlade_Style.setSelected(true);
            }
        }
        BorderPanel applyPanel = new BorderPanel(LanguageEncoder.getText("Apply To Selected Item(s)"));
        applyPanel.setLayout(new GridLayout(2, 3, 5, 5));
        applyPanel.add(new JLabel(LanguageEncoder.getText("Length")));
        this.selectedRatio = new JTextField("0.6", 8);
        applyPanel.add(this.selectedRatio);
        this.applyRatio = new JButton(LanguageEncoder.getText("Apply Now"));
        applyPanel.add(this.applyRatio);
        applyPanel.add(new JLabel(LanguageEncoder.getText("Thickness")));
        this.selectedThickness = new SpinBox(1, 99);
        applyPanel.add(this.selectedThickness);
        this.applyThickness = new JButton(LanguageEncoder.getText("Apply Now"));
        applyPanel.add(this.applyThickness);
        this.selectedThickness.setValue(2);
        this.setApplyEnabled(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 1, 0, 1);
        gc.anchor = 21;
        gc.gridy = 0;
        gc.gridx = 0;
        this.selectAll = new JCheckBox(LanguageEncoder.getText("Select All"));
        mainPanel.add((Component)this.selectAll, gc);
        gc.gridx = 1;
        mainPanel.add((Component)new JLabel(LanguageEncoder.getText("Length")), gc);
        gc.gridx = 2;
        mainPanel.add((Component)new JLabel(LanguageEncoder.getText("Thickness")), gc);
        double[] handLength = this.chart.getHandLength();
        int[] handThickness2 = this.chart.getLineThickess();
        Object[] fieldName = this.chart.colData[this.chart.mDataMap[0]].getFieldName();
        this.handRatio = new JTextField[fieldName.length];
        this.handThickness = new SpinBox[fieldName.length];
        this.handCheckBox = new JCheckBox[fieldName.length];
        for (int i = 0; i < fieldName.length; ++i) {
            gc.gridy = i + 1;
            gc.gridx = 0;
            gc.weightx = 1.0;
            this.handCheckBox[i] = new JCheckBox(fieldName[i].toString());
            mainPanel.add((Component)this.handCheckBox[i], gc);
            this.handCheckBox[i].addItemListener(this);
            gc.gridx = 1;
            gc.weightx = 0.0;
            this.handRatio[i] = new JTextField(8);
            mainPanel.add((Component)this.handRatio[i], gc);
            this.handRatio[i].setText(QbUtil.roundUp(handLength[i]) + "");
            gc.gridx = 2;
            this.handThickness[i] = new SpinBox(1, 99);
            mainPanel.add((Component)this.handThickness[i], gc);
            this.handThickness[i].setValue(handThickness2[i]);
        }
        gc.gridx = 0;
        gc.gridy = fieldName.length + 2;
        gc.weighty = 1.0;
        mainPanel.add((Component)new JPanel(), gc);
        if (fieldName.length > 0) {
            this.selectedRatio.setText(this.handRatio[0].getText());
            this.selectedThickness.setValue(handThickness2[0]);
        }
        this.applyThickness.addActionListener(this);
        this.applyRatio.addActionListener(this);
        this.selectAll.addItemListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new BorderLayout());
        cpanel.add("North", anglePanel);
        cpanel.add("Center", needlePanel);
        cpanel.add("South", checkPanel);
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add("North", cpanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add("West", westPanel);
        JScrollPane scrollPane = new JScrollPane(mainPanel);
        BorderPanel rightPanel = new BorderPanel(LanguageEncoder.getText("Needle Length and Thickness"));
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add("Center", scrollPane);
        rightPanel.add("South", applyPanel);
        topPanel.add("Center", rightPanel);
        Container cop = this.getContentPane();
        cop.add("Center", topPanel);
        cop.add("South", buttonPanel);
        this.setPosition();
    }

    private String setValues() {
        try {
            double[] hand = new double[this.handRatio.length];
            int[] thick = new int[this.handRatio.length];
            for (int i = 0; i < this.handRatio.length; ++i) {
                hand[i] = Double.valueOf(this.handRatio[i].getText());
                thick[i] = this.handThickness[i].getValue();
            }
            double start = Double.valueOf(this.startingAngle.getText());
            double end = Double.valueOf(this.endingAngle.getText());
            double rI = Double.valueOf(this.internalRadius.getText());
            this.chart.setStartAngleForDial(start);
            this.chart.setEndAngleForDial(end);
            this.chart.setHandLength(hand);
            this.chart.setLineThickess(thick);
            this.chart.setDataBorder(this.checkBorder.isSelected());
            this.chart.setArrowState(this.checkArrow.isSelected());
            this.chart.setRadiusForInternalDial(rI);
            this.chart.setDrawFullCircleForDial(this.checkFullCircle.isSelected());
            if (this.stick_Style.isSelected()) {
                this.chart.setNeedleOption(0);
            } else if (this.pointer_Style.isSelected()) {
                this.chart.setNeedleOption(1);
            } else if (this.triangularPointer_Style.isSelected()) {
                this.chart.setNeedleOption(2);
            } else if (this.pointedBlade_Style.isSelected()) {
                this.chart.setNeedleOption(3);
            } else if (this.roundHeadedBlade_Style.isSelected()) {
                this.chart.setNeedleOption(4);
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Invalid number", ex);
            return LanguageEncoder.getText("Invalid number");
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.selectAll) {
            for (JCheckBox element : this.handCheckBox) {
                element.setSelected(this.selectAll.isSelected());
            }
        } else {
            boolean isSelected = false;
            for (JCheckBox element : this.handCheckBox) {
                if (!element.isSelected()) continue;
                isSelected = true;
                break;
            }
            this.setApplyEnabled(isSelected);
        }
    }

    private void setApplyEnabled(boolean state) {
        this.selectedRatio.setEnabled(state);
        this.selectedThickness.setEnabled(state);
        this.applyRatio.setEnabled(state);
        this.applyThickness.setEnabled(state);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.applyThickness) {
            for (int i = 0; i < this.handCheckBox.length; ++i) {
                if (!this.handCheckBox[i].isSelected()) continue;
                this.handThickness[i].setValue(this.selectedThickness.getValue());
            }
        } else if (source == this.applyRatio) {
            for (int i = 0; i < this.handCheckBox.length; ++i) {
                if (!this.handCheckBox[i].isSelected()) continue;
                this.handRatio[i].setText(this.selectedRatio.getText());
            }
        } else if (source == this.okButton) {
            String msg = this.setValues();
            if (msg == null) {
                this.chartMain.setModified();
                this.chartMain.chartPanel.repaint();
                this.dispose();
            } else {
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(msg);
            }
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

