/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.DrillDynamicName;
import quadbase.chart.designer.DrillNameDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DrillDownAggregate
extends QbDialog {
    JComboBox primaryAggregateChoice = null;
    JComboBox secondaryAggregateChoice = null;
    boolean isSecondaryAxis = false;
    JButton okButton = null;
    JButton cancelButton = null;
    JPanel centerPanel = null;
    JPanel buttonPanel = null;
    ChartMain chartMain = null;
    Dimension screensize;
    boolean displayWizardOnDone = false;
    boolean isForDynamic = false;
    boolean isCancelled = false;

    public DrillDownAggregate(ChartMain chartMain, boolean isSecondaryAxis, boolean displayWizard) {
        this(chartMain, isSecondaryAxis, displayWizard, false);
    }

    public DrillDownAggregate(ChartMain chartMain, boolean isSecondaryAxis, boolean displayWizard, boolean isForDynamic) {
        super(chartMain, LanguageEncoder.getText("Aggregate Options..."), true);
        this.chartMain = chartMain;
        this.displayWizardOnDone = displayWizard;
        this.isSecondaryAxis = isSecondaryAxis;
        this.isForDynamic = isForDynamic;
        this.init();
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.centerPanel);
        cop.add("South", this.buttonPanel);
        this.setSize(this.getPreferredSize());
        this.screensize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        this.setBounds((this.screensize.width - dim.width) / 2, (this.screensize.height - dim.height) / 2, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.centerPanel = new BorderPanel();
        if (this.isSecondaryAxis) {
            this.centerPanel.setLayout(new GridLayout(2, 2, 5, 5));
        } else {
            this.centerPanel.setLayout(new GridLayout(1, 2, 5, 5));
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.primaryAggregateChoice = new JComboBox();
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("minimum"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("maximum"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("average"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("sum"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("count"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("first"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("last"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("sumsquare"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("variance"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("stddev"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("countdistinct"));
        this.centerPanel.add(new JLabel(LanguageEncoder.getText("Primary Aggregate:")));
        this.centerPanel.add(this.primaryAggregateChoice);
        String aggName = this.getAggregateName(this.chartMain.chartPanel.chart.primaryAggregate);
        this.primaryAggregateChoice.setSelectedItem(aggName);
        if (this.isSecondaryAxis) {
            this.secondaryAggregateChoice = new JComboBox();
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("minimum"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("maximum"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("average"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("sum"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("count"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("first"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("last"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("sumsquare"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("variance"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("stddev"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("countdistinct"));
            this.centerPanel.add(new JLabel(LanguageEncoder.getText("Secondary Aggregate:")));
            this.centerPanel.add(this.secondaryAggregateChoice);
            aggName = this.getAggregateName(this.chartMain.chartPanel.chart.secondaryAggregate);
            this.secondaryAggregateChoice.setSelectedItem(aggName);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.pack();
    }

    private int getAggregateFunction(int option) {
        String aggFunction = null;
        aggFunction = option == 0 ? this.primaryAggregateChoice.getSelectedItem().toString() : this.secondaryAggregateChoice.getSelectedItem().toString();
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("minimum"))) {
            return 2;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("maximum"))) {
            return 1;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("average"))) {
            return 4;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("sum"))) {
            return 3;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("count"))) {
            return 0;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("first"))) {
            return 5;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("last"))) {
            return 6;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("sumsquare"))) {
            return 7;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("variance"))) {
            return 8;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("stddev"))) {
            return 9;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("countdistinct"))) {
            return 10;
        }
        return -1;
    }

    private String getAggregateName(int value) {
        String functionName = null;
        switch (value) {
            case 2: {
                functionName = LanguageEncoder.getText("minimum");
                break;
            }
            case 1: {
                functionName = LanguageEncoder.getText("maximum");
                break;
            }
            case 4: {
                functionName = LanguageEncoder.getText("average");
                break;
            }
            case 0: {
                functionName = LanguageEncoder.getText("count");
                break;
            }
            case 5: {
                functionName = LanguageEncoder.getText("first");
                break;
            }
            case 6: {
                functionName = LanguageEncoder.getText("last");
                break;
            }
            case 7: {
                functionName = LanguageEncoder.getText("sumsquare");
                break;
            }
            case 8: {
                functionName = LanguageEncoder.getText("variance");
                break;
            }
            case 9: {
                functionName = LanguageEncoder.getText("stddev");
                break;
            }
            case 10: {
                functionName = LanguageEncoder.getText("countdistinct");
                break;
            }
            default: {
                functionName = LanguageEncoder.getText("sum");
            }
        }
        return functionName;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.isCancelled = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        int primaryAggFunction = -1;
        int secondaryAggFunction = -1;
        String drillName = null;
        if (target == this.cancelButton) {
            this.setVisible(false);
            this.isCancelled = true;
            return;
        }
        if (target == this.okButton) {
            primaryAggFunction = this.getAggregateFunction(0);
            if (this.isSecondaryAxis) {
                secondaryAggFunction = this.getAggregateFunction(1);
            }
            this.chartMain.chartPanel.chart.fillAggregators(primaryAggFunction, secondaryAggFunction);
            this.setVisible(false);
            if (this.isForDynamic) {
                DrillDynamicName dnameDialog = new DrillDynamicName(this.chartMain, LanguageEncoder.getText("Enter a drill-down template name"), this.chartMain.getDrillDownName());
                dnameDialog.pack();
                dnameDialog.setVisible(true);
                if (dnameDialog.isCancelled()) {
                    this.isCancelled = true;
                }
                return;
            }
            DrillNameDialog dnameDialog = null;
            drillName = this.chartMain.getDrillDownName();
            if (drillName == null || drillName.equals("")) {
                dnameDialog = new DrillNameDialog(this.chartMain, LanguageEncoder.getText("Enter a base drill-down name to use"), drillName);
                dnameDialog.pack();
                dnameDialog.setVisible(true);
                return;
            }
            if (this.displayWizardOnDone) {
                this.chartMain.displayDrillDown();
            }
        }
    }
}

