/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.designer.InternalListItem;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DrillDownColumnMapDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DrillDownColumnMapDialog.class.getName());
    private boolean modified = false;
    private Chart chart = null;
    private JComboBox[] columnChoices = null;
    private JButton okButton;
    private JButton cancelButton;
    private int[] colInfo_indices = null;

    public DrillDownColumnMapDialog(JFrame parent, Chart r, QueryInParamSet pset) throws Exception {
        super((Frame)parent, true);
        this.init(r, pset);
    }

    public DrillDownColumnMapDialog(JDialog parent, Chart r, QueryInParamSet pset) throws Exception {
        super((Dialog)parent, true);
        this.init(r, pset);
    }

    private void init(Chart r, QueryInParamSet pset) throws Exception {
        if (r == null) {
            throw new Exception(LanguageEncoder.getText("Parent chart not found.\nPlease open a chart and try again."));
        }
        if (pset == null || pset.getParameter() == null) {
            throw new Exception(LanguageEncoder.getText("Parameters are not properly initialized.\nPlease modify the query and try again."));
        }
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Parameter to Column Mapping"));
        this.setDefaultCloseOperation(2);
        this.chart = r;
        QueryInParam[] params = pset.getParameter();
        JPanel topPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        topPanel.setLayout(gbl);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        boolean mapToColumn = false;
        this.columnChoices = new JComboBox[params.length];
        for (int i = 0; i < params.length; ++i) {
            gbc.gridx = 0;
            gbc.gridy = i;
            QueryInParam currP = params[i];
            Label comp = new Label(currP.getPromptName());
            gbl.setConstraints(comp, gbc);
            topPanel.add(comp);
            Vector<Object> compColumns = DrillDownColumnMapDialog.getCompatibleColumns(currP.getSqlType(), this.chart);
            if (compColumns == null) {
                compColumns = new Vector();
            } else {
                mapToColumn = true;
            }
            compColumns.addElement("None");
            this.columnChoices[i] = new JComboBox<Object>(compColumns);
            gbc.gridx = 1;
            gbl.setConstraints(this.columnChoices[i], gbc);
            topPanel.add(this.columnChoices[i]);
        }
        if (!mapToColumn) {
            throw new Exception(LanguageEncoder.getText("Failed to find a compatible column field for any of the parameters.") + "\n" + LanguageEncoder.getText("As least one parameter must map to a column."));
        }
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        bottomPanel.add(this.okButton);
        bottomPanel.add(this.cancelButton);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)topPanel, "Center");
        contentPanel.add((Component)bottomPanel, "South");
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
    }

    private static Vector<Object> getCompatibleColumns(int sqlType, Chart chart) {
        try {
            Vector<Object> ret = new Vector<Object>();
            for (int i = 0; i < chart.dataDim; ++i) {
                if (!DataType.isCompatibleSQLTypes(sqlType, chart.colData[chart.mDataMap[i]].getOriginalDataType())) continue;
                ret.addElement(new InternalListItem(chart.colData[chart.mDataMap[i]].getName(), chart.mDataMap[i]));
            }
            if (ret.size() <= 0) {
                return null;
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Failed to get compatible columns", e);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            boolean mapToColumn = false;
            try {
                this.colInfo_indices = new int[this.columnChoices.length];
                for (int i = 0; i < this.columnChoices.length; ++i) {
                    if (this.columnChoices[i].getSelectedItem() instanceof InternalListItem) {
                        this.colInfo_indices[i] = ((InternalListItem)this.columnChoices[i].getSelectedItem()).colInfo_index;
                        mapToColumn = true;
                        continue;
                    }
                    if (!((String)this.columnChoices[i].getSelectedItem()).equals("None")) continue;
                    this.colInfo_indices[i] = -1;
                }
                if (!mapToColumn) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("At least one parameter must map to a column"));
                }
                this.modified = true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to set drilldown column mapping", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("An unexpected error has occured.\nPlease cancel and try again."));
                this.colInfo_indices = null;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean isModified() {
        return this.modified;
    }

    public int[] getColInfoIndices() {
        if (!this.modified) {
            return null;
        }
        return this.colInfo_indices;
    }
}

