/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ReloadChart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartOption;
import quadbase.chart.designer.ChartType;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DrillDownDialog
extends QbDialog {
    boolean bcompute = true;
    Chart parentChart = null;
    Chart chart;
    ChartType chartTypePanel;
    ChartOption chartOptionPanel;
    ChartOption newPanel = null;
    Dimension screensize;
    ChartMain chartMain;
    boolean changeType = true;
    boolean isChartType = false;
    ColData[] colData = null;

    public DrillDownDialog(ChartMain chartMain) {
        super(chartMain, LanguageEncoder.getText("Drill-Down Data Mapping..."), true);
        this.chartMain = chartMain;
        this.parentChart = chartMain.isDrillDownDefined ? chartMain.parentChart : chartMain.chartPanel.chart;
        this.chartOptionPanel = new ChartOption(this.parentChart, this.parentChart.parameters, false, true, chartMain.currentLevel);
        this.chartOptionPanel.addActionListener(this);
    }

    public void init() {
        this.parentChart = this.chartMain.isDrillDownDefined ? this.chartMain.parentChart : this.chartMain.chartPanel.chart;
        this.isChartType = false;
        int cType = 0;
        this.setDefaultTitle();
        this.colData = this.parentChart.drillDownVector != null && this.parentChart.drillDownVector.size() > 0 ? this.chartMain.getOriginalColData() : this.parentChart.colData;
        this.chartOptionPanel.initialize(cType, this.parentChart.is2DChart, this.colData);
        this.chartOptionPanel.chartPanel.progressiveDraw = true;
        this.changeType = false;
        this.chartOptionPanel.chartPanel.setDialog(this);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.chartOptionPanel);
        this.screensize = this.getToolkit().getScreenSize();
        this.setBounds((this.screensize.width - this.chartOptionPanel.width) / 2, (this.screensize.height - this.chartOptionPanel.height) / 2, this.chartOptionPanel.width, this.chartOptionPanel.height);
    }

    private void setDefaultTitle() {
        this.setTitle(LanguageEncoder.getText("Select Drill-Down Data Mapping"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.chartOptionPanel.butcancel) {
            if (this.chartMain.chartPanel.chart.isTimeChart()) {
                this.chartMain.chartPanel.chart.setTimeChart(false);
            }
            this.chartMain.backToCurrentLevel();
            this.setVisible(false);
            return;
        }
        if (target == this.chartOptionPanel.butdone) {
            this.setTitle(LanguageEncoder.getText("Please wait..."));
            this.chartMain.setModified();
            this.chartMain.chartPanel.chart.resetDrillNumber();
            if (this.parentChart.drillDownVector.size() > 0) {
                this.chartMain.isDrillDownDefined = true;
                this.chartMain.enableNonDrillDownMenu(true);
                this.parentChart.usedColumns = null;
                this.parentChart.summaryChart = true;
                this.chartMain.enableZoomHistOptions(false);
                if (this.parentChart.drillNumber == 0) {
                    for (int j = 0; j < this.parentChart.dataDim; ++j) {
                        this.parentChart.setDataOrdering(j, 3);
                    }
                    this.parentChart = ReloadChart.reloadData(this.parentChart, true);
                }
                this.chartMain.parentChart = this.parentChart;
                this.setVisible(false);
                this.chartMain.backToCurrentLevel();
                this.chartMain.isNewDrillLevel = true;
                this.chartMain.nextDrillDown();
                this.chartMain.setModified();
            }
            this.setVisible(false);
            return;
        }
    }
}

