/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import quadbase.chart.Chart;
import quadbase.chart.DrillDownInfo;
import quadbase.chart.DrillDownNode;
import quadbase.chart.designer.ChartMain;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DrillDownNavigationFrame
extends JFrame
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DrillDownNavigationFrame.class.getName());
    private ChartMain chartMain;
    private JTree tree;
    private JButton addBut;
    private JButton removeBut;
    private JButton editBut;
    private JButton closeBut;
    private JScrollPane scrollPane;

    public DrillDownNavigationFrame(ChartMain rm) throws Exception {
        super(LanguageEncoder.getText("Drill-Down Navigation"));
        if (rm == null || rm.getDrillDownTree() == null) {
            throw new Exception(LanguageEncoder.getText("Failed to initialize drill-down navigation window."));
        }
        this.chartMain = rm;
        this.tree = rm.getDrillDownTree();
        this.setDefaultCloseOperation(2);
        this.setupTree(this.tree);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.tree);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.scrollPane, "Center");
        contentPanel.add((Component)this.getButtonPanel(), "East");
        this.tree.setSelectionRow(0);
        DrillDownNode root = (DrillDownNode)this.tree.getModel().getRoot();
        this.addBut.setEnabled(this.isAddEnabled(root));
        this.removeBut.setEnabled(this.isRemoveEnable(root));
        this.editBut.setEnabled(this.isSwithEnable((DrillDownNode)this.tree.getSelectionPath().getLastPathComponent()));
        this.setPosition();
    }

    public void setPosition() {
        this.pack();
        Dimension dim = this.getPreferredSize();
        dim.height = 200;
        dim.width = 300;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    private boolean isRemoveEnable(DrillDownNode node) {
        return node != null && !node.equals((DrillDownNode)this.tree.getModel().getRoot());
    }

    private boolean isSwithEnable(DrillDownNode node) {
        if (((DrillDownNode)this.tree.getModel().getRoot()).getChildCount() == 0) {
            return false;
        }
        return node != null && !node.equals(this.chartMain.chart.currentNode);
    }

    private boolean isAddEnabled(DrillDownNode node) {
        boolean b;
        boolean bl = b = node != null && node.getChildCount() <= 0;
        if (!b) {
            return false;
        }
        if (node == null || !node.equals(this.chartMain.chart.currentNode)) {
            return false;
        }
        return DrillDownInfo.checkDrillDownType(this.chartMain.chart.getChartType());
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 1, 5, 5));
        this.editBut = new JButton(LanguageEncoder.getText("SWITCH TO"));
        panel.add(this.editBut);
        this.addBut = new JButton(LanguageEncoder.getText("ADD"));
        panel.add(this.addBut);
        this.removeBut = new JButton(LanguageEncoder.getText("REMOVE"));
        panel.add(this.removeBut);
        this.closeBut = new JButton(LanguageEncoder.getText("CLOSE"));
        panel.add(this.closeBut);
        this.editBut.addActionListener(this);
        this.addBut.addActionListener(this);
        this.removeBut.addActionListener(this);
        this.closeBut.addActionListener(this);
        return panel;
    }

    private boolean doEdit(DrillDownNode node) {
        if (!node.equals(this.chartMain.chart.currentNode)) {
            if (this.chartMain.modified) {
                this.chartMain.do_Save();
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.chartMain.linkhistory.removeAllElements();
            boolean success = false;
            try {
                if (Chart.fileExists(this.chartMain.chart, node.getFileName())) {
                    success = this.chartMain.do_openChart(node.getFileName());
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to open chart", ex);
            }
            if (!success && node.equals((DrillDownNode)this.tree.getModel().getRoot())) {
                if (this.chartMain.chart.isPACFile()) {
                    try {
                        success = this.chartMain.do_openChart(this.chartMain.chart.getPACFileName(this.chartMain.getTitle()), null, true);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failed to open chart", ex);
                    }
                }
                if (!success) {
                    success = this.chartMain.do_openChart(this.chartMain.getTitle());
                }
                if (success) {
                    node.setFileName(this.chartMain.getTitle());
                }
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (success) {
                this.chartMain.chart.currentNode = node;
                this.setSelected(this.tree, this.chartMain.chart.currentNode);
                if (node.equals((DrillDownNode)this.tree.getModel().getRoot())) {
                    this.chartMain.chart.currentNode = (DrillDownNode)this.tree.getModel().getRoot();
                    this.setSelected(this.tree, this.chartMain.chart.currentNode);
                }
                this.tree.validate();
                this.tree.repaint();
            }
            if (!success) {
                this.setVisible(false);
                this.dispose();
            }
            return success;
        }
        return true;
    }

    private void doRemove(DrillDownNode node) {
        if (!this.isRemoveEnable(node)) {
            return;
        }
        DrillDownNode parentNode = node.getParent();
        boolean deletedCurrent = this.removeFile(node);
        if (deletedCurrent) {
            try {
                boolean exists = false;
                try {
                    exists = Chart.fileExists(this.chartMain.chart, node.getFileName());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Invalid chart file", ex);
                }
                if (exists) {
                    this.chartMain.saveTree(((DrillDownNode)this.tree.getModel().getRoot()).getFileName(), (DrillDownNode)this.tree.getModel().getRoot());
                } else {
                    this.chartMain.saveTree(this.chartMain.getTitle(), (DrillDownNode)this.tree.getModel().getRoot());
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to update drill-down structure", ex);
                new JMessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to update drill-down structure.\n") + LanguageEncoder.getText("This file may be corrupted. Drill-down reports may not work properly in the future."));
            }
            this.doEdit(parentNode);
        }
        this.chartMain.setModified();
        this.chartMain.do_Save();
        this.chartMain.enableNonDrillDownMenu(true);
        this.tree.validate();
        this.tree.repaint();
    }

    private boolean removeFile(DrillDownNode node) {
        boolean deleted = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!this.removeFile(node.getChildAt(i))) continue;
            deleted = true;
        }
        if (node == this.chartMain.chart.currentNode) {
            deleted = true;
        }
        new DeleteFile(node.getFileName()).delete();
        node.removeFromParent();
        return deleted;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.tree.isSelectionEmpty()) {
            DrillDownNode node = (DrillDownNode)this.tree.getSelectionPath().getLastPathComponent();
            if (e.getSource() == this.editBut) {
                this.doEdit(node);
            } else if (e.getSource() == this.addBut) {
                if (node != this.chartMain.chart.currentNode && !this.doEdit(node)) {
                    return;
                }
                this.setVisible(false);
                this.dispose();
                this.chartMain.addDrillDown();
            } else if (e.getSource() == this.removeBut) {
                this.doRemove(node);
            }
        }
        if (e.getSource() == this.closeBut) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void setVisible(boolean state) {
        if (state && this.tree != null) {
            int rowCount = this.tree.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.tree.expandPath(this.tree.getPathForRow(i));
            }
            this.tree.setSelectionRow(0);
            this.setSelected(this.tree, this.chartMain.chart.currentNode);
        }
        super.setVisible(state);
    }

    public void updateTree(JTree newTree) {
        if (this.scrollPane != null) {
            try {
                this.scrollPane.getViewport().remove(this.tree);
                this.scrollPane.getViewport().add(newTree);
                this.setupTree(newTree);
                this.tree = newTree;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to update drilldown tree", ex);
            }
        }
    }

    private void setupTree(JTree t) {
        t.getSelectionModel().setSelectionMode(1);
        t.setShowsRootHandles(true);
        t.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DrillDownNode tn = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tn = (DrillDownNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                }
                if (tn == null) {
                    DrillDownNavigationFrame.this.editBut.setEnabled(false);
                    DrillDownNavigationFrame.this.addBut.setEnabled(false);
                } else {
                    DrillDownNavigationFrame.this.editBut.setEnabled(true);
                    DrillDownNavigationFrame.this.addBut.setEnabled(DrillDownNavigationFrame.this.isAddEnabled(tn));
                }
                DrillDownNavigationFrame.this.removeBut.setEnabled(DrillDownNavigationFrame.this.isRemoveEnable(tn));
                DrillDownNavigationFrame.this.editBut.setEnabled(DrillDownNavigationFrame.this.isSwithEnable((DrillDownNode)DrillDownNavigationFrame.this.tree.getSelectionPath().getLastPathComponent()));
            }
        });
    }

    private void setSelected(JTree tree, DrillDownNode node) {
        this.emptySelection((DrillDownNode)tree.getModel().getRoot());
        node.setSelected(true);
    }

    private void emptySelection(DrillDownNode root) {
        root.setSelected(false);
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.emptySelection(root.getChildAt(i));
        }
    }
}

