/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import quadbase.chart.DrillDownNode;

public class DrillDownTreeModel
implements TreeModel {
    private DrillDownNode root = null;
    private EventListenerList listenerList = new EventListenerList();

    public DrillDownTreeModel(DrillDownNode node) {
        this.root = node;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((DrillDownNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((DrillDownNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((DrillDownNode)node).isLeaf();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((DrillDownNode)parent).getIndex((DrillDownNode)child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        DrillDownNode aNode = (DrillDownNode)path.getLastPathComponent();
        if (newValue == null) {
            aNode.setName("");
        } else {
            aNode.setName(newValue.toString());
        }
        this.nodeChanged(aNode);
    }

    public void nodeChanged(DrillDownNode node) {
        if (this.listenerList != null && node != null) {
            DrillDownNode parent = node.getParent();
            if (parent != null) {
                int anIndex = parent.getIndex(node);
                if (anIndex != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesChanged(DrillDownNode node, int[] childIndices) {
        if (node != null) {
            if (childIndices != null) {
                int cCount = childIndices.length;
                if (cCount > 0) {
                    Object[] cChildren = new Object[cCount];
                    for (int counter = 0; counter < cCount; ++counter) {
                        cChildren[counter] = node.getChildAt(childIndices[counter]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, cChildren);
                }
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public DrillDownNode[] getPathToRoot(DrillDownNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected DrillDownNode[] getPathToRoot(DrillDownNode aNode, int depth) {
        DrillDownNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new DrillDownNode[depth];
        } else {
            retNodes = aNode == this.root ? new DrillDownNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }
}

