/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.ReloadChart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.DrillDownAggregate;
import quadbase.chart.designer.DrillDynamicName;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DrillDynamicDialog
extends QbDialog
implements ItemListener {
    ChartMain chartMain = null;
    JPanel mainPanel = null;
    JPanel buttonPanel = null;
    JCheckBox checkDynamic = null;
    JButton okButton = null;
    JButton cancelButton = null;
    JButton advancedButton = null;
    boolean secondaryAxis = true;
    boolean processing = false;

    public DrillDynamicDialog(ChartMain chartMain) {
        super(chartMain, LanguageEncoder.getText("Dynamic Drill-Down"), true);
        this.chartMain = chartMain;
        if (chartMain.chartPanel.chart.getSubValueMap() < 0) {
            this.secondaryAxis = false;
        }
        this.init();
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", this.mainPanel);
        cop.add("South", this.buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.mainPanel = new BorderPanel(LanguageEncoder.getText("For Chart Viewer"));
        this.mainPanel.setLayout(new BorderLayout());
        this.checkDynamic = new JCheckBox(LanguageEncoder.getText("Enable Dynamic Drill-Down"));
        this.checkDynamic.setSelected(this.chartMain.chartPanel.chart.isDynamicDrillDown);
        this.checkDynamic.addItemListener(this);
        this.mainPanel.add("Center", this.checkDynamic);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.advancedButton = new JButton(LanguageEncoder.getText("Advanced"));
        this.advancedButton.setEnabled(this.checkDynamic.isSelected());
        this.advancedButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.advancedButton);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
    }

    private void do_DynamicDrillDown() {
        Chart tempChart = this.chartMain.chartPanel.chart;
        this.chartMain.setModifiedOnly();
        this.chartMain.chartPanel.chart.resetDrillNumber();
        tempChart.usedColumns = null;
        tempChart.summaryChart = true;
        tempChart.isDynamicDrillDown = true;
        this.chartMain.enableZoomHistOptions(false);
        this.chartMain.parentChart = tempChart = ReloadChart.reloadData(tempChart, true);
        this.chartMain.setNewChart(tempChart);
        this.chartMain.enableNonDrillDownMenu(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancelButton) {
            if (this.chartMain.chartPanel.chart.isTimeChart()) {
                this.chartMain.chartPanel.chart.setTimeChart(false);
            }
            this.setVisible(false);
            return;
        }
        if (target == this.advancedButton) {
            DrillDynamicName dnameDialog = null;
            DrillDownAggregate aggDialog = null;
            int categoryType = this.chartMain.chartPanel.chart.getCategoryType();
            if (categoryType != 92 && categoryType != 91 && categoryType != 93) {
                aggDialog = new DrillDownAggregate(this.chartMain, this.secondaryAxis, false, true);
                aggDialog.pack();
                aggDialog.setVisible(true);
                return;
            }
            this.chartMain.launchAggregateDialog(this.secondaryAxis, categoryType, false, false, true);
            dnameDialog = new DrillDynamicName(this.chartMain, LanguageEncoder.getText("Enter a drill-down template name"), this.chartMain.getDrillDownName());
            dnameDialog.pack();
            dnameDialog.setVisible(true);
            return;
        }
        if (target == this.okButton) {
            this.setVisible(false);
            String oldTitle = this.chartMain.getTitle();
            if (this.chartMain.chartPanel.chart.primaryAggregate != -1 && this.checkDynamic.isSelected() && this.chartMain.getDrillDownName() != null) {
                this.chartMain.setTitle(LanguageEncoder.getText("Please wait..."));
                this.do_DynamicDrillDown();
                this.chartMain.setTitle(oldTitle);
            } else if (this.chartMain.chartPanel.chart.isDynamicDrillDown && !this.checkDynamic.isSelected()) {
                this.chartMain.setTitle(LanguageEncoder.getText("Please wait..."));
                this.chartMain.resetDrillDownChart();
                this.chartMain.setTitle(oldTitle);
            } else if (this.chartMain.chartPanel.chart.isTimeChart()) {
                this.chartMain.chartPanel.chart.setTimeChart(false);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.processing) {
            return;
        }
        this.processing = true;
        DrillDynamicName dnameDialog = null;
        DrillDownAggregate aggDialog = null;
        Object target = e.getSource();
        if (this.checkDynamic.isSelected()) {
            this.advancedButton.setEnabled(true);
        } else {
            this.advancedButton.setEnabled(false);
        }
        if (target == this.checkDynamic && this.checkDynamic.isSelected()) {
            if (this.chartMain.chartPanel.chart.primaryAggregate < 0 && !this.chartMain.isDrillDownEnabled()) {
                int categoryType = this.chartMain.chartPanel.chart.getCategoryType();
                if (categoryType != 92 && categoryType != 91 && categoryType != 93) {
                    aggDialog = new DrillDownAggregate(this.chartMain, this.secondaryAxis, false, true);
                    aggDialog.pack();
                    aggDialog.setVisible(true);
                    this.checkDynamic.setSelected(!aggDialog.isCancelled());
                    if (aggDialog.isCancelled()) {
                        this.chartMain.chartPanel.chart.primaryAggregate = -1;
                    }
                    this.processing = false;
                    return;
                }
                boolean isZoomSuccessed = this.chartMain.do_ZoomOptions(true);
                this.checkDynamic.setSelected(isZoomSuccessed);
                if (!isZoomSuccessed) {
                    this.chartMain.chartPanel.chart.primaryAggregate = -1;
                    this.processing = false;
                    return;
                }
                if (!this.chartMain.chart.isTimeChart()) {
                    this.processing = false;
                    return;
                }
            }
            dnameDialog = new DrillDynamicName(this.chartMain, LanguageEncoder.getText("Enter a base drill-down name to use"), this.chartMain.getDrillDownName());
            dnameDialog.pack();
            dnameDialog.setVisible(true);
            this.checkDynamic.setSelected(!dnameDialog.isCancelled());
            if (dnameDialog.isCancelled()) {
                this.chartMain.chartPanel.chart.primaryAggregate = -1;
            }
            this.processing = false;
            return;
        }
        if (target == this.checkDynamic && !this.checkDynamic.isSelected()) {
            this.chartMain.chartPanel.chart.primaryAggregate = -1;
        }
        this.processing = false;
    }
}

