/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.designer.ChartMain;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DrillDynamicName
extends QbDialog {
    ChartMain chartMain;
    String baseName;
    final String comment = LanguageEncoder.getText("Enter template name which apply to drill-down chart");
    JPanel bp;
    JPanel p0;
    JPanel p1;
    JPanel p2;
    JFileChooser fDialog = null;
    BrowseDialog bDialog = null;
    JButton browseButton;
    JButton okButton;
    JButton cancelButton;
    JTextField tf;
    Dimension screensize;
    JCheckBox useTemplate;
    boolean isCancelled = false;

    public DrillDynamicName(ChartMain frame, String title, String baseName) {
        super(frame, title, true);
        this.chartMain = frame;
        this.baseName = baseName;
        this.init();
        this.screensize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        this.setBounds((this.screensize.width - dim.width) / 2, (this.screensize.height - dim.height) / 2, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.bp = new BorderPanel();
        this.bp.setLayout(new BorderLayout());
        this.p0 = new JPanel();
        this.p1 = new JPanel();
        this.p2 = new JPanel();
        this.p0.setLayout(new FlowLayout(0));
        this.p1.setLayout(new FlowLayout(1));
        this.p2.setLayout(new FlowLayout(2));
        this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        if (this.baseName == null) {
            this.baseName = this.comment;
        }
        this.tf = new JTextField(this.baseName, 20);
        this.useTemplate = new JCheckBox(LanguageEncoder.getText("Use Template"), !this.baseName.equals(this.comment));
        this.useTemplate.addItemListener(this);
        this.tf.setEnabled(this.useTemplate.isSelected());
        this.p0.add(new JLabel(""));
        this.p0.add(this.useTemplate);
        this.p1.add(new JLabel("Name"));
        this.p1.add(this.tf);
        this.p2.add(this.browseButton);
        this.p2.add(this.okButton);
        this.p2.add(this.cancelButton);
        this.bp.add("Center", this.p1);
        this.bp.add("South", this.p0);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.bp);
        cop.add("South", this.p2);
        this.pack();
    }

    public ChartMain getChartMain() {
        return this.chartMain;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.tf.setEnabled(this.useTemplate.isSelected());
    }

    private String loadFile() {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fDialog == null) {
                this.fDialog = new JFileChooser();
                ExtensionFilter fileFilter = new ExtensionFilter(new String[]{"TPL", "PAC", "CHT"});
                this.fDialog.setFileFilter(fileFilter);
            }
            this.fDialog.setCurrentDirectory(new File(this.chartMain.getBrowseDirectories().getChartTemplatesDirectory()));
            this.fDialog.showDialog(this, null);
            if (this.fDialog.getSelectedFile() == null) {
                return null;
            }
            this.chartMain.getBrowseDirectories().setChartTemplatesDirectory(this.fDialog.getCurrentDirectory().getAbsolutePath());
            return this.fDialog.getSelectedFile().getAbsolutePath();
        }
        if (this.bDialog == null) {
            String[] ext = new String[]{"TPL", "PAC", "CHT"};
            this.bDialog = BrowseDialog.create(this.chartMain, this.chartMain.getBrowseDirectories().getChartTemplatesDirectory(), ext);
        }
        this.bDialog.setVisible(true);
        this.chartMain.getBrowseDirectories().setChartTemplatesDirectory(this.bDialog.getCurrentDirectory());
        return this.bDialog.getSelectedFile();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.isCancelled = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        String baseTemplate = null;
        String filename = null;
        if (target == this.cancelButton) {
            this.isCancelled = true;
            this.dispose();
            return;
        }
        if (target == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null && !fileText.equals("")) {
                this.tf.setEnabled(true);
                this.useTemplate.setSelected(true);
                this.tf.setText(fileText);
            }
            return;
        }
        if (target == this.okButton) {
            if (!this.tf.isEnabled()) {
                this.setVisible(false);
                this.chartMain.setDrillDownName("");
                return;
            }
            baseTemplate = this.tf.getText();
            if (baseTemplate == null || baseTemplate.equals("")) {
                return;
            }
            filename = baseTemplate;
            if (!filename.endsWith(".tpl")) {
                filename = filename + ".tpl";
            }
            if (!OverWriteDialog.findFile(filename)) {
                new MessageDialog((Frame)QbDialog.findFrame(this.chartMain), LanguageEncoder.getText("Warning")).show(filename + " " + LanguageEncoder.getText("not found\nPlease try other template file"));
                return;
            }
            this.setVisible(false);
            this.chartMain.setDrillDownName(baseTemplate);
            return;
        }
    }
}

