/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DrillNameDialog
extends QbDialog
implements KeyListener {
    ChartMain chartMain;
    String baseName;
    JPanel p1;
    JPanel p2;
    JButton okButton;
    JButton cancelButton;
    JTextField tf;
    Dimension screensize;
    boolean displayWizardOnDone;

    public DrillNameDialog(ChartMain frame, String title, String baseName) {
        this(frame, title, baseName, true);
    }

    public DrillNameDialog(ChartMain frame, String title, String baseName, boolean displayWizard) {
        super(frame, title, true);
        this.chartMain = frame;
        this.baseName = baseName;
        this.displayWizardOnDone = displayWizard;
        this.init();
        this.screensize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        this.setBounds((this.screensize.width - dim.width) / 2, (this.screensize.height - dim.height) / 2, this.getPreferredSize().width, this.getPreferredSize().height);
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.p1 = new BorderPanel();
        this.p2 = new JPanel();
        this.p1.setLayout(new FlowLayout(1));
        this.p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.cancelButton.addActionListener(this);
        if (this.baseName == null) {
            this.baseName = "";
        }
        this.tf = new JTextField(this.baseName, 20);
        this.p1.add(new JLabel(LanguageEncoder.getText("drill-down name")));
        this.p1.add(this.tf);
        this.p2.add(this.okButton);
        this.p2.add(this.cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.p1);
        cop.add("South", this.p2);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        String baseTemplate = null;
        String filename = null;
        if (target == this.cancelButton) {
            if (this.chartMain.chartPanel.chart.isTimeChart()) {
                this.chartMain.chartPanel.chart.setTimeChart(false);
            }
            this.dispose();
            return;
        }
        if (target == this.okButton) {
            String message;
            baseTemplate = this.tf.getText();
            if (baseTemplate == null || baseTemplate.equals("")) {
                return;
            }
            int index = baseTemplate.indexOf(58);
            filename = index < 0 ? this.chartMain.chart.drillTemplatePath + baseTemplate + "0.tpl" : baseTemplate + "0.tpl";
            if (!OverWriteDialog.continueSave(this.chartMain, filename, message = LanguageEncoder.getText("modifying") + " " + baseTemplate + " " + LanguageEncoder.getText("may affect some other charts!\n Continue?"))) {
                return;
            }
            this.setVisible(false);
            this.chartMain.setDrillDownName(baseTemplate);
            if (this.displayWizardOnDone) {
                this.chartMain.displayDrillDown();
            }
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.okButton.doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

