/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.PropCString;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.IVariableDialogOwner;
import quadbase.chart.designer.VariableDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class EditTextDialog
extends QbDialog
implements IVariableDialogOwner {
    Chart chart;
    Object obj;
    int pos;
    ChartMain chartMain;
    JButton variableButton;
    JButton cancelButton;
    JButton okButton;
    JTextField tf;
    VariableDialog variableDialog;

    public EditTextDialog(ChartMain frame, String title, Object obj, int pos) {
        super(frame, title, true);
        this.chartMain = frame;
        this.pos = pos;
        this.obj = obj;
        this.tf = new JTextField(20);
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        p1.setLayout(new FlowLayout(1));
        p2.setLayout(new FlowLayout(2));
        p1.add(this.tf);
        this.variableButton = new JButton(LanguageEncoder.getText("Variables..."));
        this.variableButton.addActionListener(this);
        p2.add(this.variableButton);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        p2.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        cop.add("Center", p1);
        cop.add("South", p2);
        this.pack();
        this.tf.requestFocus();
        if (obj instanceof Vector) {
            this.tf.setText(((PropCString)((Vector)obj).elementAt((int)pos)).str);
        } else {
            this.tf.setText(((CString)obj).str);
        }
        this.tf.addActionListener(this);
    }

    @Override
    public ChartMain getChartMain() {
        return this.chartMain;
    }

    @Override
    public void resetVariableDialog() {
        this.variableDialog = null;
    }

    @Override
    public void insertSelectedString() {
        String str1;
        String newStr = this.variableDialog.getSelectedString();
        String str = this.tf.getText();
        String str2 = null;
        if (this.tf.getSelectedText() != null) {
            str1 = str.substring(0, this.tf.getSelectionStart());
            str2 = str.substring(this.tf.getSelectionEnd());
        } else {
            str1 = str.substring(0, this.tf.getCaretPosition());
            str2 = str.substring(this.tf.getCaretPosition());
        }
        if (str2 != null && str2.length() > 0 && str2.charAt(0) != ' ') {
            str2 = " " + str2;
        }
        this.tf.setText(str1 + newStr + str2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.variableButton) {
            if (this.variableDialog == null) {
                this.variableDialog = new VariableDialog(this);
                this.variableDialog.setVisible(true);
            } else {
                this.variableDialog.toFront();
            }
            return;
        }
        if (this.variableDialog != null) {
            this.variableDialog.close();
        }
        this.setVisible(false);
        this.dispose();
        if (source != this.cancelButton) {
            if (this.obj instanceof Vector) {
                PropCString s = (PropCString)((Vector)this.obj).elementAt(this.pos);
                ((Vector)this.obj).removeElementAt(this.pos);
                s.setString(this.tf.getText());
                if (s.str != null && !s.str.trim().equals("")) {
                    ((Vector)this.obj).addElement(s);
                }
            } else {
                ((CString)this.obj).setString(this.tf.getText());
            }
            this.chartMain.chartPanel.paint();
            this.chartMain.setModified();
        }
    }
}

