/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartExportPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.FlashDialog;
import quadbase.chart.designer.JPEGQualityDialog;
import quadbase.chart.designer.TXTSeparatorDialog;
import quadbase.chart.designer.WMFBorderDialog;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class ExportDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(ExportDialog.class.getName());
    String newName = null;
    String query;
    ChartMain chartmain;
    JButton okButton;
    JButton browseButton;
    BrowseDialog bDialog;
    JFileChooser fDialog;
    String oldtitle;
    int portno;
    InetAddress address;
    Chart chart;
    int width;
    int height;
    int quality = 99;
    boolean displayResult = false;
    int folderID;
    int outputViewFormat;
    ChartExportPanel exportPanel;
    public static final int defaultWidth = 600;
    public static final int defaultHeight = 440;

    public ExportDialog(ChartMain frame, String title) throws Exception {
        super(frame, title, true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.initdialog();
    }

    private void initdialog() {
        this.setBackground(Color.lightGray);
        this.setDimension();
        this.exportPanel = new ChartExportPanel(this.chartmain != null && this.chartmain.filename != null ? this.chartmain.filename : "", this.width, this.height, this.chart.isBackgroundTransparent(), this.chartmain.displayUnit);
        String defaultDir = this.chartmain.getBrowseDirectories().getChartTemplatesDirectory();
        if (this.chartmain.filename != null) {
            String str = this.chartmain.filename.toLowerCase();
            defaultDir = str.endsWith(".cht") || str.endsWith(".tpl") || str.endsWith(".pac") || str.endsWith(".xml") ? this.chartmain.filename.substring(0, this.chartmain.filename.length() - 4) : this.chartmain.filename;
        }
        this.exportPanel.setTitle(defaultDir);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
        this.browseButton.addActionListener(this);
        p2.add(this.browseButton);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        p2.add(this.okButton);
        JButton cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        cancelButton.addActionListener(this);
        p2.add(cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("North", this.exportPanel);
        cop.add("South", p2);
        this.setSize(340, 180);
    }

    private void setDimension() {
        this.width = this.chartmain != null ? this.chartmain.chartPanel.chart.getSize().width : 600;
        int n = this.height = this.chartmain != null ? this.chartmain.chartPanel.chart.getSize().height : 440;
        if (this.exportPanel != null) {
            if (this.chartmain.displayUnit == 0) {
                this.exportPanel.twidth.setText(Integer.valueOf(this.width).toString());
                this.exportPanel.theight.setText(Integer.valueOf(this.height).toString());
            } else if (this.chartmain.displayUnit == 1) {
                this.exportPanel.twidth.setText(Double.valueOf(QbUtil.toInch(this.width)).toString());
                this.exportPanel.theight.setText(Double.valueOf(QbUtil.toInch(this.height)).toString());
            } else {
                this.exportPanel.twidth.setText(Double.valueOf(QbUtil.toInch(this.width) * 2.54).toString());
                this.exportPanel.theight.setText(Double.valueOf(QbUtil.toInch(this.height) * 2.54).toString());
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setDimension();
            this.pack();
            super.setVisible(true);
            this.newName = null;
        } else {
            super.setVisible(false);
        }
    }

    private String loadFile() {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fDialog == null) {
                this.fDialog = new JFileChooser();
                ExtensionFilter fileFilter = new ExtensionFilter(new String[]{".TPL", ".CHT", ".GIF", ".BMP", ".WRL", ".JPG", ".JPEG", ".WMF", ".PNG", ".TXT", ".XML", ".PDF", "SVG", "SWF"});
                this.fDialog.setFileFilter(fileFilter);
            }
            this.fDialog.setCurrentDirectory(new File(this.chartmain.getBrowseDirectories().getChartTemplatesDirectory()));
            this.fDialog.showDialog(this, null);
            if (this.fDialog.getSelectedFile() == null) {
                return null;
            }
            this.chartmain.getBrowseDirectories().setChartTemplatesDirectory(this.fDialog.getCurrentDirectory().getAbsolutePath());
            return this.fDialog.getSelectedFile().getAbsolutePath();
        }
        if (this.bDialog == null) {
            String[] ext = new String[]{".CHT", ".PAC", ".TPL", ".GIF", ".BMP", ".WRL", ".JPG", ".JPEG", ".WMF", ".PNG", "TXT", "XML", "PDF", "SVG", "SWF"};
            this.bDialog = BrowseDialog.create(this.chartmain, this.chartmain.getBrowseDirectories().getChartTemplatesDirectory(), ext);
        }
        this.bDialog.setVisible(true);
        try {
            if (new FileInfo(this.bDialog.getCurrentDirectory()).exists()) {
                this.chartmain.getBrowseDirectories().setChartTemplatesDirectory(this.bDialog.getCurrentDirectory());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to set templates directory", ex);
        }
        return this.bDialog.getSelectedFile();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null) {
                this.exportPanel.edTitle.setText(fileText);
            }
            return;
        }
        if (e.getSource() == this.okButton) {
            int dirIdx;
            this.newName = this.exportPanel.edTitle.getText();
            if (this.newName == null || this.newName.trim().equals("")) {
                return;
            }
            if (this.newName.endsWith(this.exportPanel.exportExtensionHashMap.get(this.exportPanel.choiceFormats.getSelectedItem().toString()))) {
                this.newName = this.newName.substring(0, this.newName.length() - 4);
            }
            this.newName = this.chartmain.getPath(this.newName);
            if (this.newName.endsWith(".xml")) {
                this.newName = this.newName.substring(0, this.newName.length() - 4);
            }
            if ((dirIdx = this.newName.lastIndexOf(47)) == this.newName.length() - 1) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Please enter export file name!");
                return;
            }
            dirIdx = this.newName.lastIndexOf(92);
            if (dirIdx == this.newName.length() - 1) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "Please enter export file name!");
                return;
            }
            String filename = this.newName + this.exportPanel.exportExtensionHashMap.get(this.exportPanel.choiceFormats.getSelectedItem().toString());
            if (!OverWriteDialog.continueSave(this.chartmain, filename = this.chartmain.getPath(filename))) {
                return;
            }
            if (this.exportPanel.getChoice() == 4 || this.exportPanel.getChoice() == 7) {
                JPEGQualityDialog qualityPanel = new JPEGQualityDialog(this.chartmain);
                qualityPanel.setVisible(true);
                if (qualityPanel.getValue() >= 1) {
                    this.quality = qualityPanel.getValue();
                } else {
                    return;
                }
            }
            if (this.exportPanel.getChoice() == 10) {
                this.quality = 0;
            }
            if (this.exportPanel.getChoice() == 15) {
                FlashDialog flashPanel = new FlashDialog(this.chartmain);
                flashPanel.setVisible(true);
                if (flashPanel.isCancel) {
                    return;
                }
            }
            if (this.exportPanel.getChoice() == 8) {
                WMFBorderDialog wmfPanel = new WMFBorderDialog(this.chartmain);
                wmfPanel.setVisible(true);
                if (wmfPanel.getValue() == null) {
                    return;
                }
                this.chartmain.chart.setDrawBorderForWMF(wmfPanel.getValue());
            }
            int separator = 1;
            if (this.exportPanel.getChoice() == 11) {
                TXTSeparatorDialog txtPanel = new TXTSeparatorDialog(this.chartmain);
                txtPanel.setVisible(true);
                if (txtPanel.getValue() >= 0) {
                    separator = txtPanel.getValue();
                } else {
                    return;
                }
            }
            this.setVisible(false);
            this.dispose();
            this.width = this.exportPanel.processTextField(this.exportPanel.twidth);
            this.height = this.exportPanel.processTextField(this.exportPanel.theight);
            this.chartmain.chart.setBackgroundTransparent(this.exportPanel.isTransparent());
            if (this.chartmain != null) {
                this.oldtitle = this.chartmain.getTitle();
                this.chartmain.setTitle(LanguageEncoder.getText("Exporting ..."));
            }
            try {
                if (this.exportPanel.getChoice() == 11) {
                    this.chartmain.chart.exportDataFile(this.newName, separator, 0);
                } else if (this.exportPanel.getChoice() == 12) {
                    this.chartmain.chart.exportDataFile(this.newName, separator, 1);
                } else {
                    this.exportImage(this.newName);
                }
                if (this.exportPanel.getChoice() == 0 || this.exportPanel.getChoice() == 5 || this.exportPanel.getChoice() == 16) {
                    this.chartmain.insertChartFileToOrganizer(filename);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Export failed", ex);
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(ex.toString());
                if (this.chartmain != null) {
                    this.chartmain.setTitle(this.oldtitle);
                    this.chartmain.chartPanel.update();
                }
                return;
            }
            if (this.chartmain != null) {
                this.chartmain.setTitle(this.oldtitle);
                if (!(this.chartmain.chart.getChartType() != 8 && this.chartmain.chart.getChartType() != 5 && this.chartmain.chart.getChartType() != 4 || this.chartmain.chart.is2DimChart() || this.exportPanel.getChoice() != 15)) {
                    this.chartmain.chartPanel.chart = this.chartmain.chart = this.chartmain.chart.setNewData(this.chartmain.chart.colData);
                }
            }
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void exportImage(String filename) throws Exception {
        try {
            if (this.exportPanel.getUseGrayScale()) {
                this.chartmain.chart.setBufferedImageType(10);
            }
            this.chartmain.chart.get_directExport(filename, filename, this.exportPanel.getChoice(), this.width, this.height, this.chartmain, this.exportPanel.getGenerateDataMapFile(), this.quality);
            this.chartmain.chart.setBufferedImageType(1);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "Failed to export image", ex);
            String msg = ex.getMessage();
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
        }
    }
}

