/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class FlashDialog
extends QbDialog {
    SpinBox noOfFrame;
    SpinBox frameRate;
    ChartMain chartMain;
    JCheckBox animatedBut;
    JButton okButton;
    JButton cancelButton;
    int value = -1;
    boolean isCancel = false;

    public FlashDialog(ChartMain chartMain) {
        super(chartMain, LanguageEncoder.getText("Flash Frame Options"), true);
        this.chartMain = chartMain;
        this.initdialog();
    }

    private void initdialog() {
        this.setBackground(Color.lightGray);
        BorderPanel animatePanel = new BorderPanel(LanguageEncoder.getText("Animation Options"));
        animatePanel.setLayout(new FlowLayout(0));
        this.animatedBut = new JCheckBox(LanguageEncoder.getText("Enable Animation"));
        animatePanel.add(this.animatedBut);
        this.animatedBut.setSelected(true);
        this.animatedBut.addItemListener(this);
        BorderPanel mainPanel = new BorderPanel(LanguageEncoder.getText("Frame Options"));
        mainPanel.setLayout(new GridLayout(2, 2, 5, 5));
        mainPanel.add(new JLabel(LanguageEncoder.getText("Frame Count")));
        this.noOfFrame = new SpinBox(1, 50);
        mainPanel.add(this.noOfFrame);
        if (this.chartMain.chart.flashFrameCount == 1) {
            this.noOfFrame.setValue(12);
        } else {
            this.noOfFrame.setValue(this.chartMain.chart.flashFrameCount);
        }
        mainPanel.add(new JLabel(LanguageEncoder.getText("Frame Rate")));
        this.frameRate = new SpinBox(1, 99);
        mainPanel.add(this.frameRate);
        this.frameRate.setValue((int)this.chartMain.chart.flashFrameRate);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        JButton cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("North", mainPanel);
        cop.add("Center", animatePanel);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.noOfFrame.setEnabled(this.animatedBut.isSelected());
        this.frameRate.setEnabled(this.animatedBut.isSelected());
    }

    public boolean isCancelled() {
        return this.isCancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.animatedBut.isSelected()) {
                this.chartMain.chart.flashFrameCount = this.noOfFrame.getValue();
                this.chartMain.chart.flashFrameRate = this.frameRate.getValue();
            } else {
                this.chartMain.chart.flashFrameCount = 1;
            }
            this.setVisible(false);
            this.dispose();
        } else {
            this.isCancel = true;
            this.setVisible(false);
            this.dispose();
        }
    }
}

