/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.swing.color.ColorDialog;
import quadbase.common.util.flash.FontMapping;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class FlashHintBoxDialog
extends QbDialog
implements ActionListener,
ItemListener {
    JButton cancelButton;
    JButton okButton;
    ChartMain chartMain;
    Font currentFont;
    String[] fontList;
    JComboBox nameList;
    JComboBox styleList;
    Color fontColor;
    Color bgColor;
    Color borderColor;
    SpinBox sizeField;
    ColorButton fontButton;
    ColorButton bgButton;
    ColorButton borderButton;
    FontPreviewPanel previewPanel;
    boolean isCancel = false;
    boolean drawPreviewPanel = true;
    JCheckBox enableHintBoxBut;
    boolean enableHintBox = false;

    public FlashHintBoxDialog(ChartMain chartMain, Font orgFont, Color fontColor, Color bgColor, Color borderColor, boolean enableHintBox) {
        super(chartMain, LanguageEncoder.getText("Flash Hint Box Customization"), true);
        this.chartMain = chartMain;
        this.currentFont = orgFont;
        this.fontColor = fontColor;
        this.bgColor = bgColor;
        this.borderColor = borderColor;
        this.enableHintBox = enableHintBox;
        this.init();
    }

    private void init() {
        this.nameList = new JComboBox();
        for (String element : this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!FontMapping.isSupportedFont(element)) continue;
            this.nameList.addItem(element);
        }
        this.styleList = new JComboBox();
        this.styleList.addItem(LanguageEncoder.getText("Plain"));
        this.styleList.addItem(LanguageEncoder.getText("Bold"));
        this.styleList.addItem(LanguageEncoder.getText("Italic"));
        this.styleList.addItem(LanguageEncoder.getText("Bold Italic"));
        this.sizeField = new SpinBox(3, 50);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(4, 4, 5, 5));
        p1.add(new JLabel(LanguageEncoder.getText("Name")));
        p1.add(this.nameList);
        p1.add(new JLabel(LanguageEncoder.getText("Font Color :")));
        this.fontButton = new ColorButton(LanguageEncoder.getText("Click"));
        p1.add(this.fontButton);
        this.fontButton.addActionListener(this);
        p1.add(new JLabel(LanguageEncoder.getText("Style")));
        p1.add(this.styleList);
        p1.add(new JLabel(LanguageEncoder.getText("Blackground Color :")));
        this.bgButton = new ColorButton(LanguageEncoder.getText("Click"));
        p1.add(this.bgButton);
        this.bgButton.addActionListener(this);
        p1.add(new JLabel(LanguageEncoder.getText("Size")));
        p1.add(this.sizeField);
        p1.add(new JLabel(LanguageEncoder.getText("Border Color :")));
        this.borderButton = new ColorButton(LanguageEncoder.getText("Click"));
        p1.add(this.borderButton);
        this.borderButton.addActionListener(this);
        this.enableHintBoxBut = new JCheckBox(LanguageEncoder.getText("Enable Hint Box"));
        p1.add(this.enableHintBoxBut);
        this.enableHintBoxBut.setSelected(this.enableHintBox);
        p1.add(new JLabel());
        this.enableHintBoxBut.addItemListener(this);
        this.previewPanel = new FontPreviewPanel();
        this.previewPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Preview")));
        this.nameList.addItemListener(this);
        this.styleList.addItemListener(this);
        this.sizeField.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("Ok"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        this.presetFont(this.currentFont);
        this.setColor(this.fontColor, this.fontButton);
        this.setColor(this.bgColor, this.bgButton);
        this.setColor(this.borderColor, this.borderButton);
        this.previewPanel.text.setBackground(this.bgColor);
        this.previewPanel.text.setForeground(this.fontColor);
        this.previewPanel.text.setBorder(BorderFactory.createLineBorder(this.borderColor));
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel contentPane1 = new JPanel();
        contentPane1.setLayout(new GridLayout(2, 1, 0, 0));
        contentPane1.setBorder(new TitledBorder(LanguageEncoder.getText("Set Font ...")));
        contentPane1.add(p1);
        contentPane1.add(this.previewPanel);
        contentPane.add("Center", contentPane1);
        contentPane.add("South", p2);
        this.pack();
        this.applyStyle();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.applyStyle();
        this.previewPanel.repaint();
    }

    private void presetFont(Font font) {
        if (font == null) {
            return;
        }
        this.nameList.setSelectedIndex(this.getName(font.getName()));
        this.styleList.setSelectedIndex(font.getStyle());
        this.sizeField.setValue(font.getSize());
    }

    @Override
    public Font getFont() {
        return this.currentFont;
    }

    private int getName(String str) {
        for (int i = 0; i < this.fontList.length; ++i) {
            if (!this.fontList[i].equals(str)) continue;
            return i;
        }
        return 0;
    }

    private void setColor(Color color, ColorButton colorBut) {
        if (color == null) {
            return;
        }
        colorBut.setColor(color);
    }

    public Color getFlashFontColor() {
        return this.fontColor;
    }

    public Color getFlashBgColor() {
        return this.bgColor;
    }

    public Color getFlashBorderColor() {
        return this.borderColor;
    }

    public boolean isFlashEnableHintBox() {
        return this.enableHintBoxBut.isSelected();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void applyStyle() {
        this.drawPreviewPanel = false;
        this.nameList.setEnabled(this.enableHintBoxBut.isSelected());
        this.styleList.setEnabled(this.enableHintBoxBut.isSelected());
        this.sizeField.setEnabled(this.enableHintBoxBut.isSelected());
        this.fontButton.setEnabled(this.enableHintBoxBut.isSelected());
        this.bgButton.setEnabled(this.enableHintBoxBut.isSelected());
        this.borderButton.setEnabled(this.enableHintBoxBut.isSelected());
        String name = (String)this.nameList.getSelectedItem();
        int style = this.styleList.getSelectedIndex();
        int size = this.sizeField.getValue();
        if (size < 3 || size > 99) {
            new JMessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Font Size : can't be smaller than 3 or bigger than 50!"), 6);
            this.drawPreviewPanel = true;
            return;
        }
        this.currentFont = new Font(name, style, size);
        this.previewPanel.text.setFont(this.currentFont);
        this.previewPanel.text.setBackground(this.bgColor);
        this.previewPanel.text.setForeground(this.fontColor);
        this.previewPanel.text.setBorder(BorderFactory.createLineBorder(this.borderColor));
        this.drawPreviewPanel = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color initColor;
        if (e.getSource() == this.fontButton) {
            initColor = this.fontColor == null ? Color.lightGray : this.fontColor;
            Color newfontColor = ColorDialog.showDialog(this.chartMain, LanguageEncoder.getText("Set Font Color ..."), initColor);
            if (newfontColor != null) {
                this.fontColor = newfontColor;
                this.setColor(this.fontColor, this.fontButton);
                this.applyStyle();
            } else {
                return;
            }
        }
        if (e.getSource() == this.bgButton) {
            initColor = this.bgColor == null ? Color.lightGray : this.bgColor;
            Color newbgColor = ColorDialog.showDialog(this.chartMain, LanguageEncoder.getText("Set Background Color ..."), initColor);
            if (newbgColor != null) {
                this.bgColor = newbgColor;
                this.setColor(this.bgColor, this.bgButton);
                this.applyStyle();
            }
            return;
        }
        if (e.getSource() == this.borderButton) {
            initColor = this.borderColor == null ? Color.lightGray : this.borderColor;
            Color newborderColor = ColorDialog.showDialog(this.chartMain, LanguageEncoder.getText("Set Border Color ..."), initColor);
            if (newborderColor != null) {
                this.borderColor = newborderColor;
                this.setColor(this.borderColor, this.borderButton);
                this.applyStyle();
            }
            return;
        }
        if (e.getSource() == this.sizeField) {
            this.applyStyle();
            return;
        }
        if (e.getSource() == this.cancelButton) {
            this.isCancel = true;
            this.dispose();
            this.setVisible(false);
        }
        if (e.getSource() == this.okButton) {
            this.chartMain.setModified();
            this.dispose();
            this.setVisible(false);
        }
    }

    class FontPreviewPanel
    extends JPanel {
        public JTextField text = new JTextField("abc ABC");

        public FontPreviewPanel() {
            this.text.setEditable(false);
            this.text.setFont(FlashHintBoxDialog.this.currentFont);
            this.text.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(new BorderLayout());
            this.add("Center", this.text);
        }
    }
}

