/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.GraphicsTable;
import quadbase.chart.designer.AreaOptionPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartPanel;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class FormatTableDialog
extends QbDialog {
    ChartMain chartMain;
    QbDialog qbd;
    private JCheckBox horizontal;
    private JCheckBox showSecondaryDataInPrimaryTab;
    private JCheckBox showColorSymbols;
    private JRadioButton down;
    private JRadioButton right;
    private JRadioButton shownYes;
    private JRadioButton shownNo;
    private JRadioButton alignLeftCatTitle;
    private JRadioButton alignCenterCatTitle;
    private JRadioButton alignRightCatTitle;
    private JRadioButton alignLeftCatValue;
    private JRadioButton alignCenterCatValue;
    private JRadioButton alignRightCatValue;
    private JRadioButton alignLeftSerTitle;
    private JRadioButton alignCenterSerTitle;
    private JRadioButton alignRightSerTitle;
    private JRadioButton alignLeftSerValue;
    private JRadioButton alignCenterSerValue;
    private JRadioButton alignRightSerValue;
    private JRadioButton alignLeftPriTitle;
    private JRadioButton alignCenterPriTitle;
    private JRadioButton alignRightPriTitle;
    private JRadioButton alignLeftPriValue;
    private JRadioButton alignCenterPriValue;
    private JRadioButton alignRightPriValue;
    private JRadioButton alignLeftSecTitle;
    private JRadioButton alignCenterSecTitle;
    private JRadioButton alignRightSecTitle;
    private JRadioButton alignLeftSecValue;
    private JRadioButton alignCenterSecValue;
    private JRadioButton alignRightSecValue;
    private JButton OKButton;
    private JButton CANCELButton;
    AreaOptionPanel areaPanel;
    boolean v;
    boolean gtNull;
    int direction;
    ChartPanel chartPanel;
    int winWidth = 0;
    int winHeight = 0;
    int gx = 0;
    int gy = 0;
    boolean showTable = false;

    FormatTableDialog(JFrame f, ChartPanel chartPanel) {
        super(f, LanguageEncoder.getText("Table..."), true);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        this.chartMain = (ChartMain)f;
        this.chartPanel = chartPanel;
        ButtonGroup group1 = new ButtonGroup();
        ButtonGroup group2 = new ButtonGroup();
        this.gtNull = chartPanel.chart.gt.clear;
        this.v = true;
        this.direction = 2;
        if (chartPanel.chart.tableInPanel) {
            this.shownYes = new JRadioButton(LanguageEncoder.getText("Yes"), true);
            this.shownNo = new JRadioButton(LanguageEncoder.getText("No"), false);
            this.showTable = true;
        } else {
            this.shownYes = new JRadioButton(LanguageEncoder.getText("Yes"), false);
            this.shownNo = new JRadioButton(LanguageEncoder.getText("No"), true);
            this.showTable = false;
        }
        this.shownYes.addItemListener(this);
        this.shownNo.addItemListener(this);
        group1.add(this.shownYes);
        group1.add(this.shownNo);
        this.alignLeftCatTitle = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterCatTitle = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightCatTitle = new JRadioButton(LanguageEncoder.getText("Right"), false);
        this.alignLeftCatValue = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterCatValue = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightCatValue = new JRadioButton(LanguageEncoder.getText("Right"), false);
        this.alignLeftSerTitle = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterSerTitle = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightSerTitle = new JRadioButton(LanguageEncoder.getText("Right"), false);
        this.alignLeftSerValue = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterSerValue = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightSerValue = new JRadioButton(LanguageEncoder.getText("Right"), false);
        this.alignLeftPriTitle = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterPriTitle = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightPriTitle = new JRadioButton(LanguageEncoder.getText("Right"), false);
        this.alignLeftPriValue = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterPriValue = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightPriValue = new JRadioButton(LanguageEncoder.getText("Right"), false);
        this.alignLeftSecTitle = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterSecTitle = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightSecTitle = new JRadioButton(LanguageEncoder.getText("Right"), false);
        this.alignLeftSecValue = new JRadioButton(LanguageEncoder.getText("Left"), true);
        this.alignCenterSecValue = new JRadioButton(LanguageEncoder.getText("Center"), false);
        this.alignRightSecValue = new JRadioButton(LanguageEncoder.getText("Right"), false);
        ButtonGroup gpCatTitle = new ButtonGroup();
        ButtonGroup gpCatValue = new ButtonGroup();
        ButtonGroup gpSerTitle = new ButtonGroup();
        ButtonGroup gpSerValue = new ButtonGroup();
        ButtonGroup gpPriTitle = new ButtonGroup();
        ButtonGroup gpPriValue = new ButtonGroup();
        ButtonGroup gpSecTitle = new ButtonGroup();
        ButtonGroup gpSecValue = new ButtonGroup();
        gpCatTitle.add(this.alignLeftCatTitle);
        gpCatTitle.add(this.alignCenterCatTitle);
        gpCatTitle.add(this.alignRightCatTitle);
        gpCatValue.add(this.alignLeftCatValue);
        gpCatValue.add(this.alignCenterCatValue);
        gpCatValue.add(this.alignRightCatValue);
        gpSerTitle.add(this.alignLeftSerTitle);
        gpSerTitle.add(this.alignCenterSerTitle);
        gpSerTitle.add(this.alignRightSerTitle);
        gpSerValue.add(this.alignLeftSerValue);
        gpSerValue.add(this.alignCenterSerValue);
        gpSerValue.add(this.alignRightSerValue);
        gpPriTitle.add(this.alignLeftPriTitle);
        gpPriTitle.add(this.alignCenterPriTitle);
        gpPriTitle.add(this.alignRightPriTitle);
        gpPriValue.add(this.alignLeftPriValue);
        gpPriValue.add(this.alignCenterPriValue);
        gpPriValue.add(this.alignRightPriValue);
        gpSecTitle.add(this.alignLeftSecTitle);
        gpSecTitle.add(this.alignCenterSecTitle);
        gpSecTitle.add(this.alignRightSecTitle);
        gpSecValue.add(this.alignLeftSecValue);
        gpSecValue.add(this.alignCenterSecValue);
        gpSecValue.add(this.alignRightSecValue);
        if (chartPanel.chart.gt.clear || chartPanel.chart.gt.direction == 2) {
            this.down = new JRadioButton(LanguageEncoder.getText("Bottom"), true);
            this.right = new JRadioButton(LanguageEncoder.getText("Right"), false);
        } else {
            this.down = new JRadioButton(LanguageEncoder.getText("Bottom"), false);
            this.right = new JRadioButton(LanguageEncoder.getText("Right"), true);
            this.direction = 3;
        }
        group2.add(this.down);
        group2.add(this.right);
        if (chartPanel.chart.gt.clear || chartPanel.chart.gt.isHorizontal) {
            this.horizontal = new JCheckBox(LanguageEncoder.getText("Transpose"), false);
        } else {
            this.horizontal = new JCheckBox(LanguageEncoder.getText("Transpose"), true);
            this.v = false;
        }
        this.showSecondaryDataInPrimaryTab = new JCheckBox(LanguageEncoder.getText("Show Secondary Data In Primary Tab"), chartPanel.chart.isSecondaryDataShownInPrimaryTab());
        this.showColorSymbols = new JCheckBox(LanguageEncoder.getText("Show Color Symbols"), chartPanel.chart.gt.isShowColorSymbols());
        this.OKButton = new JButton(LanguageEncoder.getText("OK"));
        this.CANCELButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.OKButton.addActionListener(this);
        this.CANCELButton.addActionListener(this);
        this.areaPanel = !chartPanel.chart.gt.clear ? new AreaOptionPanel(chartPanel.chart.farea, LanguageEncoder.getText("3D Effect")) : new AreaOptionPanel(chartPanel.chart.newArea(), LanguageEncoder.getText("3D Effect"));
        this.areaPanel.setEnable(this.showTable);
        this.setBackground(Color.lightGray);
        BorderPanel alignPanel = new BorderPanel(LanguageEncoder.getText("Alignment"));
        JPanel aPanel = new JPanel(new GridLayout(0, 4));
        aPanel.add(new JLabel(LanguageEncoder.getText("Header Title")));
        aPanel.add(this.alignLeftCatTitle);
        aPanel.add(this.alignCenterCatTitle);
        aPanel.add(this.alignRightCatTitle);
        aPanel.add(new JLabel(LanguageEncoder.getText("Header Value")));
        aPanel.add(this.alignLeftCatValue);
        aPanel.add(this.alignCenterCatValue);
        aPanel.add(this.alignRightCatValue);
        aPanel.add(new JLabel(LanguageEncoder.getText("Content Title")));
        aPanel.add(this.alignLeftPriTitle);
        aPanel.add(this.alignCenterPriTitle);
        aPanel.add(this.alignRightPriTitle);
        aPanel.add(new JLabel(LanguageEncoder.getText("Content Value")));
        aPanel.add(this.alignLeftPriValue);
        aPanel.add(this.alignCenterPriValue);
        aPanel.add(this.alignRightPriValue);
        if (chartPanel.chart.showLegend2()) {
            aPanel.add(new JLabel(LanguageEncoder.getText("Secondary Title")));
            aPanel.add(this.alignLeftSecTitle);
            aPanel.add(this.alignCenterSecTitle);
            aPanel.add(this.alignRightSecTitle);
            aPanel.add(new JLabel(LanguageEncoder.getText("Secondary Value")));
            aPanel.add(this.alignLeftSecValue);
            aPanel.add(this.alignCenterSecValue);
            aPanel.add(this.alignRightSecValue);
        }
        alignPanel.add("Center", aPanel);
        BorderPanel shownPanel = new BorderPanel(LanguageEncoder.getText("Shown"));
        shownPanel.add("Center", this.shownYes);
        shownPanel.add("South", this.shownNo);
        BorderPanel relativePositionPanel = new BorderPanel(LanguageEncoder.getText("Relative Position"));
        relativePositionPanel.add("Center", this.down);
        relativePositionPanel.add("South", this.right);
        BorderPanel formatPanel = new BorderPanel(LanguageEncoder.getText("Format"));
        formatPanel.add("Center", this.horizontal);
        if (chartPanel.chart.showLegend2() && chartPanel.chart.dataDim == 1 && !chartPanel.chart.isOverlayCombo()) {
            formatPanel.add("East", this.showSecondaryDataInPrimaryTab);
        }
        BorderPanel showColorSymbolsPanel = new BorderPanel(LanguageEncoder.getText("Color Symbols"));
        showColorSymbolsPanel.add("West", this.showColorSymbols);
        JPanel p5 = new JPanel(new BorderLayout());
        p5.add("Center", shownPanel);
        p5.add("East", relativePositionPanel);
        JPanel p6 = new JPanel(new BorderLayout());
        p6.add("Center", p5);
        p6.add("East", formatPanel);
        JPanel areaShowColorSymbolsPanel = new JPanel(new BorderLayout());
        areaShowColorSymbolsPanel.add("Center", showColorSymbolsPanel);
        areaShowColorSymbolsPanel.add("South", this.areaPanel);
        JPanel p7 = new JPanel(new BorderLayout());
        p7.add("Center", p6);
        p7.add("South", areaShowColorSymbolsPanel);
        JPanel p8 = new JPanel(new BorderLayout());
        p8.add("Center", p7);
        p8.add("South", alignPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.OKButton);
        buttonPanel.add(this.CANCELButton);
        cop.add("Center", p8);
        cop.add("South", buttonPanel);
        this.presetAlignment();
        this.enableTableOptions(this.showTable);
    }

    private void presetAlignment() {
        this.alignLeftCatTitle.setSelected(this.chartPanel.chart.gt.alignCatTitle == 0);
        this.alignCenterCatTitle.setSelected(this.chartPanel.chart.gt.alignCatTitle == 1);
        this.alignRightCatTitle.setSelected(this.chartPanel.chart.gt.alignCatTitle == 2);
        this.alignLeftCatValue.setSelected(this.chartPanel.chart.gt.alignCatValue == 0);
        this.alignCenterCatValue.setSelected(this.chartPanel.chart.gt.alignCatValue == 1);
        this.alignRightCatValue.setSelected(this.chartPanel.chart.gt.alignCatValue == 2);
        this.alignLeftPriTitle.setSelected(this.chartPanel.chart.gt.alignPrimTitle == 0);
        this.alignCenterPriTitle.setSelected(this.chartPanel.chart.gt.alignPrimTitle == 1);
        this.alignRightPriTitle.setSelected(this.chartPanel.chart.gt.alignPrimTitle == 2);
        this.alignLeftPriValue.setSelected(this.chartPanel.chart.gt.alignPrimValue == 0);
        this.alignCenterPriValue.setSelected(this.chartPanel.chart.gt.alignPrimValue == 1);
        this.alignRightPriValue.setSelected(this.chartPanel.chart.gt.alignPrimValue == 2);
        if (this.chartPanel.chart.showLegend2()) {
            this.alignLeftSecTitle.setSelected(this.chartPanel.chart.gt.alignSecTitle == 0);
            this.alignCenterSecTitle.setSelected(this.chartPanel.chart.gt.alignSecTitle == 1);
            this.alignRightSecTitle.setSelected(this.chartPanel.chart.gt.alignSecTitle == 2);
            this.alignLeftSecValue.setSelected(this.chartPanel.chart.gt.alignSecValue == 0);
            this.alignCenterSecValue.setSelected(this.chartPanel.chart.gt.alignSecValue == 1);
            this.alignRightSecValue.setSelected(this.chartPanel.chart.gt.alignSecValue == 2);
        }
    }

    private void setAlignment() {
        if (this.alignLeftCatTitle.isSelected()) {
            this.chartPanel.chart.gt.alignCatTitle = 0;
        }
        if (this.alignCenterCatTitle.isSelected()) {
            this.chartPanel.chart.gt.alignCatTitle = 1;
        }
        if (this.alignRightCatTitle.isSelected()) {
            this.chartPanel.chart.gt.alignCatTitle = (short)2;
        }
        if (this.alignLeftCatValue.isSelected()) {
            this.chartPanel.chart.gt.alignCatValue = 0;
        }
        if (this.alignCenterCatValue.isSelected()) {
            this.chartPanel.chart.gt.alignCatValue = 1;
        }
        if (this.alignRightCatValue.isSelected()) {
            this.chartPanel.chart.gt.alignCatValue = (short)2;
        }
        if (this.alignLeftPriTitle.isSelected()) {
            this.chartPanel.chart.gt.alignPrimTitle = 0;
        }
        if (this.alignCenterPriTitle.isSelected()) {
            this.chartPanel.chart.gt.alignPrimTitle = 1;
        }
        if (this.alignRightPriTitle.isSelected()) {
            this.chartPanel.chart.gt.alignPrimTitle = (short)2;
        }
        if (this.alignLeftPriValue.isSelected()) {
            this.chartPanel.chart.gt.alignPrimValue = 0;
        }
        if (this.alignCenterPriValue.isSelected()) {
            this.chartPanel.chart.gt.alignPrimValue = 1;
        }
        if (this.alignRightPriValue.isSelected()) {
            this.chartPanel.chart.gt.alignPrimValue = (short)2;
        }
        if (this.chartPanel.chart.showLegend2()) {
            if (this.alignLeftSecTitle.isSelected()) {
                this.chartPanel.chart.gt.alignSecTitle = 0;
            }
            if (this.alignCenterSecTitle.isSelected()) {
                this.chartPanel.chart.gt.alignSecTitle = 1;
            }
            if (this.alignRightSecTitle.isSelected()) {
                this.chartPanel.chart.gt.alignSecTitle = (short)2;
            }
            if (this.alignLeftSecValue.isSelected()) {
                this.chartPanel.chart.gt.alignSecValue = 0;
            }
            if (this.alignCenterSecValue.isSelected()) {
                this.chartPanel.chart.gt.alignSecValue = 1;
            }
            if (this.alignRightSecValue.isSelected()) {
                this.chartPanel.chart.gt.alignSecValue = (short)2;
            }
        }
    }

    private boolean recreateTable() {
        if (this.chartPanel.chart.tableInPanel != this.shownYes.isSelected()) {
            return true;
        }
        if (this.down.isSelected() && this.chartPanel.chart.gt.direction != 2) {
            return true;
        }
        if (this.right.isSelected() && this.chartPanel.chart.gt.direction != 3) {
            return true;
        }
        if (this.chartPanel.chart.gt.isHorizontal == this.horizontal.isSelected()) {
            return true;
        }
        return this.chartPanel.chart.isSecondaryDataShownInPrimaryTab() != this.showSecondaryDataInPrimaryTab.isSelected();
    }

    private void enableTableOptions(boolean enable) {
        this.horizontal.setEnabled(enable);
        this.showSecondaryDataInPrimaryTab.setEnabled(enable);
        this.showColorSymbols.setEnabled(enable);
        this.down.setEnabled(enable);
        this.right.setEnabled(enable);
        this.alignLeftCatTitle.setEnabled(enable);
        this.alignCenterCatTitle.setEnabled(enable);
        this.alignRightCatTitle.setEnabled(enable);
        this.alignLeftCatValue.setEnabled(enable);
        this.alignCenterCatValue.setEnabled(enable);
        this.alignRightCatValue.setEnabled(enable);
        this.alignLeftSerTitle.setEnabled(enable);
        this.alignCenterSerTitle.setEnabled(enable);
        this.alignRightSerTitle.setEnabled(enable);
        this.alignLeftSerValue.setEnabled(enable);
        this.alignCenterSerValue.setEnabled(enable);
        this.alignRightSerValue.setEnabled(enable);
        this.alignLeftPriTitle.setEnabled(enable);
        this.alignCenterPriTitle.setEnabled(enable);
        this.alignRightPriTitle.setEnabled(enable);
        this.alignLeftPriValue.setEnabled(enable);
        this.alignCenterPriValue.setEnabled(enable);
        this.alignRightPriValue.setEnabled(enable);
        this.alignLeftSecTitle.setEnabled(enable);
        this.alignCenterSecTitle.setEnabled(enable);
        this.alignRightSecTitle.setEnabled(enable);
        this.alignLeftSecValue.setEnabled(enable);
        this.alignCenterSecValue.setEnabled(enable);
        this.alignRightSecValue.setEnabled(enable);
        this.areaPanel.setEnable(enable);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (obj.equals(this.shownYes)) {
            this.enableTableOptions(this.shownYes.isSelected());
        } else if (obj.equals(this.shownNo)) {
            this.enableTableOptions(!this.shownNo.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.CANCELButton) {
            this.setVisible(false);
            return;
        }
        this.chartMain.setModified();
        this.chartPanel.chart.gt.setShowColorSymbols(this.showColorSymbols.isSelected());
        if (!this.recreateTable() && this.shownYes.isSelected()) {
            this.chartPanel.chart.farea = this.areaPanel.getArea();
            this.setAlignment();
            this.chartPanel.chart.gt.paint();
            this.chartPanel.update();
            this.setVisible(false);
            return;
        }
        int dx = 0;
        int dy = 0;
        if (this.chartPanel.chart.gt.direction == 2) {
            dy = this.chartPanel.chart.gt.getHeight();
        } else {
            dx = this.chartPanel.chart.gt.getWidth();
        }
        if (!this.shownYes.isSelected()) {
            this.chartPanel.chart.gt.clear();
            this.chartPanel.chart.gt.shift = false;
            this.chartPanel.chart.tableInPanel = false;
            GraphicsTable.shiftWithoutTable(this.chartPanel.chart);
            this.chartPanel.chart.gt.tableWidth = dx;
            this.chartPanel.chart.gt.tableHeight = dy;
            this.setVisible(false);
            this.chartPanel.update();
            this.chartPanel.chart.gt.tableWidth = 0;
            this.chartPanel.chart.gt.tableHeight = 0;
            return;
        }
        this.chartPanel.chart.gt.calculateRelativePos(false);
        this.chartPanel.chart.gt.isCenter = true;
        if (this.chartPanel.chart.gt.firstShown) {
            this.chartPanel.chart.gt.keepPosition = false;
        }
        this.gy = -1;
        this.gx = -1;
        if (this.chartPanel.chart.tableInPanel) {
            if (this.chartPanel.chart.gt.direction == 3) {
                this.gx = this.chartPanel.chart.gt.x;
            } else {
                this.gy = this.chartPanel.chart.gt.y;
            }
        }
        this.winWidth = this.chartPanel.chart.winWidth - dx;
        this.winHeight = this.chartPanel.chart.winHeight - dy;
        this.chartPanel.chart.gt.clear();
        this.chartPanel.chart.gt.shift = false;
        boolean isHorizontal = !this.horizontal.isSelected();
        this.chartPanel.chart.setSecondaryDataShownInPrimaryTab(this.showSecondaryDataInPrimaryTab.isSelected());
        this.setAlignment();
        if (this.down.isSelected()) {
            this.chartPanel.chart.gt.direction = 2;
            this.chartPanel.chart.gt.isHorizontal = isHorizontal;
            this.chartPanel.chart.farea = this.areaPanel.getArea();
            this.chartPanel.chart.tableInPanel = true;
            if (this.showTable) {
                this.chartPanel.chart.gt.draw = false;
                this.chartPanel.chart.gt.width = this.winWidth;
                this.chartPanel.chart.gt.height = 10000;
                this.chartPanel.chart.gt.cBorder = null;
                this.chartPanel.chart.gt.paint();
                this.chartPanel.chart.gt.draw = true;
            } else {
                this.chartPanel.chart.gt.tableHeight = 0;
                this.chartPanel.chart.gt.select_axis = 0;
                this.chartPanel.chart.gt.draw = false;
                this.chartPanel.chart.gt.paint(this.chartPanel.chart, this.chartPanel.chart.mData, this.chartPanel.chart.g, 0, this.chartPanel.chart.winHeight, this.winWidth, 10000, 2, isHorizontal, this.chartPanel.chart.farea, this.chartPanel.chart.cgraphics);
                this.chartPanel.chart.gt.draw = true;
            }
            this.chartPanel.update();
            this.chartPanel.chart.gt.y = this.gy == -1 ? this.winHeight : this.gy;
            this.chartPanel.chart.gt.x = (this.chartPanel.chart.winWidth - this.chartPanel.chart.gt.getWidth()) / 2;
            this.chartPanel.chart.gt.paint();
            this.setVisible(false);
        } else {
            this.chartPanel.chart.gt.direction = 3;
            this.chartPanel.chart.gt.isHorizontal = isHorizontal;
            this.chartPanel.chart.farea = this.areaPanel.getArea();
            this.chartPanel.chart.tableInPanel = true;
            if (this.showTable) {
                this.chartPanel.chart.gt.draw = false;
                this.chartPanel.chart.gt.height = this.winHeight;
                this.chartPanel.chart.gt.width = 10000;
                this.chartPanel.chart.gt.cBorder = null;
                this.chartPanel.chart.gt.paint();
                this.chartPanel.chart.gt.draw = true;
            } else {
                this.chartPanel.chart.gt.tableWidth = 0;
                this.chartPanel.chart.gt.select_axis = 0;
                this.chartPanel.chart.gt.draw = false;
                this.chartPanel.chart.gt.paint(this.chartPanel.chart, this.chartPanel.chart.mData, this.chartPanel.chart.g, this.chartPanel.chart.winWidth, 0, 10000, this.winHeight, 3, isHorizontal, this.chartPanel.chart.farea, this.chartPanel.chart.cgraphics);
                this.chartPanel.chart.gt.draw = true;
            }
            this.chartPanel.update();
            this.chartPanel.chart.gt.x = this.gx == -1 ? this.winWidth : this.gx;
            this.chartPanel.chart.gt.y = (this.chartPanel.getSize().height - this.chartPanel.chart.gt.getHeight()) / 2;
            this.chartPanel.chart.gt.paint();
            this.setVisible(false);
        }
        this.chartPanel.update();
        this.chartPanel.chart.gt.calculateRelativePos(true);
        System.gc();
    }
}

