/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import quadbase.chart.Axis;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.LabelPlacementPanel;
import quadbase.common.swing.DateTimeSamplePanel;
import quadbase.common.swing.LogicalPanel;
import quadbase.common.swing.NumericSamplePanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.DateTimeFormat;
import quadbase.util.LogicalFormat;

public class FormatValueDialog
extends QbDialog {
    ChartMain chartmain;
    JTabbedPane tabPanel;
    JButton butcancel;
    JButton butOK;
    Chart chart;
    static final short width = 550;
    static final short height = 600;
    JPanel[] formatPanel;
    LabelPlacementPanel[] labelPanel;
    int axislimit;
    int axCt = 4;
    int[] map;
    static final String[] axischar = new String[]{LanguageEncoder.getText("X"), LanguageEncoder.getText("Y"), LanguageEncoder.getText("Z"), LanguageEncoder.getText("2nd")};

    public FormatValueDialog(ChartMain frame, String title) {
        super(frame, title, true);
        boolean isMultiAxisRadar;
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.setBackground(Color.lightGray);
        this.tabPanel = new JTabbedPane();
        this.axislimit = frame.chart.showSecAxis() ? 4 : 3;
        boolean bl = isMultiAxisRadar = this.chart.getChartType() == 16 && !this.chart.isSynchronizeRadarAxis();
        if ((this.chart.getChartType() == 14 || isMultiAxisRadar) && this.chart.colDataAxis != null) {
            this.axCt += this.chart.colDataAxis.length;
        }
        this.map = new int[this.axCt];
        this.formatPanel = new JPanel[this.axCt];
        this.labelPanel = new LabelPlacementPanel[this.axCt];
        if (!this.chart.isCircularChart()) {
            int i;
            for (i = 0; i < 4; ++i) {
                if (isMultiAxisRadar && i == 1) continue;
                this.setAxisFormat(this.chart.axis[i], i);
            }
            for (i = 4; i < this.axCt; ++i) {
                this.setAxisFormat(this.chart.colDataAxis[i - 4], i);
            }
        } else {
            this.formatPanel[0] = new NumericSamplePanel(this.chartmain, this.chart.getSpecNumericFormat());
            this.formatPanel[1] = new NumericSamplePanel(this.chartmain, this.chart.colData[this.chart.valueCol].dataFormat);
            this.tabPanel.add(LanguageEncoder.getText("Percent"), this.formatPanel[0]);
            this.tabPanel.add(LanguageEncoder.getText("Value"), this.formatPanel[1]);
            ColData cd = this.chart.colData[this.chart.mDataMap[0]];
            if (cd.axisType == 9) {
                this.formatPanel[2] = new DateTimeSamplePanel(this.chartmain, cd.dataFormat, false, true, true);
                this.tabPanel.add(LanguageEncoder.getText("Label"), this.formatPanel[2]);
            } else if (cd.axisType == 8) {
                this.formatPanel[2] = new DateTimeSamplePanel(this.chartmain, cd.dataFormat, true, false, true);
                this.tabPanel.add(LanguageEncoder.getText("Label"), this.formatPanel[2]);
            } else if (cd.axisType == 10) {
                this.formatPanel[2] = new DateTimeSamplePanel(this.chartmain, cd.dataFormat, true, true, true);
                this.tabPanel.add(LanguageEncoder.getText("Label"), this.formatPanel[2]);
            } else if (cd.axisType == 0) {
                this.formatPanel[2] = new LogicalPanel();
                ((LogicalPanel)this.formatPanel[2]).setFormat(((LogicalFormat)cd.dataFormat).getformat());
                this.tabPanel.add(LanguageEncoder.getText("Label"), this.formatPanel[2]);
            }
        }
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.tabPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        this.butOK.addActionListener(this);
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butcancel.addActionListener(this);
        buttonPanel.add(this.butOK);
        buttonPanel.add(this.butcancel);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void setAxisFormat(Axis ax, int i) {
        boolean isGanttAxisFormattedAsDateTime;
        int limit;
        if (ax != null && ax.orient == 0 && this.chart.chartType == 17) {
            return;
        }
        this.map[i] = -1;
        if (ax == null) {
            return;
        }
        ColData cd = ax.columnField;
        boolean showXZAxis = false;
        int n = limit = this.chart.is2DChart ? 2 : 3;
        if (i == 0 && this.chart.axis[2].columnField == null && !this.chart.is2DChart) {
            showXZAxis = true;
        }
        if (cd == null) {
            return;
        }
        if (i == 2 && this.chart.is2DChart) {
            return;
        }
        boolean bl = isGanttAxisFormattedAsDateTime = this.chart.getChartType() == 18 && i == 0 && this.chart.isLabelDateTimeDisplay(i);
        if (cd.axisType == 99 && !isGanttAxisFormattedAsDateTime) {
            this.formatPanel[i] = new NumericSamplePanel(this.chartmain, cd.dataFormat);
        } else if (cd.axisType == 9) {
            this.formatPanel[i] = new DateTimeSamplePanel(this.chartmain, cd.dataFormat, false, true, true);
        } else if (cd.axisType == 8) {
            this.formatPanel[i] = new DateTimeSamplePanel(this.chartmain, cd.dataFormat, true, false, true);
        } else if (cd.axisType == 10 || isGanttAxisFormattedAsDateTime) {
            this.formatPanel[i] = new DateTimeSamplePanel(this.chartmain, isGanttAxisFormattedAsDateTime ? new DateTimeFormat(true) : cd.dataFormat, true, true, true);
        } else if (cd.axisType == 0) {
            this.formatPanel[i] = new LogicalPanel();
            ((LogicalPanel)this.formatPanel[i]).setFormat(((LogicalFormat)cd.dataFormat).getformat());
        } else {
            this.formatPanel[i] = null;
        }
        this.labelPanel[i] = new LabelPlacementPanel(i, this.formatPanel[i], this.chart, cd, showXZAxis);
        if (limit == 3 && this.chart.axis[i].columnField == null) {
            return;
        }
        if (i == 3 && this.axislimit < 4) {
            return;
        }
        String panelTitle = "";
        int dataMap = this.chart.mDataMap[0];
        if (this.chart.getChartType() == 16) {
            dataMap = this.chart.mDataMap[this.chart.dataDim - 1];
        }
        panelTitle = i < 4 ? axischar[i] : this.chart.colData[dataMap].getFieldName()[i - 4].toString();
        this.tabPanel.add(panelTitle + " " + LanguageEncoder.getText("axis"), this.labelPanel[i]);
        this.map[i] = this.tabPanel.getTabCount() - 1;
    }

    public void show(int i) {
        this.tabPanel.setSelectedIndex(this.map[i]);
        this.setVisible(true);
    }

    private void restoreValues() {
        if (!this.chart.isCircularChart()) {
            int i;
            for (i = 0; i < 4; ++i) {
                this.restoreValues(this.chart.axis[i], i);
            }
            for (i = 4; i < this.axCt; ++i) {
                this.restoreValues(this.chart.colDataAxis[i - 4], i);
            }
            if (this.labelPanel[0] != null && this.chart.axis[0].columnField != null && this.chart.chartType != 17) {
                this.chart.setAxisThickness(this.labelPanel[0].getAxisThickness());
                this.chart.setArrowState(this.labelPanel[0].chArrow.isSelected());
                this.chart.setWallFrame(this.labelPanel[0].chFrame.isSelected());
                if (this.labelPanel[0].chXTop != null) {
                    this.chart.setXAxisAtTop(this.labelPanel[0].chXTop.isSelected());
                }
                this.chart.xlabelrow = this.labelPanel[0].getLabelRowSize();
                this.chart.axis[0].setLabelOutsidePlotArea(this.labelPanel[0].chLabelOnTheSide.isSelected());
                if (this.chart.is2DimChart()) {
                    this.chart.setGridInFront(this.labelPanel[0].chGridToFront.isSelected());
                }
            }
            if (this.labelPanel[1] != null) {
                if (this.chart.axis[1].columnField != null) {
                    this.chart.axis[1].setLabelOutsidePlotArea(this.labelPanel[1].chLabelOnTheSide.isSelected());
                }
                if (this.labelPanel[1].chAutoAxisPos != null) {
                    this.chart.setAutoAxisPosition(this.labelPanel[1].chAutoAxisPos.isSelected());
                }
                if (this.labelPanel[1].spinAxisGap != null) {
                    this.chart.setAxisGapOffset(this.labelPanel[1].spinAxisGap.getValue());
                }
                if (this.chart.getChartType() == 17) {
                    if (this.labelPanel[1].spinTickLen != null) {
                        this.chart.setTickerLength(this.labelPanel[1].spinTickLen.getValue());
                    }
                    if (this.labelPanel[1].spinSubTickLen != null) {
                        this.chart.setSubTickerLength(this.labelPanel[1].spinSubTickLen.getValue());
                    }
                    if (this.labelPanel[1].spinSubTickCt != null) {
                        this.chart.setSubTickerCount(this.labelPanel[1].spinSubTickCt.getValue() + 1);
                    }
                    if (this.labelPanel[1].spinSubTickThickness != null) {
                        this.chart.setSubTickerThickness(this.labelPanel[1].spinSubTickThickness.getValue());
                    }
                    if (this.labelPanel[1].ch3DShadowForTicker != null) {
                        this.chart.set3DShadowForTickerOn(this.labelPanel[1].ch3DShadowForTicker.isSelected());
                    }
                }
            }
            if (this.labelPanel[3] != null && this.labelPanel[3].chSwapYS != null) {
                this.chart.setSwapAxis(this.labelPanel[3].chSwapYS.isSelected());
            }
            if (this.labelPanel[3] != null && this.labelPanel[3].chDoubleValue != null) {
                this.chart.setShowDoubleValueForLine(this.labelPanel[3].chDoubleValue.isSelected());
            }
            if (this.labelPanel[0] != null && this.labelPanel[0].chXZAxis != null) {
                this.chart.setAxisState(2, this.labelPanel[0].chXZAxis.isSelected());
            }
        } else {
            this.chart.setSpecNumericFormat(((NumericSamplePanel)this.formatPanel[0]).getformat());
            this.chart.colData[this.chart.valueCol].dataFormat = ((NumericSamplePanel)this.formatPanel[1]).getformat();
            if (this.formatPanel[2] instanceof DateTimeSamplePanel) {
                this.chart.colData[this.chart.mDataMap[0]].dataFormat = ((DateTimeSamplePanel)this.formatPanel[2]).getFormat();
            } else if (this.formatPanel[2] instanceof LogicalPanel) {
                this.chart.colData[this.chart.mDataMap[0]].dataFormat = new LogicalFormat(((LogicalPanel)this.formatPanel[2]).getFormatInt());
            }
        }
    }

    private void restoreValues(Axis ax, int i) {
        if (ax == null) {
            return;
        }
        if (this.labelPanel[i] == null) {
            return;
        }
        ColData cd = ax.columnField;
        if (cd == null) {
            return;
        }
        if (this.formatPanel[i] instanceof NumericSamplePanel) {
            cd.dataFormat = ((NumericSamplePanel)this.formatPanel[i]).getformat();
        } else if (this.formatPanel[i] instanceof DateTimeSamplePanel) {
            cd.dataFormat = ((DateTimeSamplePanel)this.formatPanel[i]).getFormat();
        } else if (this.formatPanel[i] instanceof LogicalPanel) {
            cd.dataFormat = new LogicalFormat(((LogicalPanel)this.formatPanel[i]).getFormatInt());
        }
        cd.sepSize = this.labelPanel[i].getSep();
        cd.sepUnit = this.labelPanel[i].getScaleUnit();
        if (cd.sepUnit != -1) {
            cd.isAscending = this.labelPanel[i].isAsc();
            if (cd.isAscending) {
                cd.setStartingDate(this.labelPanel[i].getRangeValue());
            } else {
                cd.setEndingDate(this.labelPanel[i].getRangeValue2());
            }
            for (int k = 0; k < this.chart.dataDim; ++k) {
                if (this.chart.colData[this.chart.mDataMap[k]] != cd) continue;
                Object[] name = cd.getSortOrder(cd.isAscending);
                this.chart.setFieldOrder(k, name);
            }
        }
        cd.tickerSepSize = this.labelPanel[i].getTickerSep();
        cd.maxNumOfTickerAndLabel = this.labelPanel[i].getMaxNumOfLabelAndTicker();
        ax.showTicker = this.labelPanel[i].chlabel.isSelected();
        ax.ticker.showline = this.labelPanel[i].chtic.isSelected();
        ax.ticker.tickerInward = this.labelPanel[i].chTickDir.isSelected();
        if (ax.isSubTickersOptionEnabled()) {
            ax.setShowSubTickers(this.labelPanel[i].chLogSubTickers.isSelected());
        }
        this.chart.setAxisState(i, this.labelPanel[i].chAxis.isSelected());
        this.chart.setGridThickness(i, this.labelPanel[i].getGridThickness());
        if (i != 3) {
            this.chart.setGridLineStyle(i, this.labelPanel[i].getGridLineStyle());
        }
        this.chart.setGridState(i, this.labelPanel[i].chGrid.isSelected());
        if (this.labelPanel[i].chGridAlignWithTicker != null) {
            this.chart.setGridAlignedWithTicker(this.labelPanel[i].chGridAlignWithTicker.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butOK) {
            this.chartmain.setModified();
            this.chartmain.invalidateLegend();
            this.restoreValues();
            this.chart.newSurface();
            this.chartmain.qbrepaint();
        }
        this.dispose();
    }
}

