/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.IOUtil;

public class GanttDialog
extends QbDialog {
    JCheckBox checkArrowsDrawn;
    JCheckBox checkDisplayTime;
    JCheckBox checkDisplayWeek;
    SpinBox spinRatio;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;

    public GanttDialog(JFrame frame, Chart chart) {
        super(frame, LanguageEncoder.getText("Gantt Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        BorderPanel subPanel10 = new BorderPanel("Gantt Chart Option");
        subPanel10.setLayout(new BoxLayout(subPanel10, 1));
        JPanel subPanel0 = new JPanel(new BorderLayout());
        this.checkArrowsDrawn = new JCheckBox(LanguageEncoder.getText("Draw Arrows"));
        subPanel0.add("West", this.checkArrowsDrawn);
        this.checkArrowsDrawn.setSelected(this.chart.isGanttArrowsDrawn());
        JPanel subPanel1 = new JPanel(new BorderLayout());
        this.checkDisplayTime = new JCheckBox(LanguageEncoder.getText("Display X-Axis in Time"));
        subPanel1.add("West", this.checkDisplayTime);
        this.checkDisplayTime.setSelected(this.chart.isLabelDateTimeDisplay(0));
        JPanel subPanel2 = new JPanel(new BorderLayout());
        this.checkDisplayWeek = new JCheckBox(LanguageEncoder.getText("Display X-Axis in Day of Week"));
        subPanel2.add("West", this.checkDisplayWeek);
        this.checkDisplayWeek.setSelected(this.chart.isDisplayByWeek(0));
        subPanel10.add(subPanel0);
        subPanel10.add(subPanel1);
        subPanel10.add(subPanel2);
        if (!IOUtil.isJava2D()) {
            this.setValues();
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", subPanel10);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void setValues() {
        this.chart.setGanttArrowsDrawn(this.checkArrowsDrawn.isSelected());
        this.chart.setLabelDateTimeDisplay(0, this.checkDisplayTime.isSelected());
        this.chart.setDisplayByWeek(0, this.checkDisplayWeek.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.setValues();
            this.chartMain.setModified();
            this.chartMain.chartPanel.repaint();
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

