/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.IGradientDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.JSwatchChooserPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.swing.color.DefaultHSBChooserPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class GradientDialog
extends QbDialog {
    private ChartMain chartMain;
    private JButton okButton;
    private JButton cancelButton;
    ColorButton colorButton;
    SpinBox startX;
    SpinBox startY;
    SpinBox endX;
    SpinBox endY;
    SpinBox shadeValue;
    JRadioButton shading;
    JRadioButton desColor;
    JComboBox shadeDirection;
    JCheckBox checkCyclic;
    JCheckBox enable3DShading;
    IGradientDialog interfaceDialog;
    boolean enable3DShadingOption = false;

    public GradientDialog(ChartMain parent, IGradientDialog dialog, String title) {
        this(parent, dialog, title, false);
    }

    public GradientDialog(ChartMain parent, IGradientDialog dialog, String title, boolean enable3DShadingOption) {
        super(parent, title, true);
        this.chartMain = parent;
        this.interfaceDialog = dialog;
        this.enable3DShadingOption = enable3DShadingOption;
        this.init();
    }

    private void init() {
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        BorderPanel pointsPanel = new BorderPanel("Points");
        pointsPanel.setLayout(new GridLayout(2, 3, 5, 5));
        pointsPanel.add(new JLabel(LanguageEncoder.getText("Start Point")));
        JPanel startXPanel = new JPanel();
        startXPanel.setLayout(new FlowLayout(0));
        startXPanel.add(new JLabel("X"));
        this.startX = new SpinBox(0, 100);
        startXPanel.add(this.startX);
        startXPanel.add(new JLabel("%"));
        pointsPanel.add(startXPanel);
        JPanel startYPanel = new JPanel();
        startYPanel.setLayout(new FlowLayout(0));
        startYPanel.add(new JLabel("Y"));
        this.startY = new SpinBox(0, 100);
        startYPanel.add(this.startY);
        startYPanel.add(new JLabel("%"));
        pointsPanel.add(startYPanel);
        pointsPanel.add(new JLabel(LanguageEncoder.getText("End Point")));
        JPanel endXPanel = new JPanel();
        endXPanel.setLayout(new FlowLayout(0));
        endXPanel.add(new JLabel("X"));
        this.endX = new SpinBox(0, 100);
        endXPanel.add(this.endX);
        endXPanel.add(new JLabel("%"));
        pointsPanel.add(endXPanel);
        JPanel endYPanel = new JPanel();
        endYPanel.setLayout(new FlowLayout(0));
        endYPanel.add(new JLabel("Y"));
        this.endY = new SpinBox(0, 100);
        endYPanel.add(this.endY);
        endYPanel.add(new JLabel("%"));
        pointsPanel.add(endYPanel);
        BorderPanel colorPanel = new BorderPanel("Color");
        colorPanel.setLayout(new GridLayout(3, 1, 0, 0));
        this.shading = new JRadioButton(LanguageEncoder.getText("Shading"));
        this.desColor = new JRadioButton(LanguageEncoder.getText("Color"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.shading);
        buttonGroup.add(this.desColor);
        JPanel shadePanel = new JPanel();
        shadePanel.setLayout(new FlowLayout(0));
        shadePanel.add(this.shading);
        this.shadeValue = new SpinBox(1, 10);
        shadePanel.add(this.shadeValue);
        this.shadeDirection = new JComboBox();
        shadePanel.add(this.shadeDirection);
        this.shadeDirection.addItem(LanguageEncoder.getText("Brighter"));
        this.shadeDirection.addItem(LanguageEncoder.getText("Darker"));
        JPanel desColorPanel = new JPanel();
        desColorPanel.setLayout(new FlowLayout(0));
        desColorPanel.add(this.desColor);
        this.colorButton = new ColorButton(LanguageEncoder.getText("Change..."));
        desColorPanel.add(this.colorButton);
        this.colorButton.addActionListener(this);
        this.shading.addItemListener(this);
        this.desColor.addItemListener(this);
        colorPanel.add(shadePanel);
        colorPanel.add(desColorPanel);
        JPanel cyclicPanel = new JPanel();
        cyclicPanel.setLayout(new FlowLayout(0));
        this.checkCyclic = new JCheckBox(LanguageEncoder.getText("Cyclic"));
        cyclicPanel.add(this.checkCyclic);
        colorPanel.add(cyclicPanel);
        BorderPanel panel4 = new BorderPanel("3D Shading");
        panel4.setLayout(new FlowLayout(0));
        this.enable3DShading = new JCheckBox(LanguageEncoder.getText("Use 3D Shading Effect for 2D bar/ column"));
        this.enable3DShading.addItemListener(this);
        panel4.add(this.enable3DShading);
        BorderPanel gradientPanel = new BorderPanel(LanguageEncoder.getText("Gradient"));
        gradientPanel.setLayout(new BorderLayout());
        gradientPanel.add("North", pointsPanel);
        gradientPanel.add("Center", colorPanel);
        if (this.enable3DShadingOption) {
            gradientPanel.add("South", panel4);
        }
        cop.add("Center", gradientPanel);
        cop.add("South", buttonPanel);
        this.setDialogValues();
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object srcObj = e.getSource();
        this.shadeValue.setEnabled(this.shading.isSelected());
        this.shadeDirection.setEnabled(this.shading.isSelected());
        this.colorButton.setEnabled(this.desColor.isSelected());
        if (srcObj == this.enable3DShading) {
            this.enableGradientOptions(!this.enable3DShading.isSelected());
        }
    }

    public void setDialogValues() {
        this.startX.setValue((int)(this.interfaceDialog.getGradientStartX() * 100.0));
        this.startY.setValue((int)(this.interfaceDialog.getGradientStartY() * 100.0));
        this.endX.setValue((int)(this.interfaceDialog.getGradientEndX() * 100.0));
        this.endY.setValue((int)(this.interfaceDialog.getGradientEndY() * 100.0));
        if (this.interfaceDialog.getGradientDesColor() == null) {
            this.shading.setSelected(true);
        } else {
            this.desColor.setSelected(true);
        }
        this.shadeValue.setValue(Math.abs(this.interfaceDialog.getGradientShade()));
        this.shadeDirection.setSelectedIndex(this.interfaceDialog.getGradientShade() <= 0 ? 0 : 1);
        if (this.interfaceDialog.getGradientDesColor() == null) {
            this.setColor(Color.lightGray);
        } else {
            this.setColor(this.interfaceDialog.getGradientDesColor());
        }
        this.checkCyclic.setSelected(this.interfaceDialog.isGradientCyclic());
        this.enable3DShading.setSelected(this.interfaceDialog.is3DShadingEnabled());
        this.shadeValue.setEnabled(this.shading.isSelected());
        this.shadeDirection.setEnabled(this.shading.isSelected());
        this.colorButton.setEnabled(this.desColor.isSelected());
        this.enableGradientOptions(!this.enable3DShading.isSelected());
    }

    private void enableGradientOptions(boolean enable) {
        this.startX.setEnabled(enable);
        this.startY.setEnabled(enable);
        this.endX.setEnabled(enable);
        this.endY.setEnabled(enable);
        this.shading.setEnabled(enable);
        this.desColor.setEnabled(enable);
        this.shadeValue.setEnabled(enable);
        this.shadeDirection.setEnabled(enable);
        this.checkCyclic.setEnabled(enable);
        this.colorButton.setEnabled(enable);
    }

    public void setValues() {
        this.interfaceDialog.setValues(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.interfaceDialog.resetGradientDialog();
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.colorButton) {
            Color currentColor = GradientDialog.showDialog(this.chartMain, LanguageEncoder.getText("Set Color ..."), this.getButtonColor());
            this.setColor(currentColor);
            return;
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.setButtonColor(color);
    }

    Color getButtonColor() {
        return this.colorButton.getColor();
    }

    private void setButtonColor(Color color) {
        this.colorButton.setColor(color);
    }

    private static JColorChooser getColorChooser(ChartMain chartMain, Color initColor) {
        JColorChooser colorChooser = new JColorChooser();
        AbstractColorChooserPanel[] panels = colorChooser.getChooserPanels();
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[]{new JSwatchChooserPanel(chartMain.getRecentColorArray()), new DefaultHSBChooserPanel(), panels[2]};
        colorChooser.setChooserPanels(newPanels);
        colorChooser.setColor(initColor);
        return colorChooser;
    }

    private static Color showDialog(ChartMain chartMain, String title, Color initColor) {
        JColorChooser pane = GradientDialog.getColorChooser(chartMain, initColor);
        ColorTracker okTracker = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(chartMain, title, true, pane, okTracker, null);
        dialog.setVisible(true);
        return okTracker.getColor();
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

