/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.LegendItemPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.OurPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class HideLegendItemDialog
extends QbDialog {
    Chart chart;
    int col1;
    int col2;
    int col3;
    boolean[] col1Save;
    boolean[] col2Save;
    boolean[] col3Save;
    LegendItemPanel p1;
    LegendItemPanel p2;
    LegendItemPanel p3;
    JButton butcancel;
    JButton butOK;
    ChartMain chartmain;
    JButton allButton;
    JButton noneButton;
    JTabbedPane tabpanel;

    public HideLegendItemDialog(ChartMain chartmain, String title) {
        super(chartmain, title, true);
        this.setBackground(Color.lightGray);
        this.chart = chartmain.chart;
        this.chartmain = chartmain;
        this.col3 = -1;
        this.col2 = -1;
        this.col1 = -1;
        switch (this.chart.dataDim) {
            case 1: {
                this.col1 = this.chart.mDataMap[0];
                break;
            }
            case 2: {
                this.col1 = this.chart.mDataMap[this.chart.isStackType() ? 1 : 0];
                break;
            }
            default: {
                this.col1 = this.chart.mDataMap[0];
                this.col2 = this.chart.mDataMap[2];
            }
        }
        if (this.chart.getComboType() == 3 && this.chart.getSubValueMap() >= 0 && this.chart.getComboSeries() >= 0 && !this.chart.processedChart) {
            if (this.col2 < 0) {
                this.col2 = this.chart.getComboSeries();
            } else {
                this.col3 = this.chart.getComboSeries();
            }
        }
        if (this.col1 < 0) {
            return;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(180, 180));
        this.p1 = new LegendItemPanel(this.chart.colData[this.col1]);
        JScrollPane sp1 = new JScrollPane(this.p1);
        this.allButton = new JButton();
        this.allButton.setToolTipText("Select All");
        this.noneButton = new JButton();
        this.allButton.setToolTipText("Select None");
        OurPanel selectionPanel = this.makeSelectionPanel();
        if (this.col2 >= 0) {
            this.p2 = new LegendItemPanel(this.chart.colData[this.col2]);
            JScrollPane sp2 = new JScrollPane(this.p2);
            this.tabpanel = new JTabbedPane();
            this.tabpanel.add(this.chart.colData[this.col1].getName(), sp1);
            this.tabpanel.add(this.chart.colData[this.col2].getName(), sp2);
            if (this.col3 >= 0) {
                this.p3 = new LegendItemPanel(this.chart.colData[this.col3]);
                JScrollPane sp3 = new JScrollPane(this.p3);
                this.tabpanel.add(this.chart.colData[this.col3].getName(), sp3);
            }
            contentPane.add("Center", this.tabpanel);
        } else {
            contentPane.add("Center", sp1);
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        this.butcancel.addActionListener(this);
        this.butOK.addActionListener(this);
        buttonPanel.add(this.butOK);
        buttonPanel.add(this.butcancel);
        contentPane.add("South", buttonPanel);
        contentPane.add("North", selectionPanel);
        if (this.col1 >= 0) {
            this.col1Save = this.chart.getLegendItems(this.col1);
        }
        if (this.col2 >= 0) {
            this.col2Save = this.chart.getLegendItems(this.col2);
        }
        if (this.col3 >= 0) {
            this.col3Save = this.chart.getLegendItems(this.col3);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (this.col1 < 0) {
                return;
            }
            this.pack();
        }
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butOK) {
            if (this.col1 >= 0) {
                this.chart.setLegendItems(this.col1, this.p1.getValues());
                if (this.col2 >= 0) {
                    this.chart.setLegendItems(this.col2, this.p2.getValues());
                    if (this.col3 >= 0) {
                        this.chart.setLegendItems(this.col3, this.p3.getValues());
                    }
                }
                this.chartmain.chartPanel.paint();
            }
            this.dispose();
        }
        if (e.getSource() == this.butcancel) {
            this.dispose();
        }
        if (e.getSource() == this.allButton) {
            if (this.col1 >= 0 && this.col2 < 0) {
                this.p1.list.setSelectionInterval(0, this.p1.list.getModel().getSize() - 1);
            }
            if (this.col2 >= 0) {
                if (this.tabpanel.getSelectedIndex() == 0) {
                    this.p1.list.setSelectionInterval(0, this.p1.list.getModel().getSize() - 1);
                } else if (this.tabpanel.getSelectedIndex() == 1) {
                    this.p2.list.setSelectionInterval(0, this.p2.list.getModel().getSize() - 1);
                } else {
                    this.p3.list.setSelectionInterval(0, this.p3.list.getModel().getSize() - 1);
                }
            }
        } else if (e.getSource() == this.noneButton) {
            if (this.col1 >= 0 && this.col2 < 0) {
                this.p1.list.clearSelection();
            }
            if (this.col2 >= 0) {
                if (this.tabpanel.getSelectedIndex() == 0) {
                    this.p1.list.clearSelection();
                } else if (this.tabpanel.getSelectedIndex() == 1) {
                    this.p2.list.clearSelection();
                } else {
                    this.p3.list.clearSelection();
                }
            }
        }
    }

    void undoHide() {
        if (this.col1Save != null) {
            this.chart.setLegendItems(this.col1, this.col1Save);
        }
        if (this.col2Save != null) {
            this.chart.setLegendItems(this.col2, this.col2Save);
        }
        if (this.col3Save != null) {
            this.chart.setLegendItems(this.col3, this.col3Save);
        }
    }

    private OurPanel makeSelectionPanel() {
        OurPanel selectionPanel = new OurPanel(new FlowLayout(2));
        String allStr = ServerMessage.imagesPath + "selectAll.png";
        String noneStr = ServerMessage.imagesPath + "unselectAll.png";
        this.allButton = new JButton(IOUtil.getImageIcon(allStr));
        selectionPanel.add(this.allButton);
        this.noneButton = new JButton(IOUtil.getImageIcon(noneStr));
        selectionPanel.add(this.noneButton);
        this.allButton.setBorder(BorderFactory.createEmptyBorder());
        this.allButton.setContentAreaFilled(false);
        this.allButton.addActionListener(this);
        this.noneButton.setBorder(BorderFactory.createEmptyBorder());
        this.noneButton.setContentAreaFilled(false);
        this.noneButton.addActionListener(this);
        selectionPanel.add(this.allButton);
        selectionPanel.add(this.noneButton);
        return selectionPanel;
    }

    ImageIcon getImage(String s) {
        InputStream inputstream = this.getClass().getResourceAsStream(s);
        if (inputstream == null) {
            return null;
        }
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        byte[] abyte0 = new byte[1024];
        try {
            int i;
            do {
                if ((i = inputstream.read(abyte0)) == -1) continue;
                bytearrayoutputstream.write(abyte0, 0, i);
            } while (i != -1);
            inputstream.close();
        }
        catch (IOException _ex) {
            try {
                _ex.printStackTrace();
                inputstream.close();
            }
            catch (IOException _ex2) {
                _ex2.printStackTrace();
            }
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(bytearrayoutputstream.toByteArray()));
    }
}

