/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.HistogramOptions;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class HistogramDialog
extends QbDialog
implements ItemListener {
    ChartMain chartMain = null;
    JPanel mainPanel = null;
    JPanel buttonPanel = null;
    JCheckBox checkHistogram = null;
    JCheckBox showPercentage = null;
    JPanel checkboxPanel = null;
    JButton okButton = null;
    JButton cancelButton = null;
    JButton optionButton = null;
    boolean enabledItemStateChanged = true;
    HistogramOptions histOptions = null;

    public HistogramDialog(ChartMain chartMain) {
        super(chartMain, LanguageEncoder.getText("Draw Histogram"), true);
        this.chartMain = chartMain;
        this.init();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.mainPanel);
        contentPane.add("South", this.buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.mainPanel = new BorderPanel(LanguageEncoder.getText("Draw Histogram"));
        this.mainPanel.setLayout(new BorderLayout());
        this.checkboxPanel = new JPanel();
        this.checkboxPanel.setLayout(new FlowLayout(3));
        this.checkHistogram = new JCheckBox(LanguageEncoder.getText("Draw Histogram"));
        this.checkHistogram.setSelected(this.chartMain.chart.isHistogram());
        this.checkHistogram.addItemListener(this);
        this.showPercentage = new JCheckBox(LanguageEncoder.getText("Show probability"));
        this.showPercentage.setEnabled(this.checkHistogram.isSelected());
        this.showPercentage.setSelected(this.chartMain.chart.isShowPercentage());
        this.showPercentage.addItemListener(this);
        this.checkboxPanel.add(this.checkHistogram);
        this.checkboxPanel.add(this.showPercentage);
        this.mainPanel.add("Center", this.checkboxPanel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.optionButton = new JButton(LanguageEncoder.getText("Options"));
        this.optionButton.setEnabled(this.checkHistogram.isSelected());
        this.optionButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.optionButton);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        if (this.chartMain.chart.isHistogram()) {
            int categoryType = this.chartMain.chart.getCategoryType();
            if (categoryType == 12 || categoryType == -1 || categoryType == 1 || categoryType == -7 || categoryType == 16) {
                this.optionButton.setEnabled(false);
            } else {
                this.optionButton.setEnabled(true);
            }
        } else {
            this.optionButton.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancelButton) {
            this.setVisible(false);
            return;
        }
        if (target == this.optionButton) {
            this.displayHistogramOptions();
        }
        if (target == this.okButton) {
            if (!this.chartMain.chart.isHistogram()) {
                this.chartMain.chart.barwidthRatio = 0.0;
            }
            this.chartMain.chart.setHistogram(this.checkHistogram.isSelected());
            this.chartMain.chart.setShowPercentage(this.showPercentage.isSelected());
            this.chartMain.chart.gt.clear();
            this.chartMain.chart.gt.shift = false;
            this.chartMain.do_Reload();
            this.chartMain.setModified();
            this.setVisible(false);
        }
    }

    private void displayHistogramOptions() {
        if (this.histOptions != null) {
            this.histOptions.setVisible(true);
        } else {
            this.histOptions = new HistogramOptions(this.chartMain, this.chartMain.chart.getCategoryType());
            this.histOptions.setVisible(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.enabledItemStateChanged) {
            return;
        }
        this.enabledItemStateChanged = false;
        Object target = e.getSource();
        if (target == this.showPercentage && this.showPercentage.isSelected() && this.chartMain.chart.getSeriesIndex() >= 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Before this action, please remove data series from data mapping!"));
            return;
        }
        if (target == this.checkHistogram) {
            if (this.checkHistogram.isSelected()) {
                int categoryType = this.chartMain.chart.getCategoryType();
                if (this.chartMain.chart.getSeriesIndex() >= 0) {
                    MessageDialog.showError(this, true, LanguageEncoder.getText("Can't display histogram for chart with data series!"));
                    return;
                }
                if (categoryType == 12 || categoryType == -1 || categoryType == 1 || categoryType == -7 || categoryType == 16) {
                    this.optionButton.setEnabled(false);
                } else {
                    this.chartMain.chart.setHistogram(this.checkHistogram.isSelected());
                    this.chartMain.chart.setShowPercentage(this.showPercentage.isSelected());
                    this.chartMain.chart.barwidthRatio = 0.0;
                    this.chartMain.chart.gt.clear();
                    this.chartMain.chart.gt.shift = false;
                    this.chartMain.do_Reload();
                    this.chartMain.setModified();
                    this.optionButton.setEnabled(true);
                    this.chartMain.chart.getPreprocInfo().bRounded = true;
                    this.chartMain.chart.getPreprocInfo().isLinear = true;
                    this.chartMain.chart.colDataHasChangedBecauseOfAggrHistZoom = true;
                    this.chartMain.chart.originalColDataFromMemSource = this.chartMain.chart.colData;
                    int n = this.getInitialBinNumber();
                    this.chartMain.chart.setBinNumber(n);
                    this.chartMain.chart.getPreprocInfo().intervalNum = this.getScaleValue(n);
                }
                this.checkHistogram.setSelected(true);
                this.showPercentage.setEnabled(true);
            } else {
                this.optionButton.setEnabled(false);
                this.showPercentage.setEnabled(false);
                this.showPercentage.setSelected(false);
            }
        }
        this.enabledItemStateChanged = true;
    }

    private int getInitialBinNumber() {
        int i = this.chartMain.chart.getCategoryIndex();
        int n = this.chartMain.chart.colData[i].getSize();
        if (n > 10) {
            return 10;
        }
        return n;
    }

    private double getScaleValue(int bin) {
        int i = this.chartMain.chart.getCategoryIndex();
        double lb = Double.parseDouble(this.chartMain.chart.getColData()[i].getData(0).toString());
        if (lb > 10.0) {
            int cnt = QbUtil.countDigits((int)lb) - 1;
            lb = QbUtil.floor(lb, Math.pow(10.0, cnt));
            this.chartMain.chart.getPreprocInfo().lBound = lb;
        } else {
            lb = 0.0;
        }
        return QbUtil.getScaleValue(bin, this.chartMain.chart.getColData()[i], true, lb, null, true);
    }
}

