/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.PreprocInfo;
import quadbase.chart.ReloadChart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class HistogramOptions
extends QbDialog
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(HistogramOptions.class.getName());
    ChartMain chartMain = null;
    Chart chart = null;
    static JPanel mainPanel = null;
    static JPanel rangePanel = null;
    static JPanel buttonPanel = null;
    public static JCheckBox enableScale = null;
    static JButton useSuggestedBinNumberButton = null;
    public static JCheckBox setLowerBound = null;
    public static JCheckBox setUpperBound = null;
    static JButton okButton = null;
    static JButton cancelButton = null;
    static JTextField lowerBound = null;
    static JTextField upperBound = null;
    static JPanel scalePanel = null;
    static RadioButtonPanel radioButtonPanel1 = null;
    static RadioButtonPanel radioButtonPanel2 = null;
    public boolean linearScale = true;
    public String scaleValue = "1";
    public int binNumber = 0;
    int categoryType = 0;
    JFrame parentFrame = null;
    boolean reloadOnOk = false;
    private boolean initializing = false;

    public HistogramOptions(ChartMain chartMain, int categoryType) {
        super(chartMain, LanguageEncoder.getText("Histogram Options..."), true);
        this.parentFrame = chartMain;
        this.chartMain = chartMain;
        this.categoryType = categoryType;
        this.reloadOnOk = false;
        this.initializing = true;
        this.init();
        this.initializing = false;
    }

    private void init() {
        this.setBackground(Color.lightGray);
        mainPanel = new BorderPanel(LanguageEncoder.getText("Axis Options"));
        mainPanel.setLayout(new BorderLayout());
        rangePanel = new BorderPanel(LanguageEncoder.getText("Enter Category Range"));
        rangePanel.setLayout(new FlowLayout(0));
        JPanel lPanel = new JPanel();
        lPanel.setLayout(new FlowLayout());
        setLowerBound = new JCheckBox(LanguageEncoder.getText("Lower Bound"));
        setLowerBound.addItemListener(this);
        lowerBound = new JTextField(10);
        lPanel.add(setLowerBound);
        lPanel.add(lowerBound);
        JPanel uPanel = new JPanel();
        uPanel.setLayout(new FlowLayout());
        setUpperBound = new JCheckBox(LanguageEncoder.getText("Upper Bound"));
        setUpperBound.addItemListener(this);
        upperBound = new JTextField(10);
        uPanel.add(setUpperBound);
        uPanel.add(upperBound);
        rangePanel.add(lPanel);
        rangePanel.add(uPanel);
        mainPanel.add((Component)rangePanel, "North");
        scalePanel = new BorderPanel(LanguageEncoder.getText("Enter Histogram Options"));
        scalePanel.setLayout(new GridLayout(2, 1, 2, 2));
        JPanel scalePanelTop = new JPanel();
        scalePanelTop.setLayout(new FlowLayout(0));
        enableScale = new JCheckBox(LanguageEncoder.getText("Enable Bins"));
        enableScale.addItemListener(this);
        scalePanelTop.add(enableScale);
        useSuggestedBinNumberButton = new JButton(LanguageEncoder.getText("Use suggested Number of Bins"));
        useSuggestedBinNumberButton.addActionListener(this);
        scalePanelTop.add(useSuggestedBinNumberButton);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new FlowLayout(0));
        JPanel LinearPanel = new JPanel();
        LinearPanel.setLayout(new FlowLayout(0));
        radioButtonPanel1 = new RadioButtonPanel(LanguageEncoder.getText("Number of Bins:"));
        radioButtonPanel2 = new RadioButtonPanel(LanguageEncoder.getText("Bin Width:"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(HistogramOptions.radioButtonPanel1.jRadioButton);
        buttonGroup.add(HistogramOptions.radioButtonPanel2.jRadioButton);
        HistogramOptions.radioButtonPanel1.jRadioButton.addItemListener(this);
        HistogramOptions.radioButtonPanel2.jRadioButton.addItemListener(this);
        HistogramOptions.radioButtonPanel1.jRadioButton.setSelected(true);
        HistogramOptions.radioButtonPanel1.jTextField.addActionListener(this);
        HistogramOptions.radioButtonPanel2.jTextField.addActionListener(this);
        radioButtonPanel.add(radioButtonPanel1);
        radioButtonPanel.add(radioButtonPanel2);
        scalePanel.add(scalePanelTop);
        scalePanel.add(radioButtonPanel);
        mainPanel.add((Component)scalePanel, "Center");
        this.extractPreprocInfo();
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        okButton = new JButton(LanguageEncoder.getText("OK"));
        okButton.addActionListener(this);
        cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        cancelButton.addActionListener(this);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == okButton) {
            if (setLowerBound.isSelected() && setUpperBound.isSelected()) {
                boolean validBounds = this.checkBoundValues();
                if (!validBounds) {
                    MessageDialog.showError(this.parentFrame, true, LanguageEncoder.getText("Please enter lower bound and upper bound values"));
                    return;
                }
                validBounds = this.checkBounds();
                if (!validBounds) {
                    MessageDialog.showError(this.parentFrame, true, LanguageEncoder.getText("Lower Bound value has to be less than Upper Bound value entered"));
                    return;
                }
            }
            if (!setLowerBound.isSelected()) {
                double d = this.setLowerBound(this.getCategoryValues());
                lowerBound.setText(String.valueOf(d));
                setLowerBound.setSelected(true);
            }
            if (enableScale.isSelected()) {
                if (HistogramOptions.radioButtonPanel1.jRadioButton.isSelected()) {
                    try {
                        int bin = Integer.parseInt(HistogramOptions.radioButtonPanel1.jTextField.getText());
                        if (bin <= 0) {
                            MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter an Integer value(>0) for Number of Bins"));
                            return;
                        }
                        HistogramOptions.radioButtonPanel2.jTextField.setText(String.valueOf(this.getScaleValue(bin)));
                        this.setScaleValue(HistogramOptions.radioButtonPanel2.jTextField.getText());
                        this.setBinNum(HistogramOptions.radioButtonPanel1.jTextField.getText());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to parse Number of Bin value, must be Integer", ex);
                        MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter an Integer value(>0) for Number of Bins."));
                        return;
                    }
                }
                if (HistogramOptions.radioButtonPanel2.jRadioButton.isSelected()) {
                    try {
                        double scale = Double.parseDouble(HistogramOptions.radioButtonPanel2.jTextField.getText());
                        if (scale <= 0.0) {
                            MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter a Numeric value(>0)for Bin Width"));
                            return;
                        }
                        this.setScaleValue(HistogramOptions.radioButtonPanel2.jTextField.getText());
                        HistogramOptions.radioButtonPanel1.jTextField.setText(String.valueOf(this.getBinNumber()));
                        this.setBinNum(HistogramOptions.radioButtonPanel1.jTextField.getText());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to parse Number of Scale vlaue, must be Number", ex);
                        MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter Numeric value for Bin Width."));
                        return;
                    }
                }
            }
            this.getParent().setEnabled(true);
            this.setVisible(false);
            this.fillPreprocInfo();
        }
        if (target == cancelButton) {
            this.getParent().setEnabled(true);
            this.setVisible(false);
        }
        if (target == useSuggestedBinNumberButton) {
            int bin = this.getSuggestedBinNumber();
            HistogramOptions.radioButtonPanel1.jTextField.setText(String.valueOf(bin));
            HistogramOptions.radioButtonPanel2.jTextField.setText(String.valueOf(this.getScaleValue(bin)));
            this.setScaleValue(HistogramOptions.radioButtonPanel2.jTextField.getText());
            enableScale.setSelected(true);
            this.enableScalePanel(true);
        }
        if (target == HistogramOptions.radioButtonPanel1.jTextField) {
            try {
                int bin = Integer.parseInt(HistogramOptions.radioButtonPanel1.jTextField.getText());
                if (bin <= 0) {
                    MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter an Integer value(>0) for Number of Bins"));
                    return;
                }
                HistogramOptions.radioButtonPanel2.jTextField.setText(String.valueOf(this.getScaleValue(bin)));
                this.setScaleValue(HistogramOptions.radioButtonPanel2.jTextField.getText());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to parse Number of Bin value, must be Integer", ex);
                MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter an Integer value(>0) for Number of Bins"));
                return;
            }
        }
        if (target == HistogramOptions.radioButtonPanel2.jTextField) {
            try {
                double scale = Double.parseDouble(HistogramOptions.radioButtonPanel2.jTextField.getText());
                if (scale <= 0.0) {
                    MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter a Numeric value(>0)for Bin Width"));
                    return;
                }
                this.setScaleValue(HistogramOptions.radioButtonPanel2.jTextField.getText());
                HistogramOptions.radioButtonPanel1.jTextField.setText(String.valueOf(this.getBinNumber()));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to parse Number of Scale vlaue, must be Number", ex);
                MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("Please enter a Numeric value(>0) for Bin Width. "));
                return;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.initializing) {
            return;
        }
        this.initializing = true;
        Object target = e.getSource();
        if (target == enableScale) {
            if (enableScale.isSelected() && (this.categoryType == 12 || this.categoryType == -1 || this.categoryType == 1)) {
                MessageDialog.showError(this.parentFrame, true, LanguageEncoder.getText("Can't enable scale for String Data Types"));
                enableScale.setSelected(false);
                return;
            }
            this.enableScalePanel(enableScale.isSelected());
        }
        if (target == HistogramOptions.radioButtonPanel1.jRadioButton || target == HistogramOptions.radioButtonPanel2.jRadioButton) {
            HistogramOptions.radioButtonPanel1.jTextField.setEnabled(HistogramOptions.radioButtonPanel1.jRadioButton.isSelected());
            HistogramOptions.radioButtonPanel2.jTextField.setEnabled(HistogramOptions.radioButtonPanel2.jRadioButton.isSelected());
        }
        if (target == setLowerBound) {
            lowerBound.setEnabled(setLowerBound.isSelected());
            if (setLowerBound.isSelected()) {
                lowerBound.setText(this.chartMain.chart.getColData()[0].getData(0).toString());
            }
        }
        if (target == setUpperBound) {
            upperBound.setEnabled(setUpperBound.isSelected());
            if (setUpperBound.isSelected()) {
                upperBound.setText(String.valueOf(Double.valueOf(this.chartMain.chart.getColData()[0].getData(this.chartMain.chart.getColData()[0].getSize() - 1).toString()) + 1.0));
            }
        }
        this.initializing = false;
    }

    private void extractPreprocInfo() {
        Chart chart = null;
        chart = this.chartMain.chart;
        PreprocInfo tsInfo = chart.getPreprocInfo();
        if (tsInfo != null) {
            if (this.categoryType == 12 || this.categoryType == -1 || this.categoryType == -7 || this.categoryType == 16) {
                enableScale.setSelected(false);
            } else {
                enableScale.setSelected(tsInfo.bRounded);
            }
            this.enableScalePanel(enableScale.isSelected());
            if (tsInfo.intervalNum != null) {
                this.scaleValue = tsInfo.intervalNum.toString();
            }
            HistogramOptions.radioButtonPanel2.jTextField.setText(this.scaleValue);
            this.binNumber = chart.getBinNumber() > 0 ? chart.getBinNumber() : this.getBinNumber();
            HistogramOptions.radioButtonPanel1.jTextField.setText(Integer.toString(this.binNumber));
            if (tsInfo.lBound != null) {
                setLowerBound.setSelected(true);
                lowerBound.setEnabled(true);
                lowerBound.setText(tsInfo.lBound.toString());
            } else {
                lowerBound.setEnabled(false);
            }
            if (tsInfo.uBound != null) {
                setUpperBound.setSelected(true);
                upperBound.setEnabled(true);
                upperBound.setText(tsInfo.uBound.toString());
            } else {
                upperBound.setEnabled(false);
            }
        } else {
            lowerBound.setText("1");
            upperBound.setText("1");
        }
    }

    private boolean checkBoundValues() {
        String lbValue = lowerBound.getText();
        String ubValue = upperBound.getText();
        return !lbValue.equals("") && !ubValue.equals("");
    }

    private boolean checkBounds() {
        int dataType = DataType.mapType(this.categoryType);
        try {
            Object lbValue = DataType.createObject(lowerBound.getText().trim(), dataType);
            Object ubValue = DataType.createObject(upperBound.getText().trim(), dataType);
            if (lbValue instanceof Number) {
                return ((Number)lbValue).floatValue() < ((Number)ubValue).floatValue();
            }
            if (lbValue instanceof String) {
                return ((String)lbValue).compareTo((String)ubValue) <= 0;
            }
            return false;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Failed to check histogram bounds", ex);
            return false;
        }
    }

    private void fillPreprocInfo() {
        Chart chart = null;
        chart = this.chartMain.chart;
        PreprocInfo tsInfo = chart.getPreprocInfo();
        tsInfo.bRounded = enableScale.isSelected();
        if (enableScale.isSelected()) {
            tsInfo.isLinear = true;
            tsInfo.intervalNum = Double.valueOf(this.scaleValue);
            chart.setBinNumber(this.binNumber);
        } else {
            tsInfo.isLinear = false;
        }
        if (!setLowerBound.isSelected()) {
            tsInfo.lBound = null;
        } else {
            this.setBound(tsInfo, 0);
        }
        if (!setUpperBound.isSelected()) {
            tsInfo.uBound = null;
        } else {
            this.setBound(tsInfo, 1);
        }
    }

    private void setBound(PreprocInfo tsInfo, int index) {
        String boundValue = null;
        if (index == 0) {
            boundValue = lowerBound.getText().trim();
        } else if (index == 1) {
            boundValue = upperBound.getText().trim();
        } else {
            LOGGER.warning("Set histogram bound - invalid index 1 !");
        }
        try {
            Object boundObject = DataType.createObject(boundValue, DataType.mapType(this.categoryType));
            if (index == 0) {
                tsInfo.lBound = boundObject;
            } else if (index == 1) {
                tsInfo.uBound = boundObject;
            } else {
                LOGGER.warning("Set histogram bound - invalid index 2 !");
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Failed to set histogram bound");
        }
    }

    public void setScaleValue(String value) {
        this.scaleValue = value;
    }

    public String getScaleValue() {
        return this.scaleValue;
    }

    public void setBinNum(String value) {
        this.binNumber = Integer.valueOf(value);
    }

    public String getBinNum() {
        return Integer.toString(this.binNumber);
    }

    public void setLinearChoice(boolean isLinear) {
        this.linearScale = isLinear;
    }

    public boolean getLinearChoice() {
        return this.linearScale;
    }

    private double getScaleValue(int bin) {
        int i = this.chartMain.chart.getCategoryIndex();
        String lBound = null;
        String uBound = null;
        Vector vData = null;
        vData = this.getCategoryValues();
        lBound = setLowerBound.isSelected() ? lowerBound.getText() : String.valueOf(this.setLowerBound(vData));
        if (setUpperBound.isSelected()) {
            uBound = upperBound.getText();
        }
        return QbUtil.getScaleValue(bin, this.getCategoryColData(), false, lBound, uBound, true);
    }

    private int getBinNumber() {
        double dataRange;
        double d;
        int n = 1;
        double scaleVal = Double.valueOf(this.getScaleValue());
        String lBound = null;
        String uBound = null;
        Vector vData = null;
        vData = this.getCategoryValues();
        lBound = setLowerBound.isSelected() ? lowerBound.getText() : String.valueOf(this.setLowerBound(vData));
        if (setUpperBound.isSelected()) {
            uBound = upperBound.getText();
        }
        if ((d = (dataRange = QbUtil.getDataRange(Double.parseDouble(vData.get(0).toString()), Double.parseDouble(vData.get(vData.size() - 1).toString()), lBound, uBound)) / scaleVal) > 1.0) {
            n = (int)(d + 0.5);
        } else if (d == 1.0) {
            n = 2;
        }
        return n;
    }

    private double log2(int n) {
        return Math.log(n) / Math.log(2.0);
    }

    private Vector getCategoryValues() {
        Vector vData = this.getCategoryColData().getDistinctValue();
        Collections.sort(vData);
        return vData;
    }

    private ColData getCategoryColData() {
        ColData cData = null;
        int i = this.chartMain.chart.getCategoryIndex();
        if (this.chartMain.chart.originalColDataFromMemSource != null) {
            cData = this.chartMain.chart.originalColDataFromMemSource[i];
        } else {
            ColData[] cds;
            String cname = this.chartMain.chart.getCategoryName();
            for (ColData cd : cds = ReloadChart.getOriginalColData(this.chartMain.chart, false, true)) {
                if (!cd.colName.equals(cname)) continue;
                cData = cd;
                break;
            }
        }
        return cData;
    }

    private double setLowerBound(Vector vData) {
        double lb = Double.parseDouble(vData.get(0).toString());
        if (lb > 10.0) {
            int cnt = QbUtil.countDigits((int)lb) - 1;
            lb = QbUtil.floor(lb, Math.pow(10.0, cnt));
        } else {
            lb = 0.0;
        }
        this.chartMain.chart.getPreprocInfo().lBound = lb;
        return lb;
    }

    private int getSuggestedBinNumber() {
        double lbound = 0.0;
        double ubound = 0.0;
        boolean setBound = false;
        Vector vData = null;
        int n = 5;
        vData = this.getCategoryValues();
        if (setLowerBound.isSelected()) {
            lbound = Double.valueOf(lowerBound.getText());
            setBound = true;
        } else {
            lbound = this.setLowerBound(vData);
        }
        if (setUpperBound.isSelected()) {
            ubound = Double.valueOf(upperBound.getText());
            setBound = true;
        } else {
            ubound = Double.valueOf(vData.get(vData.size() - 1).toString());
        }
        n = !setBound ? vData.size() : this.findDataCount(lbound, ubound, vData);
        return (int)(3.0 + this.log2(n) * Math.log(n));
    }

    private int findDataCount(double lbound, double ubound, Vector vData) {
        int n = 0;
        int size = vData.size();
        for (int i = 0; i < size; ++i) {
            double d = Double.valueOf(vData.get(i).toString());
            if (!(d >= lbound) || !(d <= ubound)) continue;
            ++n;
        }
        return n;
    }

    private void enableScalePanel(boolean b) {
        HistogramOptions.radioButtonPanel1.jRadioButton.setEnabled(b);
        if (b) {
            HistogramOptions.radioButtonPanel1.jTextField.setEnabled(HistogramOptions.radioButtonPanel1.jRadioButton.isSelected());
        } else {
            HistogramOptions.radioButtonPanel1.jTextField.setEnabled(b);
        }
        HistogramOptions.radioButtonPanel2.jRadioButton.setEnabled(b);
        if (b) {
            HistogramOptions.radioButtonPanel2.jTextField.setEnabled(HistogramOptions.radioButtonPanel2.jRadioButton.isSelected());
        } else {
            HistogramOptions.radioButtonPanel2.jTextField.setEnabled(b);
        }
    }

    private class RadioButtonPanel
    extends JPanel {
        JRadioButton jRadioButton;
        JTextField jTextField;

        RadioButtonPanel(String radioButtonName) {
            this.jRadioButton = new JRadioButton(radioButtonName);
            this.jTextField = new JTextField(10);
            this.setLayout(new FlowLayout());
            this.add(this.jRadioButton);
            this.add(this.jTextField);
            this.jTextField.setEnabled(this.jRadioButton.isSelected());
        }
    }
}

