/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.CAnnotation;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.chart.HorzVertLine;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.LineStyleDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IAnnotation;
import quadbase.util.IReferenceObj;

public class HorzVertLineDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(HorzVertLineDialog.class.getName());
    static final String NONE = "none";
    Chart chart;
    ChartMain chartmain;
    boolean callNewSurface = false;
    HorzVertLine curDataLine = null;
    HorzVertLinePanel horzVertLinePanel;
    JButton okButton;
    JButton cancelButton;

    public HorzVertLineDialog(ChartMain chartmain, HorzVertLine dataLine) {
        super(chartmain, LanguageEncoder.getText("Define Constant Line..."), true);
        this.setBackground(Color.lightGray);
        this.curDataLine = dataLine;
        this.chart = chartmain.chart;
        this.chartmain = chartmain;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        bottomPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        bottomPanel.add(this.cancelButton);
        this.horzVertLinePanel = new HorzVertLinePanel(chartmain);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        contentPane.add("South", bottomPanel);
        contentPane.add("Center", this.horzVertLinePanel);
        this.horzVertLinePanel.displayLine(this.curDataLine);
        this.horzVertLinePanel.txt_title.setSelectionStart(0);
        this.horzVertLinePanel.txt_title.setSelectionEnd(this.horzVertLinePanel.txt_title.getText().length());
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    DataLine getDataLine() {
        return this.curDataLine;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.horzVertLinePanel.actionPerformed(e);
    }

    private void addComponent(JPanel p, Component c, String label) {
        this.addComponent(p, c, null, label);
    }

    private void addComponent(JPanel p, Component c, Component c2, String label) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        if (label != null) {
            panel.add(new JLabel(label));
        }
        panel.add(c);
        if (c2 != null) {
            panel.add(c2);
        }
        p.add(panel);
    }

    private static int getMapIndex(int[] map, int linetype) {
        for (int i = 0; i < map.length; ++i) {
            if (map[i] != linetype) continue;
            return i;
        }
        return -1;
    }

    private boolean showSubValue() {
        return this.chart.mData2 != null;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.curDataLine = null;
        super.windowClosing(e);
    }

    private class HorzVertLinePanel
    extends JPanel
    implements ActionListener {
        int[] linetypeMap = HorzVertLine.linetypeMap;
        JComboBox ch_linetype;
        SpinBox spin_thickness;
        JCheckBox checktitle;
        JCheckBox checkanno;
        JCheckBox checksubValue;
        JCheckBox checkcircular;
        JCheckBox checkTodayLine;
        JTextField txt_title;
        Color linecolor = Color.black;
        JTextField line_value;
        JButton butt_style;
        private final String currentDateStr = "CURRENTDATE";

        public HorzVertLinePanel(ChartMain chartmain) {
            this.setLayout(new BoxLayout(this, 1));
            this.txt_title = new JTextField("New Line", 20);
            HorzVertLineDialog.this.addComponent(this, this.txt_title, LanguageEncoder.getText("Label"));
            this.line_value = new JTextField(" Value", 10);
            HorzVertLineDialog.this.addComponent(this, this.line_value, LanguageEncoder.getText("Constant line value :"));
            this.line_value.addActionListener(this);
            if (chartmain.chart.getChartType() == 18) {
                this.checkTodayLine = new JCheckBox();
                HorzVertLineDialog.this.addComponent(this, this.checkTodayLine, LanguageEncoder.getText("Current Date for Gantt Chart"));
                this.checkTodayLine.addActionListener(this);
            }
            this.spin_thickness = new SpinBox(1, 100);
            HorzVertLineDialog.this.addComponent(this, this.spin_thickness, LanguageEncoder.getText("Line thickness :"));
            this.ch_linetype = new JComboBox();
            for (int i = 0; i < this.linetypeMap.length; ++i) {
                this.ch_linetype.addItem(HorzVertLine.defaultNames[i]);
            }
            this.selectDefaultType();
            if (chartmain.chart.getChartType() != 16) {
                HorzVertLineDialog.this.addComponent(this, this.ch_linetype, LanguageEncoder.getText("Line type :"));
            } else {
                this.checkcircular = new JCheckBox();
                HorzVertLineDialog.this.addComponent(this, this.checkcircular, LanguageEncoder.getText("Circular Style"));
            }
            if (chartmain.chart.getChartType() != 16) {
                this.butt_style = new JButton(LanguageEncoder.getText("Line Style"));
                HorzVertLineDialog.this.addComponent(this, this.butt_style, null);
                this.butt_style.addActionListener(this);
            }
            this.checktitle = new JCheckBox(LanguageEncoder.getText("Show Label In Legend"));
            HorzVertLineDialog.this.addComponent(this, this.checktitle, null);
            this.checkanno = new JCheckBox(LanguageEncoder.getText("Show attached text"));
            HorzVertLineDialog.this.addComponent(this, this.checkanno, null);
            if (HorzVertLineDialog.this.showSubValue()) {
                this.checksubValue = new JCheckBox(LanguageEncoder.getText("Use secondary axis value"));
                this.add(this.checksubValue);
            }
        }

        void selectDefaultType() {
            int chartType = HorzVertLineDialog.this.chart.chartType;
            if (!HorzVertLineDialog.this.chart.isCircularChart()) {
                if (chartType == 0 || chartType == 2 || chartType == 3 || chartType == 4 || chartType == 7 || chartType == 8 || chartType == 9 || chartType == 10) {
                    this.ch_linetype.setSelectedIndex(0);
                } else {
                    this.ch_linetype.setSelectedIndex(1);
                }
            }
        }

        void displayLine(HorzVertLine hvLine) {
            if (hvLine == null) {
                this.txt_title.setText(LanguageEncoder.getText("New Line"));
                this.selectDefaultType();
                this.line_value.setText("0");
                this.spin_thickness.setValue(1);
                this.linecolor = Color.black;
                if (HorzVertLineDialog.this.showSubValue()) {
                    this.checksubValue.setSelected(false);
                }
            } else {
                Vector<IAnnotation> annoVector;
                HorzVertLineDialog.this.curDataLine = hvLine;
                this.txt_title.setText(hvLine.getTitle());
                this.ch_linetype.setSelectedIndex(HorzVertLineDialog.getMapIndex(this.linetypeMap, hvLine.getLineType() % 100));
                this.linecolor = hvLine.getColor();
                this.spin_thickness.setValue(hvLine.getThickness());
                this.checktitle.setSelected(hvLine.isTitleVisibleInLegend());
                if (this.checkcircular != null) {
                    this.checkcircular.setSelected(hvLine.getLineType() >= 100);
                }
                if ((annoVector = hvLine.getAnnotations()) == null || annoVector.size() == 0) {
                    LOGGER.finest("DISPLAY LINE - ANNO SIZE IS NULL!");
                    this.checkanno.setSelected(false);
                } else {
                    this.checkanno.setSelected(annoVector.elementAt(0).isVisible());
                }
                if (HorzVertLineDialog.this.showSubValue()) {
                    this.checksubValue.setSelected(hvLine.isSecondaryValueUsed());
                }
                if (hvLine.getActualLineValue() == -1.7976931348623157E308 && HorzVertLineDialog.this.chartmain.chart.getChartType() == 18) {
                    this.enableTodayLine(true);
                    this.line_value.setText("CURRENTDATE");
                    this.checkTodayLine.setSelected(true);
                } else {
                    this.enableTodayLine(false);
                    this.line_value.setText(hvLine.getLineValue() + "");
                    if (this.checkTodayLine != null) {
                        this.checkTodayLine.setSelected(false);
                    }
                }
                this.txt_title.requestFocus();
            }
        }

        HorzVertLine getHorzVertLine() {
            String label = this.txt_title.getText();
            int linetype = HorzVertLine.linetypeMap[this.ch_linetype.getSelectedIndex()];
            if (this.checkcircular != null && this.checkcircular.isSelected()) {
                linetype += 100;
            }
            HorzVertLine hvLine = null;
            if (HorzVertLineDialog.this.curDataLine == null) {
                return null;
            }
            hvLine = HorzVertLineDialog.this.curDataLine;
            hvLine.setTitle(label);
            hvLine.setLineType(linetype);
            hvLine.setThickness(this.spin_thickness.getValue());
            hvLine.setTitleVisibleInLegend(this.checktitle.isSelected());
            boolean showAnnotation = this.checkanno.isSelected();
            Vector<IAnnotation> annoVector = hvLine.getAnnotations();
            if (annoVector != null) {
                int nAnno = annoVector.size();
                for (int i = 0; i < nAnno; ++i) {
                    ((CAnnotation)annoVector.elementAt(i)).setVisible(showAnnotation);
                }
            } else if (showAnnotation) {
                CAnnotation anno = new CAnnotation(HorzVertLineDialog.this.chart, (IReferenceObj)hvLine, "New Text");
                hvLine.addAnnotation(anno);
            }
            hvLine.setColor(this.linecolor);
            if (HorzVertLineDialog.this.showSubValue()) {
                hvLine.useSecondaryValue(this.checksubValue.isSelected());
            }
            try {
                if (HorzVertLineDialog.this.chartmain.chart.getChartType() == 18 && this.line_value.getText().equals("CURRENTDATE")) {
                    hvLine.setLineValue(-1.7976931348623157E308);
                } else {
                    hvLine.setLineValue(Double.valueOf(this.line_value.getText()));
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to set line options", ex);
                return null;
            }
            return hvLine;
        }

        void updateHorzVertLine() {
            this.getHorzVertLine();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object target = e.getSource();
            if (target == HorzVertLineDialog.this.okButton) {
                this.updateHorzVertLine();
                this.setVisible(false);
                HorzVertLineDialog.this.dispose();
            } else if (target == HorzVertLineDialog.this.cancelButton) {
                HorzVertLineDialog.this.curDataLine = null;
                HorzVertLineDialog.this.callNewSurface = false;
                this.setVisible(false);
                HorzVertLineDialog.this.dispose();
            } else if (target == this.line_value) {
                try {
                    this.line_value.setText(Double.valueOf(this.line_value.getText()) + "");
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINEST, "Failed to parse line_value value", ex);
                    this.line_value.setText("0");
                }
            } else if (target == this.checkTodayLine) {
                if (this.checkTodayLine.isSelected()) {
                    this.enableTodayLine(true);
                } else {
                    this.enableTodayLine(false);
                }
            } else if (target == this.butt_style) {
                new LineStyleDialog(HorzVertLineDialog.this.chartmain, HorzVertLineDialog.this.curDataLine, false).setVisible(true);
            }
        }

        private void enableTodayLine(boolean enable) {
            if (enable) {
                this.ch_linetype.setSelectedItem("Vertical line");
                this.ch_linetype.setEnabled(false);
                this.line_value.setText("CURRENTDATE");
                this.line_value.setEnabled(false);
            } else {
                this.ch_linetype.setEnabled(true);
                this.line_value.setText("0");
                this.line_value.setEnabled(true);
            }
        }
    }
}

