/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.HorzVertLine;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ControlLineDialog;
import quadbase.chart.designer.HorzVertLineDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class HorzVertLineListDialog
extends QbDialog
implements ListSelectionListener,
ChangeListener {
    ChartMain chartmain;
    JList hvdatalist;
    JList contdatalist;
    DefaultListModel hvModel;
    DefaultListModel contModel;
    JButton editButton;
    JButton addButton;
    JButton removeButton;
    JButton butcancel;
    JButton butOK;
    Chart chart;
    Vector<DataLine> hvData;
    Vector<DataLine> hvSaveData;
    Vector<DataLine> contData;
    Vector<DataLine> contSaveData;
    JTabbedPane tabPanel;
    static final short width = 225;
    static final short height = 275;
    boolean inProcess = false;

    public HorzVertLineListDialog(ChartMain frame) {
        super(frame, LanguageEncoder.getText("Define Horizontal/Vertical Lines..."), true);
        int j;
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.setBackground(Color.lightGray);
        BorderPanel hvpanel = new BorderPanel(LanguageEncoder.getText("Constant Lines"));
        this.hvModel = new DefaultListModel();
        this.hvData = this.chart.dataLineSet.getHorzVertLineList();
        this.hvSaveData = (Vector)this.hvData.clone();
        for (j = 0; j < this.hvData.size(); ++j) {
            this.hvModel.addElement(((HorzVertLine)this.hvData.get(j)).getTitle());
        }
        this.hvdatalist = new JList(this.hvModel);
        this.hvdatalist.setSelectionMode(0);
        BorderPanel contpanel = new BorderPanel(LanguageEncoder.getText("Control Lines"));
        this.contModel = new DefaultListModel();
        this.contData = this.chart.dataLineSet.getControlLineList();
        this.contSaveData = (Vector)this.contData.clone();
        for (j = 0; j < this.contData.size(); ++j) {
            this.contModel.addElement(((ControlLine)this.contData.get(j)).getTitle());
        }
        this.contdatalist = new JList(this.contModel);
        this.contdatalist.setSelectionMode(0);
        this.editButton = new JButton(LanguageEncoder.getText("Edit"));
        this.addButton = new JButton(LanguageEncoder.getText("Insert"));
        this.removeButton = new JButton(LanguageEncoder.getText("Remove"));
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addButton.addActionListener(this);
        hvpanel.setLayout(new BorderLayout());
        JScrollPane hvscrollPane = new JScrollPane(this.hvdatalist);
        hvpanel.add("Center", hvscrollPane);
        contpanel.setLayout(new BorderLayout());
        JScrollPane contscrollPane = new JScrollPane(this.contdatalist);
        contpanel.add("Center", contscrollPane);
        this.tabPanel = new JTabbedPane();
        this.tabPanel.add(LanguageEncoder.getText("Constant"), hvpanel);
        if (this.chart.getChartType() != 15 && this.chart.getChartType() != 18) {
            this.tabPanel.add(LanguageEncoder.getText("Control"), contpanel);
        }
        this.tabPanel.addChangeListener(this);
        JPanel spanel = new JPanel();
        spanel.setLayout(new GridLayout(4, 1));
        spanel.add(new JLabel("  "));
        spanel.add(this.addButton);
        spanel.add(this.editButton);
        spanel.add(this.removeButton);
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new BorderLayout());
        bpanel.add("North", spanel);
        bpanel.add("West", new JLabel("  "));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        this.butcancel.addActionListener(this);
        this.butOK.addActionListener(this);
        buttonPanel.add(this.butOK);
        buttonPanel.add(this.butcancel);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.tabPanel);
        cop.add("East", bpanel);
        cop.add("South", buttonPanel);
        Dimension screensize = this.getToolkit().getScreenSize();
        this.hvdatalist.addListSelectionListener(this);
        this.contdatalist.addListSelectionListener(this);
        this.addWindowListener(this);
        this.enableButtons();
        this.setBounds((screensize.width - 225) / 2, (screensize.height - 275) / 2, 225, 275);
    }

    public void show(DataLine dline) {
        int currentRecord = -1;
        if (dline instanceof ControlLine) {
            this.hvdatalist.clearSelection();
            this.tabPanel.setSelectedIndex(1);
            currentRecord = this.contData.indexOf(dline);
            if (currentRecord >= 0) {
                this.contdatalist.setSelectedIndex(currentRecord);
            } else {
                this.contdatalist.clearSelection();
            }
        } else {
            this.contdatalist.clearSelection();
            this.tabPanel.setSelectedIndex(0);
            if (dline != null && (currentRecord = this.hvData.indexOf(dline)) >= 0) {
                this.hvdatalist.setSelectedIndex(currentRecord);
            } else {
                this.hvdatalist.clearSelection();
            }
        }
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableButtons();
    }

    private void enableButtons() {
        Vector<DataLine> list = null;
        JList datalist = null;
        if (this.tabPanel.getSelectedIndex() == 0) {
            list = this.hvData;
            datalist = this.hvdatalist;
        } else {
            list = this.contData;
            datalist = this.contdatalist;
        }
        if (list.size() == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        this.editButton.setEnabled(datalist.getSelectedIndex() >= 0);
        this.removeButton.setEnabled(datalist.getSelectedIndex() >= 0);
    }

    private int getDefaultType() {
        int chartType = this.chart.chartType;
        if (chartType == 0 || chartType == 2 || chartType == 3 || chartType == 4 || chartType == 7 || chartType == 8 || chartType == 9 || chartType == 10) {
            return 14;
        }
        return 15;
    }

    private void insertItem() {
        if (this.tabPanel.getSelectedIndex() == 0) {
            HorzVertLine hvLine = this.chart.dataLineSet.newHorzVertLine(this.getDefaultType(), LanguageEncoder.getText("New Label"));
            HorzVertLineDialog cDialog = new HorzVertLineDialog(this.chartmain, hvLine);
            cDialog.setVisible(true);
            DataLine c = cDialog.getDataLine();
            if (c != null) {
                this.hvModel.addElement(c.getTitle());
                this.hvData.add(c);
                this.hvdatalist.validate();
                this.hvdatalist.repaint();
            }
        } else {
            ControlLine contLine = this.chart.dataLineSet.newControlLine(this.getDefaultType(), LanguageEncoder.getText("New Label"));
            ControlLineDialog cDialog = new ControlLineDialog(this.chartmain, contLine);
            cDialog.setVisible(true);
            DataLine c = cDialog.getDataLine();
            if (c != null) {
                this.contModel.addElement(c.getTitle());
                this.contData.add(c);
                this.contdatalist.validate();
                this.contdatalist.repaint();
            }
        }
        this.enableButtons();
    }

    private void editItem() {
        if (this.tabPanel.getSelectedIndex() == 0) {
            int idx = this.hvdatalist.getSelectedIndex();
            HorzVertLine c = (HorzVertLine)this.hvData.get(idx);
            c = (HorzVertLine)c.clone();
            HorzVertLineDialog cDialog = new HorzVertLineDialog(this.chartmain, c);
            cDialog.setVisible(true);
            c = (HorzVertLine)cDialog.getDataLine();
            if (c != null) {
                this.hvModel.setElementAt(c.getTitle(), idx);
                this.hvData.setElementAt(c, idx);
                this.hvdatalist.validate();
                this.hvdatalist.repaint();
            }
        } else {
            int idx = this.contdatalist.getSelectedIndex();
            ControlLine c = (ControlLine)this.contData.get(idx);
            c = (ControlLine)c.clone();
            ControlLineDialog cDialog = new ControlLineDialog(this.chartmain, c);
            cDialog.setVisible(true);
            c = (ControlLine)cDialog.getDataLine();
            if (c != null) {
                this.contModel.setElementAt(c.getTitle(), idx);
                this.contData.setElementAt(c, idx);
                this.contdatalist.validate();
                this.contdatalist.repaint();
            }
        }
        this.enableButtons();
    }

    private void removeItem() {
        if (this.tabPanel.getSelectedIndex() == 0) {
            int i = this.hvdatalist.getSelectedIndex();
            if (i >= 0) {
                this.hvModel.remove(i);
                this.hvData.remove(i);
                this.chartmain.invalidateLegend();
                this.chartmain.chartPanel.repaint();
                this.hvdatalist.validate();
                this.hvdatalist.repaint();
            }
        } else {
            int i = this.contdatalist.getSelectedIndex();
            if (i >= 0) {
                this.contModel.remove(i);
                this.contData.remove(i);
                this.chartmain.invalidateLegend();
                this.chartmain.chartPanel.repaint();
                this.contdatalist.validate();
                this.contdatalist.repaint();
            }
        }
        this.enableButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.inProcess = true;
        Object target = e.getSource();
        String msg = null;
        if (target == this.butOK) {
            msg = this.setValues(this.hvData, this.contData);
            if (msg != null) {
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(msg);
                this.inProcess = false;
                return;
            }
            this.chartmain.setModified();
            this.chart.newSurface();
            this.chartmain.invalidateLegend();
            this.chartmain.chartPanel.repaint();
            this.setVisible(false);
            this.dispose();
        } else if (target == this.butcancel) {
            this.setValues(this.hvSaveData, this.contSaveData);
            this.chartmain.invalidateLegend();
            this.chartmain.chartPanel.repaint();
            this.setVisible(false);
            this.dispose();
            this.inProcess = false;
        } else if (target == this.addButton) {
            this.insertItem();
        } else if (target == this.removeButton) {
            this.removeItem();
        } else if (target == this.editButton) {
            this.editItem();
        }
        this.inProcess = false;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.inProcess = true;
        this.setValues(this.hvSaveData, this.contSaveData);
        this.chartmain.invalidateLegend();
        this.chartmain.chartPanel.repaint();
        this.setVisible(false);
        this.dispose();
        this.inProcess = false;
        super.windowClosing(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableButtons();
    }

    private String setValues(Vector<DataLine> hvData, Vector<DataLine> contData) {
        this.chart.dataLineSet.setHorzVertLineList(hvData);
        this.chart.dataLineSet.setControlLineList(contData);
        return null;
    }
}

