/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.HyperLink;
import quadbase.util.PickData;

public class HyperLinkDialog
extends QbDialog {
    JTextField txt_link;
    JComboBox ch_series = null;
    JComboBox ch_category = null;
    JComboBox ch_sumBy = null;
    ChartMain chartmain;
    Chart chart;
    static final String ALLSTR = "All";
    JButton okButton;
    JButton cancelButton;
    JTextField txt_target;
    JTextField txt_hint;
    boolean enableListener = true;
    HyperLink selectedLink;

    public HyperLinkDialog(ChartMain chartmain, HyperLink hlink, PickData pd) {
        super(chartmain, LanguageEncoder.getText("Hyperlink Options"), true);
        Object[] name;
        this.setBackground(Color.lightGray);
        this.chartmain = chartmain;
        this.chart = chartmain.chart;
        this.selectedLink = hlink;
        BorderPanel hpanel = new BorderPanel(LanguageEncoder.getText("Hyperlink"));
        hpanel.setLayout(new GridLayout(0, 1));
        JPanel txtpanel = new JPanel();
        txtpanel.setLayout(new FlowLayout(0));
        txtpanel.add(new JLabel(LanguageEncoder.getText("URL :")));
        this.txt_link = new JTextField(40);
        txtpanel.add(this.txt_link);
        hpanel.add(txtpanel);
        if (pd.series != null) {
            JPanel pseries = new JPanel();
            pseries.setLayout(new FlowLayout(0));
            pseries.add(new JLabel(LanguageEncoder.getText("Series :")));
            this.ch_series = new JComboBox();
            pseries.add(this.ch_series);
            this.ch_series.addItem(ALLSTR);
            for (Object element : name = this.chart.colData[this.chart.mDataMap[0]].getFieldName()) {
                this.ch_series.addItem(element.toString());
            }
            hpanel.add(pseries);
            this.ch_series.addItemListener(this);
        }
        if (pd.category != null) {
            JPanel pcategory = new JPanel();
            pcategory.setLayout(new FlowLayout(0));
            pcategory.add(new JLabel(LanguageEncoder.getText("Category :")));
            this.ch_category = new JComboBox();
            pcategory.add(this.ch_category);
            this.ch_category.addItem(ALLSTR);
            for (Object element : name = this.chart.colData[this.chart.mDataMap[this.chart.isStackType() ? this.chart.dataDim - 2 : this.chart.dataDim - 1]].getFieldName()) {
                this.ch_category.addItem(element.toString());
            }
            hpanel.add(pcategory);
            this.ch_category.addItemListener(this);
        }
        if (pd.sumBy != null) {
            JPanel psum = new JPanel();
            psum.setLayout(new FlowLayout(0));
            psum.add(new JLabel(LanguageEncoder.getText("Sum :")));
            this.ch_sumBy = new JComboBox();
            psum.add(this.ch_sumBy);
            this.ch_sumBy.addItem(ALLSTR);
            for (Object element : name = this.chart.colData[this.chart.mDataMap[this.chart.dataDim - 1]].getFieldName()) {
                this.ch_sumBy.addItem(element.toString());
            }
            hpanel.add(psum);
            this.ch_sumBy.addItemListener(this);
        }
        JPanel targetpanel = new JPanel();
        targetpanel.setLayout(new FlowLayout(0));
        targetpanel.add(new JLabel(LanguageEncoder.getText("Target :")));
        this.txt_target = new JTextField(30);
        targetpanel.add(this.txt_target);
        JPanel hintpanel = new JPanel();
        hintpanel.setLayout(new FlowLayout(0));
        hintpanel.add(new Label(LanguageEncoder.getText("Hint :")));
        this.txt_hint = new JTextField(30);
        hintpanel.add(this.txt_hint);
        hpanel.add(targetpanel);
        hpanel.add(hintpanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        p2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        p2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        hpanel.add(p2);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", hpanel);
        this.displayLink(hlink);
    }

    boolean inside(JComboBox ch, String s) {
        for (int i = 0; i < ch.getItemCount(); ++i) {
            if (!ch.getItemAt(i).toString().equals(s)) continue;
            return true;
        }
        return false;
    }

    private void displayLink(HyperLink hlink) {
        this.enableListener = false;
        this.txt_link.setText(hlink.link);
        if (this.ch_category != null) {
            if (!hlink.category.equals("") && !this.inside(this.ch_category, hlink.category)) {
                hlink.category = "";
            }
            this.ch_category.setSelectedItem(hlink.category.equals("") ? ALLSTR : hlink.category);
        }
        if (this.ch_series != null) {
            if (!hlink.series.equals("") && !this.inside(this.ch_series, hlink.series)) {
                hlink.series = "";
            }
            this.ch_series.setSelectedItem(hlink.series.equals("") ? ALLSTR : hlink.series);
        }
        if (this.ch_sumBy != null) {
            if (!hlink.sumBy.equals("") && !this.inside(this.ch_sumBy, hlink.sumBy)) {
                hlink.sumBy = "";
            }
            this.ch_sumBy.setSelectedItem(hlink.sumBy.equals("") ? ALLSTR : hlink.sumBy);
        }
        this.txt_target.setText(hlink.target);
        this.txt_hint.setText(hlink.hint);
        this.txt_link.requestFocus();
        this.enableListener = true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
            super.setVisible(true);
            this.txt_link.requestFocus();
        } else {
            super.setVisible(false);
        }
    }

    HyperLink getLink() {
        if (this.selectedLink == null) {
            return null;
        }
        HyperLink newlink = this.selectedLink;
        newlink.link = this.txt_link.getText();
        if (this.ch_series != null) {
            String string = newlink.series = this.ch_series.getSelectedIndex() == 0 ? "" : this.ch_series.getSelectedItem().toString();
        }
        if (this.ch_category != null) {
            String string = newlink.category = this.ch_category.getSelectedIndex() == 0 ? "" : this.ch_category.getSelectedItem().toString();
        }
        if (this.ch_sumBy != null) {
            newlink.sumBy = this.ch_sumBy.getSelectedIndex() == 0 ? "" : this.ch_sumBy.getSelectedItem().toString();
        }
        newlink.target = this.txt_target.getText();
        newlink.hint = this.txt_hint.getText();
        return newlink;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.enableListener) {
            return;
        }
        Object target = e.getSource();
        if (target == this.okButton) {
            if (this.txt_link.getText().trim().equals("") && this.txt_hint.getText().trim().equals("")) {
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please enter link/ hint field!"));
                return;
            }
            this.setVisible(false);
            this.dispose();
        } else if (target == this.cancelButton) {
            this.selectedLink = null;
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.selectedLink = null;
        super.windowClosing(e);
    }
}

