/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.chart3d.FaceHyperLink;
import quadbase.chart.chart3d.types3d.general3d.SurfaceChart3D;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class HyperLinkForSurface
extends QbDialog {
    JTextField txt_link;
    JComboBox xChoice = null;
    JComboBox zChoice = null;
    ChartMain chartmain;
    Chart chart;
    double[] xValue;
    double[] zValue;
    JButton okButton;
    JButton cancelButton;
    int currentRecord = -1;
    JTextField txt_target;
    JTextField txt_hint;
    FaceHyperLink currentLink = null;
    boolean isCancelled = false;

    public HyperLinkForSurface(ChartMain chartmain, FaceHyperLink currentLink) {
        super(chartmain, LanguageEncoder.getText("Hyperlink Options"), true);
        this.setBackground(Color.lightGray);
        this.chartmain = chartmain;
        this.chart = chartmain.chart;
        this.currentLink = currentLink;
        BorderPanel hpanel = new BorderPanel(LanguageEncoder.getText("HyperLink"));
        hpanel.setLayout(new GridLayout(0, 1));
        JPanel txtpanel = new JPanel();
        txtpanel.setLayout(new FlowLayout(0));
        txtpanel.add(new JLabel(LanguageEncoder.getText("URL :")));
        this.txt_link = new JTextField(40);
        txtpanel.add(this.txt_link);
        this.txt_link.setText("http://");
        hpanel.add(txtpanel);
        JPanel pxChoice = new JPanel();
        pxChoice.setLayout(new FlowLayout(0));
        pxChoice.add(new JLabel(LanguageEncoder.getText("x value :")));
        this.xChoice = new JComboBox();
        pxChoice.add(this.xChoice);
        this.xChoice.addItem(FaceHyperLink.ALLPOINTS);
        for (double element : this.xValue = ((SurfaceChart3D)this.chart).getxUniqueValue()) {
            this.xChoice.addItem(Double.toString(element));
        }
        hpanel.add(pxChoice);
        this.xChoice.addItemListener(this);
        JPanel pzChoice = new JPanel();
        pzChoice.setLayout(new FlowLayout(0));
        pzChoice.add(new JLabel(LanguageEncoder.getText("z value :")));
        this.zChoice = new JComboBox();
        pzChoice.add(this.zChoice);
        this.zChoice.addItem(FaceHyperLink.ALLPOINTS);
        for (double element : this.zValue = ((SurfaceChart3D)this.chart).getzUniqueValue()) {
            this.zChoice.addItem(Double.toString(element));
        }
        hpanel.add(pzChoice);
        this.zChoice.addItemListener(this);
        JPanel targetpanel = new JPanel();
        targetpanel.setLayout(new FlowLayout(0));
        targetpanel.add(new JLabel(LanguageEncoder.getText("Target :")));
        this.txt_target = new JTextField(30);
        targetpanel.add(this.txt_target);
        this.txt_target.setText(LanguageEncoder.getText("EspressChart"));
        JPanel hintpanel = new JPanel();
        hintpanel.setLayout(new FlowLayout(0));
        hintpanel.add(new JLabel(LanguageEncoder.getText("Hint :")));
        this.txt_hint = new JTextField(30);
        hintpanel.add(this.txt_hint);
        hpanel.add(targetpanel);
        hpanel.add(hintpanel);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        p2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        p2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        hpanel.add(p2);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", hpanel);
        this.setButtons();
        this.displayLink();
    }

    private void setButtons() {
        this.txt_link.requestFocus();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
            super.setVisible(true);
            this.txt_link.requestFocus();
        } else {
            super.setVisible(false);
        }
    }

    FaceHyperLink getLink() {
        if (this.isCancelled) {
            return null;
        }
        return this.currentLink;
    }

    private void setLink() {
        String hint = this.txt_hint.getText();
        String target = this.txt_target.getText();
        String link = this.txt_link.getText();
        if (link == null || link.trim().equals("")) {
            return;
        }
        this.currentLink = (FaceHyperLink)this.chart.setSurfaceLink(this.currentLink, link, target, hint, this.xChoice.getSelectedItem().toString(), this.zChoice.getSelectedItem().toString(), this.xChoice.getSelectedIndex() - 1, this.zChoice.getSelectedIndex() - 1);
    }

    private void displayLink() {
        if (this.currentLink == null) {
            return;
        }
        if (this.currentLink.faceDataList.size() <= 0) {
            return;
        }
        this.txt_hint.setText(this.currentLink.getHint());
        this.txt_target.setText(this.currentLink.getTarget());
        this.txt_link.setText(this.currentLink.getHyperLink());
        this.xChoice.setSelectedItem(this.currentLink.getxValue());
        this.zChoice.setSelectedItem(this.currentLink.getzValue());
        this.setButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.okButton) {
            this.setLink();
            this.setVisible(false);
            this.dispose();
        } else if (target == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.isCancelled = true;
        super.windowClosing(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

