/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ImageListPanel;
import quadbase.chart.designer.YAImageCanvas;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.ImageData;

public class ImageDialog
extends QbDialog
implements FilenameFilter,
ListSelectionListener,
ActionListener,
ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ImageDialog.class.getName());
    URL directory;
    YAImageCanvas imageCanvas;
    JButton btnOK;
    JButton btnCancel;
    ImageListPanel extendchoice;
    JLabel sizelabel;
    JScrollPane listPane;
    JRadioButton ch_center;
    JRadioButton ch_fit;
    JRadioButton ch_tile;
    JTextField radiusIncreaseTF;
    public static final int CENTER = 0;
    public static final int FIT = 1;
    public static final int TILE = 2;
    public static final int NONE = 3;
    int display_option = 0;
    private URL file_url;
    private JCheckBox enableBGImage;
    URL imageURL;
    String relativeURL = null;
    boolean isModified = false;
    boolean isBackgroundImage = false;
    private boolean setDisplayOption = false;

    public ImageDialog(JFrame parent, boolean tileOption, String title) {
        super(parent, title, true);
        this.isBackgroundImage = title.equalsIgnoreCase(LanguageEncoder.getText("Choose A Background Image"));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Color.lightGray);
        JPanel imagePanel = new JPanel();
        imagePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Preview")));
        imagePanel.setLayout(new BorderLayout());
        this.imageCanvas = new YAImageCanvas();
        imagePanel.add("Center", this.imageCanvas);
        this.sizelabel = new JLabel("                     ");
        imagePanel.add("South", this.sizelabel);
        imagePanel.setPreferredSize(new Dimension(350, 350));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.btnOK = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.btnOK);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.btnCancel);
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.extendchoice = new ImageListPanel(this, parent, LanguageEncoder.getText("Image URL:"));
        JPanel lpanel = new JPanel();
        lpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Location")));
        lpanel.setLayout(new BorderLayout());
        lpanel.add("Center", this.extendchoice);
        JPanel epanel = new JPanel();
        epanel.setLayout(new BorderLayout());
        this.enableBGImage = new JCheckBox(LanguageEncoder.getText("Enable Background Image"));
        epanel.add("Center", this.enableBGImage);
        this.enableBGImage.addItemListener(this);
        contentPane.add("North", epanel);
        contentPane.add("Center", imagePanel);
        JPanel botpanel = new JPanel();
        botpanel.setLayout(new BorderLayout());
        botpanel.add("East", buttonPanel);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Display Option")));
        optionPanel.setLayout(new FlowLayout(0));
        if (!this.isBackgroundImage) {
            optionPanel.add(new JLabel(LanguageEncoder.getText("Radius (1 = 100% of Dial Chart Radius):")));
            this.radiusIncreaseTF = new JTextField("1");
            this.radiusIncreaseTF.setPreferredSize(new Dimension(80, 20));
            optionPanel.add(this.radiusIncreaseTF);
        }
        ButtonGroup ckgroup = new ButtonGroup();
        this.ch_fit = new JRadioButton(LanguageEncoder.getText("Fit"), true);
        optionPanel.add(this.ch_fit);
        if (this.isBackgroundImage) {
            this.ch_center = new JRadioButton(LanguageEncoder.getText("Center"), false);
            optionPanel.add(this.ch_center);
            this.ch_tile = new JRadioButton(LanguageEncoder.getText("Tile"), false);
            optionPanel.add(this.ch_tile);
        }
        ckgroup.add(this.ch_fit);
        this.ch_fit.addItemListener(this);
        if (this.isBackgroundImage) {
            ckgroup.add(this.ch_center);
            this.ch_center.addItemListener(this);
            ckgroup.add(this.ch_tile);
            this.ch_tile.addItemListener(this);
        }
        this.setDisplayOption(this.display_option);
        if (tileOption) {
            JPanel tpanel = new JPanel();
            tpanel.setLayout(new BorderLayout());
            tpanel.add("North", lpanel);
            tpanel.add("Center", optionPanel);
            tpanel.add("South", botpanel);
            contentPane.add("South", tpanel);
        } else {
            JPanel tpanel = new JPanel();
            tpanel.setLayout(new BorderLayout());
            tpanel.add("Center", lpanel);
            tpanel.add("South", botpanel);
            contentPane.add("South", tpanel);
        }
        this.setPosition();
    }

    public ImageDialog(JFrame parent) {
        this(parent, false, LanguageEncoder.getText("Choose A Background Image"));
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void show(URL directory) {
        this.imageURL = directory;
        this.extendchoice.setValue(directory.toString());
        super.setVisible(true);
    }

    public void show(URL file_url, int display_option) {
        this.show(file_url, null, display_option);
    }

    public void show(URL file_url, String relativeURL, int display_option) {
        this.imageURL = file_url;
        String s = file_url.toString();
        this.file_url = file_url;
        this.imageCanvas.setImage(file_url);
        int index = s.lastIndexOf(47);
        this.enableBGImage.setSelected(display_option != 3 && this.imageCanvas.getImage() != null);
        if (index != -1) {
            if (relativeURL != null) {
                this.extendchoice.setValue(relativeURL);
            } else {
                this.extendchoice.setValue(s);
            }
            this.setDisplayOption(display_option);
        }
        super.setVisible(true);
    }

    public void setRatio(double r) {
        this.radiusIncreaseTF.setText("" + r);
    }

    public void addChoice(URL s) {
        this.extendchoice.setValue(s.toString());
    }

    @Override
    public boolean accept(File dir, String name) {
        String filenameUpper = name.toUpperCase();
        return filenameUpper.endsWith(".GIF") || filenameUpper.endsWith(".PNG") || filenameUpper.endsWith(".JPG") || filenameUpper.endsWith(".JPEG");
    }

    public URL getImageURL() {
        if (this.imageURL != null) {
            return this.imageURL;
        }
        return null;
    }

    public String getRelativeURL() {
        if (this.relativeURL != null) {
            return this.relativeURL;
        }
        return null;
    }

    public URL getDialogImageURL() {
        try {
            return new URL(this.extendchoice.getValue());
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINEST, "Failed to get image URL", t);
            return null;
        }
    }

    public int getDisplayOption() {
        return this.display_option;
    }

    private void setDisplayOption(int option) {
        if (!this.isBackgroundImage && option != 3) {
            option = 1;
        }
        this.setDisplayOption = true;
        this.display_option = option;
        this.imageCanvas.setDisplayOption(option);
        switch (option) {
            case 0: {
                this.ch_center.setSelected(true);
                break;
            }
            case 2: {
                if (this.ch_tile != null) {
                    this.ch_tile.setSelected(true);
                    break;
                }
                this.ch_center.setSelected(true);
                break;
            }
            case 1: {
                if (this.ch_fit != null) {
                    this.ch_fit.setSelected(true);
                    break;
                }
                this.ch_center.setSelected(true);
                break;
            }
            default: {
                this.enableBGImage.setSelected(false);
            }
        }
        if (this.extendchoice != null) {
            this.extendchoice.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.ch_center != null) {
            this.ch_center.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.ch_fit != null) {
            this.ch_fit.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.ch_tile != null) {
            this.ch_tile.setEnabled(this.enableBGImage.isSelected());
        }
        if (this.radiusIncreaseTF != null) {
            this.radiusIncreaseTF.setEnabled(this.enableBGImage.isSelected());
        }
        this.setDisplayOption = false;
    }

    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.file_url != null) {
            Dimension d = ImageData.getSize(this.imageURL, ServerMessage.getComponent());
            if (d.width != 0) {
                this.sizelabel.setText(LanguageEncoder.getText("Size") + " " + d.width + "x" + d.height + " " + LanguageEncoder.getText("px"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.btnOK) {
            this.changeDirectory();
            if (this.display_option != 3 && this.imageCanvas.getImage() == null) {
                String msg = LanguageEncoder.getText("Please choose an image!");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (!this.isBackgroundImage && (this.getRatio() < 0.0 || this.getRatio() > 5.0)) {
                String msg = LanguageEncoder.getText("Gauge radius must be between 0 and 5!");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.display_option != 3 && !this.checkRelativeURL()) {
                String msg = LanguageEncoder.getText("Cannot use relative path for this directory!");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.getImageURL() != null) {
                this.fireEvent(this, 0);
            }
            this.isModified = true;
            this.setVisible(false);
        } else if (target == this.btnCancel) {
            this.setVisible(false);
        }
    }

    void changeDirectory() {
        this.imageCanvas.setImage((Image)null);
        this.sizelabel.setText("                    ");
        try {
            String s = this.extendchoice.getValue();
            if (s != null) {
                if (QbUtil.isImageFile(s)) {
                    this.sizelabel.setText(LanguageEncoder.getText("Loading..."));
                    this.repaint();
                    this.imageURL = this.getURL(s);
                    this.imageCanvas.setImage(this.imageURL);
                    this.sizelabel.setText("                    ");
                    Dimension d = ImageData.getSize(this.imageURL, ServerMessage.getComponent());
                    if (d.width != 0) {
                        this.sizelabel.setText(LanguageEncoder.getText("Size") + " " + d.width + "x" + d.height + " " + LanguageEncoder.getText("px"));
                    }
                } else if (!s.endsWith("/")) {
                    s = s + "/";
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to change directory", ex);
        }
    }

    private URL getURL(String s) throws MalformedURLException {
        if (s == null) {
            return null;
        }
        if (!s.toLowerCase().startsWith("file") && !s.toLowerCase().startsWith("http")) {
            try {
                this.relativeURL = s;
                String path = new FileInfo(s).getAbsolutePath();
                if (!(s.toLowerCase().endsWith(".gif") || s.toLowerCase().endsWith(".jpg") || s.toLowerCase().endsWith(".png") || path.endsWith("/") || path.endsWith("\\"))) {
                    path = path + "/";
                }
                if (ServerMessage.getApplet() != null) {
                    return new URL(IOUtil.getCodeBase(ServerMessage.getApplet()) + s);
                }
                return new URL(IOUtil.nameToURL3(path));
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to parse relative URL", ex);
                return new URL(s);
            }
        }
        this.relativeURL = null;
        return new URL(QbUtil.fixUrlString(s));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setImage();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.setDisplayOption) {
            return;
        }
        if (!this.enableBGImage.isSelected()) {
            this.setDisplayOption(3);
            this.sizelabel.setVisible(false);
        } else if (this.ch_fit.isSelected()) {
            this.setDisplayOption(1);
            this.sizelabel.setVisible(true);
        } else if (this.ch_center.isSelected()) {
            this.setDisplayOption(0);
            this.sizelabel.setVisible(true);
        } else if (this.ch_tile.isSelected()) {
            this.setDisplayOption(2);
            this.sizelabel.setVisible(true);
        }
    }

    private void setImage() {
        URL url = this.getDialogImageURL();
        if (url != null) {
            this.sizelabel.setText(LanguageEncoder.getText("Loading..."));
            this.repaint();
            this.imageCanvas.setImage(url);
            this.sizelabel.setText("                    ");
            Dimension d = ImageData.getSize(this.imageURL, ServerMessage.getComponent());
            this.imageURL = url;
            if (d.width != 0) {
                this.sizelabel.setText(LanguageEncoder.getText("Size") + " " + d.width + "x" + d.height + " " + LanguageEncoder.getText("px"));
            }
        }
    }

    private boolean checkRelativeURL() {
        boolean relative = true;
        if (this.imageURL != null && (this.imageURL.toString().toUpperCase().startsWith("HTTP://") || this.imageURL.toString().toUpperCase().startsWith("HTTPS://"))) {
            relative = false;
        }
        if (!relative) {
            this.relativeURL = null;
            return true;
        }
        if (this.relativeURL != null) {
            return true;
        }
        try {
            String curLoc = new FileInfo("/").getAbsolutePath().replaceAll("\\\\", "/");
            if (!curLoc.endsWith("/")) {
                curLoc = curLoc + "/";
            }
            curLoc = this.frame instanceof ChartMain && ((ChartMain)this.frame).getURL(curLoc) != null ? ((ChartMain)this.frame).getURL(curLoc) : IOUtil.nameToURL3(curLoc);
            String urlStr = this.imageURL.toString().replaceAll("\\\\", "/");
            LOGGER.finest("CUR LOC = " + curLoc);
            LOGGER.finest("URL STR = " + urlStr);
            if (urlStr.startsWith(curLoc)) {
                this.relativeURL = urlStr.substring(curLoc.length());
                return true;
            }
            if (urlStr.replaceAll("file:/", "").startsWith(curLoc)) {
                this.relativeURL = urlStr.replaceAll("file:/", "").substring(curLoc.length() + 1);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to check relative URL", e);
        }
        this.relativeURL = null;
        return true;
    }

    public double getRatio() {
        double result;
        String ratio = this.radiusIncreaseTF.getText();
        try {
            result = Double.parseDouble(ratio);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed parsing ratio value, using 1", e);
            result = 1.0;
        }
        return result;
    }
}

