/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ImageDialog;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class ImageListPanel
extends JPanel
implements ItemListener,
ActionListener {
    JTextField choice;
    JButton btnadd;
    JButton btnRefresh;
    JFrame frame;
    ImageDialog iDialog;
    BrowseDialog browseDialog = null;
    JFileChooser fileChooser = null;
    String[] ext = new String[]{"GIF", "JPEG", "JPG", "PNG"};
    String currentDir = "";

    public ImageListPanel(ImageDialog iDialog, JFrame frame, String title) {
        this.frame = frame;
        this.iDialog = iDialog;
        this.choice = new JTextField();
        this.choice.addActionListener(this);
        this.setLayout(new BorderLayout());
        if (title != null) {
            JLabel lb = new JLabel(title);
            this.add("West", lb);
        }
        this.btnadd = new JButton(LanguageEncoder.getText("Browse"));
        this.btnadd.addActionListener(this);
        this.btnRefresh = new JButton(LanguageEncoder.getText("Refresh Preview"));
        this.btnRefresh.addActionListener(this);
        this.add("Center", this.choice);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add(this.btnRefresh);
        buttonPanel.add(this.btnadd);
        this.add("South", buttonPanel);
    }

    public String getValue() {
        return this.choice.getText();
    }

    public void setValue(String str) {
        this.choice.setText(str);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.iDialog.changeDirectory();
    }

    private String loadFile() {
        File file;
        ChartMain chartmain = null;
        if (this.frame instanceof ChartMain) {
            chartmain = (ChartMain)this.frame;
            this.currentDir = "backgroundImages";
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            String val;
            File file2;
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                ExtensionFilter fileFilter = new ExtensionFilter(this.ext);
                this.fileChooser.addChoosableFileFilter(fileFilter);
                this.fileChooser.setCurrentDirectory(new File(this.currentDir));
            }
            this.fileChooser.showDialog(this.frame, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            if (chartmain != null) {
                chartmain.getBrowseDirectories().setImagesDir(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            }
            if ((file2 = this.fileChooser.getSelectedFile()).isAbsolute() && (val = QbUtil.createRelativePath(file2.getPath(), ServerMessage.getPath(""))) != null) {
                return val;
            }
            return file2.getPath().replace('\\', '/');
        }
        if (this.browseDialog == null) {
            this.browseDialog = ServerMessage.getApplet() != null ? BrowseDialog.create(this.frame, this.currentDir, this.ext, false, true) : BrowseDialog.create(this.frame, this.currentDir, this.ext, true, true);
        }
        this.browseDialog.setVisible(true);
        String selectedFile = this.browseDialog.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        selectedFile = selectedFile.replace('\\', '/');
        if (chartmain != null) {
            chartmain.getBrowseDirectories().setImagesDir(this.browseDialog.getCurrentDirectory());
        }
        if ((file = new File(selectedFile)).isAbsolute()) {
            String val = QbUtil.createRelativePath(file.getPath(), ServerMessage.getPath(""));
            if (val != null) {
                return val;
            }
        } else {
            return selectedFile;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean b) {
        this.choice.setEnabled(b);
        this.btnadd.setEnabled(b);
        this.btnRefresh.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnadd) {
            String s = this.loadFile();
            if (s != null) {
                this.choice.setText(s);
                this.iDialog.changeDirectory();
            }
        } else if (e.getSource() == this.choice) {
            this.iDialog.changeDirectory();
        } else if (e.getSource() == this.btnRefresh) {
            this.iDialog.changeDirectory();
        }
    }
}

