/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JApplet;
import javax.swing.JPanel;
import quadbase.chart.designer.InitPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;

public class InitApplet
extends JApplet {
    private static final Logger LOGGER = Logger.getLogger(InitApplet.class.getName());
    InitPanel p;

    @Override
    public void init() {
        String debugMode;
        String hosts;
        String portno;
        String address;
        String servletContext;
        String comm_url;
        InitApplet.initJNLP();
        ServerMessage.setApplet(this);
        QbUtil.setWindowsLAF();
        String proto = this.getParameter("comm_protocol");
        String file = this.getParameter("file");
        String enc = this.getParameter("enc");
        if (proto != null) {
            if (proto.equalsIgnoreCase("http")) {
                ServerMessage.useHttp();
            } else if (proto.equalsIgnoreCase("servlet")) {
                ServerMessage.useServlet();
            }
        }
        if ((comm_url = this.getParameter("comm_url")) != null) {
            if (ServerMessage.isServlet()) {
                ServerMessage.setConnectServlet(comm_url);
            } else {
                ServerMessage.setConnectURL(comm_url);
            }
        }
        if ((servletContext = this.getParameter("servlet_context")) != null) {
            ServerMessage.setServletContext(servletContext);
        }
        if ((address = this.getParameter("server_address")) != null) {
            try {
                ServerMessage.setAddress(address);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to set address", ex);
            }
        }
        if ((portno = this.getParameter("server_port_number")) != null) {
            try {
                int portnumber = Integer.parseInt(portno);
                ServerMessage.setPortNumber(portnumber);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to set port nr.", ex);
            }
        }
        if ((hosts = this.getParameter("server_hosts")) != null) {
            ServerMessage.setHosts(QbUtil.readMultiValues(hosts));
        }
        if ((debugMode = this.getParameter("debug")) != null) {
            QbDebug.setDebugMode(debugMode);
        }
        this.p = new InitPanel(this, file, enc);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.p);
    }

    @Override
    public void start() {
        this.p.initFocus();
    }

    @Override
    public void destroy() {
        try {
            this.p.logoutFromServer();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to log out from server", ex);
        }
    }

    private static void initJNLP() {
        if (ServerMessage.isJnlp()) {
            InitApplet.deleteJNLPFile();
            InitApplet.registerJNLPSingleton();
        }
    }

    private static void deleteJNLPFile() {
        File jnlpFile;
        String jnlpPath = System.getProperty("jnlpx.origFilenameArg");
        if (jnlpPath != null && !(jnlpFile = new File(jnlpPath)).delete()) {
            LOGGER.warning("Failed to delete JNLP file " + jnlpPath);
        }
    }

    private static void registerJNLPSingleton() {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(new SingleInstanceListener(){

                public void newActivation(String[] strings) {
                    InitApplet.deleteJNLPFile();
                }
            });
        }
        catch (UnavailableServiceException e) {
            LOGGER.log(Level.WARNING, "Failed to register SingleInstanceService", e);
        }
    }
}

