/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.chart.designer.InitPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;

public class InitFrame
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(InitFrame.class.getName());
    InitPanel p;

    public InitFrame(String filename, String encoding) {
        this.setTitle("Chart Designer");
        this.p = new InitPanel(this, filename, encoding);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.p);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (InitFrame.this.p.logout()) {
                    System.exit(0);
                }
            }
        });
    }

    public static void main(String[] args) {
        QbUtil.setWindowsLAF();
        String filename = null;
        String enc = null;
        String address = null;
        String port = null;
        String hosts = null;
        String servletURL = null;
        for (String arg : args) {
            if (arg.startsWith("-file:")) {
                filename = arg.substring(6);
                continue;
            }
            if (arg.startsWith("-enc:")) {
                enc = arg.substring(5);
                continue;
            }
            if (arg.equalsIgnoreCase("-http")) {
                ServerMessage.useHttp();
                continue;
            }
            if (arg.startsWith("-servlet:")) {
                ServerMessage.useServlet();
                String tmp = arg.substring(9);
                if (tmp.equals("")) continue;
                servletURL = tmp;
                continue;
            }
            if (arg.equalsIgnoreCase("-servlet")) {
                ServerMessage.useServlet();
                continue;
            }
            if (arg.startsWith("-address:")) {
                address = arg.substring(9);
                continue;
            }
            if (arg.startsWith("-port:")) {
                port = arg.substring(6);
                continue;
            }
            if (arg.startsWith("-hosts:")) {
                hosts = arg.substring(7);
                continue;
            }
            if (!arg.startsWith("-debug:")) continue;
            QbDebug.setDebugMode(arg.substring(7));
        }
        if (address != null) {
            try {
                ServerMessage.setAddress(address);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to set server address", ex);
            }
        }
        if (port != null) {
            try {
                int portno = Integer.parseInt(port);
                ServerMessage.setPortNumber(portno);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to set port nr.", ex);
            }
        }
        if (hosts != null) {
            ServerMessage.setHosts(QbUtil.readMultiValues(hosts));
        }
        if (servletURL != null) {
            String servletBaseStr = ServerMessage.getServletBaseString(servletURL);
            String servletContext = ServerMessage.getServletContext(servletURL);
            ServerMessage.setConnectServlet(servletBaseStr);
            ServerMessage.setServletContext(servletContext);
        }
        new InitFrame(filename, enc);
    }
}

