/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.chart.designer.ChartDesignManager;
import quadbase.chart.designer.InitFrame;
import quadbase.chart.designer.YAStatusBar;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.swing.CanShowHint;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.CustomizeElement;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.IOUtil;

public class InitPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final Logger LOGGER = Logger.getLogger(InitPanel.class.getName());
    JButton startbutton;
    JTextField tf_name;
    JPasswordField tf_password;
    boolean pressOnce = false;
    boolean isFromInitFrame = false;
    CanShowHint statusBar;
    ChartDesignManager manager;
    JFrame frame;
    boolean disableLogin = false;

    public InitPanel() {
    }

    public InitPanel(Container c, String filename, String enc) {
        if (c instanceof InitFrame) {
            this.isFromInitFrame = true;
        }
        if (filename != null && enc != null) {
            try {
                if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                    LanguageEncoder.load(filename, enc);
                } else {
                    LanguageEncoder.loadFromServer(filename, enc);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to parse file name", e);
            }
        }
        CustomizeElement.load();
        this.frame = c instanceof JFrame ? (JFrame)c : QbDialog.findFrame(c);
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        JPanel bPanel = new JPanel();
        bPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Login")));
        bPanel.setLayout(new BorderLayout());
        JPanel pleft = new JPanel();
        pleft.setLayout(new GridLayout(2, 1));
        pleft.add(new JLabel(LanguageEncoder.getText("User Name :")));
        pleft.add(new JLabel(LanguageEncoder.getText("Password :") + " "));
        JPanel pright = new JPanel();
        pright.setLayout(new GridLayout(2, 1));
        this.tf_name = new JTextField(15);
        pright.add(this.tf_name);
        this.tf_password = new JPasswordField(15);
        pright.add(this.tf_password);
        this.tf_name.addKeyListener(this);
        this.tf_password.addKeyListener(this);
        JPanel upanel = new JPanel();
        upanel.setLayout(new BorderLayout());
        upanel.add("West", pleft);
        upanel.add("East", pright);
        bPanel.add("North", upanel);
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new FlowLayout(1));
        this.startbutton = new JButton(LanguageEncoder.getText("Start EspressChart"));
        lpanel.add(this.startbutton);
        this.startbutton.addActionListener(this);
        bPanel.add("South", lpanel);
        this.statusBar = new YAStatusBar();
        ((YAStatusBar)this.statusBar).setDelay(30000L);
        this.add("Center", bPanel);
        this.add("South", (Component)((Object)this.statusBar));
        this.tf_name.requestFocus();
        if (ServerMessage.isEvalVersion()) {
            this.tf_name.setText("guest");
            this.tf_password.setText("*****");
        }
    }

    void initFocus() {
        this.tf_name.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.pressOnce) {
            return;
        }
        this.pressOnce = true;
        if (this.manager == null || this.manager.getDesigner() == null) {
            this.startbutton.setText(LanguageEncoder.getText("Please wait..."));
            this.startbutton.setEnabled(false);
            if (!this.disableLogin) {
                try {
                    char[] passChar = this.tf_password.getPassword();
                    String errmessage = this.login(this.tf_name.getText(), Coder.encode(String.valueOf(passChar)));
                    Arrays.fill(passChar, '0');
                    if (errmessage != null) {
                        this.resumeButton();
                        new MessageDialog((Frame)this.frame, LanguageEncoder.getText("Error")).show(errmessage);
                        return;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to log in", ex);
                    this.resumeButton();
                    new MessageDialog((Frame)this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Failed to login.\n") + ex.getMessage());
                    return;
                }
            }
            if (this.isFromInitFrame) {
                this.frame.setVisible(false);
            }
            if (this.manager == null) {
                this.manager = new ChartDesignManager(this.frame, this);
            }
            this.manager.setLoginUser(this.tf_name.getText());
            this.manager.loadView();
        } else {
            this.manager.getDesigner().toFront();
            this.pressOnce = false;
        }
    }

    void loadDesigner() {
        if (this.manager == null || this.manager.getDesigner() == null) {
            if (this.manager == null) {
                this.manager = new ChartDesignManager(this.frame, this);
            }
            this.manager.loadView();
        } else {
            this.manager.getDesigner().toFront();
        }
    }

    void resumeButton() {
        this.pressOnce = false;
        this.startbutton.setText(LanguageEncoder.getText("Start EspressChart"));
        this.startbutton.setEnabled(true);
    }

    public String organizerLogin() throws Exception {
        return this.login(null, null, true);
    }

    public String login(String name, String password) throws Exception {
        return this.login(name, password, false);
    }

    public String login(String name, String password, boolean fromOrganizer) throws Exception {
        return InitPanel.login(name, password, fromOrganizer, false, this.statusBar);
    }

    public static String login(String name, String password, boolean fromOrganizer, boolean fromQbChartDesigner, CanShowHint statusBar) throws Exception {
        if (statusBar != null) {
            statusBar.showHint(LanguageEncoder.getText("Getting port no and server IP..."));
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(30831);
        dout.writeBoolean(true);
        dout.writeBoolean(fromOrganizer);
        dout.writeBoolean(fromQbChartDesigner);
        if (!fromOrganizer) {
            IOUtil.writeString(dout, Coder.encode(name));
            IOUtil.writeString(dout, Coder.encode(password));
        }
        if (statusBar != null) {
            statusBar.showHint(LanguageEncoder.getText("Connecting to") + " " + ServerMessage.getServerInfo());
        }
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            LOGGER.log(Level.FINE, "Can't contact Chart Server", ex);
            throw new IOException(LanguageEncoder.getText("Can't contact Chart Server at") + ":\n" + ServerMessage.getServerInfo());
        }
        String errmessage = null;
        DataInputStream dstream = null;
        try {
            dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                errmessage = IOUtil.readString(dstream, true);
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.log(Level.FINE, "Failed to read data from server", ex);
                throw ex;
            }
            catch (Throwable throwable) {
                CloseUtils.close(dstream);
                CloseUtils.close(socket);
                throw throwable;
            }
        }
        CloseUtils.close(dstream);
        CloseUtils.close(socket);
        return errmessage;
    }

    public void organizerLogoutFromServer() throws Exception {
        this.logoutFromServer(true);
    }

    public void logoutFromServer() throws Exception {
        this.logoutFromServer(false);
    }

    public void logoutFromServer(boolean fromOrganizer) throws Exception {
        InitPanel.logoutFromServer(fromOrganizer, false);
    }

    public static void logoutFromServer(boolean fromOrganizer, boolean fromQbChartDesigner) throws Exception {
        if (!ServerMessage.useServer) {
            return;
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(30831);
        dout.writeBoolean(false);
        dout.writeBoolean(fromOrganizer);
        dout.writeBoolean(fromQbChartDesigner);
        IConnection socket = ServerMessage.createConnection();
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Failed to write data", ex);
            throw ex;
        }
        finally {
            CloseUtils.close(socket);
        }
        String errmessage = null;
        DataInputStream dstream = null;
        try {
            dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                errmessage = IOUtil.readString(dstream, true);
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.log(Level.FINER, "Failed to read data", ex);
                throw ex;
            }
            catch (Throwable throwable) {
                CloseUtils.close(dstream);
                CloseUtils.close(socket);
                throw throwable;
            }
        }
        CloseUtils.close(dstream);
        CloseUtils.close(socket);
        if (errmessage != null) {
            throw new IOException(errmessage);
        }
    }

    boolean logout() {
        if (this.manager != null) {
            if (this.manager.getDesigner() != null) {
                return this.manager.getDesigner().do_exit();
            }
            try {
                this.logoutFromServer();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to log out from server", ex);
            }
        }
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.startbutton.doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

