/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class LabelPlacementPanel
extends JPanel
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(LabelPlacementPanel.class.getName());
    SpinBox spinSep;
    SpinBox spinTicker;
    SpinBox spinLabelRow;
    SpinBox spinGrid;
    SpinBox spinAxis;
    SpinBox spinAxisGap;
    SpinBox spinTickLen;
    SpinBox spinSubTickLen;
    SpinBox spinSubTickCt;
    SpinBox spinSubTickThickness;
    SpinBox spinMaxLabel;
    JCheckBox chAxis;
    JCheckBox chArrow;
    JCheckBox chGrid;
    JCheckBox chFrame;
    JCheckBox chXTop;
    JCheckBox chSwapYS;
    JCheckBox chXZAxis;
    JCheckBox chLabelOnTheSide;
    JCheckBox chDoubleValue;
    JCheckBox chGridToFront;
    JCheckBox chGridAlignWithTicker;
    JCheckBox chlabel;
    JCheckBox chtic;
    JCheckBox chTickDir;
    JCheckBox chAutoAxisPos;
    JCheckBox chLogSubTickers;
    JCheckBox ch3DShadowForTicker;
    JCheckBox chEnableMaxLabel;
    JRadioButton ascValue;
    JRadioButton desValue;
    int type = -1;
    JComboBox unitChoice = null;
    JComboBox gridLineStyle = null;
    SpinBox spinYear1 = null;
    SpinBox spinMonth1 = null;
    SpinBox spinDay1 = null;
    SpinBox spinHour1 = null;
    SpinBox spinMin1 = null;
    SpinBox spinSec1 = null;
    SpinBox spinYear2 = null;
    SpinBox spinMonth2 = null;
    SpinBox spinDay2 = null;
    SpinBox spinHour2 = null;
    SpinBox spinMin2 = null;
    SpinBox spinSec2 = null;

    public LabelPlacementPanel(int axis, JPanel centerPanel, Chart chart, ColData cd, boolean showXZAxis) {
        boolean is2DChart = chart.is2DimChart();
        int sepsize = cd.sepSize;
        int unit = cd.sepUnit;
        boolean isAsc = cd.isAscending;
        Date startingDate = cd.getStartingDate();
        Date endingDate = cd.getEndingDate();
        this.type = cd.getOriginalDataType();
        int tickersize = cd.tickerSepSize;
        int maxNumOfTickerAndLabel = cd.maxNumOfTickerAndLabel;
        int labelrow = axis != 0 ? 0 : chart.xlabelrow;
        int gridThickness = chart.getGridThickness(axis);
        int gridStyle = chart.getGridLineStyle(axis);
        int axisThickness = chart.getAxisThickness();
        boolean showlabel = chart.getTickerLabelState(axis);
        boolean showtic = chart.getTickerLineState(axis);
        boolean tickerInward = chart.isTickerDrawInward(axis);
        boolean showLogSubTickers = chart.getLogSubTickersState(axis);
        boolean showAxis = chart.getAxisState(axis);
        boolean showArrow = chart.getArrowState();
        boolean showGrid = chart.getGridState(axis);
        boolean showFrame = chart.getWallFrameState();
        boolean shiftXTop = chart.isXAxisAtTop();
        boolean isSwapAxis = chart.isSwapAxis();
        boolean xzAxis = chart.getAxisState(2);
        boolean labelOnTheSide = chart.isLabelOutsidePlotArea(axis);
        boolean showDoubleValue = chart.isShowDoubleValueForLine();
        int chartType = chart.getChartType();
        boolean autoAxisPos = chart.isAutoAxisPosition();
        int axisGapOffset = chart.getAxisGapOffset();
        this.setLayout(new BorderLayout());
        JPanel chpanel1 = new JPanel();
        chpanel1.setLayout(new FlowLayout(0));
        this.chlabel = new JCheckBox(LanguageEncoder.getText("Show labels"));
        chpanel1.add(this.chlabel);
        this.chtic = new JCheckBox(LanguageEncoder.getText("Show ticker"));
        chpanel1.add(this.chtic);
        this.chTickDir = new JCheckBox(LanguageEncoder.getText("Draw ticker inward"));
        chpanel1.add(this.chTickDir);
        this.chLogSubTickers = new JCheckBox(LanguageEncoder.getText("Show sub-tickers"));
        this.ch3DShadowForTicker = new JCheckBox(LanguageEncoder.getText("Show Shadow for Ticker"));
        this.ch3DShadowForTicker.setSelected(chart.is3DShadowForTickerOn());
        if (chart.getChartType() == 17) {
            chpanel1.add(this.ch3DShadowForTicker);
        }
        if (chart.getAxis(axis).isSubTickersOptionEnabled()) {
            chpanel1.add(this.chLogSubTickers);
        }
        this.chGrid = new JCheckBox(LanguageEncoder.getText("Show grid"));
        if (axis != 3) {
            chpanel1.add(this.chGrid);
        }
        if (axis == 0 && is2DChart) {
            this.chGridToFront = new JCheckBox(LanguageEncoder.getText("Grid to front"));
            chpanel1.add(this.chGridToFront);
        }
        if (axis == 3 && is2DChart) {
            this.chSwapYS = new JCheckBox(LanguageEncoder.getText("Swap Y-axis position"));
            chpanel1.add(this.chSwapYS);
        }
        if (axis == 3 && chartType == 3 && is2DChart) {
            this.chDoubleValue = new JCheckBox(LanguageEncoder.getText("Show using primary axis"));
            chpanel1.add(this.chDoubleValue);
        }
        if (axis == 0) {
            this.chArrow = new JCheckBox(LanguageEncoder.getText("Show 2D arrow"));
            chpanel1.add(this.chArrow);
        }
        JPanel chpanel2 = new JPanel();
        chpanel2.setLayout(new FlowLayout(0));
        this.chAxis = new JCheckBox(LanguageEncoder.getText("Show axis"));
        if (is2DChart || axis != 3) {
            chpanel2.add(this.chAxis);
        }
        if (axis == 0) {
            this.chFrame = new JCheckBox(LanguageEncoder.getText("Show 3D frame"));
            chpanel2.add(this.chFrame);
            this.chXTop = new JCheckBox(LanguageEncoder.getText("Draw X axis at top"));
            chpanel2.add(this.chXTop);
            if (chart.is2DimChart() && !Chart.stackType(chartType) && chartType != 15 && chartType != 3 && chartType != 17 && chartType != 16 && chartType != 14 && chartType != 7) {
                this.chXTop.setEnabled(true);
            } else {
                this.chXTop.setEnabled(false);
            }
        }
        if (axis == 0 || axis == 1) {
            this.chLabelOnTheSide = new JCheckBox(LanguageEncoder.getText("Label outside plot area"));
            chpanel2.add(this.chLabelOnTheSide);
        }
        if (axis == 0 && (chartType == 0 || chartType == 4 || chartType == 9 || chartType == 10 || chartType == 11 || chartType == 14)) {
            this.chGridAlignWithTicker = new JCheckBox(LanguageEncoder.getText("Align grid with ticker"));
            chpanel2.add(this.chGridAlignWithTicker);
            this.chGridAlignWithTicker.setSelected(chart.isGridAlignedWithTicker());
        } else if (axis == 1 && (chartType == 1 || chartType == 5 || chartType == 15)) {
            this.chGridAlignWithTicker = new JCheckBox(LanguageEncoder.getText("Align grid with ticker"));
            chpanel2.add(this.chGridAlignWithTicker);
            this.chGridAlignWithTicker.setSelected(chart.isGridAlignedWithTicker());
        }
        if (axis == 1 && chart.getChartType() == 14 && chart.colDataAxis != null) {
            this.chAutoAxisPos = new JCheckBox(LanguageEncoder.getText("Auto axis position"), autoAxisPos);
            chpanel2.add(this.chAutoAxisPos);
        }
        if (showXZAxis) {
            this.chXZAxis = new JCheckBox("Show XZ axis");
            chpanel2.add(this.chXZAxis);
        }
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new GridLayout(0, 1, 0, 0));
        checkPanel.add(chpanel1);
        checkPanel.add(chpanel2);
        this.chlabel.setSelected(showlabel);
        this.chtic.setSelected(showtic);
        this.chTickDir.setSelected(tickerInward);
        this.chLogSubTickers.setSelected(showLogSubTickers);
        this.chAxis.setSelected(showAxis);
        if (axis == 0) {
            this.chArrow.setSelected(showArrow);
            this.chFrame.setSelected(showFrame);
            if (this.chXTop != null) {
                this.chXTop.setSelected(shiftXTop);
            }
            this.chLabelOnTheSide.setSelected(labelOnTheSide);
            if (is2DChart) {
                this.chGridToFront.setSelected(chart.isGridInFront());
            }
        }
        if (axis == 1) {
            this.chLabelOnTheSide.setSelected(labelOnTheSide);
        }
        if (axis != 3) {
            this.chGrid.setSelected(showGrid);
        }
        if (axis == 3 && isSwapAxis) {
            this.chSwapYS.setSelected(isSwapAxis);
        }
        if (axis == 3 && chartType == 3 && is2DChart) {
            this.chDoubleValue.setSelected(showDoubleValue);
        }
        if (showXZAxis) {
            this.chXZAxis.setSelected(xzAxis);
        }
        JPanel spinPanel = new JPanel();
        spinPanel.setLayout(new GridLayout(0, 4, 0, 0));
        this.spinGrid = new SpinBox(1, 30);
        this.spinTicker = new SpinBox(1, 9999);
        if (axis != 3) {
            if (axis == 1 && chart.getChartType() == 17) {
                spinPanel.add(new JLabel(LanguageEncoder.getText("Ticker thickness :")));
            } else {
                spinPanel.add(new JLabel(LanguageEncoder.getText("Grid thickness :")));
            }
            spinPanel.add(this.spinGrid);
            spinPanel.add(new JLabel(LanguageEncoder.getText("Grid step interval :")));
            spinPanel.add(this.spinTicker);
            spinPanel.add(new JLabel(LanguageEncoder.getText("Grid line style :")));
            this.gridLineStyle = new JComboBox();
            this.gridLineStyle.addItem(LanguageEncoder.getText("Solid"));
            this.gridLineStyle.addItem(LanguageEncoder.getText("Dotted"));
            this.gridLineStyle.addItem(LanguageEncoder.getText("Dash"));
            spinPanel.add(this.gridLineStyle);
            spinPanel.add(new JLabel(" "));
            spinPanel.add(new JLabel(" "));
        }
        this.spinLabelRow = new SpinBox(1, 9999);
        if (axis == 0) {
            spinPanel.add(new JLabel(LanguageEncoder.getText("Label rows :")));
            spinPanel.add(this.spinLabelRow);
            this.spinLabelRow.setValue(labelrow);
            spinPanel.add(new JLabel(LanguageEncoder.getText("Axis thickness :")));
            this.spinAxis = new SpinBox(1, 30);
            spinPanel.add(this.spinAxis);
        }
        spinPanel.add(new JLabel(LanguageEncoder.getText("Label step interval :")));
        this.spinSep = new SpinBox(1, 9999);
        spinPanel.add(this.spinSep);
        this.spinSep.setValue(sepsize);
        if (axis == 1 && chart.getChartType() == 14 && chart.colDataAxis != null) {
            spinPanel.add(new JLabel(LanguageEncoder.getText("Axis Gap Offset :")));
            this.spinAxisGap = new SpinBox(1, 9999);
            spinPanel.add(this.spinAxisGap);
            this.spinAxisGap.setValue(axisGapOffset);
        }
        if (axis == 1 && chart.getChartType() == 17) {
            spinPanel.add(new JLabel(LanguageEncoder.getText("Ticker Length :")));
            this.spinTickLen = new SpinBox(1, 30);
            spinPanel.add(this.spinTickLen);
            this.spinTickLen.setValue(chart.getTickerLength());
            spinPanel.add(new JLabel(LanguageEncoder.getText("SubTicker Length :")));
            this.spinSubTickLen = new SpinBox(1, 30);
            spinPanel.add(this.spinSubTickLen);
            this.spinSubTickLen.setValue(chart.getSubTickerLength());
            spinPanel.add(new JLabel(LanguageEncoder.getText("SubTicker Count :")));
            this.spinSubTickCt = new SpinBox(0, 30);
            spinPanel.add(this.spinSubTickCt);
            this.spinSubTickCt.setValue(chart.getSubTickerCount() - 1);
            spinPanel.add(new JLabel(LanguageEncoder.getText("SubTicker Thickness :")));
            this.spinSubTickThickness = new SpinBox(1, 30);
            spinPanel.add(this.spinSubTickThickness);
            this.spinSubTickThickness.setValue(chart.getSubTickerThickness());
        }
        this.spinMaxLabel = new SpinBox(1, 9999);
        this.chEnableMaxLabel = new JCheckBox(LanguageEncoder.getText("Enable"));
        JPanel maxLabelPanel = new JPanel();
        maxLabelPanel.setLayout(new GridLayout(0, 4, 0, 0));
        maxLabelPanel.add(new JLabel(LanguageEncoder.getText("Max number of labels :")));
        maxLabelPanel.add(this.spinMaxLabel);
        maxLabelPanel.add(this.chEnableMaxLabel);
        maxLabelPanel.add(new JLabel(""));
        if (maxNumOfTickerAndLabel < 1) {
            this.chEnableMaxLabel.setSelected(false);
            this.spinMaxLabel.setEnabled(false);
            this.spinMaxLabel.setValue(25);
        } else {
            this.chEnableMaxLabel.setSelected(true);
            this.spinMaxLabel.setEnabled(true);
            this.spinMaxLabel.setValue(maxNumOfTickerAndLabel);
        }
        this.chEnableMaxLabel.addItemListener(this);
        JPanel rangePanel = null;
        if (this.type != 92 && this.type != 91 && this.type != 93) {
            spinPanel.add(new JLabel(""));
            spinPanel.add(new JLabel(""));
        } else {
            this.unitChoice = new JComboBox();
            rangePanel = new JPanel();
            this.ascValue = new JRadioButton(LanguageEncoder.getText("Asc"), true);
            this.desValue = new JRadioButton(LanguageEncoder.getText("Desc"), false);
            ButtonGroup cg = new ButtonGroup();
            cg.add(this.ascValue);
            cg.add(this.desValue);
            this.ascValue.addItemListener(this);
            this.desValue.addItemListener(this);
            switch (this.type) {
                case 93: {
                    this.unitChoice.addItem(LanguageEncoder.getText("tickers"));
                    this.unitChoice.addItem(LanguageEncoder.getText("years"));
                    this.unitChoice.addItem(LanguageEncoder.getText("months"));
                    this.unitChoice.addItem(LanguageEncoder.getText("days"));
                    this.unitChoice.addItem(LanguageEncoder.getText("hours"));
                    this.unitChoice.addItem(LanguageEncoder.getText("minutes"));
                    this.unitChoice.addItem(LanguageEncoder.getText("seconds"));
                    this.unitChoice.addItem(LanguageEncoder.getText("dynamic"));
                    rangePanel.setLayout(new GridLayout(3, 7, 0, 0));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("Starting at :")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("year")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("month")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("day")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("hour")));
                    rangePanel.add(new JLabel("minute"));
                    rangePanel.add(new JLabel("second"));
                    this.spinYear1 = new SpinBox(1970, 2050, 1);
                    this.spinMonth1 = new SpinBox(1, 12, 1);
                    this.spinDay1 = new SpinBox(1, 31, 1);
                    this.spinHour1 = new SpinBox(0, 23, 1);
                    this.spinMin1 = new SpinBox(0, 59, 1);
                    this.spinSec1 = new SpinBox(0, 59, 1);
                    rangePanel.add(this.ascValue);
                    rangePanel.add(this.spinYear1);
                    rangePanel.add(this.spinMonth1);
                    rangePanel.add(this.spinDay1);
                    rangePanel.add(this.spinHour1);
                    rangePanel.add(this.spinMin1);
                    rangePanel.add(this.spinSec1);
                    this.spinYear2 = new SpinBox(1970, 2050, 1);
                    this.spinMonth2 = new SpinBox(1, 12, 1);
                    this.spinDay2 = new SpinBox(1, 31, 1);
                    this.spinHour2 = new SpinBox(0, 23, 1);
                    this.spinMin2 = new SpinBox(0, 59, 1);
                    this.spinSec2 = new SpinBox(0, 59, 1);
                    rangePanel.add(this.desValue);
                    rangePanel.add(this.spinYear2);
                    rangePanel.add(this.spinMonth2);
                    rangePanel.add(this.spinDay2);
                    rangePanel.add(this.spinHour2);
                    rangePanel.add(this.spinMin2);
                    rangePanel.add(this.spinSec2);
                    break;
                }
                case 91: {
                    this.unitChoice.addItem(LanguageEncoder.getText("tickers"));
                    this.unitChoice.addItem(LanguageEncoder.getText("years"));
                    this.unitChoice.addItem(LanguageEncoder.getText("months"));
                    this.unitChoice.addItem(LanguageEncoder.getText("days"));
                    this.unitChoice.addItem(LanguageEncoder.getText("dynamic"));
                    rangePanel.setLayout(new GridLayout(3, 4, 0, 0));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("Starting at :")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("year")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("month")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("day")));
                    this.spinYear1 = new SpinBox(1970, 2050, 1);
                    this.spinMonth1 = new SpinBox(1, 12, 1);
                    this.spinDay1 = new SpinBox(1, 31, 1);
                    rangePanel.add(this.ascValue);
                    rangePanel.add(this.spinYear1);
                    rangePanel.add(this.spinMonth1);
                    rangePanel.add(this.spinDay1);
                    this.spinYear2 = new SpinBox(1970, 2050, 1);
                    this.spinMonth2 = new SpinBox(1, 12, 1);
                    this.spinDay2 = new SpinBox(1, 31, 1);
                    rangePanel.add(this.desValue);
                    rangePanel.add(this.spinYear2);
                    rangePanel.add(this.spinMonth2);
                    rangePanel.add(this.spinDay2);
                    break;
                }
                case 92: {
                    this.unitChoice.addItem(LanguageEncoder.getText("tickers"));
                    this.unitChoice.addItem(LanguageEncoder.getText("hours"));
                    this.unitChoice.addItem(LanguageEncoder.getText("minutes"));
                    this.unitChoice.addItem(LanguageEncoder.getText("seconds"));
                    this.unitChoice.addItem(LanguageEncoder.getText("dynamic"));
                    rangePanel.setLayout(new GridLayout(3, 4, 0, 0));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("starting_at")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("hour")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("minute")));
                    rangePanel.add(new JLabel(LanguageEncoder.getText("second")));
                    this.spinHour1 = new SpinBox(0, 23, 1);
                    this.spinMin1 = new SpinBox(0, 59, 1);
                    this.spinSec1 = new SpinBox(0, 59, 1);
                    rangePanel.add(this.ascValue);
                    rangePanel.add(this.spinHour1);
                    rangePanel.add(this.spinMin1);
                    rangePanel.add(this.spinSec1);
                    this.spinHour2 = new SpinBox(0, 23, 1);
                    this.spinMin2 = new SpinBox(0, 59, 1);
                    this.spinSec2 = new SpinBox(0, 59, 1);
                    rangePanel.add(this.desValue);
                    rangePanel.add(this.spinHour2);
                    rangePanel.add(this.spinMin2);
                    rangePanel.add(this.spinSec2);
                }
            }
            this.setScaleUnit(unit);
            this.unitChoice.addItemListener(this);
            if (startingDate == null || endingDate == null) {
                this.setRangeValue(new Timestamp((long)chart.axis[0].minScale));
                this.setRangeValue2(new Timestamp((long)chart.axis[0].maxScale));
            } else {
                this.setRangeValue(new Timestamp(startingDate.getTime()));
                this.setRangeValue2(new Timestamp(endingDate.getTime()));
            }
            this.ascValue.setSelected(isAsc);
            this.enableStartingBound(0, isAsc);
            this.desValue.setSelected(!isAsc);
            this.enableStartingBound(1, !isAsc);
            if (chart.getChartType() != 18) {
                spinPanel.add(new JLabel(LanguageEncoder.getText("Label interval unit :")));
                spinPanel.add(this.unitChoice);
            }
        }
        if (axis != 3) {
            this.spinTicker.setValue(tickersize);
            this.spinGrid.setValue(gridThickness);
            this.gridLineStyle.setSelectedIndex(gridStyle);
        }
        if (axis == 0) {
            this.spinAxis.setValue(axisThickness);
        }
        BorderPanel panel = new BorderPanel(LanguageEncoder.getText("Axis elements"));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(spinPanel);
        int type = chart.getChartType();
        if (type != 2 && type != 6 && type != 12 && type != 13 && type != 16 && type != 17 && type != 19 && type != 20) {
            panel.add(maxLabelPanel);
        }
        if (type != 18 && rangePanel != null) {
            panel.add(rangePanel);
        }
        panel.add(checkPanel);
        if (type != 17 || !chart.getDialPlotBGImageState()) {
            this.add("North", panel);
        }
        if (centerPanel != null) {
            this.add("Center", centerPanel);
        }
        this.itemStateChanged(null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.ascValue != null) {
            this.enableStartingBound(0, this.ascValue.isSelected());
        }
        if (this.desValue != null) {
            this.enableStartingBound(1, this.desValue.isSelected());
        }
        this.spinMaxLabel.setEnabled(this.chEnableMaxLabel.isSelected());
    }

    private void enableStartingBound(int index, boolean enable) {
        switch (this.type) {
            case 91: 
            case 93: {
                if (index == 0) {
                    this.spinYear1.setEnabled(enable);
                    this.spinMonth1.setEnabled(enable);
                    this.spinDay1.setEnabled(enable);
                } else {
                    this.spinYear2.setEnabled(enable);
                    this.spinMonth2.setEnabled(enable);
                    this.spinDay2.setEnabled(enable);
                }
                if (this.type == 91) break;
            }
            case 92: {
                if (index == 0) {
                    this.spinHour1.setEnabled(enable);
                    this.spinMin1.setEnabled(enable);
                    this.spinSec1.setEnabled(enable);
                    break;
                }
                this.spinHour2.setEnabled(enable);
                this.spinMin2.setEnabled(enable);
                this.spinSec2.setEnabled(enable);
            }
        }
    }

    public boolean isAsc() {
        return this.ascValue.isSelected();
    }

    public int getSep() {
        return this.spinSep.getValue();
    }

    public int getTickerSep() {
        return this.spinTicker.getValue();
    }

    public int getMaxNumOfLabelAndTicker() {
        if (this.chEnableMaxLabel.isSelected()) {
            return this.spinMaxLabel.getValue();
        }
        return -1;
    }

    public int getLabelRowSize() {
        return this.spinLabelRow.getValue();
    }

    public int getAxisThickness() {
        return this.spinAxis.getValue();
    }

    public int getGridThickness() {
        return this.spinGrid.getValue();
    }

    public int getGridLineStyle() {
        return this.gridLineStyle.getSelectedIndex();
    }

    public int getTickerLength() {
        return this.spinTickLen.getValue();
    }

    public int getSubTickerLength() {
        return this.spinSubTickLen.getValue();
    }

    public int getTickerCount() {
        return this.spinSubTickCt.getValue() + 1;
    }

    public int getSubTickerThickness() {
        return this.spinSubTickThickness.getValue();
    }

    public boolean is3DShadowForTickerOn() {
        return this.ch3DShadowForTicker.isSelected();
    }

    public int getScaleUnit() {
        if (this.unitChoice == null) {
            return -1;
        }
        String unitValue = this.unitChoice.getSelectedItem().toString();
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("years"))) {
            return 6;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("months"))) {
            return 5;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("days"))) {
            return 3;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("hours"))) {
            return 2;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("minutes"))) {
            return 1;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("seconds"))) {
            return 0;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("dynamic"))) {
            return 7;
        }
        return -1;
    }

    public void setScaleUnit(int unit) {
        switch (unit) {
            case 6: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("years"));
                break;
            }
            case 5: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("months"));
                break;
            }
            case 3: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("days"));
                break;
            }
            case 2: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("hours"));
                break;
            }
            case 1: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("minutes"));
                break;
            }
            case 0: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("seconds"));
                break;
            }
            case 7: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("dynamic"));
                break;
            }
            default: {
                this.unitChoice.setSelectedItem(LanguageEncoder.getText("tickers"));
            }
        }
    }

    public void setRangeValue(Timestamp tsValue) {
        if (this.type == 93 || this.type == 91) {
            this.spinYear1.setValue(tsValue.getYear() + 1900);
            this.spinMonth1.setValue(tsValue.getMonth() + 1);
            this.spinDay1.setValue(tsValue.getDate());
        }
        if (this.type == 93 || this.type == 92) {
            this.spinHour1.setValue(tsValue.getHours());
            this.spinMin1.setValue(tsValue.getMinutes());
            this.spinSec1.setValue(tsValue.getSeconds());
        }
    }

    public Date getRangeValue() {
        Date tsValue = null;
        if (this.type != 93 && this.type != 91 && this.type != 92) {
            return null;
        }
        switch (this.type) {
            case 91: {
                tsValue = new Date(this.spinYear1.getValue() - 1900, this.spinMonth1.getValue() - 1, this.spinDay1.getValue(), 0, 0, 0);
                break;
            }
            case 92: {
                tsValue = new Date(70, 0, 1, this.spinHour1.getValue(), this.spinMin1.getValue(), this.spinSec1.getValue());
                break;
            }
            case 93: {
                tsValue = new Date(this.spinYear1.getValue() - 1900, this.spinMonth1.getValue() - 1, this.spinDay1.getValue(), this.spinHour1.getValue(), this.spinMin1.getValue(), this.spinSec1.getValue());
                break;
            }
            default: {
                LOGGER.warning("Category Type: " + this.type + " not supported");
            }
        }
        return tsValue;
    }

    public void setRangeValue2(Timestamp tsValue) {
        if (this.type == 93 || this.type == 91) {
            this.spinYear2.setValue(tsValue.getYear() + 1900);
            this.spinMonth2.setValue(tsValue.getMonth() + 1);
            this.spinDay2.setValue(tsValue.getDate());
        }
        if (this.type == 93 || this.type == 92) {
            this.spinHour2.setValue(tsValue.getHours());
            this.spinMin2.setValue(tsValue.getMinutes());
            this.spinSec2.setValue(tsValue.getSeconds());
        }
    }

    public Date getRangeValue2() {
        Date tsValue = null;
        if (this.type != 93 && this.type != 91 && this.type != 92) {
            return null;
        }
        switch (this.type) {
            case 91: {
                tsValue = new Date(this.spinYear2.getValue() - 1900, this.spinMonth2.getValue() - 1, this.spinDay2.getValue(), 0, 0, 0);
                break;
            }
            case 92: {
                tsValue = new Date(70, 0, 1, this.spinHour2.getValue(), this.spinMin2.getValue(), this.spinSec2.getValue());
                break;
            }
            case 93: {
                tsValue = new Date(this.spinYear2.getValue() - 1900, this.spinMonth2.getValue() - 1, this.spinDay2.getValue(), this.spinHour2.getValue(), this.spinMin2.getValue(), this.spinSec2.getValue());
                break;
            }
            default: {
                LOGGER.warning("Category Type: " + this.type + " not supported");
            }
        }
        return tsValue;
    }
}

