/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import quadbase.chart.Legend;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.HideLegendItemDialog;
import quadbase.chart.designer.LegendLabelDialog;
import quadbase.chart.designer.LegendPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class LegendDialog
extends QbDialog {
    ChartMain chartmain;
    LegendPanel legendpanel;
    LegendPanel legendpanel2;
    JTabbedPane tabPanel;
    HideLegendItemDialog hideDialog;
    JButton okButton;
    JButton cancelButton;
    JButton moreButton;
    JButton hideButton;
    Legend lg;
    boolean showfirstLegend;

    public LegendDialog(ChartMain chartmain, Legend lg, Legend lg2, boolean showfirstLegend, String title) {
        super(chartmain, title, true);
        this.chartmain = chartmain;
        this.showfirstLegend = showfirstLegend;
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        JPanel but_panel = new JPanel();
        but_panel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        but_panel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        but_panel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        if (lg.cd != null && lg.cd.axisType != 7 && lg.cd.axisType != 99 || lg.cd2 != null && lg.cd2.axisType != 7 && lg.cd2.axisType != 99) {
            this.moreButton = new JButton(LanguageEncoder.getText("Format..."));
            but_panel.add(this.moreButton);
            this.moreButton.addActionListener(this);
        }
        this.hideButton = new JButton(LanguageEncoder.getText("Hide..."));
        int cType = chartmain.chart.chartType;
        if (chartmain.chart.dataDim != 1 || cType != 16 && cType != 3 && cType != 9 && cType != 10) {
            but_panel.add(this.hideButton);
        }
        this.hideButton.addActionListener(this);
        this.legendpanel = new LegendPanel(chartmain, lg);
        if (lg2 == null) {
            cop.add("Center", this.legendpanel);
        } else {
            this.tabPanel = new JTabbedPane();
            this.tabPanel.add(LanguageEncoder.getText("Primary Axis"), this.legendpanel);
            this.legendpanel2 = new LegendPanel(chartmain, lg2);
            this.tabPanel.add(LanguageEncoder.getText("Secondary Axis"), this.legendpanel2);
            cop.add("Center", this.tabPanel);
        }
        this.setBackground(Color.lightGray);
        cop.add("South", but_panel);
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.tabPanel != null) {
            this.tabPanel.setSelectedIndex(this.showfirstLegend ? 0 : 1);
        }
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.moreButton) {
            new LegendLabelDialog(this.chartmain, LanguageEncoder.getText("Format Label")).setVisible(true);
        } else if (e.getSource() == this.hideButton) {
            if (this.hideDialog == null) {
                this.hideDialog = new HideLegendItemDialog(this.chartmain, LanguageEncoder.getText("Hide Legend Items"));
            }
            this.hideDialog.setVisible(true);
        } else {
            this.setVisible(false);
            this.dispose();
            if (e.getSource() == this.okButton) {
                this.legendpanel.getLegend();
                if (this.legendpanel2 != null) {
                    this.legendpanel2.getLegend();
                }
                this.chartmain.setModified();
                this.chartmain.chartPanel.paint();
            } else {
                this.legendpanel.resortLegend();
                if (this.legendpanel2 != null) {
                    this.legendpanel2.resortLegend();
                }
                if (this.hideDialog != null) {
                    this.hideDialog.undoHide();
                }
            }
        }
    }
}

