/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Legend;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.DateTimeSamplePanel;
import quadbase.common.swing.LogicalPanel;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IFormat;
import quadbase.util.LogicalFormat;

public class LegendLabelDialog
extends QbDialog {
    JTabbedPane tabPanel;
    JButton butcancel;
    JButton butOK;
    Legend legend;
    ChartMain chartmain;
    Chart chart;
    static final short width = 550;
    static final short height = 550;
    Object[] formatPanel;

    public LegendLabelDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.legend = frame.chart.legend;
        this.setBackground(Color.lightGray);
        this.tabPanel = new JTabbedPane();
        this.formatPanel = new Object[2];
        if (!this.chart.isCircularChart()) {
            if (this.legend.cd != null && this.legend.cd.axisType != 7) {
                this.formatPanel[0] = this.newPanel(this.legend.cd.axisType, this.legend.cd.dataFormat);
                this.tabPanel.add(this.legend.lgName1 != null ? this.legend.lgName1 : this.legend.cd.colName, (JPanel)this.formatPanel[0]);
            }
            if (this.legend.cd2 != null && this.legend.cd2.axisType != 7) {
                this.formatPanel[1] = this.newPanel(this.legend.cd2.axisType, this.legend.cd2.dataFormat);
                this.tabPanel.add(this.legend.lgName2, (JPanel)this.formatPanel[1]);
            }
        } else {
            ColData cd = this.chart.colData[this.chart.mDataMap[0]];
            this.formatPanel[0] = this.newPanel(cd.axisType, cd.dataFormat);
            this.tabPanel.add(cd.colName, (JPanel)this.formatPanel[0]);
        }
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", this.tabPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butcancel.addActionListener(this);
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        this.butOK.addActionListener(this);
        buttonPanel.add(this.butOK);
        buttonPanel.add(this.butcancel);
        cop.add("South", buttonPanel);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private Object newPanel(int axType, IFormat dataFormat) {
        PanelAction dpanel = null;
        if (axType == 8) {
            dpanel = new DateTimeSamplePanel(this.chartmain, dataFormat, true, false, false);
        } else if (axType == 9) {
            dpanel = new DateTimeSamplePanel(this.chartmain, dataFormat, false, true, false);
        } else if (axType == 10) {
            dpanel = new DateTimeSamplePanel(this.chartmain, dataFormat, true, true, false);
        } else if (axType == 0) {
            dpanel = new LogicalPanel();
            ((LogicalPanel)dpanel).setFormat(((LogicalFormat)dataFormat).getformat());
        }
        return dpanel;
    }

    private void restoreValues() {
        if (this.formatPanel[0] instanceof DateTimeSamplePanel) {
            this.legend.cd.dataFormat = ((DateTimeSamplePanel)this.formatPanel[0]).getFormat();
        }
        if (this.formatPanel[1] instanceof DateTimeSamplePanel) {
            this.legend.cd2.dataFormat = ((DateTimeSamplePanel)this.formatPanel[1]).getFormat();
        }
        if (this.formatPanel[0] instanceof LogicalPanel) {
            this.legend.cd.dataFormat = new LogicalFormat(((LogicalPanel)this.formatPanel[0]).getFormatInt());
        }
        if (this.formatPanel[1] instanceof LogicalPanel) {
            this.legend.cd2.dataFormat = new LogicalFormat(((LogicalPanel)this.formatPanel[1]).getFormatInt());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butOK) {
            this.chartmain.setModified();
            this.restoreValues();
            this.chartmain.chartPanel.update();
        }
        this.dispose();
    }
}

