/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.Legend;
import quadbase.chart.designer.AreaOptionPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.GradientDialog;
import quadbase.chart.designer.IGradientDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class LegendPanel
extends JPanel
implements ActionListener,
ItemListener,
IGradientDialog {
    Legend legend;
    JCheckBox ck_background;
    JCheckBox ck_border;
    JCheckBox ck_symbols;
    JRadioButton ck_vert;
    JRadioButton ck_horz;
    JRadioButton ck_square;
    JRadioButton ck_fixed_col;
    JCheckBox ck_reverse;
    JCheckBox ck_draw;
    JCheckBox ck_oneLegendSet;
    SpinBox spinPtSizeRatio;
    SpinBox spinNoOfColumn;
    AreaOptionPanel areapanel;
    int defaultPointSize;
    ChartMain chartmain;
    JCheckBox enableGradient;
    JButton gradientOption;
    GradientDialog gradientDialog;

    public LegendPanel(ChartMain chartmain, Legend lg) {
        this.legend = lg;
        BorderPanel p_display = new BorderPanel(LanguageEncoder.getText("Display"));
        this.ck_background = new JCheckBox(LanguageEncoder.getText("Background"));
        this.ck_background.setSelected(this.legend.area.drawArea);
        this.ck_border = new JCheckBox(LanguageEncoder.getText("Border"));
        this.ck_border.setSelected(this.legend.framearea.drawBorder);
        this.ck_symbols = new JCheckBox(LanguageEncoder.getText("Draw Symbols"));
        this.ck_symbols.setSelected(this.legend.areSymbolsDrawn());
        p_display.setLayout(new GridLayout(3, 1));
        p_display.add(this.ck_border);
        p_display.add(this.ck_background);
        p_display.add(this.ck_symbols);
        this.chartmain = chartmain;
        this.ck_background.addItemListener(this);
        BorderPanel p_layout = new BorderPanel(LanguageEncoder.getText("Layout"));
        this.ck_vert = new JRadioButton(LanguageEncoder.getText("Vertical"), this.legend.isVertical());
        this.ck_horz = new JRadioButton(LanguageEncoder.getText("Horizontal"), this.legend.isHorizontal());
        this.ck_square = new JRadioButton(LanguageEncoder.getText("Square"), this.legend.isSquare());
        this.ck_fixed_col = new JRadioButton(LanguageEncoder.getText("Fixed Column"), this.legend.isFixedColumn());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.ck_vert);
        bg.add(this.ck_horz);
        bg.add(this.ck_square);
        bg.add(this.ck_fixed_col);
        p_layout.setLayout(new GridLayout(4, 1));
        p_layout.add(this.ck_vert);
        p_layout.add(this.ck_horz);
        p_layout.add(this.ck_square);
        p_layout.add(this.ck_fixed_col);
        this.ck_fixed_col.addItemListener(this);
        BorderPanel order_panel = new BorderPanel(LanguageEncoder.getText("Other"));
        order_panel.setLayout(new GridLayout(3, 2));
        this.ck_reverse = new JCheckBox(LanguageEncoder.getText("Reverse Order"));
        this.ck_reverse.setSelected(this.legend.reverse);
        this.ck_draw = new JCheckBox(LanguageEncoder.getText("Display Legend"));
        this.ck_draw.setSelected(this.legend.showLegend);
        this.ck_oneLegendSet = new JCheckBox(LanguageEncoder.getText("One Legend Set"));
        this.ck_oneLegendSet.setSelected(this.legend.useOneLegendSet);
        JLabel label = new JLabel(LanguageEncoder.getText("Symbol Size Ratio (%)"));
        this.spinPtSizeRatio = new SpinBox(1, 1000, 10);
        this.defaultPointSize = this.legend.getPointSizeRatio();
        this.spinPtSizeRatio.setValue(this.defaultPointSize);
        JLabel label2 = new JLabel(LanguageEncoder.getText("Number Of Columns"));
        this.spinNoOfColumn = new SpinBox(1, 100, 1);
        this.spinNoOfColumn.setValue(this.legend.getFixedColumnCount());
        order_panel.add(this.ck_reverse);
        order_panel.add(this.ck_draw);
        order_panel.add(this.ck_oneLegendSet);
        order_panel.add(label);
        order_panel.add(this.spinPtSizeRatio);
        order_panel.add(new JLabel(""));
        order_panel.add(label2);
        order_panel.add(this.spinNoOfColumn);
        this.spinPtSizeRatio.addActionListener(this);
        JPanel spanel = new JPanel();
        spanel.setLayout(new BorderLayout());
        spanel.add("North", p_display);
        spanel.add("Center", p_layout);
        BorderPanel gradientPanel = new BorderPanel(LanguageEncoder.getText("Gradient"));
        gradientPanel.setLayout(new FlowLayout(0));
        this.enableGradient = new JCheckBox(LanguageEncoder.getText("Enable Gradient"), this.legend.area.isGradientEnabled());
        this.gradientOption = new JButton(LanguageEncoder.getText("Customize..."));
        this.enableGradient.addItemListener(this);
        this.gradientOption.setEnabled(this.enableGradient.isSelected());
        gradientPanel.add(this.enableGradient);
        gradientPanel.add(this.gradientOption);
        this.gradientOption.addActionListener(this);
        JPanel sbpanel = new JPanel();
        sbpanel.setLayout(new BorderLayout());
        this.areapanel = new AreaOptionPanel(this.legend.area, LanguageEncoder.getText("Effect"), true);
        sbpanel.add("North", this.areapanel);
        sbpanel.add("Center", gradientPanel);
        sbpanel.add("South", order_panel);
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.add("Center", spanel);
        this.add("East", sbpanel);
        this.itemStateChanged(null);
    }

    void getLegend() {
        this.legend.invalidate();
        if (this.ck_vert.isSelected()) {
            this.legend.setLayout(1);
        } else if (this.ck_horz.isSelected()) {
            this.legend.setLayout(0);
        } else if (this.ck_square.isSelected()) {
            this.legend.setLayout(2);
        } else if (this.ck_fixed_col.isSelected()) {
            this.legend.setLayout(3);
        }
        this.legend.setFixedColumnCount(this.spinNoOfColumn.getValue());
        this.legend.framearea.drawBorder = this.ck_border.isSelected();
        this.legend.drawSymbols(this.ck_symbols.isSelected());
        this.legend.reverse = this.ck_reverse.isSelected();
        this.legend.showLegend = this.ck_draw.isSelected();
        this.legend.useOneLegendSet = this.ck_oneLegendSet.isSelected();
        this.legend.area = this.areapanel.getArea();
        this.legend.area.drawArea = this.ck_background.isSelected();
        if (this.enableGradient.isEnabled()) {
            this.legend.area.setGradientEnabled(this.enableGradient.isSelected());
        } else {
            this.legend.area.setGradientEnabled(false);
        }
        if (this.gradientDialog != null) {
            this.gradientDialog.setValues();
        }
        this.legend.setPointSizeRatio(this.spinPtSizeRatio.getValue());
        this.legend.invalidate();
    }

    void resortLegend() {
        if (this.spinPtSizeRatio.getValue() != this.defaultPointSize) {
            this.legend.invalidate();
            this.legend.setPointSizeRatio(this.defaultPointSize);
            this.chartmain.qbpaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableGradient.setEnabled(this.ck_background.isSelected());
        this.gradientOption.setEnabled(this.ck_background.isSelected() && this.enableGradient.isSelected());
        this.areapanel.setEnable(this.ck_background.isSelected());
        this.spinNoOfColumn.setEnabled(this.ck_fixed_col.isSelected());
        this.legend.setxIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.spinPtSizeRatio) {
            this.legend.invalidate();
            this.legend.setPointSizeRatio(this.spinPtSizeRatio.getValue());
            this.chartmain.qbpaint();
        } else if (e.getSource() == this.gradientOption) {
            if (this.gradientDialog == null) {
                this.gradientDialog = new GradientDialog(this.chartmain, this, "Gradient Options");
            }
            this.gradientDialog.setVisible(true);
        }
    }

    @Override
    public void resetGradientDialog() {
        this.gradientDialog = null;
    }

    @Override
    public double getGradientStartX() {
        return this.legend.area.getGradientStartX();
    }

    @Override
    public double getGradientStartY() {
        return this.legend.area.getGradientStartY();
    }

    @Override
    public double getGradientEndX() {
        return this.legend.area.getGradientEndX();
    }

    @Override
    public double getGradientEndY() {
        return this.legend.area.getGradientEndY();
    }

    @Override
    public Color getGradientDesColor() {
        return this.legend.area.getGradientDesColor();
    }

    @Override
    public int getGradientShade() {
        return this.legend.area.getGradientShade();
    }

    @Override
    public boolean isGradientCyclic() {
        return this.legend.area.isGradientCyclic();
    }

    @Override
    public void setValues(GradientDialog gDialog) {
        this.legend.area.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.legend.area.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.legend.area.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.legend.area.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.legend.area.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.legend.area.setGradientDesColor(null);
        } else {
            this.legend.area.setGradientDesColor(gDialog.getButtonColor());
        }
        this.legend.area.setGradientCyclic(gDialog.checkCyclic.isSelected());
        this.legend.area.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.legend.area.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.legend.area.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.legend.area.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.legend.area.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.legend.area.setGradientDesColor(null);
        } else {
            this.legend.area.setGradientDesColor(gDialog.getButtonColor());
        }
        this.legend.area.setGradientCyclic(gDialog.checkCyclic.isSelected());
    }

    @Override
    public boolean is3DShadingEnabled() {
        return false;
    }

    @Override
    public boolean isGradientEnabled() {
        return false;
    }
}

