/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.ArrowSlideBar;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class LightDialog
extends QbDialog
implements ChangeListener {
    ChartMain chartmain;
    ArrowSlideBar amb_r;
    ArrowSlideBar amb_g;
    ArrowSlideBar amb_b;
    ArrowSlideBar int_r;
    ArrowSlideBar int_g;
    ArrowSlideBar int_b;
    JButton butResetAMB;
    JButton butResetINT;
    JButton butCancel;
    JButton butOK;
    float ambr;
    float ambg;
    float ambb;
    float intr;
    float intg;
    float intb;

    public LightDialog(ChartMain chartmain) {
        super(chartmain, LanguageEncoder.getText("Define Lighting Properties..."), true);
        this.chartmain = chartmain;
        this.setBackground(Color.lightGray);
        JPanel ambientpanel = new JPanel();
        ambientpanel.setLayout(new GridLayout(3, 1));
        BorderPanel RPanel = new BorderPanel();
        RPanel.add("West", new JLabel(LanguageEncoder.getText("R")));
        this.amb_r = new ArrowSlideBar(0.0, 255.0, true);
        RPanel.add("Center", this.amb_r);
        ambientpanel.add(RPanel);
        BorderPanel GPanel = new BorderPanel();
        GPanel.add("West", new JLabel(LanguageEncoder.getText("G")));
        this.amb_g = new ArrowSlideBar(0.0, 255.0, true);
        GPanel.add("Center", this.amb_g);
        ambientpanel.add(GPanel);
        BorderPanel BPanel = new BorderPanel();
        BPanel.add("West", new JLabel(LanguageEncoder.getText("B")));
        this.amb_b = new ArrowSlideBar(0.0, 255.0, true);
        BPanel.add("Center", this.amb_b);
        ambientpanel.add(BPanel);
        this.amb_r.setPreferredSize(new Dimension(290, 20));
        this.amb_g.setPreferredSize(new Dimension(290, 20));
        this.amb_b.setPreferredSize(new Dimension(290, 20));
        this.amb_r.addChangeListener(this);
        this.amb_g.addChangeListener(this);
        this.amb_b.addChangeListener(this);
        BorderPanel bambient = new BorderPanel(LanguageEncoder.getText("Ambient Color"));
        FlowLayout sharedLayout = new FlowLayout(2);
        bambient.setLayout(sharedLayout);
        bambient.add(ambientpanel);
        this.butResetAMB = new JButton(LanguageEncoder.getText("Reset"));
        Dimension buttDimension = new Dimension(100, 25);
        this.butResetAMB.setPreferredSize(buttDimension);
        bambient.add(this.butResetAMB);
        JPanel intensitypanel = new JPanel();
        intensitypanel.setLayout(new GridLayout(3, 1));
        BorderPanel RiPanel = new BorderPanel();
        RiPanel.add("West", new JLabel(LanguageEncoder.getText("R")));
        this.int_r = new ArrowSlideBar(0.0, 3.0, true);
        RiPanel.add("Center", this.int_r);
        intensitypanel.add(RiPanel);
        BorderPanel GiPanel = new BorderPanel();
        GiPanel.add("West", new JLabel(LanguageEncoder.getText("G")));
        this.int_g = new ArrowSlideBar(0.0, 3.0, true);
        GiPanel.add("Center", this.int_g);
        intensitypanel.add(GiPanel);
        BorderPanel BiPanel = new BorderPanel();
        BiPanel.add("West", new JLabel(LanguageEncoder.getText("B")));
        this.int_b = new ArrowSlideBar(0.0, 3.0, true);
        BiPanel.add("Center", this.int_b);
        intensitypanel.add(BiPanel);
        this.int_r.setPreferredSize(new Dimension(290, 20));
        this.int_g.setPreferredSize(new Dimension(290, 20));
        this.int_b.setPreferredSize(new Dimension(290, 20));
        this.int_r.addChangeListener(this);
        this.int_g.addChangeListener(this);
        this.int_b.addChangeListener(this);
        BorderPanel bintensity = new BorderPanel(LanguageEncoder.getText("Light Intensity"));
        bintensity.setLayout(sharedLayout);
        bintensity.add(intensitypanel);
        this.butResetINT = new JButton(LanguageEncoder.getText("Reset"));
        this.butResetINT.setPreferredSize(buttDimension);
        bintensity.add(this.butResetINT);
        JPanel mainPanel = new JPanel(new GridLayout(2, 1));
        mainPanel.add(bambient);
        mainPanel.add(bintensity);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", mainPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butCancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.butCancel);
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.butOK);
        this.butResetAMB.addActionListener(this);
        this.butResetINT.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butOK.addActionListener(this);
        float[] f = chartmain.chart.getAmbient();
        this.ambr = f[0];
        this.amb_r.setFValue(this.ambr);
        this.ambg = f[1];
        this.amb_g.setFValue(this.ambg);
        this.ambb = f[2];
        this.amb_b.setFValue(this.ambb);
        f = chartmain.chart.getIntensity();
        this.intr = f[0];
        this.int_r.setFValue(this.intr);
        this.intg = f[1];
        this.int_g.setFValue(this.intg);
        this.intb = f[2];
        this.int_b.setFValue(this.intb);
        cop.add("South", buttonPanel);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setSize(350, 370);
        }
        super.setVisible(b);
    }

    private void setvalue() {
        float[] f = new float[]{this.amb_r.getFValue(), this.amb_g.getFValue(), this.amb_b.getFValue()};
        this.chartmain.chart.setAmbient(f);
        f[0] = this.int_r.getFValue();
        f[1] = this.int_g.getFValue();
        f[2] = this.int_b.getFValue();
        this.chartmain.chart.setIntensity(f);
        this.chartmain.qbpaint();
    }

    private void restorevalue() {
        this.amb_r.setFValue(this.ambr);
        this.amb_g.setFValue(this.ambg);
        this.amb_b.setFValue(this.ambb);
        this.int_r.setFValue(this.intr);
        this.int_g.setFValue(this.intg);
        this.int_b.setFValue(this.intb);
        this.setvalue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setvalue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.butOK) {
            this.chartmain.setModified();
        } else {
            if (target == this.butResetAMB) {
                this.ambr = 0.0f;
                this.amb_r.setFValue(0.0f);
                this.ambg = 0.0f;
                this.amb_g.setFValue(0.0f);
                this.ambb = 0.0f;
                this.amb_b.setFValue(0.0f);
                return;
            }
            if (target == this.butResetINT) {
                this.intr = 1.5f;
                this.int_r.setFValue(1.5f);
                this.intg = 1.5f;
                this.int_g.setFValue(1.5f);
                this.intb = 1.5f;
                this.int_b.setFValue(1.5f);
                return;
            }
            this.restorevalue();
        }
        this.dispose();
    }
}

