/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class LineDialog
extends QbDialog {
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;
    JCheckBox checkBorder;
    JCheckBox checkDropBar;
    JCheckBox checkUniform;
    JCheckBox checkStep;
    JRadioButton verCheckbox;
    JRadioButton horCheckbox;
    JComboBox series1;
    JComboBox series2;
    JTextField stepRatio;
    boolean stateChanged = false;

    public LineDialog(JFrame frame, Chart chart) {
        super(frame, LanguageEncoder.getText("Line Chart Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        BorderPanel optionPanel = new BorderPanel();
        optionPanel.setLayout(new BorderLayout());
        JPanel mainPanel = this.chart.dataDim == 1 ? this.createUniformPanel() : this.createDropBarPanel();
        BorderPanel layoutPanel = new BorderPanel(LanguageEncoder.getText("Set Layout"));
        layoutPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.horCheckbox = new JRadioButton(LanguageEncoder.getText("Horizontal"), this.chart.getLayout() == 0);
        this.verCheckbox = new JRadioButton(LanguageEncoder.getText("Vertical"), this.chart.getLayout() == 1);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.horCheckbox);
        bg.add(this.verCheckbox);
        layoutPanel.add(this.horCheckbox);
        layoutPanel.add(this.verCheckbox);
        BorderPanel stepPanel = new BorderPanel(LanguageEncoder.getText("Step Line"));
        stepPanel.setLayout(new GridLayout(0, 1));
        this.checkStep = new JCheckBox(LanguageEncoder.getText("Draw Step Lines"), this.chart.showStepLine);
        this.chart.setStepLineState2(this.chart.showStepLine);
        this.checkStep.addItemListener(this);
        this.stepRatio = new JTextField(5);
        this.stepRatio.setText(Double.toString(this.chart.stepRatio));
        this.stepRatio.setEnabled(this.chart.showStepLine);
        this.stepRatio.addActionListener(this);
        JPanel ratioPanel = new JPanel();
        ratioPanel.setLayout(new FlowLayout(0));
        ratioPanel.add(new JLabel(LanguageEncoder.getText("The ratio of the step line")));
        ratioPanel.add(this.stepRatio);
        stepPanel.add(this.checkStep);
        stepPanel.add(ratioPanel);
        optionPanel.add("North", mainPanel);
        optionPanel.add("Center", layoutPanel);
        optionPanel.add("South", stepPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        cop.add("North", optionPanel);
        cop.add("Center", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private JPanel createUniformPanel() {
        BorderPanel uniformPanel = new BorderPanel(LanguageEncoder.getText("Line Options"));
        uniformPanel.setLayout(new BorderLayout());
        this.checkUniform = new JCheckBox(LanguageEncoder.getText("Set Points Uniform"));
        uniformPanel.add("Center", this.checkUniform);
        this.checkUniform.setSelected(this.chart.isSyncPointColorForLine());
        return uniformPanel;
    }

    private JPanel createDropBarPanel() {
        BorderPanel dropBarPanel = new BorderPanel(LanguageEncoder.getText("Drop Bar Options"));
        dropBarPanel.setLayout(new GridLayout(0, 2, 5, 5));
        Object[] fieldName = this.chart.colData[this.chart.mDataMap[0]].getFieldName();
        this.series1 = new JComboBox();
        this.series2 = new JComboBox();
        for (Object element : fieldName) {
            this.series1.addItem(element.toString());
            this.series2.addItem(element.toString());
        }
        dropBarPanel.add(new JLabel(LanguageEncoder.getText("Series A")));
        dropBarPanel.add(this.series1);
        dropBarPanel.add(new JLabel(LanguageEncoder.getText("Series B")));
        dropBarPanel.add(this.series2);
        this.checkDropBar = new JCheckBox(LanguageEncoder.getText("Draw Drop Bar"));
        dropBarPanel.add(this.checkDropBar);
        this.checkBorder = new JCheckBox(LanguageEncoder.getText("Draw Border"));
        dropBarPanel.add(this.checkBorder);
        this.series1.setSelectedIndex(this.chart.getDropBarSeries1() >= fieldName.length ? 0 : this.chart.getDropBarSeries1());
        this.series2.setSelectedIndex(this.chart.getDropBarSeries2() >= fieldName.length ? 0 : this.chart.getDropBarSeries2());
        this.checkDropBar.setSelected(this.chart.isShowDropBarForLine());
        this.checkBorder.setSelected(this.chart.getDropBarBorderState());
        this.setDropBarEnabled(this.chart.isShowDropBarForLine());
        this.checkDropBar.addItemListener(this);
        return dropBarPanel;
    }

    private String setValues() {
        if (this.chart.dataDim != 1) {
            return this.setDropBarValues();
        }
        this.chart.setSyncPointColorForLine(this.checkUniform.isSelected());
        return null;
    }

    private String setLineRatio() {
        if (this.stepRatio.getText() == null || this.stepRatio.getText().trim().equals("")) {
            return "Please enter step ratio value!";
        }
        this.chart.setStepLineRatio(Double.valueOf(this.stepRatio.getText()));
        this.chart.setStepLineRatio2(Double.valueOf(this.stepRatio.getText()));
        return null;
    }

    private String setDropBarValues() {
        if (this.checkDropBar.isSelected()) {
            int index1 = this.series1.getSelectedIndex();
            int index2 = this.series2.getSelectedIndex();
            if (index1 == -1) {
                return LanguageEncoder.getText("Please select Series A!");
            }
            if (index2 == -1) {
                return LanguageEncoder.getText("Please select Series B!");
            }
            if (index1 == index2) {
                return LanguageEncoder.getText("Series A cannot be the same as Series B!");
            }
            this.chart.setDropBarSeries1(index1);
            this.chart.setDropBarSeries2(index2);
            this.chart.setShowDropBarForLine(this.checkDropBar.isSelected());
            this.chart.setDropBarBorderState(this.checkBorder.isSelected());
        }
        this.chart.setShowDropBarForLine(this.checkDropBar.isSelected());
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.checkDropBar != null) {
            this.setDropBarEnabled(this.checkDropBar.isSelected());
        }
        this.setStepLineEnabled(this.checkStep.isSelected());
        this.stateChanged = true;
    }

    public void setStepLineEnabled(boolean b) {
        this.stepRatio.setEnabled(b);
        this.chart.setStepLineState(b);
        this.chart.setStepLineState2(b);
    }

    public void setDropBarEnabled(boolean b) {
        this.series1.setEnabled(b);
        this.series2.setEnabled(b);
        this.checkBorder.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            String msg = this.setLineRatio();
            if (msg == null) {
                msg = this.setValues();
            }
            if (msg == null) {
                this.chartMain.setModified();
                this.chart.setLayout(this.horCheckbox.isSelected() ? 0 : 1);
                this.chartMain.chartPanel.repaint();
                this.dispose();
            } else {
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(msg);
            }
            this.stateChanged = false;
        } else if (source == this.cancelButton) {
            if (this.stateChanged) {
                this.setStepLineEnabled(!this.checkStep.isSelected());
            }
            this.stateChanged = false;
            this.dispose();
        }
    }
}

