/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.HiLowMap;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.DBPanel;
import quadbase.chart.designer.WizardStep3;
import quadbase.chart.designer.WizardStep31;
import quadbase.chart.designer.WizardStep5;
import quadbase.common.swing.MessageDialog;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ModifyWizard
extends ChartWizard {
    private static final Logger LOGGER = Logger.getLogger(ModifyWizard.class.getName());
    private static int CHECKALL = 0;
    private static int CHECKTYPEONLY = 1;
    private static int CHECKNAMEONLY = 2;

    public ModifyWizard(ChartMain f, boolean updateQuery) {
        super(f, LanguageEncoder.getText("Modify Wizard"));
        this.registryID = f.chart.registryID;
        this.dataSourceID = f.chart.dataSourceID;
        this.dataSourceLoc = f.chart.dataSourceLoc;
        this.screensize = this.getToolkit().getScreenSize();
        this.setModifyWizard(true);
    }

    public ModifyWizard(ChartMain f) {
        super(f, LanguageEncoder.getText("Modify Wizard"));
        this.registryID = f.chart.registryID;
        this.dataSourceID = f.chart.dataSourceID;
        this.dataSourceLoc = f.chart.dataSourceLoc;
        this.screensize = this.getToolkit().getScreenSize();
        this.setBackground(Color.lightGray);
        this.setModifyWizard(true);
        this.newChart(true, null, false);
    }

    @Override
    void getFromDB() {
        if (this.step3 == null) {
            this.step3 = new WizardStep3(this);
            DBPanel dbpanel = this.step3.getDBPanel();
            Chart chart = this.chartmain.chart;
            if (chart.sourceData == 1) {
                dbpanel.setDBInfo(chart.dbInfo);
                dbpanel.filenameText.setText(chart.queryFilename);
            }
        }
        super.getFromDB();
    }

    @Override
    void getFromFile() {
        if (this.step31 == null) {
            this.step31 = new WizardStep31(this);
            Chart chart = this.chartmain.chart;
            if (chart.sourceData == 2 || chart.sourceData == 6 || chart.sourceData == 4) {
                this.step31.tf.setText(chart.sourceFile);
            }
        }
        super.getFromFile();
    }

    @Override
    void newchartType(boolean fromdb, JPanel prevPanel) {
        this.newPreview(this.chartmain.chart.chartType, this.chartmain.chart.is2DChart, prevPanel);
    }

    private boolean isRedoDataMapping() {
        if (this.colData == null) {
            return true;
        }
        if (this.chart == null) {
            this.chart = this.chartmain.chart;
        }
        if (this.chart.colData == null) {
            return true;
        }
        if (this.chart.colData.length != this.colData.length) {
            return true;
        }
        for (int i = 0; i < this.chart.colData.length; ++i) {
            if (this.sameType(this.chart.colData[i], this.colData[i])) continue;
            return true;
        }
        return false;
    }

    boolean redoDataMapping(JPanel prevPanel) {
        boolean redoMapping;
        if (this.chart == null) {
            this.chart = this.chartmain.chart;
        }
        if (this.chart.processedChart) {
            try {
                this.colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(this.colData), false, false, null, null, this.chart.isTimeChart() || this.chart.isHistogram() || this.chart.isAggregationChart() || this.chart.isDynamicDrillDown || this.chart.drillDownVector != null && this.chart.drillDownVector.size() > 0 ? this.chart.tsInfo : null, this.chart.isDrawNullColumn(), this.chart.getNullColumnName()));
            }
            catch (Exception ex) {
                String errMsg = null;
                if (this.chartmain.isFieldDrillDownChart()) {
                    errMsg = LanguageEncoder.getText("Please undo field drill-down before modify data source!");
                } else if (this.chartmain.isDrillDownEnabled()) {
                    errMsg = LanguageEncoder.getText("Please remove drill-down layer before modify data source!");
                } else if (this.chart.isTimeChart()) {
                    errMsg = LanguageEncoder.getText("Please undo zooming before modify data source!");
                } else if (this.chart.isHistogram()) {
                    errMsg = LanguageEncoder.getText("Please remove histogram before modify data source!");
                } else if (this.chart.isAggregationChart()) {
                    errMsg = LanguageEncoder.getText("Please remove aggregation before modify data source!");
                }
                LOGGER.log(Level.FINEST, "Cannot map data column: " + errMsg, ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot map data column.") + " " + errMsg);
                return true;
            }
        }
        if (!(redoMapping = this.isRedoDataMapping())) {
            this.colData = this.chart.colData;
        } else {
            MappingInfo mInfo = this.remapColInfo();
            if (mInfo != null) {
                this.chart.mDataMap = mInfo.mDataMap;
                this.chart.coordCol = mInfo.coordCol;
                this.chart.hilowCol = mInfo.hilowCol;
                this.chart.subvalueCol = mInfo.subvalueCol;
                this.chart.valueCol = mInfo.valueCol;
                redoMapping = false;
            }
        }
        if (!redoMapping) {
            super.doneWizard(this.chart);
            this.chartmain.do_Refresh();
            if (this.chartmain.filename != null && this.chartmain.filename.endsWith(".tpl")) {
                this.chartmain.do_loadTemplate(this.chartmain.filename);
            }
        } else {
            this.newchartType(true, prevPanel);
        }
        return redoMapping;
    }

    private MappingInfo remapColInfo() {
        int i;
        MappingInfo mInfo = new MappingInfo();
        int[] newMapping = this.getColDataMapping(this.chart.colData, this.colData, CHECKALL);
        if (newMapping == null) {
            newMapping = this.getColDataMapping(this.chart.colData, this.colData, CHECKTYPEONLY);
        }
        if (newMapping == null) {
            newMapping = this.getColDataMapping(this.chart.colData, this.colData, CHECKNAMEONLY);
        }
        if (newMapping == null) {
            return null;
        }
        mInfo.mDataMap = new int[this.chart.mDataMap.length];
        for (i = 0; i < mInfo.mDataMap.length; ++i) {
            mInfo.mDataMap[i] = i < this.chart.dataDim ? newMapping[this.chart.mDataMap[i]] : this.chart.mDataMap[i];
        }
        mInfo.valueCol = newMapping[this.chart.valueCol];
        mInfo.subvalueCol = -1;
        if (this.chart.subvalueCol >= 0) {
            mInfo.subvalueCol = newMapping[this.chart.subvalueCol];
        }
        mInfo.coordCol = null;
        if (this.chart.coordCol != null) {
            mInfo.coordCol = new int[this.chart.coordCol.length];
            for (i = 0; i < mInfo.coordCol.length; ++i) {
                mInfo.coordCol[i] = this.chart.coordCol[i] >= 0 ? newMapping[this.chart.coordCol[i]] : this.chart.coordCol[i];
            }
        }
        if (this.chart.coordCol != null) {
            mInfo.coordCol = new int[this.chart.coordCol.length];
            for (i = 0; i < mInfo.coordCol.length; ++i) {
                mInfo.coordCol[i] = this.chart.coordCol[i] >= 0 ? newMapping[this.chart.coordCol[i]] : this.chart.coordCol[i];
            }
        }
        mInfo.hilowCol = null;
        if (this.chart.hilowCol != null) {
            mInfo.hilowCol = new HiLowMap();
            if (this.chart.hilowCol.close >= 0) {
                mInfo.hilowCol.close = newMapping[this.chart.hilowCol.close];
            }
            if (this.chart.hilowCol.hi >= 0) {
                mInfo.hilowCol.hi = newMapping[this.chart.hilowCol.hi];
            }
            if (this.chart.hilowCol.low >= 0) {
                mInfo.hilowCol.low = newMapping[this.chart.hilowCol.low];
            }
            if (this.chart.hilowCol.open >= 0) {
                mInfo.hilowCol.open = newMapping[this.chart.hilowCol.open];
            }
        }
        return mInfo;
    }

    private int[] getColDataMapping(ColData[] orgData, ColData[] newData, int checkLevel) {
        int i;
        int newColIdx = orgData.length - 1;
        int[] newMapping = new int[newData.length - 1];
        for (i = 0; i < newMapping.length; ++i) {
            newMapping[i] = -1;
        }
        for (i = 0; i < newData.length - 1; ++i) {
            boolean matched = false;
            for (int j = 0; j < Math.min(orgData.length - 1, newData.length - 1); ++j) {
                if (newMapping[j] != -1 || !this.equals(newData[i], orgData[j], checkLevel)) continue;
                newMapping[j] = i;
                matched = true;
                break;
            }
            if (matched) continue;
            if (newColIdx >= newMapping.length) {
                return null;
            }
            newMapping[newColIdx] = i;
            ++newColIdx;
        }
        return newMapping;
    }

    private boolean sameType(ColData colData1, ColData colData2) {
        return DataType.isCompatibleSQLTypes(colData1.getOriginalDataType(), colData2.getOriginalDataType());
    }

    private boolean equals(ColData colData1, ColData colData2, int checkLevel) {
        if (checkLevel == CHECKALL || checkLevel == CHECKTYPEONLY) {
            if (!this.sameType(colData1, colData2)) {
                return false;
            }
            if (checkLevel == CHECKTYPEONLY) {
                return true;
            }
        }
        if (checkLevel == CHECKALL || checkLevel == CHECKNAMEONLY) {
            if (!colData1.getName().equalsIgnoreCase(colData2.getName())) {
                return false;
            }
            if (checkLevel == CHECKNAMEONLY) {
                return true;
            }
        }
        if (colData1.getTableName() == null || colData2.getTableName() == null) {
            return true;
        }
        return colData1.getTableName().equalsIgnoreCase(colData2.getTableName());
    }

    @Override
    void doneWizard(Chart chart) {
        super.doneWizard(chart);
        if (this.chartmain.filename != null && this.chartmain.filename.endsWith(".tpl")) {
            this.chartmain.do_loadTemplate(this.chartmain.filename);
        }
    }

    @Override
    void getStep4() {
        if (this.sourceData == 3 && this.stepMerge41 != null) {
            this.swapPanel(this.step5, this.stepMerge41);
        } else {
            this.swapPanel(this.step5, this.stepMulti);
        }
    }

    private void newPreview(int ctype, boolean is2D, JPanel prevPanel) {
        try {
            this.step5 = new WizardStep5((ChartWizard)this, ctype, is2D, this.chartmain.chartPanel.chart);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to initialize wizard step nr. 5", ex);
            new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(ex.toString());
            return;
        }
        this.setVisible(false);
        this.remove(prevPanel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.step5);
        this.pack();
        super.setBounds(0, 0, 950, 600);
        this.validate();
        this.setVisible(true);
    }

    @Override
    void displayResult(JPanel removedPanel) {
        if (this.sameColData()) {
            this.doneWizard(this.chartmain.chart.setNewData(this.colData));
        } else {
            if (this.chartmain != null && this.chartmain.chart != null) {
                this.isTransposed = this.chartmain.chart.isTransposed();
                this.transposeCol = this.chartmain.chart.getTransposeColumn();
            }
            super.displayResult(removedPanel);
        }
    }

    private boolean sameColData() {
        ColData[] set1 = this.chartmain.chart.colData;
        int set1Len = set1.length;
        ColData[] set2 = this.colData;
        int set2Len = set2.length;
        if (set1Len != set2Len) {
            return false;
        }
        if (set1[0].getSize() != set2[0].getSize()) {
            return false;
        }
        for (int i = 0; i < set1Len; ++i) {
            if (set1[i].getDataType() == set2[i].getDataType() && set1[i].getName().equals(set2[i].getName())) continue;
            return false;
        }
        return true;
    }

    class MappingInfo {
        int[] mDataMap;
        int valueCol;
        int subvalueCol;
        int[] coordCol;
        HiLowMap hilowCol = null;

        MappingInfo() {
        }
    }
}

