/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.FontPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.color.ColorDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class NoDataToPlotMessageDialog
extends QbDialog {
    ChartMain chartmain;
    Chart chart;
    FontPanel fontPanel;
    JButton okButton;
    JButton cancelButton;
    JTextField message = null;
    ColorButton colorBut;

    public NoDataToPlotMessageDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.setBackground(Color.lightGray);
        this.colorBut = new ColorButton(LanguageEncoder.getText("Click"));
        this.setButtonColor(this.chart.getNoDataToPlotMessageColor());
        BorderPanel drawpanel = new BorderPanel(LanguageEncoder.getText("No Data To Plot Message"));
        drawpanel.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(2, 1, 5, 5));
        labelPanel.add(new JLabel("Message "));
        labelPanel.add(new JLabel("Color   "));
        JPanel itemPanel = new JPanel();
        itemPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.message = new JTextField(this.chart.getNoDataToPlotMessage(), 15);
        itemPanel.add(this.message);
        itemPanel.add(this.colorBut);
        drawpanel.add("West", labelPanel);
        drawpanel.add("Center", itemPanel);
        this.colorBut.addActionListener(this);
        this.fontPanel = new FontPanel(this.chart.getNoDataToPlotMessageFont(), this.chart.getNoDataToPlotMessageAngle());
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("North", drawpanel);
        cop.add("Center", this.fontPanel);
        JPanel but_panel = new JPanel();
        but_panel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        but_panel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        but_panel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        cop.add("South", but_panel);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
        }
        super.setVisible(b);
    }

    private void restoreValue() {
        this.chart.setNoDataToPlotMessage(this.message.getText());
        this.chart.setNoDataToPlotMessageAngle(this.fontPanel.getAngle());
        this.chart.setNoDataToPlotMessageFont(this.fontPanel.getNewFont());
        this.chart.setNoDataToPlotMessageVisible(true);
        this.chart.setNoDataToPlotMessageColor(this.getButtonColor());
    }

    private Color getButtonColor() {
        return this.colorBut.getColor();
    }

    private void setButtonColor(Color color) {
        this.colorBut.setColor(color);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.colorBut) {
            Color currentColor = NoDataToPlotMessageDialog.showDialog(this.chartmain, LanguageEncoder.getText("Set Border Color..."), this.getButtonColor());
            if (currentColor != null) {
                this.setButtonColor(currentColor);
            }
            return;
        }
        this.setVisible(false);
        this.dispose();
        if (e.getSource() == this.okButton) {
            this.restoreValue();
            this.chartmain.chartPanel.repaint();
            this.chartmain.setModified();
        }
    }

    private static Color showDialog(ChartMain chartMain, String title, Color initColor) {
        return ColorDialog.showDialog(chartMain, title, initColor);
    }
}

