/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class NullDataPropertiesDialog
extends QbDialog {
    static final int LEN = 15;
    JTextField nullColumnField;
    JButton okButton;
    JButton cancelButton;
    JCheckBox checkDrawNullColumn;
    Chart chart;
    ChartMain chartMain;

    public NullDataPropertiesDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartMain = frame;
        this.chart = this.chartMain.chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.checkDrawNullColumn = new JCheckBox(LanguageEncoder.getText("Draw Null Column"), this.chart.isDrawNullColumn());
        this.nullColumnField = new JTextField(this.chart.getNullColumnName(), 15);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.checkDrawNullColumn.addItemListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        BorderPanel borderPanel = new BorderPanel(LanguageEncoder.getText("Null Data Column"));
        borderPanel.setLayout(new FlowLayout(1));
        borderPanel.add(this.checkDrawNullColumn);
        borderPanel.add(this.nullColumnField);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.add("Center", borderPanel);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.itemStateChanged(null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.nullColumnField.setEnabled(this.checkDrawNullColumn.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.chart.setDrawNullColumn(this.checkDrawNullColumn.isSelected());
            if (this.checkDrawNullColumn.isSelected()) {
                this.chart.setNullColumnName(this.nullColumnField.getText());
            }
            this.chartMain.setModified();
            this.setVisible(false);
            this.dispose();
            this.chartMain.do_Refresh();
            return;
        }
        if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
            return;
        }
    }
}

