/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.chart.SaveChart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.SelectViewerDialog;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class OpenSaveDialog
extends QbDialog {
    public static final int NONE = 0;
    public static final int OPENCHART = 1;
    public static final int OPENTEMPLATE = 2;
    public static final int SAVECHART = 3;
    public static final int PAC = 0;
    public static final int CHT = 1;
    public static final int TPL = 2;
    public static final int XML = 3;
    private static final Logger LOGGER = Logger.getLogger(OpenSaveDialog.class.getName());
    protected JTextField chartNameTextField;
    protected JTextField dbtf;
    private JCheckBox createHtml = null;
    private JCheckBox createXML = null;
    private ChartMain chartmain;
    private JButton okButton;
    private JButton cancelButton;
    private JButton browseButton;
    private boolean runquery = false;
    private JRadioButton saveToDatabase = null;
    private JRadioButton saveToFile = null;
    private int mode;
    private BrowseDialog bDialog = null;
    private JFileChooser fDialog = null;
    private JComboBox choiceFormats;
    private JPanel saveToDBPanel;
    private String currentDir = "";
    private String dbLabel = null;

    public OpenSaveDialog(ChartMain frame, String title) {
        this(frame, title, 0, 0);
    }

    public OpenSaveDialog(ChartMain frame, String title, int mode) {
        this(frame, title, mode, 0);
    }

    public OpenSaveDialog(ChartMain frame, String title, int mode, int defaultSaveFormat) {
        super(frame, title, true);
        this.mode = mode;
        this.chartmain = frame;
        this.setBackground(Color.lightGray);
        this.chartNameTextField = new JTextField(42);
        this.chartNameTextField.addActionListener(this);
        this.createXML = new JCheckBox(LanguageEncoder.getText("Create XML"), false);
        this.createHtml = new JCheckBox(LanguageEncoder.getText("Create HTML File"), false);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.choiceFormats = new JComboBox();
        this.choiceFormats.addItem(LanguageEncoder.getText("PAC - Chart In Pack Format"));
        this.choiceFormats.addItem(LanguageEncoder.getText("CHT - Chart Format"));
        this.choiceFormats.addItem(LanguageEncoder.getText("TPL - Chart Template"));
        if (defaultSaveFormat != 3) {
            this.choiceFormats.setSelectedIndex(defaultSaveFormat);
        }
        this.createXML.setSelected(defaultSaveFormat == 3);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        p3.add((Component)new JLabel(LanguageEncoder.getText("Path")), gbc);
        if (mode != 1 && mode != 2) {
            gbc.gridy = 1;
            p3.add((Component)new JLabel(LanguageEncoder.getText("Type")), gbc);
        }
        int colspan = 0;
        gbc.gridy = 1;
        if (mode != 1 && mode != 2) {
            ++gbc.gridx;
            ++colspan;
            p3.add((Component)this.choiceFormats, gbc);
        }
        if (ServerMessage.useServer && mode != 1 && mode != 2 && !LCKey.isDashboardOnly()) {
            ++gbc.gridx;
            ++colspan;
        }
        if (mode != 1 && mode != 2) {
            ++gbc.gridx;
            ++colspan;
            p3.add((Component)this.createXML, gbc);
        }
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = colspan;
        gbc.weightx = 1.0;
        p3.add((Component)this.chartNameTextField, gbc);
        this.dbtf = this.chartmain.getItemName() != null && !this.chartmain.getItemName().equals("") ? new JTextField(this.chartmain.getItemName(), 30) : new JTextField(30);
        this.saveToDBPanel = new JPanel();
        this.saveToDBPanel.setLayout(new BorderLayout());
        this.saveToDBPanel.add("West", new JLabel(LanguageEncoder.getText("Name")));
        this.saveToDBPanel.add("Center", this.dbtf);
        this.saveToFile = new JRadioButton(LanguageEncoder.getText("Save To File"), true);
        this.saveToDatabase = new JRadioButton(LanguageEncoder.getText("Save To Database"), false);
        this.saveToFile.addItemListener(this);
        this.saveToDatabase.addItemListener(this);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.saveToFile);
        group2.add(this.saveToDatabase);
        this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
        this.browseButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        if (mode != 1 && mode != 2 && this.chartmain.allowOpeningSaveAsDialogForSaveColorsForCategories) {
            this.chartNameTextField.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.createXML.setEnabled(false);
            this.choiceFormats.setEnabled(false);
        }
        if (ServerMessage.getForcedSaveDirectory() != null && mode != 1 && mode != 2) {
            p2.add(new JLabel());
        } else {
            p2.add(this.browseButton);
        }
        p2.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        p2.add(this.cancelButton);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (this.chartmain.isFromOrganizer() && this.getTitle().startsWith(LanguageEncoder.getText("Save As"))) {
            JPanel selectPanel1 = new JPanel();
            selectPanel1.setBorder(new TitledBorder("Save To File"));
            selectPanel1.setLayout(new BorderLayout());
            selectPanel1.add("Center", p3);
            JPanel selectPanel2 = new JPanel();
            selectPanel2.setLayout(new BorderLayout());
            selectPanel2.setBorder(new TitledBorder("Save To Database"));
            selectPanel2.add("North", this.saveToDatabase);
            cop.add("Center", selectPanel1);
            cop.add("South", p2);
            this.pack();
        } else {
            cop.add("Center", p3);
            cop.add("South", p2);
            this.setSize(400, 110);
        }
        this.chartNameTextField.requestFocus();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
        }
        super.setVisible(b);
    }

    private String loadFile() {
        String[] ext = this.mode == 2 ? new String[]{"TPL", "XML"} : (this.mode == 1 ? new String[]{"TPL", "CHT", "XML", "PAC"} : new String[]{"TPL", "CHT", "PAC"});
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fDialog == null) {
                this.fDialog = new JFileChooser();
                this.fDialog.setCurrentDirectory(new File(this.currentDir));
                this.fDialog.setFileFilter(new ExtensionFilter(ext));
            }
            this.fDialog.setCurrentDirectory(new File(this.currentDir));
            this.fDialog.showDialog(this, null);
            if (this.fDialog.getSelectedFile() == null) {
                return null;
            }
            this.currentDir = this.fDialog.getCurrentDirectory().getAbsolutePath();
            return this.fDialog.getSelectedFile().getAbsolutePath();
        }
        if (this.bDialog == null) {
            this.bDialog = BrowseDialog.create(this.chartmain, this.currentDir, ext, true, false);
        }
        this.bDialog.setVisible(true);
        this.currentDir = this.bDialog.getCurrentDirectory();
        return this.bDialog.getSelectedFile();
    }

    private boolean isTemplate() {
        return this.choiceFormats.getSelectedIndex() == 2;
    }

    private boolean isPack() {
        return this.choiceFormats.getSelectedIndex() == 0;
    }

    private boolean isXML() {
        return this.createXML.isSelected();
    }

    private boolean isHTML() {
        return this.createHtml.isSelected();
    }

    public String getDBLabel() {
        return this.saveToDatabase.isSelected() ? this.dbLabel : null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename = this.chartNameTextField.getText();
        if (e.getSource() == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null) {
                this.chartNameTextField.setText(fileText);
            }
            return;
        }
        if (e.getSource() != this.cancelButton) {
            String newName;
            int dirIdx;
            if (filename == null || filename.equals("")) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter file name"));
                return;
            }
            if (this.mode == 1) {
                if (this.chartmain.do_openChart(this.chartmain.getPath(this.chartNameTextField.getText()))) {
                    this.chartmain.linkhistory.removeAllElements();
                    this.setVisible(false);
                    this.dispose();
                }
                return;
            }
            if (this.mode == 2) {
                this.setVisible(false);
                this.dispose();
                this.chartmain.do_loadTemplate(this.chartmain.getPath(this.chartNameTextField.getText()));
                return;
            }
            if (ServerMessage.getForcedSaveDirectory() != null) {
                if (filename.contains("/") || filename.contains("\\")) {
                    new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("File name cannot contain / and \\."));
                    return;
                }
                filename = this.chartmain.getPath(ServerMessage.getForcedSaveDirectory() + "/" + filename);
            } else {
                filename = this.chartmain.getPath(filename);
            }
            if (this.mode == 3) {
                if (this.chartmain.chart.chartType != 3 && this.chartmain.chart.getComboType() != 0) {
                    this.chartmain.chart.setStepLineState(false);
                    this.chartmain.chart.setStepLineState2(false);
                }
                if (this.saveToDatabase.isSelected()) {
                    this.dbLabel = this.dbtf.getText();
                    if (this.dbLabel.equals("")) {
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please enter a database file name!"));
                        return;
                    }
                    if (QbUtil.containInvalidChar(this.dbLabel)) {
                        String msg = LanguageEncoder.getText("A database file name cannot contain any of the following characters:") + " " + QbUtil.invalidCharSet;
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                        return;
                    }
                    if (this.chartmain.isFileNameExisted(this.dbLabel) && !this.dbLabel.equalsIgnoreCase(this.chartmain.getItemName())) {
                        String msg = LanguageEncoder.getText("A file with the name you specified already exists in the organizer folder.  Do you want specify a different file name?");
                        JMessageDialog dialog = new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg, 1);
                        int response = dialog.getResponse();
                        if (response == 4) {
                            return;
                        }
                        if (response == 7) {
                            this.setVisible(false);
                            this.dispose();
                            return;
                        }
                    }
                    this.chartmain.do_SaveToDatabase(this.dbLabel);
                    this.setVisible(false);
                    this.dispose();
                    return;
                }
                if (filename.endsWith(".xml")) {
                    filename.substring(0, filename.length() - 4);
                }
                if (this.isTemplate() && !filename.endsWith(".tpl")) {
                    filename = filename + ".tpl";
                } else if (this.isPack() && !filename.endsWith(".pac")) {
                    filename = filename + ".pac";
                } else if (!(this.isTemplate() || this.isPack() || filename.endsWith(".cht") || filename.endsWith(".qch"))) {
                    filename = filename + ".cht";
                } else if (this.isXML() && !filename.endsWith(".xml")) {
                    filename = filename + ".xml";
                }
                String newName2 = filename.substring(0, filename.length() - 4);
                int dirIdx2 = newName2.lastIndexOf(47);
                if (dirIdx2 == newName2.length() - 1) {
                    new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter file name"));
                    return;
                }
                dirIdx2 = newName2.lastIndexOf(92);
                if (dirIdx2 == newName2.length() - 1) {
                    new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter file name"));
                    return;
                }
                if (!this.chartmain.allowOpeningSaveAsDialogForSaveColorsForCategories && !OverWriteDialog.continueSave(this.chartmain, filename)) {
                    return;
                }
                int viewerType = 0;
                boolean useSwing = false;
                if (this.createHtml.isSelected()) {
                    SelectViewerDialog viewerDialog = new SelectViewerDialog(this.chartmain);
                    viewerDialog.setVisible(true);
                    if (viewerDialog.isCancelled()) {
                        return;
                    }
                    viewerType = viewerDialog.getValue();
                    useSwing = viewerDialog.getSwingValue();
                }
                this.setVisible(false);
                this.dispose();
                this.chartmain.do_saveChart(filename, this.isHTML(), viewerType, useSwing, this.isXML());
                return;
            }
            if (!filename.endsWith(".cht") && !filename.endsWith(".qch")) {
                filename = filename + ".cht";
            }
            if ((dirIdx = (newName = filename.substring(0, filename.length() - 4)).lastIndexOf(47)) == newName.length() - 1) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter file name"));
                return;
            }
            dirIdx = newName.lastIndexOf(92);
            if (dirIdx == newName.length() - 1) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter file name"));
                return;
            }
            if (!OverWriteDialog.continueSave(this.chartmain, filename)) {
                return;
            }
            int viewerType = 0;
            boolean useSwing = false;
            if (this.isHTML()) {
                SelectViewerDialog viewerDialog = new SelectViewerDialog(this.chartmain);
                viewerDialog.setVisible(true);
                if (viewerDialog.isCancelled()) {
                    return;
                }
                viewerType = viewerDialog.getValue();
                useSwing = viewerDialog.getSwingValue();
            }
            this.setVisible(false);
            this.dispose();
            newName = this.chartNameTextField.getText();
            newName = this.chartmain.getPath(newName);
            String oldtitle = this.chartmain.getTitle();
            this.chartmain.setTitle(LanguageEncoder.getText("Saving..."));
            try {
                SaveChart sChart = new SaveChart(this.chartmain.chartPanel.chart);
                sChart.generateHtmlFile(this.isHTML(), viewerType, useSwing);
                sChart.generateXMLFile(this.isXML());
                sChart.save(newName);
                this.chartmain.insertChartFileToOrganizer(null, this.isXML());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to save in file" + newName, ex);
                this.chartmain.setTitle(oldtitle);
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Fail to save in file") + " " + newName + "\n" + ex.toString());
                return;
            }
            this.chartmain.setTitle(newName);
            this.chartmain.setUnModified();
            if (this.runquery) {
                this.chartmain.doQuery();
            }
            if (this.chartmain.isClose) {
                this.dispose();
                this.chartmain.do_exit();
            }
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getItem();
        if (obj == this.saveToDatabase || obj == this.saveToFile) {
            if (this.chartNameTextField != null) {
                this.chartNameTextField.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.dbtf != null) {
                this.dbtf.setEnabled(this.saveToDatabase.isSelected());
            }
            if (this.choiceFormats != null) {
                this.choiceFormats.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.createHtml != null) {
                this.createHtml.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.createXML != null) {
                this.createXML.setEnabled(!this.saveToDatabase.isSelected());
            }
            if (this.browseButton != null) {
                this.browseButton.setEnabled(!this.saveToDatabase.isSelected());
            }
        }
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(String dir) {
        this.setCurrentDirectory(dir, dir);
    }

    public void setCurrentDirectory(String dir, String defaultFileName) {
        if (ServerMessage.getForcedSaveDirectory() != null) {
            this.currentDir = "";
            if (defaultFileName != null && !defaultFileName.replace('\\', '/').contains("/")) {
                this.chartNameTextField.setText(QbUtil.getFileName(defaultFileName));
            } else {
                this.chartNameTextField.setText("");
            }
        } else {
            this.currentDir = dir;
            if (this.chartNameTextField != null && this.chartNameTextField.getText().equals("")) {
                if (defaultFileName != null) {
                    String tmp = QbUtil.replace(defaultFileName, "*", "");
                    this.chartNameTextField.setText(tmp);
                } else if (this.currentDir != null) {
                    String tmp = QbUtil.replace(this.currentDir, "*", "");
                    this.chartNameTextField.setText(tmp);
                } else {
                    this.chartNameTextField.setText(this.currentDir);
                }
            }
        }
    }
}

