/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.PreprocInfo;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartOption;
import quadbase.chart.designer.ChartType;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class OptionDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(OptionDialog.class.getName());
    boolean bcompute = true;
    Chart chart;
    ChartType chartTypePanel;
    ChartOption chartOptionPanel;
    Dimension screensize;
    ChartMain chartMain;
    boolean changeType = true;
    boolean isChartType = false;
    String oldCategoryColumn = null;
    boolean usingChartInChartMain = true;
    boolean isCancelled = true;

    public OptionDialog(ChartMain chartMain) {
        this(chartMain, chartMain.chartPanel.chart, true);
    }

    public OptionDialog(ChartMain chartMain, Chart displayChart, boolean usingChartInChartMain) {
        super(chartMain, LanguageEncoder.getText("Options..."), true);
        this.chartMain = chartMain;
        this.chart = displayChart;
        this.usingChartInChartMain = usingChartInChartMain;
        this.chartOptionPanel = new ChartOption(this.chart.parameters, false);
        this.chartOptionPanel.addActionListener(this);
        this.oldCategoryColumn = this.chart.getCategoryName();
    }

    public void init() {
        this.init(this.chartMain.chartPanel.chart);
    }

    public void init(Chart inputChart) {
        this.chart = inputChart;
        this.isChartType = false;
        this.setDefaultTitle();
        this.chartOptionPanel.initialize(this.chart.chartType, this.chart.is2DChart, this.chart.colData, this.chart);
        this.chartOptionPanel.chartPanel.progressiveDraw = true;
        this.changeType = false;
        this.chartOptionPanel.chartPanel.setDialog(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.chartOptionPanel);
        this.screensize = this.getToolkit().getScreenSize();
        this.setBounds((this.screensize.width - this.chartOptionPanel.width) / 2, (this.screensize.height - this.chartOptionPanel.height) / 2, this.chartOptionPanel.width, this.chartOptionPanel.height);
    }

    public void initialize(boolean reloadData) {
        this.initialize(this.chartMain.chartPanel.chart, reloadData);
    }

    private void initialize(Chart inputChart, boolean reloadData) {
        this.chart = inputChart;
        this.setDefaultTitle();
        if (this.changeType || reloadData) {
            this.chartOptionPanel.initialize(this.chart.chartType, this.chart.is2DChart, this.chart.colData, this.chart, reloadData);
            this.changeType = false;
        } else {
            this.chartOptionPanel.setValues(this.chart);
        }
        this.chartOptionPanel.chartPanel.progressiveDraw = true;
        this.oldCategoryColumn = this.chart.getCategoryName();
    }

    private void setDefaultTitle() {
        this.setTitle(LanguageEncoder.getText("Select Data Mapping for") + " " + Chart.TypeName(this.chart.chartType, this.chart.is2DChart));
    }

    public Chart getChart() {
        if (this.chartOptionPanel != null && this.chartOptionPanel.chartPanel != null && this.chartOptionPanel.chartPanel.chart != null) {
            return this.chartOptionPanel.chartPanel.chart;
        }
        return this.chart;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            this.isCancelled = true;
            this.chartOptionPanel.chartRepaint(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error closing window", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (this.chartTypePanel != null && target == this.chartTypePanel.cancel || target == this.chartOptionPanel.butcancel) {
            this.isCancelled = true;
            this.setVisible(false);
            return;
        }
        int oldtype = this.chartOptionPanel.chartPanel.chart.chartType;
        if (this.chartTypePanel != null && target == this.chartTypePanel.buttonNext) {
            this.setTitle(LanguageEncoder.getText("Please wait..."));
            try {
                this.chartOptionPanel.initialize(this.chartTypePanel.chartType, this.chartTypePanel.is2DChart, this.chart.colData, this.chartOptionPanel.chartPanel.chart);
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage() == null) {
                    LOGGER.log(Level.FINE, "No data to plot", ex);
                    new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("No data to plot"));
                } else {
                    LOGGER.log(Level.FINE, "Failed to initialize chart option panel", ex);
                    new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(ex.getMessage());
                }
                this.setDefaultTitle();
                return;
            }
            this.chartOptionPanel.chartPanel.setDialog(this);
            this.chart = this.chartOptionPanel.chart;
            if (this.chart.chartType != oldtype) {
                this.chart.setDefault();
            }
            this.setVisible(false);
            this.removeAll();
            this.add("Center", this.chartOptionPanel);
            this.validate();
            this.setDefaultTitle();
            this.setBounds(0, 0, this.chartOptionPanel.width, this.chartOptionPanel.height);
            this.setLocation((this.screensize.width - this.chartOptionPanel.width) / 2, (this.screensize.height - this.chartOptionPanel.height) / 2);
            this.isChartType = false;
            this.setVisible(true);
            if (target == this.chartTypePanel.buttonNext) {
                this.changeType = true;
            }
            return;
        }
        if (target == this.chartOptionPanel.butprev) {
            if (this.chartTypePanel == null) {
                this.chartTypePanel = new ChartType(this);
                this.chartTypePanel.addActionListener(this);
                this.chartTypePanel.init(false);
            }
            this.chartTypePanel.setType(this.chart.chartType, this.chart.is2DChart);
            this.setVisible(false);
            this.removeAll();
            this.add("Center", this.chartTypePanel);
            this.pack();
            this.validate();
            this.setTitle(LanguageEncoder.getText("Select Chart Type"));
            this.isChartType = true;
            this.setSize(570, 500);
            this.setVisible(true);
            return;
        }
        if (target == this.chartOptionPanel.fetchButton) {
            LOGGER.finest("OptionDialog: fetch button event received");
            this.chartOptionPanel.chartPanel.chart.setTimeChart(true);
            this.chartMain.chartPanel.chart = this.chartMain.chart = this.chartOptionPanel.chartPanel.chart;
            PreprocInfo tsInfo = this.chartMain.chart.getPreprocInfo();
            tsInfo.aggrOp[0] = 0;
            tsInfo.isLinear = false;
            tsInfo.bRounded = false;
            tsInfo.selectColType = this.chartOptionPanel.chart.getCategoryType();
            this.chartMain.do_Reload();
        }
        if (target == this.chartOptionPanel.butdone) {
            this.chartMain.setShowReportDataHasChangedDialog(false);
            if (!this.usingChartInChartMain) {
                this.isCancelled = false;
                this.setVisible(false);
                return;
            }
            String newCategoryColumn = null;
            int subValueMap = -1;
            boolean secondaryAxis = false;
            boolean showAggregateDialog = false;
            newCategoryColumn = this.chartOptionPanel.chartPanel.chart.getCategoryName();
            int categoryType = this.chartOptionPanel.chartPanel.chart.getCategoryType();
            subValueMap = this.chartOptionPanel.chartPanel.chart.getSubValueMap();
            secondaryAxis = subValueMap >= 0;
            if (!this.oldCategoryColumn.equalsIgnoreCase(newCategoryColumn)) {
                this.chartOptionPanel.chartPanel.chart.setTimeChart(false);
                this.chartOptionPanel.chartPanel.chart.clearPreprocInfo();
                showAggregateDialog = true;
                this.oldCategoryColumn = newCategoryColumn;
                switch (categoryType) {
                    case 92: {
                        LOGGER.finest("New category type: Types.TIME");
                        break;
                    }
                    case 91: {
                        LOGGER.finest("New category type: Types.DATE");
                        break;
                    }
                    case 93: {
                        LOGGER.finest("New category type: Types.TIMESTAMP");
                        break;
                    }
                    default: {
                        LOGGER.finest("Unknown category type");
                    }
                }
            }
            this.chartMain.setChart(this.chartOptionPanel.chartPanel.chart, true);
            this.chartMain.chartPanel.chart.newSurface();
            this.chartMain.setModified();
            this.isCancelled = false;
            this.setVisible(false);
            Chart tempChart = this.chartOptionPanel.chartPanel.chart;
            if (!(tempChart.colData[tempChart.valueCol].dataType == 0 || tempChart.subvalueCol >= 0 && tempChart.colData[tempChart.subvalueCol].dataType == 0 || !showAggregateDialog || this.chartMain.isReportVersion() || tempChart.colData[tempChart.valueCol].getSize() < 250 || categoryType != 92 && categoryType != 91 && categoryType != 93)) {
                this.chartMain.launchAggregateDialog(secondaryAxis, categoryType, true);
            }
            if (this.chart.isDisplayByWeek(0)) {
                this.chartOptionPanel.chartPanel.chart.setDisplayByWeek(0, false);
                this.chartOptionPanel.chartPanel.chart.setDisplayByWeek(0, true);
            }
            return;
        }
    }
}

