/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class OverlayPanel
extends BorderPanel
implements ItemListener {
    JComboBox[] choice;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;
    JComboBox[] axisCombo;
    Object[] fieldName;
    int[] indexMap = new int[]{-1, 7, 0, 3};
    String[] indexName = new String[]{LanguageEncoder.getText("Invisible"), LanguageEncoder.getText("Area"), LanguageEncoder.getText("Column"), LanguageEncoder.getText("Line")};
    boolean displayAxis = true;
    boolean isItemListenerEnabled = true;

    public OverlayPanel(JFrame frame, Chart chart, boolean displayAxis) {
        super(LanguageEncoder.getText("Overlay Options"));
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.displayAxis = displayAxis;
        this.init();
    }

    private void init() {
        int[] seriesType = this.chart.getSeriesType();
        int[] axisPosition = this.chart.getAxisPosition();
        if (this.chart.dataDim == 1) {
            JPanel gpanel = new JPanel();
            gpanel.setLayout(new FlowLayout(1));
            gpanel.add(new JLabel(LanguageEncoder.getText("Chart Type :")));
            this.choice = new JComboBox[1];
            this.choice[0] = new JComboBox();
            this.choice[0].addItem(this.indexName[2]);
            gpanel.add(this.choice[0]);
            this.choice[0].setSelectedItem(this.indexName[2]);
            this.setLayout(new BorderLayout());
            this.add((Component)gpanel, "Center");
        } else {
            if (this.displayAxis) {
                this.setLayout(new GridLayout(0, 3, 0, 0));
            } else {
                this.setLayout(new GridLayout(0, 2, 0, 0));
            }
            this.fieldName = this.chart.colData[this.chart.mDataMap[0]].getFieldName();
            this.choice = new JComboBox[seriesType.length];
            this.axisCombo = new JComboBox[axisPosition.length];
            Vector<String> axisList = this.getAxisComboList(axisPosition);
            for (int i = 0; i < seriesType.length; ++i) {
                JPanel jp = new JPanel(new FlowLayout(1));
                jp.add(new JLabel(this.fieldName[i].toString()));
                this.add(jp);
                this.choice[i] = new JComboBox();
                for (int j = 0; j < this.indexMap.length; ++j) {
                    this.choice[i].addItem(this.indexName[j]);
                }
                JPanel comboPane = new JPanel(new FlowLayout(1));
                comboPane.add(this.choice[i]);
                this.add(comboPane);
                this.choice[i].setSelectedItem(this.indexName[this.getIndex(seriesType[i])]);
                if (!this.displayAxis) continue;
                JPanel axisPane = new JPanel(new FlowLayout(1));
                this.axisCombo[i] = this.createAxisCombo(axisList, i, axisPosition[i]);
                axisPane.add(this.axisCombo[i]);
                this.add(axisPane);
            }
        }
    }

    private JComboBox createAxisCombo(Vector<String> list, int pos, int selectedPos) {
        JComboBox box = new JComboBox();
        this.setAxisCombo(box, list, pos, selectedPos);
        box.addItemListener(this);
        return box;
    }

    private void setAxisCombo(JComboBox box, Vector<String> list, int pos, int selectedPos) {
        this.isItemListenerEnabled = false;
        box.removeAllItems();
        for (int i = 0; i < list.size(); ++i) {
            box.addItem(list.elementAt(i));
        }
        this.isItemListenerEnabled = false;
        if (selectedPos == -1) {
            box.setSelectedIndex(0);
        } else if (selectedPos == -2) {
            box.setSelectedIndex(1);
        } else if (selectedPos == pos) {
            box.setSelectedIndex(2);
        } else {
            box.setSelectedItem(this.fieldName[selectedPos].toString() + " Axis");
        }
        this.isItemListenerEnabled = true;
    }

    private Vector<String> getAxisComboList(int[] axisPosition) {
        Vector<String> tbl = new Vector<String>();
        tbl.addElement(LanguageEncoder.getText("Base Axis"));
        tbl.addElement(LanguageEncoder.getText("Secondary Axis"));
        tbl.addElement(LanguageEncoder.getText("New Axis"));
        for (int element : axisPosition) {
            if (element < 0 || tbl.contains(this.fieldName[element].toString() + " Axis")) continue;
            tbl.addElement(this.fieldName[element].toString() + " Axis");
        }
        return tbl;
    }

    private int[] getAxisPosition() {
        int[] list = new int[this.axisCombo.length];
        for (int i = 0; i < list.length; ++i) {
            String pos = this.axisCombo[i].getSelectedItem().toString();
            list[i] = pos.equals(LanguageEncoder.getText("Base Axis")) ? -1 : (pos.equals(LanguageEncoder.getText("Secondary Axis")) ? -2 : (pos.equals(LanguageEncoder.getText("New Axis")) ? i : this.getFieldNameIndex(pos.substring(0, pos.lastIndexOf(" Axis")))));
        }
        return list;
    }

    private int getFieldNameIndex(String fieldNameStr) {
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (!this.fieldName[i].equals(fieldNameStr)) continue;
            return i;
        }
        return -1;
    }

    private int getIndex(int chartType) {
        for (int i = 0; i < this.indexMap.length; ++i) {
            if (this.indexMap[i] != chartType) continue;
            return i;
        }
        return 0;
    }

    boolean setValues() {
        if (this.chart.dataDim == 1) {
            return true;
        }
        boolean allInvisible = true;
        int[] seriesType = new int[this.choice.length];
        for (int i = 0; i < this.choice.length; ++i) {
            seriesType[i] = this.indexMap[this.choice[i].getSelectedIndex()];
            if (seriesType[i] == 3) {
                this.chart.setLineState(true);
                this.chart.setLineState2(true);
            }
            if (seriesType[i] == -1) continue;
            allInvisible = false;
        }
        if (allInvisible) {
            return false;
        }
        this.chart.setSeriesType(seriesType, true);
        if (this.displayAxis) {
            this.chart.setAxisPosition(this.getAxisPosition(), true);
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isItemListenerEnabled) {
            return;
        }
        int[] axisPos = this.getAxisPosition();
        Vector<String> list = this.getAxisComboList(axisPos);
        for (int i = 0; i < this.axisCombo.length; ++i) {
            this.setAxisCombo(this.axisCombo[i], list, i, axisPos[i]);
        }
    }
}

