/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.INParametersDialog;

public class ParamDialog
extends QbDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ParamDialog.class.getName());
    ChartMain chartmain;
    JButton okButton;
    JButton cancelButton;
    INParametersDialog step32;
    EnterInParamDialog enterDialog;

    public ParamDialog(ChartMain chartmain) throws Exception {
        super(QbDialog.findFrame(chartmain), LanguageEncoder.getText("Parameter Dialog"), true);
        this.chartmain = chartmain;
        this.step32 = new INParametersDialog(this, chartmain.chart.getQueryFileInfo(), true, false, 0);
        JPanel mainPanel = this.step32.getMainPanel();
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        okPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        okPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        cop.add("Center", mainPanel);
        cop.add("South", okPanel);
        this.pack();
        this.validate();
        this.setCenter();
    }

    private void setCenter() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dialogSize = this.getPreferredSize();
        int width = dialogSize.width;
        int height = dialogSize.height;
        int p_width = this.chartmain.getPreferredSize().width;
        if (width > p_width) {
            width = (int)((double)screenSize.width * 0.7);
        }
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        this.setBounds(x, y, width, height);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            if (this.step32.makeCurrParam()) {
                QueryFileInfo info = this.step32.getQueryFileInfo();
                this.chartmain.chart.setQueryFileInfo(info);
                try {
                    if (this.chartmain.chart.queryFilename != null && !this.chartmain.chart.queryFilename.trim().equals("")) {
                        info.saveFile(this.chartmain.chart.queryFilename);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Cannot save query file", ex);
                    new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Cannot save query file") + "\n" + ex.toString());
                    return;
                }
                try {
                    if (this.enterDialog != null) {
                        this.enterDialog.removeActionListener(this);
                    }
                    try {
                        this.enterDialog = new EnterInParamDialog((Frame)QbDialog.findFrame(this), info, true);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Can't initialize EnterInParamDialog", ex);
                    }
                    this.enterDialog.addActionListener(this);
                    this.enterDialog.setVisible(true);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Cannot read database", ex);
                    new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Cannot read database") + "\n" + ex.toString());
                    return;
                }
            }
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (source == this.enterDialog) {
            QueryFileInfo info = this.chartmain.chart.getQueryFileInfo();
            QueryInParamSet inSet = info.getInSet();
            inSet.setParameter(this.enterDialog.getInParamValue());
            try {
                this.chartmain.do_Reload();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Cannot read data from database", ex);
                String message = LanguageEncoder.getText("Cannot read data from database.  Please make sure the attributes are correct") + " " + ex.toString();
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(message);
                return;
            }
            this.setVisible(false);
            this.dispose();
        }
    }
}

