/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.IPieChart;
import quadbase.chart.PieChart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class PieOptionsDlg
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(PieOptionsDlg.class.getName());
    SpinBox spinAngle;
    SpinBox spinDistance;
    SpinBox spinSlice;
    SpinBox spinGapRatio;
    SpinBox piePerRow;
    SpinBox spinThickness;
    JCheckBox checkConcentric;
    JCheckBox checkPercent;
    JCheckBox checkPieBorder;
    JCheckBox checkExtendLine;
    JCheckBox checkLabelAtTheSide;
    JCheckBox checkValue;
    JCheckBox checkLabel;
    JCheckBox checkCategory;
    JCheckBox checkSmart;
    JCheckBox checkValInLegend;
    JCheckBox checkBestFit;
    JCheckBox checkDrawLinearly;
    JTextField groupLimit;
    JTextField groupName;
    JRadioButton checkExplode;
    JRadioButton checkSectorGap;
    JList categoryList;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    PieChart pieChart;
    ChartMain chartMain;
    boolean isReady = false;

    public PieOptionsDlg(JFrame frame, Chart chart) {
        super(frame, chart.getChartType() == 20 ? LanguageEncoder.getText("Doughnut Options") : LanguageEncoder.getText("Pie Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.pieChart = ((IPieChart)((Object)chart)).getPieChart();
        this.init();
    }

    private void init() {
        this.isReady = false;
        this.setBackground(Color.lightGray);
        GridLayout glayout21 = new GridLayout(2, 1);
        this.checkConcentric = new JCheckBox(LanguageEncoder.getText("Concentric Doughnuts"));
        this.checkConcentric.addItemListener(this);
        this.checkPercent = new JCheckBox(LanguageEncoder.getText("Percentage"));
        this.checkPercent.addItemListener(this);
        this.checkPieBorder = new JCheckBox(LanguageEncoder.getText("Border"));
        this.checkPieBorder.addItemListener(this);
        this.checkExtendLine = new JCheckBox(LanguageEncoder.getText("Slice-to-Label Line"));
        this.checkExtendLine.addItemListener(this);
        this.checkLabelAtTheSide = new JCheckBox(LanguageEncoder.getText("Label At The Side"));
        this.checkLabelAtTheSide.addItemListener(this);
        this.checkValue = new JCheckBox(LanguageEncoder.getText("Value"));
        this.checkValue.addItemListener(this);
        this.checkLabel = new JCheckBox(LanguageEncoder.getText("Label"));
        this.checkLabel.addItemListener(this);
        this.checkCategory = new JCheckBox(LanguageEncoder.getText("Category"));
        this.checkCategory.addItemListener(this);
        this.checkSmart = new JCheckBox(LanguageEncoder.getText("% in legend"));
        this.checkSmart.addItemListener(this);
        this.checkValInLegend = new JCheckBox(LanguageEncoder.getText("Value in legend"));
        this.checkValInLegend.addItemListener(this);
        this.checkBestFit = new JCheckBox(LanguageEncoder.getText("Best Fit"));
        this.checkBestFit.addItemListener(this);
        this.checkDrawLinearly = new JCheckBox(LanguageEncoder.getText("Draw Linearly"));
        this.checkDrawLinearly.addItemListener(this);
        this.spinAngle = new SpinBox(-360, 360);
        this.spinAngle.addActionListener(this);
        this.groupLimit = new JTextField(this.chart.getPieGroupOthersLimit() + "");
        this.groupName = new JTextField(this.chart.getPieGroupOthersName());
        this.spinThickness = new SpinBox(1, 100);
        this.spinThickness.addActionListener(this);
        this.spinDistance = new SpinBox(0, 100);
        this.spinDistance.addActionListener(this);
        this.spinSlice = new SpinBox(0, 100);
        this.spinSlice.addActionListener(this);
        this.spinGapRatio = new SpinBox(0, 500);
        this.spinGapRatio.addActionListener(this);
        this.piePerRow = new SpinBox(1, 99);
        this.piePerRow.addActionListener(this);
        this.categoryList = new JList();
        this.categoryList.setToolTipText(LanguageEncoder.getText("<html><b>Ctrl + left click:</b> select/unselect multiple items<br><b>Shift + left click:</b> select range<br><b>Ctrl + A:</b> select all</html>"));
        this.categoryList.setSelectionMode(2);
        JPanel rotatePanel = new JPanel();
        rotatePanel.setLayout(glayout21);
        JPanel rotate2Panel = new JPanel();
        rotate2Panel.setLayout(new BorderLayout());
        rotate2Panel.add("Center", new JLabel(this.chart.getChartType() == 20 ? LanguageEncoder.getText("Rotate doughnut") : LanguageEncoder.getText("Rotate pie:")));
        rotatePanel.add(rotate2Panel);
        JPanel spinPanel = new JPanel();
        spinPanel.setLayout(new BorderLayout());
        spinPanel.add("Center", this.spinAngle);
        rotatePanel.add(spinPanel);
        JPanel thicknessPanel = new JPanel();
        thicknessPanel.setLayout(glayout21);
        thicknessPanel.add(new JLabel(LanguageEncoder.getText("Arc Length Ratio:(%)")));
        thicknessPanel.add(this.spinThickness);
        JPanel distancePanel = new JPanel();
        JPanel spin2Panel = new JPanel();
        spin2Panel.setLayout(new BorderLayout());
        spin2Panel.add("Center", this.spinDistance);
        distancePanel.setLayout(glayout21);
        JPanel distance2Panel = new JPanel();
        distance2Panel.setLayout(new BorderLayout());
        distance2Panel.add("Center", new JLabel(LanguageEncoder.getText("Place label:")));
        distancePanel.add(distance2Panel);
        distancePanel.add(spin2Panel);
        JPanel groupLimitPanel = new JPanel();
        JPanel groupLimit1 = new JPanel();
        groupLimit1.setLayout(new BorderLayout());
        groupLimit1.add("Center", this.groupLimit);
        groupLimitPanel.setLayout(glayout21);
        JPanel groupLimit2 = new JPanel();
        groupLimit2.setLayout(new BorderLayout());
        groupLimit2.add("Center", new JLabel(LanguageEncoder.getText("'Others' % Threshold:")));
        groupLimitPanel.add(groupLimit2);
        groupLimitPanel.add(groupLimit1);
        JPanel groupNamePanel = new JPanel();
        JPanel groupName1 = new JPanel();
        groupName1.setLayout(new BorderLayout());
        groupName1.add("Center", this.groupName);
        groupNamePanel.setLayout(glayout21);
        JPanel groupName2 = new JPanel();
        groupName2.setLayout(new BorderLayout());
        groupName2.add("Center", new JLabel(LanguageEncoder.getText("Display Name For 'Others':")));
        groupNamePanel.add(groupName2);
        groupNamePanel.add(groupName1);
        JPanel distPanel = new JPanel();
        distPanel.setLayout(new FlowLayout());
        distPanel.add(new JLabel(LanguageEncoder.getText("Distance from origin :")));
        distPanel.add(this.spinSlice);
        JPanel gapPanel = new JPanel();
        gapPanel.setLayout(new FlowLayout());
        gapPanel.add(new JLabel(this.chart.getChartType() == 20 ? LanguageEncoder.getText("Gap between doughnuts :") : LanguageEncoder.getText("Gap between pies :")));
        gapPanel.add(this.spinGapRatio);
        BorderPanel formationPanel = new BorderPanel(LanguageEncoder.getText("Formation"));
        formationPanel.setLayout(new BorderLayout());
        JPanel nPiePanel = new JPanel();
        nPiePanel.setLayout(new FlowLayout());
        nPiePanel.add(new JLabel(this.chart.getChartType() == 20 ? LanguageEncoder.getText("Number Of Doughnuts Per Row:") : LanguageEncoder.getText("Number Of Pies Per Row:")));
        nPiePanel.add(this.piePerRow);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(0));
        panel1.add(this.checkBestFit);
        panel1.add(this.checkDrawLinearly);
        formationPanel.add("North", panel1);
        formationPanel.add("Center", nPiePanel);
        formationPanel.add("South", gapPanel);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridLayout(1, 2));
        this.checkExplode = new JRadioButton(LanguageEncoder.getText("Explode"), true);
        this.checkSectorGap = new JRadioButton(LanguageEncoder.getText("Sector Gap"), false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.checkExplode);
        bg.add(this.checkSectorGap);
        this.checkExplode.addItemListener(this);
        this.checkSectorGap.addItemListener(this);
        radioPanel.add(this.checkExplode);
        radioPanel.add(this.checkSectorGap);
        JPanel slicePanel = new JPanel();
        slicePanel.setLayout(new BorderLayout());
        slicePanel.add("North", radioPanel);
        JScrollPane scrollPane = new JScrollPane(this.categoryList);
        slicePanel.add("Center", scrollPane);
        slicePanel.add("South", distPanel);
        JPanel legendLabelPanel = new JPanel();
        legendLabelPanel.setLayout(new GridLayout(0, 2));
        legendLabelPanel.add(this.checkLabel);
        if (this.chart.dataDim == 2) {
            legendLabelPanel.add(this.checkCategory);
        }
        legendLabelPanel.add(this.checkValue);
        legendLabelPanel.add(this.checkPercent);
        if (this.chart.dataDim == 1) {
            legendLabelPanel.add(this.checkSmart);
            legendLabelPanel.add(this.checkValInLegend);
        }
        if (this.chart.is2DChart) {
            legendLabelPanel.add(this.checkPieBorder);
        }
        legendLabelPanel.add(this.checkExtendLine);
        legendLabelPanel.add(this.checkLabelAtTheSide);
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridLayout(0, 2, 5, 5));
        optionPanel.add(rotatePanel);
        optionPanel.add(distancePanel);
        if (!this.chartMain.isDrillDownEnabled() && !this.chartMain.isFieldDrillDownChart()) {
            optionPanel.add(groupLimitPanel);
            optionPanel.add(groupNamePanel);
        }
        if (this.chart.getChartType() == 20) {
            optionPanel.add(thicknessPanel);
            optionPanel.add(new JLabel(""));
        }
        BorderPanel mainPanel = new BorderPanel(this.chart.getChartType() == 20 ? LanguageEncoder.getText("Doughnut Options") : LanguageEncoder.getText("Pie Options"));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(slicePanel);
        mainPanel.add(optionPanel);
        mainPanel.add(legendLabelPanel);
        if (this.chart.dataDim == 2) {
            mainPanel.add(formationPanel);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel pane = (JPanel)this.getContentPane();
        pane.add("North", this.checkConcentric);
        pane.add("Center", mainPanel);
        pane.add("South", buttonPanel);
        this.setSize(this.getPreferredSize());
        this.getValues();
        this.isReady = true;
    }

    private void getValues() {
        this.spinAngle.setValue(this.pieChart.initangle);
        this.spinThickness.setValue(this.pieChart.pieThickness[0]);
        this.piePerRow.setValue(this.pieChart.piePerRow);
        this.spinDistance.setValue((int)(this.pieChart.fontdistance * 50.0));
        this.spinSlice.setValue((int)(this.pieChart.sliceDistance * 100.0));
        this.spinGapRatio.setValue((int)(this.pieChart.gapRatioBetweenPies * 200.0));
        this.checkConcentric.setSelected(this.chart.getConcentricDoughnut());
        this.checkPercent.setSelected(this.chart.getPercentState());
        this.checkPieBorder.setSelected(this.chart.getDataBorder());
        this.checkExtendLine.setSelected(this.chart.isPieExtendLineDrawn());
        this.checkLabelAtTheSide.setSelected(this.chart.isPieLabelAtTheSide());
        this.checkSmart.setSelected(this.chart.getSmartState());
        this.checkValInLegend.setSelected(this.chart.isValueInLegend());
        this.checkValue.setSelected(this.chart.getValueState());
        this.checkLabel.setSelected(this.chart.getLabelState());
        this.checkCategory.setSelected(this.chart.getCatLabelState());
        this.checkBestFit.setSelected(this.pieChart.isBestFit());
        this.checkDrawLinearly.setSelected(this.pieChart.isDrawLinearly());
        this.checkSectorGap.setSelected(this.pieChart.isSectorGapEnabled());
        Object[] fname = this.chart.colData[this.chart.mDataMap[0]].getFieldName();
        String[] tmp = new String[this.chart.mDataLen[0]];
        Vector<Integer> tmp2 = new Vector<Integer>();
        for (int i = 0; i < this.chart.mDataLen[0]; ++i) {
            tmp[i] = fname[i].toString();
            if (this.chart.dataDim == 1) {
                if (!this.chart.mData.multiData[i].plotData.bSlice) continue;
                tmp2.addElement(i);
                continue;
            }
            if (!this.chart.mData.multiData[i].multiData[0].plotData.bSlice) continue;
            tmp2.addElement(i);
        }
        this.categoryList.setListData(tmp);
        int[] selectedList = new int[tmp2.size()];
        for (int i = 0; i < selectedList.length; ++i) {
            selectedList[i] = (Integer)tmp2.elementAt(i);
        }
        this.categoryList.setSelectedIndices(selectedList);
        this.setupCheckBox();
    }

    private void setValues() {
        for (int i = 0; i < this.categoryList.getModel().getSize(); ++i) {
            this.pieChart.setSliceState(i, this.categoryList.isSelectedIndex(i));
        }
        this.pieChart.setInitAngle(this.spinAngle.getValue());
        this.pieChart.fontdistance = (double)this.spinDistance.getValue() / 50.0;
        this.pieChart.pieThickness[0] = this.spinThickness.getValue();
        this.pieChart.setSliceDistance((double)this.spinSlice.getValue() / 100.0);
        this.pieChart.setGapRatioBetweenPies((double)this.spinGapRatio.getValue() / 200.0);
        this.chart.setPieGroupOthersName(this.groupName.getText());
        try {
            double tmp = Double.valueOf(this.groupLimit.getText());
            if (tmp < 0.0) {
                tmp = 0.0;
            } else if (tmp > 100.0) {
                tmp = 100.0;
            }
            this.chart.setPieGroupOthersLimit(tmp);
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Pie group others limit: Invalid number, using 0.", ex);
            this.chart.setPieGroupOthersLimit(0.0);
        }
        this.chart.setConcentricDoughnut(this.checkConcentric.isSelected());
        this.chart.setPercentState(this.checkPercent.isSelected());
        this.chart.setDataBorder(this.checkPieBorder.isSelected());
        this.chart.setPieExtendLineDrawn(this.checkExtendLine.isSelected());
        this.chart.setPieLabelAtTheSide(this.checkLabelAtTheSide.isSelected());
        this.chart.setSmartState(this.checkSmart.isSelected());
        this.chart.setValueInLegend(this.checkValInLegend.isSelected());
        this.chart.setValueState(this.checkValue.isSelected());
        this.chart.setLabelState(this.checkLabel.isSelected());
        this.chart.setCatLabelState(this.checkCategory.isSelected());
        this.pieChart.setSectorGapEnabled(this.checkSectorGap.isSelected());
        this.pieChart.piePerRow = this.piePerRow.getValue();
        this.pieChart.setBestFit(this.checkBestFit.isSelected());
        this.pieChart.setDrawLinearly(this.checkDrawLinearly.isSelected());
        this.chartMain.setModified();
        this.chartMain.invalidateLegend();
        this.chartMain.qbrepaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isReady) {
            return;
        }
        Object target = e.getSource();
        this.setupCheckBox();
        if (target == this.checkExplode || target == this.checkSectorGap) {
            if (this.checkSectorGap.isSelected()) {
                this.spinSlice.setValue(3);
            } else {
                this.spinSlice.setValue(40);
            }
        }
        if (target == this.checkConcentric) {
            if (this.checkConcentric.isSelected()) {
                this.checkPieBorder.setSelected(false);
                this.checkCategory.setSelected(false);
            } else {
                this.checkPieBorder.setSelected(true);
                this.checkCategory.setSelected(true);
            }
        }
    }

    private void setupCheckBox() {
        this.checkDrawLinearly.setEnabled(!this.checkBestFit.isSelected());
        this.piePerRow.setEnabled(!this.checkBestFit.isSelected() && !this.checkDrawLinearly.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.setValues();
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

