/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.designer.AreaOptionPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.GradientDialog;
import quadbase.chart.designer.IGradientDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class PlotAreaDialog
extends QbDialog
implements IGradientDialog,
ItemListener {
    ChartMain chartmain;
    Chart chart;
    AreaOptionPanel areapanel;
    JCheckBox ckborder;
    JCheckBox ckarea;
    JButton okButton;
    JButton cancelButton;
    SpinBox spinThick;
    JCheckBox enableGradient;
    JButton gradientOption;
    GradientDialog gradientDialog;

    public PlotAreaDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.setBackground(Color.lightGray);
        BorderPanel drawpanel = new BorderPanel(LanguageEncoder.getText("Draw"));
        drawpanel.setLayout(new FlowLayout(0));
        drawpanel.add(new JLabel(LanguageEncoder.getText("Area")));
        this.ckarea = new JCheckBox();
        drawpanel.add(this.ckarea);
        this.ckarea.addItemListener(this);
        drawpanel.add(new JLabel(LanguageEncoder.getText("Border")));
        this.ckborder = new JCheckBox();
        drawpanel.add(this.ckborder);
        this.ckborder.addItemListener(this);
        drawpanel.add(new JLabel(LanguageEncoder.getText("Thickness")));
        this.spinThick = new SpinBox(1, 30);
        drawpanel.add(this.spinThick);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BoxLayout(cop, 1));
        this.areapanel = new AreaOptionPanel(this.chart.background, LanguageEncoder.getText("Appearance"));
        if (this.chart.is2DimChart()) {
            cop.add(drawpanel);
            cop.add(this.areapanel);
        }
        BorderPanel gradientPanel = new BorderPanel(LanguageEncoder.getText("Gradient"));
        gradientPanel.setLayout(new FlowLayout(0));
        this.enableGradient = new JCheckBox(LanguageEncoder.getText("Enable Gradient"), this.chart.background.isGradientEnabled());
        this.gradientOption = new JButton(LanguageEncoder.getText("Customize..."));
        this.enableGradient.addItemListener(this);
        this.gradientOption.setEnabled(this.enableGradient.isSelected());
        gradientPanel.add(this.enableGradient);
        gradientPanel.add(this.gradientOption);
        this.gradientOption.addActionListener(this);
        cop.add(gradientPanel);
        JPanel but_panel = new JPanel();
        but_panel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        but_panel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        but_panel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        cop.add(but_panel);
        this.ckarea.setSelected(this.chart.getBackgroundState());
        this.areapanel.setEnable(this.ckarea.isSelected());
        this.ckborder.setSelected(this.chart.getBorderState());
        this.spinThick.setValue(this.chart.getBorderThickness());
        this.ckarea.addItemListener(this);
        this.setBorderThickState();
        this.enableGradient.setEnabled(this.ckarea.isSelected() || !this.chart.is2DimChart());
        this.gradientOption.setEnabled((this.ckarea.isSelected() || !this.chart.is2DimChart()) && this.enableGradient.isSelected());
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
        }
        super.setVisible(b);
    }

    private void restoreValue() {
        this.chart.setBackgroundState(this.ckarea.isSelected());
        this.chart.setBorderState(this.ckborder.isSelected());
        this.chart.setBorderThickness(this.spinThick.getValue());
        this.chart.background = this.areapanel.getArea();
        if (this.enableGradient.isEnabled()) {
            this.chart.background.setGradientEnabled(this.enableGradient.isSelected());
        } else {
            this.chart.background.setGradientEnabled(false);
        }
        if (this.gradientDialog != null) {
            this.gradientDialog.setValues();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.restoreValue();
            this.chartmain.chartPanel.repaint();
            this.chartmain.setModified();
        } else if (e.getSource() == this.gradientOption) {
            if (this.gradientDialog == null) {
                this.gradientDialog = new GradientDialog(this.chartmain, this, "Gradient Options");
            }
            this.gradientDialog.setVisible(true);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableGradient.setEnabled(this.ckarea.isSelected() || !this.chart.is2DimChart());
        this.gradientOption.setEnabled((this.ckarea.isSelected() || !this.chart.is2DimChart()) && this.enableGradient.isSelected());
        if (e.getSource() == this.ckarea) {
            this.areapanel.setEnable(this.ckarea.isSelected());
        } else {
            this.setBorderThickState();
        }
    }

    private void setBorderThickState() {
        this.spinThick.setEnabled(this.ckborder.isSelected());
    }

    @Override
    public void resetGradientDialog() {
        this.gradientDialog = null;
    }

    @Override
    public double getGradientStartX() {
        return this.chart.background.getGradientStartX();
    }

    @Override
    public double getGradientStartY() {
        return this.chart.background.getGradientStartY();
    }

    @Override
    public double getGradientEndX() {
        return this.chart.background.getGradientEndX();
    }

    @Override
    public double getGradientEndY() {
        return this.chart.background.getGradientEndY();
    }

    @Override
    public Color getGradientDesColor() {
        return this.chart.background.getGradientDesColor();
    }

    @Override
    public int getGradientShade() {
        return this.chart.background.getGradientShade();
    }

    @Override
    public boolean isGradientCyclic() {
        return this.chart.background.isGradientCyclic();
    }

    @Override
    public void setValues(GradientDialog gDialog) {
        this.chart.background.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.chart.background.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.chart.background.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.chart.background.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.chart.background.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.chart.background.setGradientDesColor(null);
        } else {
            this.chart.background.setGradientDesColor(gDialog.getButtonColor());
        }
        this.chart.background.setGradientCyclic(gDialog.checkCyclic.isSelected());
        this.chart.background.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.chart.background.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.chart.background.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.chart.background.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.chart.background.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.chart.background.setGradientDesColor(null);
        } else {
            this.chart.background.setGradientDesColor(gDialog.getButtonColor());
        }
        this.chart.background.setGradientCyclic(gDialog.checkCyclic.isSelected());
    }

    @Override
    public boolean is3DShadingEnabled() {
        return false;
    }

    @Override
    public boolean isGradientEnabled() {
        return false;
    }
}

