/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class PointDialog
extends QbDialog {
    ChartMain chartmain;
    Chart chart;
    boolean oldState;
    JCheckBox showPoint;
    JButton okButton;
    JButton cancelButton;

    public PointDialog(ChartMain frame, String title) {
        super(frame, title, true);
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        this.setBackground(Color.lightGray);
        BorderPanel gpanel = new BorderPanel(LanguageEncoder.getText("Point"));
        gpanel.setLayout(new BorderLayout());
        this.oldState = this.chart.getPointState();
        JPanel centerPanel = new JPanel(new FlowLayout(1));
        this.showPoint = new JCheckBox(LanguageEncoder.getText("Show all points"), this.oldState);
        centerPanel.add(this.showPoint);
        gpanel.add("Center", centerPanel);
        JPanel but_panel = new JPanel();
        but_panel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        but_panel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        but_panel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", gpanel);
        cop.add("South", but_panel);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, super.getPreferredSize().height);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
        }
        super.setVisible(b);
    }

    private void restoreValue() {
        this.chart.setPointState(this.showPoint.isSelected());
    }

    private boolean isChanged() {
        return this.oldState != this.showPoint.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
        if (e.getSource() == this.okButton) {
            if (this.isChanged()) {
                if (!this.chart.is2DChart) {
                    this.chart.newSurface();
                }
                this.restoreValue();
            }
            this.chartmain.chartPanel.repaint();
            this.chartmain.setModified();
        }
    }
}

