/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.chart.Chart;
import quadbase.chart.DataAttribute;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class PointPanel
extends PanelAction
implements ListSelectionListener {
    JList datalist;
    JList pointshapelist;
    JScrollPane scrollPane;
    DataAttribute dattribute;
    MultiDimData mData;
    boolean is2DChart;
    int chartType;
    SpinBox epixel;
    SpinBox fpixel;
    SpinBox psize;
    SpinBox lineThickness;
    JCheckBox checkPoint;
    JCheckBox checkLine;
    JCheckBox checkArea;
    JCheckBox checkPointBorder;
    boolean isSecondary;
    Chart chart;
    boolean isListenerEnabled = false;
    JRadioButton blackColorBut;
    JRadioButton darkColorBut;
    int curSelectedIndex = 0;

    public PointPanel(Chart chart, boolean bSecondary) {
        this.chart = chart;
        this.isSecondary = bSecondary;
        this.mData = this.isSecondary ? chart.mData2 : chart.mData;
        this.is2DChart = chart.is2DChart;
        this.chartType = this.mData.chart.chartType;
        this.pointshapelist = new JList();
        this.pointshapelist.setListData(Point3D.shapeNames);
        this.pointshapelist.setSelectionMode(0);
        this.pointshapelist.addListSelectionListener(this);
        this.datalist = new JList();
        this.datalist.setSelectionMode(0);
        this.dattribute = new DataAttribute(this.mData, this.isSecondary, this.is2DChart, this.chartType, true);
        this.datalist.setListData(this.dattribute.name);
        this.datalist.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.datalist);
        JPanel seriespanel = new JPanel();
        seriespanel.setLayout(new BorderLayout());
        seriespanel.add("North", new JLabel(LanguageEncoder.getText("Data Series")));
        seriespanel.add("Center", this.scrollPane);
        JPanel shapepanel = new JPanel();
        shapepanel.setLayout(new BorderLayout());
        shapepanel.add("North", new JLabel(LanguageEncoder.getText("Point Shape")));
        shapepanel.add("Center", this.pointshapelist);
        BorderPanel lineStylePanel = new BorderPanel(LanguageEncoder.getText("Line Thickness and Style"));
        lineStylePanel.setLayout(new GridLayout(3, 2));
        lineStylePanel.add(new JLabel(LanguageEncoder.getText("Line thickness")));
        this.lineThickness = new SpinBox(0, 30);
        lineStylePanel.add(this.lineThickness);
        this.lineThickness.addActionListener(this);
        lineStylePanel.add(new JLabel(LanguageEncoder.getText("Fill pixel")));
        this.epixel = new SpinBox(0, 255);
        lineStylePanel.add(this.epixel);
        this.epixel.addActionListener(this);
        lineStylePanel.add(new JLabel(LanguageEncoder.getText("Empty pixel")));
        this.fpixel = new SpinBox(0, 255);
        lineStylePanel.add(this.fpixel);
        this.fpixel.addActionListener(this);
        BorderPanel pointSizePanel = new BorderPanel(LanguageEncoder.getText("Point Size"));
        pointSizePanel.setLayout(new BorderLayout());
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new GridLayout(1, 2));
        gridpanel.add(new JLabel(LanguageEncoder.getText("Point Size")));
        this.psize = new SpinBox(-3, 20);
        gridpanel.add(this.psize);
        this.psize.addActionListener(this);
        pointSizePanel.add("Center", gridpanel);
        JPanel dualPanel = new JPanel();
        dualPanel.setLayout(new BorderLayout());
        dualPanel.add("North", pointSizePanel);
        dualPanel.add("Center", lineStylePanel);
        JPanel pointpanel = new JPanel();
        pointpanel.setLayout(new BorderLayout());
        pointpanel.add("West", seriespanel);
        pointpanel.add("Center", shapepanel);
        pointpanel.add("East", dualPanel);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new FlowLayout(0));
        this.checkPoint = new JCheckBox(LanguageEncoder.getText("Show points"));
        checkPanel.add(this.checkPoint);
        this.checkLine = new JCheckBox(LanguageEncoder.getText("Show lines"));
        checkPanel.add(this.checkLine);
        if (!this.isSecondary && (chart.getChartType() == 16 || chart.getChartType() == 19) || chart.getChartType() == 2 && chart.is2DimChart()) {
            this.checkArea = new JCheckBox(LanguageEncoder.getText("Show area"));
            checkPanel.add(this.checkArea);
            this.checkArea.setSelected(chart.getAreaState());
        }
        this.checkPointBorder = new JCheckBox(LanguageEncoder.getText("Points border"));
        checkPanel.add(this.checkPointBorder);
        if (this.isSecondary) {
            this.checkLine.setSelected(chart.getLineState2());
            this.checkPoint.setSelected(chart.getPointState2());
            this.checkPointBorder.setSelected(chart.isDrawPointBorder2());
        } else {
            this.checkLine.setSelected(chart.getLineState());
            this.checkPoint.setSelected(chart.getPointState());
            this.checkPointBorder.setSelected(chart.isDrawPointBorder());
        }
        BorderPanel mainPanel = new BorderPanel(LanguageEncoder.getText("Line & Point"));
        mainPanel.setLayout(new BorderLayout());
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new GridLayout(0, 3, 5, 5));
        this.blackColorBut = new JRadioButton(LanguageEncoder.getText("Black"), true);
        this.darkColorBut = new JRadioButton(LanguageEncoder.getText("Dark"), false);
        borderPanel.add(new JLabel(LanguageEncoder.getText("Border Color")));
        borderPanel.add(this.blackColorBut);
        borderPanel.add(this.darkColorBut);
        ButtonGroup butGp = new ButtonGroup();
        butGp.add(this.blackColorBut);
        butGp.add(this.darkColorBut);
        if (this.isSecondary) {
            this.blackColorBut.setSelected(chart.getDrawPointBorderColor2().getRGB() == Color.black.getRGB());
            this.darkColorBut.setSelected(chart.getDrawPointBorderColor2().getRGB() != Color.black.getRGB());
        } else {
            this.blackColorBut.setSelected(chart.getDrawPointBorderColor().getRGB() == Color.black.getRGB());
            this.darkColorBut.setSelected(chart.getDrawPointBorderColor().getRGB() != Color.black.getRGB());
        }
        mainPanel.add("North", checkPanel);
        mainPanel.add("Center", pointpanel);
        mainPanel.add("South", borderPanel);
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.add("Center", mainPanel);
        int s = this.dattribute.dataShape[0];
        this.setStyle(s);
        this.pointshapelist.setSelectedIndex(s % 256);
        s = this.dattribute.dataSize[0];
        this.psize.setValue(s);
        this.lineThickness.setValue(this.dattribute.lineThickness[0]);
        this.datalist.setSelectedIndex(0);
        this.setSize(this.getPreferredSize());
        this.isListenerEnabled = true;
    }

    private void setStyle(int s) {
        boolean curListenerEnabled = this.isListenerEnabled;
        this.isListenerEnabled = false;
        this.epixel.setValue((s /= 256) / 256);
        this.fpixel.setValue(s % 256);
        this.isListenerEnabled = curListenerEnabled;
    }

    void restoreValue() {
        this.chart.legend.invalidate();
        if (this.chart.legend2 != null) {
            this.chart.legend2.invalidate();
        }
        this.setlist(this.curSelectedIndex);
        this.dattribute.loadAttribute(this.mData, this.mData.chart.is2DimChart(), this.mData.chart.getChartType());
        this.chart.setDataPtShapes(this.chart.getDataShape());
        this.chart.setDataPtSizes(this.chart.getDataSize());
        if (this.isSecondary) {
            this.chart.setPointState2(this.checkPoint.isSelected());
            this.chart.setLineState2(this.checkLine.isSelected());
            this.chart.setDrawPointBorder2(this.checkPointBorder.isSelected());
            this.chart.setDrawPointBorderColor2(this.getButtonColor());
        } else {
            this.chart.setPointState(this.checkPoint.isSelected());
            this.chart.setLineState(this.checkLine.isSelected());
            this.chart.setDrawPointBorder(this.checkPointBorder.isSelected());
            this.chart.setDrawPointBorderColor(this.getButtonColor());
        }
        if (this.checkArea != null) {
            this.chart.setAreaState(this.checkArea.isSelected());
        }
    }

    private Color getButtonColor() {
        if (this.blackColorBut.isSelected()) {
            return Color.black;
        }
        return Color.yellow;
    }

    private void setlist(int id) {
        if (!this.isListenerEnabled) {
            return;
        }
        if (id >= 0) {
            this.epixel.focusLost(null);
            this.fpixel.focusLost(null);
            this.psize.focusLost(null);
            this.lineThickness.focusLost(null);
            this.dattribute.dataShape[id] = this.pointshapelist.getSelectedIndex() + (256 * this.epixel.getValue() + this.fpixel.getValue()) * 256;
            this.dattribute.dataSize[id] = this.psize.getValue();
            this.dattribute.lineThickness[id] = this.lineThickness.getValue();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isListenerEnabled) {
            return;
        }
        this.setlist(this.curSelectedIndex);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.isListenerEnabled) {
            return;
        }
        this.setlist(this.curSelectedIndex);
        if (e.getSource() == this.datalist) {
            this.isListenerEnabled = false;
            int idx = this.datalist.getSelectedIndex();
            if (idx < 0 || idx >= this.dattribute.dataShape.length) {
                return;
            }
            this.curSelectedIndex = idx;
            int s = this.dattribute.dataShape[this.datalist.getSelectedIndex()];
            this.pointshapelist.setSelectedIndex(s % 256);
            this.setStyle(s);
            s = this.dattribute.dataSize[this.datalist.getSelectedIndex()];
            this.psize.setValue(s);
            this.lineThickness.setValue(this.dattribute.lineThickness[this.datalist.getSelectedIndex()]);
            this.isListenerEnabled = true;
        }
    }
}

