/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.QbUtil;

public class PolarDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(PolarDialog.class.getName());
    JTextField textStartAngle;
    JTextField textNoSector;
    JRadioButton radioRadian;
    JRadioButton radioDegree;
    JRadioButton radioCW;
    JRadioButton radioCCW;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;
    boolean isModified = false;
    boolean recalulateInProcess = false;
    boolean isRadian = true;

    public PolarDialog(JFrame frame, Chart chart) {
        super(frame, LanguageEncoder.getText("Polar Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        BorderPanel mainPanel = new BorderPanel(LanguageEncoder.getText("Polar Options"));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        BorderPanel subPanel1 = new BorderPanel(LanguageEncoder.getText("Start Angle"));
        subPanel1.add("West", new JLabel(LanguageEncoder.getText("Value")));
        this.textStartAngle = new JTextField("0", 10);
        subPanel1.add("East", this.textStartAngle);
        this.textStartAngle.addActionListener(this);
        BorderPanel subPanel4 = new BorderPanel(LanguageEncoder.getText("Number Of Sectors"));
        subPanel4.add("West", new JLabel(LanguageEncoder.getText("Value")));
        this.textNoSector = new JTextField("0", 10);
        subPanel4.add("East", this.textNoSector);
        this.textNoSector.addActionListener(this);
        BorderPanel subPanel2 = new BorderPanel(LanguageEncoder.getText("Input Data Angle Units"));
        ButtonGroup gp1 = new ButtonGroup();
        this.radioRadian = new JRadioButton(LanguageEncoder.getText("Radians"), true);
        subPanel2.add("West", this.radioRadian);
        this.radioDegree = new JRadioButton(LanguageEncoder.getText("Degrees"), false);
        subPanel2.add("East", this.radioDegree);
        gp1.add(this.radioRadian);
        gp1.add(this.radioDegree);
        this.radioRadian.addItemListener(this);
        this.radioDegree.addItemListener(this);
        BorderPanel subPanel3 = new BorderPanel(LanguageEncoder.getText("Direction"));
        ButtonGroup gp2 = new ButtonGroup();
        this.radioCW = new JRadioButton(LanguageEncoder.getText("Clockwise"), true);
        subPanel3.add("West", this.radioCW);
        this.radioCCW = new JRadioButton(LanguageEncoder.getText("Counter-clockwise"), false);
        subPanel3.add("East", this.radioCCW);
        gp2.add(this.radioCW);
        gp2.add(this.radioCCW);
        mainPanel.add(subPanel2);
        mainPanel.add(new JLabel(""));
        mainPanel.add(subPanel3);
        mainPanel.add(new JLabel(""));
        mainPanel.add(subPanel1);
        mainPanel.add(new JLabel(""));
        mainPanel.add(subPanel4);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.getValues();
    }

    private void getValues() {
        this.textStartAngle.setText(QbUtil.roundUp(this.getStartAngleForChart()) + "");
        this.textNoSector.setText(this.chart.getNoSectionForPolar() + "");
        if (this.chart.isClockWiseForPolar()) {
            this.radioCW.setSelected(true);
        } else {
            this.radioCCW.setSelected(true);
        }
        if (this.chart.isRadianForPolar()) {
            this.radioRadian.setSelected(true);
        } else {
            this.radioDegree.setSelected(true);
        }
    }

    private String setValues() {
        try {
            this.recalulateStartAngle();
            this.chart.setStartAngleForPolar(this.getStartAngleInRadian());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Please enter numeric value for start angle", ex);
            return LanguageEncoder.getText("Please enter numeric value for start angle!");
        }
        int tmpNoSec = 0;
        try {
            tmpNoSec = Integer.valueOf(this.textNoSector.getText());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Please enter numeric value for number of sectors!", ex);
            return LanguageEncoder.getText("Please enter numeric value for number of sectors!");
        }
        if (tmpNoSec < 2) {
            LOGGER.finest("Number of sectors:  value has to be greater than 1");
            return LanguageEncoder.getText("Number of sectors:  value has to be greater than 1!");
        }
        this.chart.setNoSectionForPolar(tmpNoSec);
        this.chart.setClockWiseForPolar(this.radioCW.isSelected());
        this.chart.setRadianForPolar(this.radioRadian.isSelected());
        return null;
    }

    boolean isModified() {
        return this.isModified;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            String err = this.setValues();
            if (err != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), err);
                return;
            }
            this.isModified = true;
            this.chartMain.setModified();
            this.chartMain.qbpaint();
            this.dispose();
        } else if (source == this.textStartAngle) {
            this.recalulateStartAngle();
        } else if (source == this.textNoSector) {
            this.recalulateStartAngle();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    private double getStartAngleInRadian() throws Exception {
        double newVal = Double.valueOf(this.textStartAngle.getText());
        if (this.radioRadian.isSelected()) {
            return newVal;
        }
        return newVal * Math.PI / 180.0;
    }

    double checkLoopInRadian(double val) {
        while (val < 0.0) {
            if (!((val += Math.PI * 2) >= 0.0)) continue;
            return val;
        }
        while (val > Math.PI * 2) {
            if (!((val -= Math.PI * 2) <= Math.PI * 2)) continue;
            return val;
        }
        return val;
    }

    private double checkLoopInDegree(double val) {
        while (val < 0.0) {
            if (!((val += 360.0) >= 0.0)) continue;
            return val;
        }
        while (val > 360.0) {
            if (!((val -= 360.0) <= 360.0)) continue;
            return val;
        }
        return val;
    }

    private void convertToRadian() {
        if (this.isRadian) {
            return;
        }
        this.recalulateInProcess = true;
        double newVal = Double.valueOf(this.textStartAngle.getText());
        newVal = newVal * Math.PI / 180.0;
        newVal = this.checkLoopInRadian(newVal);
        this.textStartAngle.setText(QbUtil.roundUp(newVal) + "");
        this.isRadian = true;
        this.recalulateInProcess = false;
    }

    private void convertToDegree() {
        if (!this.isRadian) {
            return;
        }
        this.recalulateInProcess = true;
        double newVal = Double.valueOf(this.textStartAngle.getText());
        newVal = Math.rint(newVal / Math.PI * 180.0);
        newVal = this.checkLoopInDegree(newVal);
        this.textStartAngle.setText(QbUtil.roundUp(newVal) + "");
        this.isRadian = false;
        this.recalulateInProcess = false;
    }

    private double getStartAngleForChart() {
        this.isRadian = this.chart.isRadianForPolar();
        if (this.isRadian) {
            return this.checkLoopInRadian(this.chart.getStartAngleForPolar());
        }
        return this.checkLoopInDegree(Math.rint(this.chart.getStartAngleForPolar() * 180.0 / Math.PI));
    }

    private void recalulateStartAngle() {
        if (this.recalulateInProcess) {
            return;
        }
        this.recalulateInProcess = true;
        try {
            double newVal = this.checkLoopInRadian(this.chart.calulateStartAngleForPolar(this.getStartAngleInRadian()));
            if (!this.isRadian) {
                newVal = this.checkLoopInDegree(Math.rint(newVal * 180.0 / Math.PI));
            }
            this.textStartAngle.setText(QbUtil.roundUp(newVal) + "");
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error recalculating start angle", ex);
        }
        this.recalulateInProcess = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.radioRadian) {
            this.convertToRadian();
        } else if (source == this.radioDegree) {
            this.convertToDegree();
        }
    }
}

